#!/usr/bonsaitools/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): Rick Dean <software@fdd.com>
#                 Terry Weissman <terry@mozilla.org>
#                 David Gardiner <david.gardiner@unisa.edu.au>
#

use strict;

require "CGI.pl";

$::CheckOptionValues = 0;       # It's OK if we have some bogus things in the
                                # pop-up lists here, from a remembered query
                                # that is no longer quite valid.  We don't
                                # want to crap out in the query page.

# Shut up misguided -w warnings about "used only once":

use vars
  @::CheckOptionValues,
  @::legal_resolution,
  @::legal_bug_status,
  @::legal_components,
  @::legal_keywords,
  @::legal_opsys,
  @::legal_platform,
  @::legal_priority,
  @::legal_product,
  @::legal_severity,
  @::legal_target_milestone,
  @::legal_versions,
  @::log_columns,
  %::versions,
  %::components,
  %::FORM;
 
if (defined($::FORM{'csv'})) { 
    print("Content-Type: text/csv\n\n");
} else {
    print "Content-type: text/html\n\n";
};

if (defined $::FORM{"GoAheadAndLogIn"}) {
    # We got here from a login page, probably from relogin.cgi.  We better
    # make sure the password is legit.
    confirm_login();
} else {
    quietly_check_login();
}
my $userid = 0;
if (defined $::COOKIE{"Bugzilla_login"}) {
    $userid = DBNameToIdAndCheck($::COOKIE{"Bugzilla_login"});
}

use vars %::default;  # would use "our" but want perl 5.004 compliance
my %type;

sub ProcessFormStuff {
    my ($buf) = (@_);
    my $foundone = 0;
    foreach my $name ("bug_status", "resolution", "assigned_to",
                      "rep_platform", "priority", "bug_severity",
                      "product", "op_sys",
                      "component", "version", 
                      "assigned_to","reporter","qa_contact","cc","comment_add",
                      "changedin", "votes", "short_desc", 
                      "long_desc", "long_desc_type", "bug_file_loc",
                      "status_whiteboard",
                      "status_whiteboard_type", "bug_id", "target_milestone",
                      "retroactive","num_intervals", "metric_census", "metric_open", 
                      "metric_resolved","metric_fixed","metric_verified",
                      "metric_closed", "metric_openings", "metric_resolves", 
                      "metric_fixes", "metric_nonfixes", "metric_verifies",
                      "metric_closingss",
                      "bugidtype", "keywords", "keywords_type") {
        $::default{$name} = "";
        $type{$name} = 0;
    }


    foreach my $item (split(/\&/, $buf)) {
        my @el = split(/=/, $item);
        my $name = $el[0];
        my $value;
        if ($#el > 0) {
            $value = url_decode($el[1]);
        } else {
            $value = "";
        }
        if (defined $::default{$name}) {
            $foundone = 1;
            if ($::default{$name} ne "") {
                $::default{$name} .= "|$value";
                $type{$name} = 1;
            } else {
                $::default{$name} = $value;
            }
        }
    }
    return $foundone;
}

if($::buffer eq "") {
    $::buffer = "bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED";
    $::buffer = "nothing";
}

if (!ProcessFormStuff($::buffer)) {
    #    ProcessFormStuff(Param("defaultquery"));
}

my $hasmetric = grep { /^metric_/ && $::default{$_} } keys %::default;  # if a metric is selected
$::default{"metric_open"} = 1 if ! $hasmetric;

$::default{"num_intervals"} ||= "10";

$::default{'retroactive'} = 1 if ! defined $::FORM{'vertical'};

GetVersionTable();


# javascript
    
my $jscript = << 'ENDSCRIPT';
<script language="Javascript1.1" type="text/javascript">
<!--
var cpts = new Array();
var vers = new Array();
var tms  = new Array();
ENDSCRIPT


my $p;
my $v;
my $c;
my $m;
my $i = 0;
my $j = 0;

foreach $c (@::legal_components) {
    $jscript .= "cpts['$c'] = new Array();\n";
}

foreach $v (@::legal_versions) {
    $jscript .= "vers['$v'] = new Array();\n";
}

my $tm;
foreach $tm (@::legal_target_milestone) {
    $jscript .= "tms['$tm'] = new Array();\n";
}

for $p (@::legal_product) {
    if ($::components{$p}) {
        foreach $c (@{$::components{$p}}) {
            $jscript .= "cpts['$c'][cpts['$c'].length] = '$p';\n";
        }
    }

    if ($::versions{$p}) {
        foreach $v (@{$::versions{$p}}) {
            $jscript .= "vers['$v'][vers['$v'].length] = '$p';\n";
        }
    }

    if ($::target_milestone{$p}) {
        foreach $m (@{$::target_milestone{$p}}) {
            $jscript .= "tms['$m'][tms['$m'].length] = '$p';\n";
        }
    }
}

$i = 0;
$jscript .= q{

// Only display versions/components valid for selected product(s)

function selectProduct(f) {
    // Netscape 4.04 and 4.05 also choke with an "undefined"
    // error.  if someone can figure out how to "define" the
    // whatever, we'll remove this hack.  in the mean time, we'll
    // assume that v4.00-4.03 also die, so we'll disable the neat
    // javascript stuff for Netscape 4.05 and earlier.

    var cnt = 0;
    var i;
    var j;
    for (i=0 ; i<f.product.length ; i++) {
        if (f.product[i].selected) {
            cnt++;
        }
    }
    var doall = (cnt == f.product.length || cnt == 0);

    var csel = new Array();
    for (i=0 ; i<f.component.length ; i++) {
        if (f.component[i].selected) {
            csel[f.component[i].value] = 1;
        }
    }

    f.component.options.length = 0;

    for (c in cpts) {
        if (typeof(cpts[c]) == 'function') continue;
        var doit = doall;
        for (i=0 ; !doit && i<f.product.length ; i++) {
            if (f.product[i].selected) {
                var p = f.product[i].value;
                for (j in cpts[c]) {
                    if (typeof(cpts[c][j]) == 'function') continue;
                    var p2 = cpts[c][j];
                    if (p2 == p) {
                        doit = true;
                        break;
                    }
                }
            }
        }
        if (doit) {
            var l = f.component.length;
            f.component[l] = new Option(c, c);
            if (csel[c]) {
                f.component[l].selected = true;
            }
        }
    }

    var vsel = new Array();
    for (i=0 ; i<f.version.length ; i++) {
        if (f.version[i].selected) {
            vsel[f.version[i].value] = 1;
        }
    }

    f.version.options.length = 0;

    for (v in vers) {
        if (typeof(vers[v]) == 'function') continue;
        var doit = doall;
        for (i=0 ; !doit && i<f.product.length ; i++) {
            if (f.product[i].selected) {
                var p = f.product[i].value;
                for (j in vers[v]) {
                    if (typeof(vers[v][j]) == 'function') continue;
                    var p2 = vers[v][j];
                    if (p2 == p) {
                        doit = true;
                        break;
                    }
                }
            }
        }
        if (doit) {
            var l = f.version.length;
            f.version[l] = new Option(v, v);
            if (vsel[v]) {
                f.version[l].selected = true;
            }
        }
    }

    var tmsel = new Array();
    for (i=0 ; i<f.target_milestone.length ; i++) {
        if (f.target_milestone[i].selected) {
            tmsel[f.target_milestone[i].value] = 1;
        }
    }

    f.target_milestone.options.length = 0;

    for (tm in tms) {
        if (typeof(tms[v]) == 'function') continue;
        var doit = doall;
        for (i=0 ; !doit && i<f.product.length ; i++) {
            if (f.product[i].selected) {
                var p = f.product[i].value;
                for (j in tms[tm]) {
                    if (typeof(tms[tm][j]) == 'function') continue;
                    var p2 = tms[tm][j];
                    if (p2 == p) {
                        doit = true;
                        break;
                    }
                }
            }
        }
        if (doit) {
            var l = f.target_milestone.length;
            f.target_milestone[l] = new Option(tm, tm);
            if (tmsel[tm]) {
                f.target_milestone[l].selected = true;
            }
        }
    }

}
// -->
</script>

};



# Muck the "legal product" list so that the default one is always first (and
# is therefore visibly selected.

# Commented out, until we actually have enough products for this to matter.

# set w [lsearch $legal_product $::default{"product"}]
# if {$w >= 0} {
#    set legal_product [concat $::default{"product"} [lreplace $legal_product $w $w]]
# }

if (!defined($::FORM{'csv'})) { 
    PutHeader("Table of Bug Counts", "Table of Bug Counts", 
          "Build a trendy table of bug counts.  Everyone does it!  Start by picking the axes...",
          q{onLoad="selectProduct(document.forms[0]);"},
          0, $jscript);
};

push @::legal_resolution, "---"; # Oy, what a hack.

my @logfields = ("[Bug creation]", @::log_columns);

@::axis_types = ("severity", "priority", "nothing", "who", "assigned_to", "reporter", "status", 
                 "resolution", "component", "product", "version", "platform", "os");
push(@::axis_types,"qa_contact") if (Param("useqacontact"));
push(@::axis_types,"target_milestone") if (Param("usetargetmilestone"));

@::time_types = ("4hours", "12hours", "daily", "3days", "weekly", "2weeks", "month");

sub use_if_listed {
    my($desired, $default, @list) = @_;
    return $default if ! defined($desired);
    for my $elem (@list) {
        return $desired if $elem eq $desired;
    }
    return $default;
}

# figure out what our axes are
$::vertical = $::FORM{'vertical'};
$::vertical = use_if_listed($::vertical, "priority", @::axis_types);
$::horizontal = $::FORM{'horizontal'};
$::horizontal = use_if_listed($::horizontal, "weekly", @::time_types);

do "print_trend_table.pl" || print "<h2><font color=red>Error in print_trend_table.pl</font></h2><tt>$@</tt><p>\n";
exit if defined($::FORM{'csv'});

print qq{
<FORM METHOD=GET ACTION="bug_count_trends.cgi">

<table>
<tr>
<th align=left><A HREF="bug_status.html">Vertical Axis</a>:</th>
<th align=left><A HREF="bug_status.html">Horizontal Axis</a>:</th>
<th align=left colspan=2><A HREF="bug_status.html">Metrics</a>:</th>
</tr>
};

my $script_name = $0;
$script_name =~ s/.*\///;  # delete anything before the slash
$script_name .= "/bugs_". time2str("%Y%b%d",time) . "_$::vertical.csv";
print "
<tr>
<td align=left valign=top>
@{[make_selection_widget(\"vertical\",\@::axis_types,$::vertical,1 , 0)]}
</td><td>
@{[make_selection_widget(\"horizontal\",\@::time_types,$::horizontal,1 , 0)]}
 <br><input name=num_intervals value=$::default{'num_intervals'} size=5> intervals
</td> <td>
  (census at instant)<br>
  <input type=checkbox name=metric_census   ". ($::default{'metric_census'}  ?"CHECKED":"") ." > Count all (matching)<br>
  <input type=checkbox name=metric_open     ". ($::default{'metric_open'}    ?"CHECKED":"") ." > Count open<br>
  <input type=checkbox name=metric_resolved ". ($::default{'metric_resolved'}?"CHECKED":"") ." > Count resolved<br>
  <input type=checkbox name=metric_fixed    ". ($::default{'metric_fixed'}   ?"CHECKED":"") ." > Count resolved, fixed<br>
  <input type=checkbox name=metric_verified ". ($::default{'metric_verified'}?"CHECKED":"") ." > Count verified<br>
  <input type=checkbox name=metric_closed   ". ($::default{'metric_closed'}  ?"CHECKED":"") ." > Count closed<br>
</td><td>
  (transitions during interval)<br>
  <input type=checkbox name=metric_openings ". ($::default{'metric_openings'}?"CHECKED":"") ." > Count openings<br>
  <input type=checkbox name=metric_resolves ". ($::default{'metric_resolves'}?"CHECKED":"") ." > Count resolves<br>
  <input type=checkbox name=metric_fixes    ". ($::default{'metric_fixes'}   ?"CHECKED":"") ." > Count resolves, fixes<br>
  <input type=checkbox name=metric_nonfixes ". ($::default{'metric_nonfixes'}?"CHECKED":"") ." > Count resolves, non-fixes<br>
  <input type=checkbox name=metric_verifies ". ($::default{'metric_verifies'}?"CHECKED":"") ." > Count verifies<br>
  <input type=checkbox name=metric_closings ". ($::default{'metric_closings'}?"CHECKED":"") ." > Count closings<br>
</td> <td>
</tr>
</table>

<input type=checkbox name=retroactive ". ($::default{'retroactive'}?"CHECKED":"") ."> 
Use final values retroactively (except status & resolution)<br>

<table><tr><td>
  <INPUT TYPE=\"submit\" VALUE=\"Update Table\">
 </td><td>
  <a href=\"$script_name?csv=1&$::buffer\">download as Comma Separated Variables (CSV)</a>
</td></tr></table>
";

print "
(HINT: After updating to a table you like, consider bookmarking the page.)
<p>And further constrain your data set with ...
";

print qq{
<table>
<tr>
<th align=left><A HREF="bug_status.html">Status</a>:</th>
<th align=left><A HREF="bug_status.html">Resolution</a>:</th>
<th align=left><A HREF="bug_status.html#rep_platform">Platform</a>:</th>
<th align=left><A HREF="bug_status.html#op_sys">OpSys</a>:</th>
<th align=left><A HREF="bug_status.html#priority">Priority</a>:</th>
<th align=left><A HREF="bug_status.html#severity">Severity</a>:</th>
};

print "
</tr>
<tr>
<td align=left valign=top>

@{[make_selection_widget(\"bug_status\",\@::legal_bug_status,$::default{'bug_status'}, $type{'bug_status'}, 1)]}

</td>
<td align=left valign=top>
@{[make_selection_widget(\"resolution\",\@::legal_resolution,$::default{'resolution'}, $type{'resolution'}, 1)]}

</td>
<td align=left valign=top>
@{[make_selection_widget(\"rep_platform\",\@::legal_platform,$::default{'rep_platform'}, $type{'rep_platform'}, 1)]}

</td>
<td align=left valign=top>
@{[make_selection_widget(\"op_sys\",\@::legal_opsys,$::default{'op_sys'}, $type{'op_sys'}, 1)]}

</td>
<td align=left valign=top>
@{[make_selection_widget(\"priority\",\@::legal_priority,$::default{'priority'}, $type{'priority'}, 1)]}

</td>
<td align=left valign=top>
@{[make_selection_widget(\"bug_severity\",\@::legal_severity,$::default{'bug_severity'}, $type{'bug_severity'}, 1)]}

</tr>
</table>

<p>\n";

my $def_assigned_to = value_quote($::default{"assigned_to"});
my $def_reporter    = value_quote($::default{"reporter"});
my $def_qa_contact  = value_quote($::default{"qa_contact"});
my $def_cc          = value_quote($::default{"cc"});
my $def_comment_add = value_quote($::default{"comment_add"});

print qq{
<b>Email:</b>
<table>
<tr><td align=right>Assigned To:</td>
    <td><input size=50 name=assigned_to value="$def_assigned_to"></td>
    <td> </td></tr>
<tr><td align=right>Reported By:</td>
    <td><input size=50 name=reporter value="$def_reporter"></td>
    <td> </td></tr>
<tr><td align=right>QA Contact:</td>
    <td><input size=50 name=qa_contact value="$def_qa_contact"></td>
    <td> </td></tr>
<tr><td align=right>CC:</td>
    <td align=right><input size=50 name=cc value="$def_cc"></td>
    <td> (only one)</td></tr>
<tr><td>Added Comment By:</td>
    <td align=right><input size=50 name=comment_add value="$def_comment_add"></td>
    <td> (only one)</td></tr>
};


print"
<P>
<table>
<tr>
<TH ALIGN=LEFT VALIGN=BOTTOM>Program:</th>
<TH ALIGN=LEFT VALIGN=BOTTOM>Version:</th>
<TH ALIGN=LEFT VALIGN=BOTTOM><A HREF=describecomponents.cgi>Component:</a></th>
";

if (Param("usetargetmilestone")) {
    print "<TH ALIGN=LEFT VALIGN=BOTTOM>Target Milestone:</th>";
}

print "
</tr>
<tr>

<td align=left valign=top>
<SELECT NAME=\"product\" MULTIPLE SIZE=5 onChange=\"selectProduct(this.form);\">
@{[make_options(\@::legal_product, $::default{'product'}, $type{'product'})]}
</SELECT>
</td>

<td align=left valign=top>
<SELECT NAME=\"version\" MULTIPLE SIZE=5>
@{[make_options(\@::legal_versions, $::default{'version'}, $type{'version'})]}
</SELECT>
</td>

<td align=left valign=top>
<SELECT NAME=\"component\" MULTIPLE SIZE=5>
@{[make_options(\@::legal_components, $::default{'component'}, $type{'component'})]}
</SELECT>
</td>";

if (Param("usetargetmilestone")) {
    print "
<td align=left valign=top>
<SELECT NAME=\"target_milestone\" MULTIPLE SIZE=5>
@{[make_options(\@::legal_target_milestone, $::default{'target_milestone'}, $type{'target_milestone'})]}
</SELECT>
</td>";
}


sub StringSearch {
    my ($desc, $name) = (@_);
    my $type = $name . "_type";
    my $def = value_quote($::default{$name});
    print qq{<tr>
<td align=right>$desc:</td>
<td><input name=$name size=30 value="$def"></td>
<td><SELECT NAME=$type>
};
    if ($::default{$type} eq "") {
        $::default{$type} = "substring";
    }
    foreach my $i (["substring", "case-insensitive substring"],
                   ["casesubstring", "case-sensitive substring"],
                   ["allwords", "all words"],
                   ["anywords", "any words"],
                   ["regexp", "regular expression"],
                   ["notregexp", "not ( regular expression )"]) {
        my ($n, $d) = (@$i);
        my $sel = "";
        if ($::default{$type} eq $n) {
            $sel = " SELECTED";
        }
        print qq{<OPTION VALUE="$n"$sel>$d\n};
    }
    print "</SELECT></TD>
</tr>
";
}

print "
</tr>
</table>

<table border=0>
";

my $def_short_desc   = value_quote($::default{"short_desc"});
my $def_bug_file_loc = value_quote($::default{"bug_file_loc"});

print qq{
<table>
<tr><td align=right>Summary:</td>
    <td><input size=50 name=short_desc value="$def_short_desc"></td>
    <td> (any word)</td></tr>
<tr><td align=right>URL:</td>
    <td><input size=50 name=bug_file_loc value="$def_bug_file_loc"></td>
    <td> (any word)</td></tr>
</table>
};

#StringSearch("Summary", "short_desc");
#StringSearch("A description entry", "long_desc");
#StringSearch("URL", "bug_file_loc");

if (Param("usestatuswhiteboard")) {
    StringSearch("Status whiteboard", "status_whiteboard");
}

if (@::legal_keywords) {
    my $def = value_quote($::default{'keywords'});
    print qq{
<TR>
<TD ALIGN="right"><A HREF="describekeywords.cgi">Keywords</A>:</TD>
<TD><INPUT NAME="keywords" SIZE=30 VALUE="$def"></TD>
<TD>
};
    my $type = $::default{"keywords_type"};
    if ($type eq "or") {        # Backward compatability hack.
        $type = "anywords";
    }
    print BuildPulldown("keywords_type",
                        [["anywords", "Any of the listed keywords set"],
                         ["allwords", "All of the listed keywords set"],
                         ["nowords", "None of the listed keywords set"]],
                        $type);
    print qq{</TD></TR>};
}

print "
</table>
<p>
";


my @fields;
push(@fields, ["noop", "---"]);
ConnectToDatabase();
SendSQL("SELECT name, description FROM fielddefs ORDER BY sortkey");
while (MoreSQLData()) {
    my ($name, $description) = (FetchSQLData());
    push(@fields, [$name, $description]);
}

my @types = (
	     ["noop", "---"],
	     ["equals", "equal to"],
	     ["notequals", "not equal to"],
	     ["casesubstring", "contains (case-sensitive) substring"],
	     ["substring", "contains (case-insensitive) substring"],
	     ["notsubstring", "does not contain (case-insensitive) substring"],
	     ["regexp", "contains regexp"],
	     ["notregexp", "does not contain regexp"],
	     ["lessthan", "less than"],
	     ["greaterthan", "greater than"],
	     ["anywords", "any words"],
	     ["allwords", "all words"],
	     ["nowords", "none of the words"],
	     ["changedbefore", "changed before"],
	     ["changedafter", "changed after"],
	     ["changedto", "changed to"],
	     ["changedby", "changed by"],
	     );


print qq{<A NAME="chart"> </A>\n};

foreach my $cmd (grep(/^cmd-/, keys(%::FORM))) {
    if ($cmd =~ /^cmd-add(\d+)-(\d+)-(\d+)$/) {
	$::FORM{"field$1-$2-$3"} = "xyzzy";
    }
}
	
#  foreach my $i (sort(keys(%::FORM))) {
#      print "$i : " . value_quote($::FORM{$i}) . "<BR>\n";
#  }

print " <INPUT TYPE=\"submit\" VALUE=\"Update table\">\n";

print "
</FORM>
<P>
";


if (UserInGroup("tweakparams")) {
    print "<a href=editparams.cgi>Edit Bugzilla operating parameters</a><br>\n";
}
if (UserInGroup("editcomponents")) {
    print "<a href=editproducts.cgi>Edit Bugzilla products and components</a><br>\n";
}
if (UserInGroup("editkeywords")) {
    print "<a href=editkeywords.cgi>Edit Bugzilla keywords</a><br>\n";
}
if ($userid) {
    print "<a href=relogin.cgi>Log in as someone besides <b>$::COOKIE{'Bugzilla_login'}</b></a><br>\n";
}
print "<a href=userprefs.cgi>Change your password or preferences.</a><br>\n";
print "<a href=\"enter_bug.cgi\">Create a new bug.</a><br>\n";
print "<a href=\"createaccount.cgi\">Open a new Bugzilla account</a><br>\n";
print "<a href=\"reports.cgi\">Bug reports</a><br>\n";

PutFooter();
