
use strict;

# Copyright 2003,2004 Frederick Dean

package FKong::config;

#
#  Our config parameter from the DB are stored in %FKong::config
%FKong::config = ();
my %descript = ();
my %type = ();
my @names;
my $max_seq_num = 0;

# Here we load any config records that are newer than the last time we checked.
sub maybe_load_config
{
   my $dbh = FKong::db::SendSQL("SELECT name, value, seq_num FROM config WHERE seq_num > $max_seq_num ORDER BY seq_num");
   while(my @row = $dbh->fetchrow_array()) {
      my($name,$value,$seq_num) = @row;
      $FKong::config{$name} = $value;
      $max_seq_num = $seq_num;
   }
}

sub DefConfigParam
{
   my($name,$typee,$default,$descrip) = @_;
   push(@names,$name);
   $FKong::config{$name} = $default;
   $descript{$name} = $descrip;
   $type{$name} = $typee;
}


DefConfigParam('AdminEmail','oneline',"the administrator",
               'Used for error messages.  This is different than the abuse email link that should '.
               'be appended to every email.  Angle brackets and HTML formatting are okay.');

DefConfigParam('MaxIdleTime','integer',30*24*360,
               'Maximum time (measured in seconds) a session survives without a hit, before it is logged out.');

DefConfigParam('TimeFormat','oneline','%a %b %d, %Y %l:%M%P %Z',
                "How we should show the time by default.\n".
                "The codes are explained in perldoc Date::Format.");

DefConfigParam('ListTimeFormat','oneline', '%Y-%b-%d <nobr>%l:%M%P %Z</nobr>',
                "How we should show the time in lists (tables).\n".
                "The codes are explained in perldoc Date::Format.");

DefConfigParam('bugzilla_url', 'oneline', 'http://bugzilla/show_bug.cgi?id=',
              'This is the URL prefix to link bug numbers to.  The bug number is appended to it.');

DefConfigParam('featurekong_url', 'oneline', 'http://featurekong',
              'What is the hostname and scheme (http or https) should emails specify when linking to FeatureKong? '.
              'The url should not end in a slash or include a path.');

DefConfigParam('MoneyDecimalPlaces', 'integer', '2',
              'How many digits are right of the decimal point for fixed precision decimals.');

DefConfigParam('UserPulldown', 'bool', '1',
              'If few users exist, it may be convenient to have a pulldown instead of a text entry.');

DefConfigParam('ShowRealnames', 'bool', '1',
              'For emails and user pulldowns do we list realnames along with usernames?');

DefConfigParam('SendUpdateEmails', 'bool', '0',
              'Should we send emails when records are updated?');

DefConfigParam('FromAddress', 'oneline', '"FeatureKong" <featurekong@localhost>',
              'When FeatureKong sends emails, this is who they claim to be from.');

DefConfigParam('DefaultTableUrl', 'oneline', 'feature',
              'When they are in the root directory, which table are the links for?');

DefConfigParam('DefaultTableName', 'oneline', 'Feature',
              'This is the table name corresponding to DefaultTableUrl above.');

$FKong::url_func{'config.html'} = \&show_config_page;

sub show_config_page
{
   my($recprefix,$name,$url,$tablesql) = @_;

   FKong::session::must_have_priv("view_other");
   $FKong::cgi::keyword{'tables'} = FKong::tables_keyword(1);  # show admin tab
   if($FKong::cgi::form{'cancel'}) {
      FKong::cgi::redirect(FKong::cgi::Uri("/"));
   } elsif($FKong::cgi::form{'commit'}) {
      FKong::session::must_have_priv("edit_other");
      my @sql;
      my $warning = '';
      foreach my $name (@names) {
         my $formval = $FKong::cgi::form{$name};
         if(defined $formval) {
            FKong::cgi::trim($formval);
            if($formval ne $FKong::config{$name}) {
               push(@sql,"(UNIX_TIMESTAMP(),". FKong::db::SqlQuote($name) .",".  FKong::db::SqlQuote($formval) .")");
               $warning .= "Config \"$name\" updated.</br>\n";
            };
         }
      };
      if(scalar @sql) {
         FKong::db::SendSQL("REPLACE config (mtime, name, value) VALUES\n". join(",\n",@sql));
      }
      $FKong::cgi::keyword{"warning"} .= "<div class=warn>$warning</div>" if $warning;
      FKong::cgi::redirect(FKong::cgi::Uri("/"));
   } else {
      $FKong::cgi::keyword{'config_form'} = '';
      foreach my $name (@names) {
         my $input = '';
         if($type{$name} eq 'bool') {
            $input = "<input name=\"". FKong::cgi::value_quote($name) .'" type=radio value=1 '. ($FKong::config{$name}?"CHECKED":'') ."> yes \n".
                     " &nbsp;  &nbsp; &nbsp; ".
                     "<input name=\"". FKong::cgi::value_quote($name) .'" type=radio value=0 '. ($FKong::config{$name}?'':"CHECKED") ."> no \n";
         } elsif($type{$name} eq 'multiline') {
            $input .= " <textarea WRAP=HARD NAME=\"". FKong::cgi::value_quote($name) ."\" ROWS=5 COLS=80>".
            FKong::cgi::htmlQuoteForPre($FKong::config{$name}) ."</textarea>\n";
         } else {
            $input = "<input name=\"". FKong::cgi::value_quote($name) .'" size=50 value="'. 
            FKong::cgi::value_quote($FKong::config{$name}) .'">';
         };
         $FKong::cgi::keyword{'config_form'} .= "<tr><td colspan=2><hr></td></tr>\n".
         "<tr><td>". FKong::cgi::htmlQuote($name) ."</td>\n".
         "<td>$input</td></tr>\n".
         "<tr><td colspan=2 class=config_desc>". FKong::cgi::htmlQuote($descript{$name}) .
         "</td></tr>\n";
      };
      FKong::cgi::print_expanded_template("template/config.html");
   };
}


