
# Copyright 2003,2004 Frederick Dean

# -*- Mode: perl; indent-tabs-mode: nil -*-

package FKong::db;

use strict;

use DBI;
use FKong::config;
use FKong::cgi;



our $db;

sub ConnectToDatabase {
    return if defined($db);
    $db = DBI->connect("DBI:mysql:host=$FKong::db_host;database=$FKong::db_name", 
                       $FKong::db_user, $FKong::db_pass)
        || FKong::Fatal(
            "<p>I am currently broken because I cannot connect to my database.\n".
            "Please try again later.\n" . 
            "\n".
            "<p>If the problem persists, please contact $FKong::config{'AdminEmail'}.\n" .
            "The error you should quote is:<tt>\n" . $DBI::errstr . "</tt>".
            "\n".
            "<p>If FeatureKong was just installed, then\n".
            "someone probably needs to edit the database connection\n".
            "parameters in <tt>featurekong_startup.pl</tt>, then run <tt>./checksetup.pl</tt>");
}

my(@sqls);  # for debug

my $locked;

sub SendSQL {
    my ($str, @args) = (@_);
    if($FKong::debug && scalar(@sqls) < 30) {  # if we haven't saved too many SQL statements
       my($package, $filename, $line,$subroutine) = caller(1);
       $filename ||= '';  # ensure defined
       $line ||= '';  # ensure defined
       $subroutine ||= "";  # ensure defined
       $filename =~ s/.*\///; # remove path
       push(@sqls,"<font color=black>$subroutine()</font> <font color=gray>file $filename line $line</font>\n".
                  "<font color=green>". FKong::cgi::htmlQuoteForPre($str) ."</font>\n");
    };
    ConnectToDatabase() unless $db;
    my $dbh = $db->prepare($str);
    if(! $dbh->execute(@args)) {  # if there was an error
       my($package, $filename, $line) = caller();
       if(($db->err == 2006 || ! $db->errstr) && # if server has gone away or our connection probably timed out.
          $package ne __PACKAGE__) {  # and we are not recursing
          $db = undef;  # force reconnect attempt
          ConnectToDatabase();  # try to reconnect
          return &SendSQL;  # call ourself with same args
       }
       if($FKong::debug) {  # if in debug mode
          FKong::Fatal("<pre>". FKong::cgi::htmlQuoteForPre("called from $filename line $line\n".
              $db->errstr ."\n".
              $str ."\n\n") ."</pre>",'');
       } else {  # else not in debug mode
          FKong::Fatal("<p>FeatureKong had an internal error, which means it was not your fault.\n".
                       "Please contact $FKong::config{'AdminEmail'} for help.\n".
                       "If you are the administrator please check the system log, or enable debugging.\n".
                       "<p>(DBI error #". $db->err .")\n",
                       "called from $filename line $line\n".   # log details to the system error_log
                       "errstr=". $db->errstr ."\n".
                       $str ."\n");
       };
    }
    $locked = 1 if $str =~ /^\s*LOCK/i;
    $locked = 0 if $str =~ /^\s*UNLOCK/i;
    return $dbh;
}

sub last_insert_id
{
   return $db->{ mysql_insertid };
   #my $dbh = SendSQL("SELECT LAST_INSERT_ID()");
   #my @row = $dbh->fetchrow_array();
   #return $row[0];
}

sub maybe_unlock_tables
{
   SendSQL("UNLOCK TABLES") if $locked;
}

# This routine is largely copied from Mysql.pm.
sub SqlQuote {
    my ($str) = (@_);
    return "NULL" if !defined($str);
    $str =~ s/([\\\'])/\\$1/g;
    $str =~ s/\0/\\0/g;
    # If it's been SqlQuote()ed, then it's safe, so we tell -T that.
    #$str = detaint_string($str);
    return "'$str'";
}

my %mapping = ( r => "\r", "'" => "'", n => "\n", 0 => "\0", "\\" => "\\" );

# This function assumes the bounding single quotes are already removed.
# This function is probably broken.
sub SqlUnquoteInside {
    my ($str) = (@_);
    $str =~ s/''/'/g;
    $str =~ s/\\([rn0'\\])/$mapping{$1}/ge;
    return $str;
}

sub print_debug_sqls
{
   $FKong::r->print("<hr><font size=+1>SQL history</font><br>\n");
   $FKong::r->print("<pre>\n");
   $FKong::r->print(join("\n",@sqls));
   $FKong::r->print("</pre>\n");
}

sub more_pages
{
   my $max = 100; 
   $max = $1 if ($FKong::cgi::form{'max_rec'} || '') =~ /(\d+)/; # remove non-digits
   $max = 1000 if $max > 1000;
   my @html;
   if($FKong::cgi::form{'skip'}) {
      my $skip = 0;
      $skip = $1 - $max if ($FKong::cgi::form{'skip'} || '') =~ /(\d+)/;
      $skip = 0 if $skip < 0;
      push @html, FKong::cgi::Link("",["skip=$skip", "max_rec=$max", "search=1"]) ."Previous Page</a>";
   };
   # Here we have to guess that if the max are shown, we can find more
   if($FKong::cgi::keyword{'rowCount'} =~ /(\d+)/ && $1 == $max) {
      my $skip = $max;
      $skip = $1 + $max if ($FKong::cgi::form{'skip'} || '') =~ /(\d+)/;
      push @html, FKong::cgi::Link("",["skip=$skip", "max_rec=$max", "search=1"]) ."Next Page</a>";
   };
   return join(" | ", @html);
}

# returs a little SQL to limit query result size
sub sql_limit
{
   my $limit = 100; 
   $limit = $1 if ($FKong::cgi::form{'max_rec'} || '') =~ /(\d+)/; # remove non-digits
   $limit = 1000 if $limit > 1000;
   if(defined $FKong::cgi::form{'skip'} && $FKong::cgi::form{'skip'} =~ /(\d+)/) {
      $limit = "$1,$limit";
   }
   $FKong::cgi::keyword{'more_pages'} = \&more_pages;
   return "LIMIT $limit";
}

# We ignore these signals so a web browser cancel doesn't stop interrupt atomic updates.
# It is not needed for every LOCK TABLES because mysql will unlock when the connection drops.
# You should call it right after you successfully lock the tables (when necessisary).
sub ignore_cancel
{
   # FIXME  we should not be doing this stuff with mod_perl right?
   $::SIG{PIPE} = 'IGNORE';
   $::SIG{TERM} = 'IGNORE'; 
}

sub debug_hint
{
   push(@sqls,"(You do not see the session establishment SQL because I ".
              "did not know yet we were debugging.)\n");
}


#  Free up some memory and destroy state from last session
sub Done
{
   @sqls = ();
}

1;



