
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::main;

my $leadLength = 250;

sub do_go_to
{
   my($fktable) = @_;
   if($FKong::cgi::form{'go_to_feature'} =~ /(\d+)/) {
      my $id = $1;
      (my $list = $FKong::cgi::form{'go_to_feature'}) =~ s/[^\d]+/,/g;  # convert non numbers to single comma
      $list =~ s/^[^\d]+//;  # remove prefix
      $list =~ s/[^\d]+$//;  # remove suffix
      if($list =~ /,/ || ! FKong::session::get_state($$fktable{'tablesql'} .'-list')) {  # if they entered multiple or have no saved list
         FKong::session::set_state($$fktable{'tablesql'} .'-list',$list);  # make this list, the list
      };
      #return FKong::cgi::redirect(FKong::cgi::Uri("/$$fktable{'url'}/$$fktable{'recprefix'}$id.html"));
      return FKong::cgi::redirect("$$fktable{'recprefix'}$id.html");
   } elsif($FKong::cgi::form{'go_to_feature'} eq "") {
      FKong::Fatal("I need you to enter a number before pushing the \"go to\" button.");
   } else {
      FKong::Fatal("Feature ". FKong::cgi::htmlQuote($FKong::cgi::form{'go_to_feature'}) ." not understood.");
   }
}

sub do_search_features
{
   if($FKong::cgi::form{'text'}) {
      return FKong::cgi::redirect("list.html?text=". FKong::cgi::urlQuote($FKong::cgi::form{'text'}));
   } elsif (my $f_list = FKong::session::get_state('list')) {   # if a feature list was saved
      return FKong::cgi::redirect("list.html");  # by default will show saved list
   } else {
      return FKong::cgi::redirect("search.html");  #  last resort show search form
   };
}

sub do_search_comments
{
   if($FKong::cgi::form{'search_comments'}) {
      return FKong::cgi::redirect("comment/list.html?search_comments=". FKong::cgi::urlQuote($FKong::cgi::form{'search_comments'}));
   } else {
      return FKong::cgi::redirect("comment/search.html");  #  last resort show search form
   };
}

sub fix_truncated
{
   return if ! defined $_[0];
   my $truncated = (length $_[0] == $leadLength);  # if it was truncated
   $_[0] =~ s/(\S+)$//;  # remove trailing partial word
   $_[0] .= " ..." if $truncated; 
}

sub new_features
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   my $dbh = FKong::db::SendSQL("SELECT sqlName, fieldName, type FROM field_def\n".
                                "WHERE new_summary AND tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ." ORDER BY sort");
   my(@sqlNames,@fieldNames,@types);
   my $joins = '';
   while(my($sqlName,$fieldName,$type) = $dbh->fetchrow_array()) {  # for each field which should be in the summary
      push(@fieldNames,$fieldName);
      push(@types,$type);
      if($type eq "user") {
         push(@sqlNames,"$sqlName.username");
         $joins .= "LEFT JOIN user AS $sqlName ON ($sqlName.userid = feature.$sqlName)\n";
      } elsif($type eq "multiline") {
         push(@sqlNames,"LEFT($sqlName,$leadLength)");
      } else {  # else type does not require a join
         push(@sqlNames,$sqlName);
      }
   }
   return "<font color=red>This table has no fields selected for new record summary.</font>" if scalar(@sqlNames) == 0;
   $dbh = FKong::db::SendSQL("SELECT $tablesql.createTS, creator.username, $pkey,\n".
                      join(",",@sqlNames) ."\nFROM $tablesql\n".
                      "LEFT JOIN user AS creator ON (creator.userid = $tablesql.create_by)\n".
                      $joins .
                      "ORDER BY createTS DESC, $pkey DESC LIMIT 5");
   my $new_features = '';
   while(my($createTS,$creator,$recId,@row) = $dbh->fetchrow_array()) {  # for every feature
      $FKong::cgi::keyword{$pkey} = $recId;
      $FKong::cgi::keyword{'featureLink'} = "$$fktable{'recprefix'}$recId.html";
      $FKong::cgi::keyword{'who'} = FKong::cgi::htmlQuote($creator);
      $FKong::cgi::keyword{'when'} = Date::Format::time2str($FKong::config{'TimeFormat'},$createTS);
      @FKong::cgi::keyword{'first','middle','last'} = ('') x 3;
      foreach (0..$#row) {  # for each field of this feature
         fix_truncated($row[$_]) if $types[$_] eq 'multiline';
         my $quotedValue = FKong::cgi::htmlQuote(defined $row[$_] ? $row[$_] : '');
         FKong::cgi::Linkify($quotedValue);
         $FKong::cgi::keyword{$fieldNames[$_]} = $quotedValue;   # save for custom template
         if(! length $FKong::cgi::keyword{'first'}) {
            $FKong::cgi::keyword{'first'} = $quotedValue;
         } else {
            if($_ == $#row) {  # if last
               $FKong::cgi::keyword{'last'} .= $quotedValue ." &nbsp; ";
            } elsif($types[$_] eq 'oneline' || $types[$_] eq 'multiline') {
               $FKong::cgi::keyword{'middle'} .= "<br>\n" if $FKong::cgi::keyword{'middle'} !~ /<br>\n$/i && length $FKong::cgi::keyword{'middle'};
               $FKong::cgi::keyword{'middle'} .= $quotedValue . "<br>\n";
            } else {
               $FKong::cgi::keyword{'middle'} .= $quotedValue ." &nbsp; ";
            };
         };
      }
      $new_features .= FKong::cgi::return_expanded_template('template/summary_new_feature-template.html');
   }
   return $new_features;
}

sub new_comments
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   my $dbh = FKong::db::SendSQL("SELECT sqlName, fieldName, type FROM field_def\n".
                                "WHERE cmt_summary AND tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ." ORDER BY sort");
   my(@sqlNames,@fieldNames,@types);
   my $joins = '';
   while(my($sqlName,$fieldName,$type) = $dbh->fetchrow_array()) {  # for each field which should be in the summary
      push(@fieldNames,$fieldName);
      push(@types,$type);
      if($type eq "user") {
         push(@sqlNames,"$sqlName.username");
         $joins .= "LEFT JOIN user AS $sqlName ON ($sqlName.userid = $pkey.$sqlName)\n";
      } elsif($type eq "multiline") {
         push(@sqlNames,"LEFT($sqlName,$leadLength)");
      } else {  # else type does not require a join
         push(@sqlNames,$sqlName);
      }
   }
   return "<font color=red>This table has no fields selected for new comments summary.</font>" if scalar(@sqlNames) == 0;
   $dbh = FKong::db::SendSQL("SELECT ${tablesql}_comment.createTS, who.username, ${tablesql}_comment.$pkey, \n".
                      "subject, LEFT(${tablesql}_comment.body,$leadLength), commentId,\n".
                      join(",",@sqlNames) ."\nFROM ${tablesql}_comment, $tablesql\n".
                      "LEFT JOIN user AS who ON (who.userid = ${tablesql}_comment.create_by)\n".
                      $joins .
                      "WHERE ${tablesql}_comment.$pkey = $tablesql.$pkey\n".
                      "AND ${tablesql}_comment.createTS > $tablesql.createTS + 5\n".  # don't consider comments created when the feature is created
                      "ORDER BY commentId DESC LIMIT 5");
   my $new_comments = '';
   while(my($when,$who,$recId,$subject,$comment,$commentId,@row) = $dbh->fetchrow_array()) {  # for every feature
      $FKong::cgi::keyword{$pkey} = $recId;
      $FKong::cgi::keyword{'featureLink'} = "$$fktable{'recprefix'}$recId.html";
      $FKong::cgi::keyword{'commentLink'} = "$$fktable{'recprefix'}$recId.html#$commentId";
      $FKong::cgi::keyword{'who'} = FKong::cgi::htmlQuote($who);
      $FKong::cgi::keyword{'when'} = Date::Format::time2str($FKong::config{'TimeFormat'},$when);
      $FKong::cgi::keyword{'subject'} = FKong::cgi::htmlQuote($subject);
      fix_truncated($comment);
      $FKong::cgi::keyword{'comment'} = FKong::cgi::htmlQuote($comment);
      FKong::cgi::Linkify($FKong::cgi::keyword{'comment'});
      @FKong::cgi::keyword{'first','middle','last'} = ('') x 3;
      foreach (0..$#row) {  # for each field of this feature
         fix_truncated($row[$_]) if $types[$_] eq 'multiline';
         my $quotedValue = FKong::cgi::htmlQuoteForPre(defined $row[$_] ? $row[$_] : '');
         $FKong::cgi::keyword{$fieldNames[$_]} = $quotedValue;   # save for custom template
         if(! length $FKong::cgi::keyword{'first'}) {
            $FKong::cgi::keyword{'first'} = $quotedValue;
         } else {
            FKong::cgi::Linkify($quotedValue);
            if($_ == $#row) {  # if last
               $FKong::cgi::keyword{'last'} .= $quotedValue ." &nbsp; ";
            } elsif($types[$_] eq 'oneline' || $types[$_] eq 'multiline') {
               $FKong::cgi::keyword{'middle'} .= "<br>\n" if $FKong::cgi::keyword{'middle'} !~ /<br>\n$/i && length $FKong::cgi::keyword{'middle'};
               $FKong::cgi::keyword{'middle'} .= $quotedValue . "<br>\n";
            } else {
               $FKong::cgi::keyword{'middle'} .= $quotedValue ." &nbsp; ";
            };
         };
      }
      $new_comments .= FKong::cgi::return_expanded_template('template/summary_new_comment-template.html');
   }
   return $new_comments;
}

$FKong::table_func{'index.html'} = \&Show;
$FKong::table_func{''} = $FKong::table_func{'index.html'};

sub Show
{
   my($fktable) = @_;
   FKong::session::must_have_priv('view_features');
   FKong::session::must_have_priv("view_fields") if $$fktable{'internal'};
   # first check for some bad browser default action on carrage return
   if($FKong::cgi::form{'go_to_feature'} && ! $FKong::cgi::form{'text'} && ! $FKong::cgi::form{'search_comments'}) {  # if only go to filled in
      return do_go_to($fktable);
   } elsif(! $FKong::cgi::form{'go_to_feature'} && $FKong::cgi::form{'text'} && ! $FKong::cgi::form{'search_comments'}) {  # if only features filled in
      return do_search_features($fktable);
   } elsif(! $FKong::cgi::form{'go_to_feature'} && ! $FKong::cgi::form{'text'} && $FKong::cgi::form{'search_comments'}) {  # if only comments filled in
      return do_search_comments($fktable);
   }
   # then check if they hit the right button
   if($FKong::cgi::form{'do_go_to'}) {
      return do_go_to($fktable);
   } elsif($FKong::cgi::form{'do_search_features'}) {
      return do_search_features($fktable);
   } elsif($FKong::cgi::form{'do_search_comments'}) {
      return do_search_comments($fktable);
   }
   $FKong::cgi::keyword{'new_features'} = sub { new_features($fktable) };
   $FKong::cgi::keyword{'new_comments'} = sub { new_comments($fktable) };
   FKong::cgi::print_expanded_template("template/main-template.html");
}

1;


