#!/usr/bin/perl -w
use strict;

# copyright 2004 Frederick Dean

use lib "..";
require "../featurekong_startup.pl";
use FKong::db;

my $numFeatures = 6;
my $numComments = 12;

my $tablesql = 'feature';
my $dataloss;
use Getopt::Long;
GetOptions(dataloss => \$dataloss,
           "num-features=i" => \$numFeatures,
           "num-comment=i" => \$numComments,
           "tablesql=s" => \$tablesql) or die "bad command line arg";

my $ansiBright = "\033[1m";
my $ansiBlue = "\033[34m";
my $ansiGreen = "\033[32m";
my $ansiRed = "\033[31m";
my $ansiNormal = "\033[0m";

if(! $dataloss) {
   print("$ansiBright${ansiRed}WARNING: This script will corrupt your data.$ansiNormal\n");
   print("$ansiBright${ansiRed}WARNING: This script will corrupt your data.$ansiNormal\n");
   print("$ansiBright${ansiRed}WARNING: This script will corrupt your data.$ansiNormal\n");
   print("If you really want to, then rerun with the --dataloss flag.\n");
   exit -1;
}

srand(10);

#
#  Load some jibberish
#
open(WORDS,"</usr/share/dict/words") or die;
my @words;
while(my $word = <WORDS>) {
   next unless $word =~ /^[a-z]{3,8}$/;
   chomp $word;
   push(@words,$word);
}
close(WORDS);
#print(($#words+1) .  " words loaded.\n");

sub random_word
{ 
   my $index = int(rand($#words+1));
   my $word = splice(@words,$index,1,());  # remove word form list so only used once
   #my $name = $words[int(rand($#words+1))];
   return $word; 
}

sub random_multiline
{
   my $body = ucfirst(random_word()) ." ";
   my $numwords = int(rand()*140) + 3;
   foreach (0 .. $numwords) {
      my $r = rand();
      if($r < 0.05) {
         $body =~ s/ $/./;  # replace trailing space with period
         $body .= "\n\n". ucfirst(random_word()) ." ";
      } elsif($r < 0.08) {
         $body .= "http://". random_word() .".com/". random_word() .".html ";
      } elsif($r < 0.10) {
         $body .= "bug ". int(rand()*10000) ." ";
      } elsif($r < 0.11) {
         $body .= random_word() .".com ";
      } elsif($r < 0.12) {
         $body .= random_word() .".com/". random_word() .".html ";
      } else {
         $body .= random_word() ." ";
      }
   }
   $body =~ s/(.{60} )/$1\n/g;  # wrap lines
   return "$body.";
}

# Make more users if needed
my $dbh = FKong::db::SendSQL("SELECT COUNT(*) FROM user WHERE userid >= 100");
my $num_users = $dbh->fetchrow_array();
while($num_users < 10) {
   my $name = random_word();
   # Check if they already exist
   my $dbh = FKong::db::SendSQL("SELECT userid FROM user WHERE username = ". FKong::db::SqlQuote($name));
   next if $dbh->fetchrow_array();
   # Create the user
   FKong::db::SendSQL("INSERT INTO user SET username = ". FKong::db::SqlQuote($name) .", email = ". FKong::db::SqlQuote("$name\@fdd.bogus") .",\n".
               "realname = ". FKong::db::SqlQuote(ucfirst($name) ." ". ucfirst(random_word())) .", phone = ". FKong::db::SqlQuote(int(rand() * 999999)) .",\n".
               "lastTS = UNIX_TIMESTAMP(), createTS = UNIX_TIMESTAMP() - 10 + $num_users, modifyTS = UNIX_TIMESTAMP(), privs = 6144");
   $num_users++;
}

sub describe_field {
   my($table,$field) = @_;
   my $dbh = FKong::db::SendSQL("DESCRIBE $table $field");
   my @row = $dbh->fetchrow_array(); 
   return $row[0];
}

if($tablesql eq 'feature' && ! describe_field($tablesql,'_myBool')) {
   # make sure we have every data type
   foreach my $col (
     " `_myBool` tinyint(1) default '0'",
     "`_myBoolRO` tinyint(1) default '0'",
     "`_mydttm` int(10) unsigned default 'NULL'",
     "`_mydttmRO` int(10) unsigned default 'NULL'",
     "`_myFloatRO` float default NULL",
     "`_myHex` int(11) unsigned default '0'",
     "`_myHexRO` int(11) unsigned default '0'",
     "`_myIntRO` int(11) default NULL",
     "`_myIP` int(11) unsigned default NULL",
     "`_myIPRO` int(11) unsigned default NULL",
     "`_myMoney` int(11) default '0'",
     "`_myMoneyRO` int(11) default '0'",
     "`_myMltLnRO` text",
     "`_myOnelineRO` text",
     "`_myUserRO` mediumint(8) unsigned default '0'") {
      my $dbh = FKong::db::SendSQL("ALTER TABLE $tablesql ADD COLUMN $col");
   };
   
   $dbh = FKong::db::SendSQL(
"INSERT INTO field_def (fieldName, tablesql, sqlName, type, mult_choices,
min, max, deflt, read_only, on_edit_form, on_new_form, list_show,
cmt_list_show, basic_search, adv_search, new_summary, cmt_summary, batch,
rset_on_dup, unique_, create_by, createTS, mod_by, modifyTS, sort,
short_help, long_help, width, height, changeId, fixed_sql) VALUES
('myBool', '$tablesql', '_myBool', 'bool', '', NULL, NULL, NULL, '0', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734113', '100', '1109734113', '1000', NULL, NULL, NULL, NULL, '0', '0'),
('myBoolRO', '$tablesql', '_myBoolRO', 'bool', '', NULL, NULL, NULL, '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734136', '100', '1109734136', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('mydatetime', '$tablesql', '_mydttm', 'unix_ts', '', NULL, NULL, '', '0', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734169', '100', '1109734169', '2000', NULL, NULL, 30, NULL, '0', '0'),
('mydatetimeRO', '$tablesql', '_mydttmRO', 'unix_ts', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734169', '100', '1109734169', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myFloatRO', '$tablesql', '_myFloatRO', 'float', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734194', '100', '1109734194', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myHex', '$tablesql', '_myHex', 'hexint', '', NULL, NULL, '', '0', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734213', '100', '1109734213', '1000', NULL, NULL, NULL, NULL, '0', '0'),
('myHexRO', '$tablesql', '_myHexRO', 'hexint', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734235', '100', '1109734235', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myIntRO', '$tablesql', '_myIntRO', 'integer', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734251', '100', '1109734251', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myIP', '$tablesql', '_myIP', 'ip', '', NULL, NULL, '', '0', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734266', '100', '1109734266', '1000', NULL, NULL, NULL, NULL, '0', '0'),
('myIPRO', '$tablesql', '_myIPRO', 'ip', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734277', '100', '1109734277', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myMoney', '$tablesql', '_myMoney', 'money', '', NULL, NULL, '', '0', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734289', '100', '1109734289', '1000', NULL, NULL, NULL, NULL, '0', '0'),
('myMoneyRO', '$tablesql', '_myMoneyRO', 'money', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734300', '100', '1109734300', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myMultiLineRO', '$tablesql', '_myMltLnRO', 'multiline', '', NULL, NULL, '', '1', '1', '1', '0', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734326', '100', '1109734326', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myOnelineRO', '$tablesql', '_myOnelineRO', 'oneline', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734346', '100', '1109734346', '2000', NULL, NULL, NULL, NULL, '0', '0'),
('myUserRO', '$tablesql', '_myUserRO', 'user', '', NULL, NULL, '', '1', '1', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '100', '1109734364', '100', '1109734364', '2000', NULL, NULL, NULL, NULL, '0', '0')
");
}


# load field definitions from field_def table
$dbh = FKong::db::SendSQL("SELECT sqlName, type FROM field_def\n".
                          "WHERE tablesql = '$tablesql' AND type != 'constant'");
my(@sqlNames,@types);
while(my($sqlName,$type) = $dbh->fetchrow_array()) {
  push(@sqlNames,$sqlName);
  push(@types,$type);
}

# check the features table definition for valid choices of enum fields
my @choices;
foreach my $index (0..$#sqlNames) {
   if($types[$index] eq 'mult_choice') {
      $dbh = FKong::db::SendSQL("DESCRIBE $tablesql $sqlNames[$index]");
      my(undef,$def) = $dbh->fetchrow_array();
      my @blah = split(/','/,$def);
      $choices[$index] = scalar(@blah);
   };
}

foreach my $indexf (0..$numFeatures) {
   my $user = int(rand() * $num_users) + 100;
   my $sql = "INSERT INTO $tablesql SET createTS = UNIX_TIMESTAMP() - $numFeatures + $indexf, modifyTS = UNIX_TIMESTAMP(),\n".
             "create_by = $user,mod_by = $user\n";

   foreach my $index (0..$#sqlNames) {
      if($sqlNames[$index] !~ /^_/) { # if it does not begin with underscore
         next;  # skip it
      } elsif($types[$index] eq "mult_choice") {
         $sql .= ",$sqlNames[$index] = ". int(rand() * $choices[$index] + 1) ."\n";
      } elsif($types[$index] eq "float") {
         $sql .= ",$sqlNames[$index] = ". sprintf("%.2f",rand() * 10) ."\n";
      } elsif($types[$index] eq "integer" || $types[$index] eq 'hexint' || $types[$index] eq 'money') {
         $sql .= ",$sqlNames[$index] = ". int(rand() * 100) ."\n";
      } elsif($types[$index] eq "ip") {
         $sql .= ",$sqlNames[$index] = ". int(rand() * 400000000) ."0\n";
      } elsif($types[$index] eq "unix_ts") {
         my $secs = (time() - int(rand() * 10000));
         $sql .= ",$sqlNames[$index] = ". ($secs - $secs % 60) ."\n";  # on the minute
      } elsif($types[$index] eq "bool") {
         $sql .= ",$sqlNames[$index] = ". (rand() > 0.5 ? "1" : "0") ."\n";
      } elsif($types[$index] eq "user") {
         $sql .= ",$sqlNames[$index] = ". int(rand() * $num_users + 100) ."\n";
      } elsif($types[$index] eq "oneline") {
         $sql .= ",$sqlNames[$index] = ". FKong::db::SqlQuote(ucfirst(random_word()) ." ". ucfirst(random_word()) ." ". ucfirst(random_word())) ."\n";
      } elsif($types[$index] eq "multiline") {
         my $body = random_multiline();
         $sql .= ",$sqlNames[$index] = ". FKong::db::SqlQuote($body) ."\n";
      };
   };
   FKong::db::SendSQL($sql);
};

# insert record with (mostly) all NULL
if(1) {
   my $user = int(rand() * $num_users) + 100;
   my $sql = "INSERT INTO $tablesql SET createTS = UNIX_TIMESTAMP() - $numFeatures, modifyTS = UNIX_TIMESTAMP(),\n".
             "create_by = $user,mod_by = $user\n";
   foreach my $index (0..$#sqlNames) {
      if($sqlNames[$index] !~ /^_/) { # if it does not begin with underscore
         next;  # skip it
      } elsif($types[$index] eq "oneline" || $types[$index] eq "multiline") {
         $sql .= ",$sqlNames[$index] = ''\n";
      } elsif($types[$index] eq "bool") {
         $sql .= ",$sqlNames[$index] = 0\n";
      } else {
         $sql .= ",$sqlNames[$index] = NULL\n";
      };
   };
   FKong::db::SendSQL($sql);
};

$dbh = FKong::db::SendSQL("SELECT pkey FROM fktable WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
my($pkey) = $dbh->fetchrow_array();
$pkey or die "Could not find $tablesql in fktable\n";

foreach my $index (0..$numComments) {
   my $user = int(rand() * $num_users) + 100;
   my $body = random_multiline();
   FKong::db::SendSQL("INSERT INTO ${tablesql}_comment SET\n".
                "$pkey = ". int(rand()*$numFeatures+1) .",\n".
                "createTS  = ". (time() + $index) .",\n".
                "modifyTS  = createTS,\n".
                "create_by = $user,\n".
                   "mod_by = $user,\n".
                   "format = 'text',\n".
                  "subject = ". FKong::db::SqlQuote(ucfirst(random_word()) ." ". random_word() ." ". random_word()) .",\n".
                     "body = ". FKong::db::SqlQuote($body) ."\n"
                          );
}


