#!/usr/bin/perl -w
use strict;

use lib ".";
use lib "..";
require "../featurekong_startup.pl";
use Date::Format;
use FKong::db;
use htmlform;

my $base_url = 'http://127.0.0.1/fkong/';

# log ourselves in (hopefully as the administrator)
my $cookie_val = 'abcdefghijklmnopqrstuv';
my $userid = 100;
FKong::db::SendSQL("REPLACE session SET cookie = ". FKong::db::SqlQuote($cookie_val) .",\n".
                   "userid = $userid, isvalid = 1, remoteip = 2130706433, lastused = UNIX_TIMESTAMP() ");

my $curl_cmd = "curl -s --header 'Cookie: featurekong_session=$cookie_val' ";

my $tablesql = 'feature';
my $dbh = FKong::db::SendSQL("SELECT pkey, url, recprefix, changes FROM fktable\n".
             "WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
my($pkey, $url, $recprefix, $changes) = $dbh->fetchrow_array();
defined $pkey || die;
defined $url || die;
defined $recprefix || die;

sub check_unchanged_submit
{
   my($recId) = @_;

   my $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql\n".   
                                "WHERE $tablesql.$pkey = $recId"); 
   my $hr1 = $dbh->fetchrow_hashref();
   # double fetch to clear any pending error messages.
   my $before_page = `$curl_cmd $base_url$recprefix$recId.html`;
   $before_page = `$curl_cmd $base_url$recprefix$recId.html`;
   #open(my $fd,">rick1.html") or die;
   #print $fd $before_page;
   #close($fd);
   my $form = htmlform::new($before_page);
   $form->select_form_by_submit_value('Commit') or return;
   my($action, $formcli) = $form->submit_by_name('ok_show_next');
   $action =~ s|^/fkong/||;  # trim leading directory 
   my $after_page = `$curl_cmd $formcli $base_url$action`;
   #open($fd,">rick2.html") or die;
   #print $fd $after_page;
   #close($fd);
   $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql\n".   
                                 "WHERE $tablesql.$pkey = $recId"); 
   my $hr2 = $dbh->fetchrow_hashref();
   foreach my $key (sort keys %$hr1) {
      if(defined $$hr1{$key} != defined $$hr2{$key} ||
         (defined $$hr1{$key} && defined $$hr2{$key} && $$hr1{$key} ne $$hr2{$key})) {
         warn "submit changed $key for #$recId\n";
      };
   }
}

$dbh = FKong::db::SendSQL("SELECT $pkey FROM $tablesql LIMIT 300");
my @ids;
while(my($id) = $dbh->fetchrow_array()) {
   push(@ids,$id);
};

foreach (@ids) {
   check_unchanged_submit($_);
};

# get time format
$dbh = FKong::db::SendSQL("SELECT value FROM config WHERE name = 'TimeFormat'");
my($timeformat) = $dbh->fetchrow_array();
#$timeformat ||= '%Y-%b-%d <nobr>%l:%M%P %Z</nobr>';   # list time format
$timeformat ||= '%a %b %d, %Y %l:%M%P %Z';             # record time format

my %numerical = ( 'float' => 1, 'integer' => 1 );


sub check_onechanged_submit
{
   my($recId, $change_type, $change_db_val, $change_form_val, $should_succeed, $min, $max, $by_pretext) = @_;

   $should_succeed = 1 if ! defined $should_succeed;  # assume success if not specified
   # determine what field to change
   $dbh = FKong::db::SendSQL("SELECT sqlName, fieldId, fieldName, min, max FROM field_def\n".   
                             "WHERE type = ". FKong::db::SqlQuote($change_type) ."\n".
                             "AND tablesql = ". FKong::db::SqlQuote($tablesql) ."\n".
                             "AND read_only = 0 LIMIT 1"); 
   my($sqlName,$fieldId, $fieldName, $old_min, $old_max) = $dbh->fetchrow_array;
   if(! defined $sqlName) {
      warn "no $change_type type to change\n";
      return;
   };
   # get the original values
   my $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql\n".   
                                "WHERE $tablesql.$pkey = $recId"); 
   my $hr1 = $dbh->fetchrow_hashref();
   # check that the test will actually change something
   if(defined $$hr1{$sqlName} eq defined $change_db_val && 
      (! defined $$hr1{$sqlName} || $$hr1{$sqlName} eq $change_db_val)) {
      $change_db_val = 'undef' if ! defined $change_db_val;
      warn "$change_type is already $change_db_val\n";
      return;
   };
   # clear any previous error
   #FKong::db::SendSQL("DELETE FROM more_session WHERE cookie = ". FKong::db::SqlQuote($cookie_val) .",\n".
   #                             "AND name = ". FKong::db::SqlQuote("$tablesql-$recId-fail")); 
   # set the min and max
   FKong::db::SendSQL("UPDATE field_def SET min = ". FKong::db::SqlQuote($min) .",\n".   
                      "max = ". FKong::db::SqlQuote($max) ."\n".   
                      "WHERE fieldId = $fieldId"); 
   # load twice to clear any previous error
   my $before_page = `$curl_cmd $base_url$recprefix$recId.html`; 
   $before_page = `$curl_cmd $base_url$recprefix$recId.html`; 
   #open(my $fd,">rick1.html") or die;
   #print $fd $before_page;
   #close($fd);
   # parse HTML and make the change
   my $form = htmlform::new($before_page);
   $form->select_form_by_submit_value('Commit') or return;
   if($by_pretext) {
      (my $textre = $fieldName) =~ s/(\W)/\\$1/g;  # escape for regexp
      $form->set_value_by_pretext($textre,$change_form_val);
   } else {
      $form->set_value_by_name($sqlName,$change_form_val);
   };
   my($action, $formcli) = $form->submit_by_name('ok_show_next');
   $action =~ s|^/fkong/||;  # trim leading directory 
   my $after_page = `$curl_cmd $formcli $base_url$action`;
   #open($fd,">rick2.html") or die;
   #print $fd $after_page;
   #close($fd);
   # FIXME check the right value went into the change table
   # check the database state
   $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql\n".   
                                 "WHERE $tablesql.$pkey = $recId"); 
   my $hr2 = $dbh->fetchrow_hashref();
   $$hr1{'mod_by'} = $userid;
   $change_form_val = 'undef' if ! defined $change_form_val; # for error messages
   # check that other stuff is unaffected
   foreach my $key (sort keys %$hr1) {
      next if ($key eq 'modifyTS' || $key eq 'changeId' || $key eq $sqlName) && $should_succeed;
      if(defined $$hr1{$key} ne defined $$hr2{$key} ||
         (defined $$hr1{$key} && $$hr1{$key} ne $$hr2{$key})) {
         warn "submit $change_type $change_form_val changed $key for #$recId\n";
      };
   }
   if($should_succeed) {
      if(defined $change_db_val ne defined $$hr2{$sqlName} ||
         (  $numerical{$change_type} && defined $change_db_val && $change_db_val != $$hr2{$sqlName}) ||
         (! $numerical{$change_type} && defined $change_db_val && $change_db_val ne $$hr2{$sqlName})) {
         warn "submit $change_type $change_form_val did not change correctly ($change_db_val != $$hr2{$sqlName})\n";
      };
      if(defined $sqlName) {
         if($changes && $$hr1{'changeId'} >= $$hr2{'changeId'}) {
            warn "changeId did not advance $change_type $change_form_val ($$hr1{'changeId'} and $$hr2{'changeId'})\n";
         };
         if($$hr1{'modifyTS'} > $$hr2{'modifyTS'}) {
            warn "modifyTS went backwards $change_type $change_form_val ($$hr1{'modifyTS'} and $$hr2{'modifyTS'})\n";
         };
      }
      if($changes) {
         my $dbh = FKong::db::SendSQL("SELECT old_val, create_by, $pkey, fieldId FROM ${tablesql}_change\n".   
                                      "WHERE changeId = $$hr2{'changeId'}"); 
         my($old_val, $create_by, $featureId, $fieldId2) = $dbh->fetchrow_array();
         if(defined $old_val ne defined $$hr1{$sqlName} || (defined $old_val && $old_val ne $$hr1{$sqlName})) {
            warn "for $change_type $change_form_val _change table received wrong value $old_val $$hr1{$sqlName}\n";
         };
         $create_by == $userid or warn "wrong userid in _change table\n";
         $featureId == $recId or warn "wrong $pkey in _change table\n";
         $fieldId == $fieldId2 or warn "wrong fieldId in _change table\n";
      };
   } else {  # should have failed
      my $error_page = `$curl_cmd $base_url$recprefix$recId.html`; 
      # FIXME check for error message
   }
   # restore the min and max
   FKong::db::SendSQL("UPDATE field_def SET min = ". FKong::db::SqlQuote($old_min) .",\n".   
                      "max = ". FKong::db::SqlQuote($old_max) ."\n".   
                      "WHERE fieldId = $fieldId"); 
}

#  FIXME configure two decimal places
check_onechanged_submit(4, 'money',      0,     '0.00');
check_onechanged_submit(4, 'money',      1,     '0.01');
check_onechanged_submit(4, 'money',      2,      '.02');
check_onechanged_submit(4, 'money',      3,    '  .03');
check_onechanged_submit(4, 'money',      4,    '.04  ');
check_onechanged_submit(4, 'money',      5,    ' .05 ');
check_onechanged_submit(4, 'money',     91,     '0.91');
check_onechanged_submit(4, 'money',    200,     '2.00');
check_onechanged_submit(4, 'money',    201,    '$2.01');
check_onechanged_submit(4, 'money',    202,    '2.02$');
check_onechanged_submit(4, 'money',    203,   '$ 2.03');
check_onechanged_submit(4, 'money',    204,   '2.04 $');
check_onechanged_submit(4, 'money',    205,   '2.$05',   0);
check_onechanged_submit(4, 'money',   4000,    '40.00');
check_onechanged_submit(4, 'money',   4100,    '41.003', 0);
check_onechanged_submit(4, 'money',   4203,    '42.030');
check_onechanged_submit(4, 'money',   3000,       '30');
check_onechanged_submit(4, 'money',  31000,      '310');
check_onechanged_submit(4, 'money',    550,      '5.5');
check_onechanged_submit(4, 'money',    800,        '8');
check_onechanged_submit(4, 'money', -50001,  '-500.01');
check_onechanged_submit(4, 'money',     -1,    '-0.01');
check_onechanged_submit(4, 'money',    -81,    '-0.81');
check_onechanged_submit(4, 'money',    -31,     '-.31');
check_onechanged_submit(4, 'money',   -101,    '-1.01');
check_onechanged_submit(4, 'money',  undef,         '');
check_onechanged_submit(4, 'money',   -100,    '-1.00');
check_onechanged_submit(4, 'money',    110,     '1.10',  1, -300, undef);
check_onechanged_submit(4, 'money',    120,     '1.20',  1, -300, 300);
check_onechanged_submit(4, 'money',    130,     '1.30',  1, undef, 300);
check_onechanged_submit(4, 'money',    140,     '1.40',  0, -100, 100);
check_onechanged_submit(4, 'money',   -140,    '-1.40',  0, -100, 100);
check_onechanged_submit(4, 'money',      0,        '0',  0,   50, 100);
check_onechanged_submit(4, 'money',      0,     'blue',  0);

check_onechanged_submit(4, 'ip',   sprintf("%u",0x10101010),    '16.16.16.16');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x01020304),    '1.2.3.4');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x0a0b0c0d),    '10.11.12.13');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x01020305),    '  1.2.3.5');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x01020306),    '01.02.03.06');
check_onechanged_submit(4, 'ip',   0,                           '0.0.0.0');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x7f101010),    '127.16.16.16');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x80000000),    '128.0.0.0');
check_onechanged_submit(4, 'ip',   sprintf("%u",0xfffefdfc),    '255.254.253.252');
check_onechanged_submit(4, 'ip',   sprintf("%u",0xfcfdfeff),    '252.253.254.255');
check_onechanged_submit(4, 'ip',   undef,                       ' ');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x10101010),    ' 16.16.16.16');
check_onechanged_submit(4, 'ip',   undef,                       '');
check_onechanged_submit(4, 'ip',   sprintf("%u",0x10101011),    '	16.16.16.17 ');
check_onechanged_submit(4, 'ip',   undef,    '16.16.16', 0);
check_onechanged_submit(4, 'ip',   undef,    '161616', 0);
check_onechanged_submit(4, 'ip',   undef,    '16.16.16.16 blue', 0);

check_onechanged_submit(4, 'float',   -100,    '-100');
check_onechanged_submit(4, 'float',      0,       '0');
check_onechanged_submit(4, 'float',    0.1,     '0.1');
check_onechanged_submit(4, 'float',      0,      '-0');
check_onechanged_submit(4, 'float',   -0.1,    '-0.1');
check_onechanged_submit(4, 'float',      0,      '+0');
check_onechanged_submit(4, 'float',   2000,    '+2e3');
check_onechanged_submit(4, 'float',    200,     '2e2');
check_onechanged_submit(4, 'float',   0.02,    '2e-2');
check_onechanged_submit(4, 'float',  30000,    '3e+4');
check_onechanged_submit(4, 'float',  50000,   '+5e+4');
check_onechanged_submit(4, 'float',  -6000,   '-6e+3');
check_onechanged_submit(4, 'float',  -4000,    '-4e3');
check_onechanged_submit(4, 'float',  -4100,  '-4.1e3');
check_onechanged_submit(4, 'float',  -4111,'-4.111e3');
check_onechanged_submit(4, 'float',   4200,   '4.2e3');
check_onechanged_submit(4, 'float',  undef,       ' ');
check_onechanged_submit(4, 'float',   4200,   '4.2e3');
check_onechanged_submit(4, 'float',  undef,        '');
check_onechanged_submit(4, 'float',    500,     '500');
check_onechanged_submit(4, 'float',    501,     '501', 0, 600);
check_onechanged_submit(4, 'float',    502,     '502', 0, undef, 300);
check_onechanged_submit(4, 'float',    503,     '503', 0, 100, 300);
check_onechanged_submit(4, 'float',    504,    'blue', 0);

check_onechanged_submit(4, 'hexint',    15,     '0x0f');
check_onechanged_submit(4, 'hexint',    14,       '0e');
check_onechanged_submit(4, 'hexint',    13,        'd');
check_onechanged_submit(4, 'hexint',     9,        '9');
check_onechanged_submit(4, 'hexint',     8,      '0x8');
check_onechanged_submit(4, 'hexint',     0,      '0x0');
check_onechanged_submit(4, 'hexint', undef,         '');
check_onechanged_submit(4, 'hexint',   256,    '0x100');
check_onechanged_submit(4, 'hexint', undef,        ' ');
check_onechanged_submit(4, 'hexint',   sprintf("%u",0xfedcba91),      'fedcba91');
check_onechanged_submit(4, 'hexint',   sprintf("%u",0x12345678),    '0x12345678');
check_onechanged_submit(4, 'hexint',   sprintf("%u",0xfedcba98),    '0xfedcba98');

check_onechanged_submit(4, 'integer',     9,        '9');
check_onechanged_submit(4, 'integer',     0,        '0');
check_onechanged_submit(4, 'integer', undef,       '	');
check_onechanged_submit(4, 'integer', 11111,    '11111');
check_onechanged_submit(4, 'integer',    -9,       '-9');
check_onechanged_submit(4, 'integer',     9,       '+9');
check_onechanged_submit(4, 'integer', undef,         '');
check_onechanged_submit(4, 'integer', 999999999,'999999999');
check_onechanged_submit(4, 'integer',     4,       ' 4');
check_onechanged_submit(4, 'integer',     5,       '5 ');
check_onechanged_submit(4, 'integer', undef,       ' ');
check_onechanged_submit(4, 'integer',     2,       '02');
check_onechanged_submit(4, 'integer',     50,     '050');
check_onechanged_submit(4, 'integer',     90,     '090');
check_onechanged_submit(4, 'integer',     91,    'blue', 0);

check_onechanged_submit(4, 'bool',     1,     'on');
check_onechanged_submit(4, 'bool',     0,       '');

check_onechanged_submit(4, 'unix_ts',     10000*60, time2str($timeformat,10000*60));
check_onechanged_submit(4, 'unix_ts',     undef,     ' ');
check_onechanged_submit(4, 'unix_ts',     10040*60, time2str($timeformat,10040*60));
check_onechanged_submit(4, 'unix_ts',     undef,     '');

check_onechanged_submit(4, 'oneline',  '',                '');
check_onechanged_submit(4, 'oneline',  'blue green red',  'blue green red');
check_onechanged_submit(4, 'oneline',  'blue       red',  'blue       red');
check_onechanged_submit(4, 'oneline',  'blue& green red', 'blue& green red');
check_onechanged_submit(4, 'oneline',  'blue< g>een red', 'blue< g>een red');
check_onechanged_submit(4, 'oneline',  'blue',            'blue');
check_onechanged_submit(4, 'oneline',  'green',           '  green');
check_onechanged_submit(4, 'oneline',  'red',             'red   ');
check_onechanged_submit(4, 'oneline',  'yellow',          'yellow	');

check_onechanged_submit(4, 'multiline',  '',                '');
check_onechanged_submit(4, 'multiline',  'blue green red',  'blue green red');
check_onechanged_submit(4, 'multiline',  'blue       red',  'blue       red');
check_onechanged_submit(4, 'multiline',  'blue& green red', 'blue& green red');
check_onechanged_submit(4, 'multiline',  'blue< g>een red', 'blue< g>een red');
check_onechanged_submit(4, 'multiline',  'blue',            'blue');
check_onechanged_submit(4, 'multiline',  'green',           '  green');
check_onechanged_submit(4, 'multiline',  'red',             'red   ');
check_onechanged_submit(4, 'multiline',  'yellow',          'yellow	');
check_onechanged_submit(4, 'multiline',  "foo\nbar",        "foo\nbar");
check_onechanged_submit(4, 'multiline',  "foo\nbar\nme",    "foo\nbar\nme");
check_onechanged_submit(4, 'multiline',  "foo\nbaz \nme",   "\nfoo\nbaz \nme");
check_onechanged_submit(4, 'multiline',  "foo\n you\nme",   "foo\n you\nme");
check_onechanged_submit(4, 'multiline',  "foo\nbar\nMe",    "foo\nbar\nMe\n");
check_onechanged_submit(4, 'multiline',  "foo\nbar\nme",    "foo\nbar\nme\n\n");

