
# Copyright 2003,2004 Frederick Dean

use strict;

use FKong::list;

package FKong::comment;

sub field_id_with_link { 
   return FKong::cgi::Link("/$_[1]$_[0].html") . "$_[1]$_[0]</a>" 
};

sub commands { 
   my($commentId) = @_;
   return FKong::cgi::Link("edit.html",["commentId=$commentId"]) ."Edit</a>\n" .
          FKong::cgi::Link("delete.html",["commentId=$commentId"]) ."Delete</a>\n".
          FKong::cgi::Link("list.html",["commentId=$commentId"]) ."Fields</a>";
}

my $tbl = FKong::list->new('comment','comment');
#           nick private         title  align default   sql          display      descript replaceable
$tbl->DefCol("p90",0,            "Commands",1,1,"comment.commentId",   \&commands, "");
$tbl->DefCol("p10",0,               "DB ID",1,0,"comment.commentId",        undef, "");
$tbl->DefCol("p23",0,           "Record ID",1,1,"comment.recId",  \&FKong::table::field_id_with_link, "");
$tbl->DefCol("p43",0,             "Subject",0,1,"comment.subject",          undef, "");
#$tbl->DefCol("p98",0,             "Parent",1,1,"comment.parentId",        undef, "");
$tbl->DefCol("p52",0,          "Created By",0,1,"COALESCE(creator.username,comment.create_by)",undef, "",
             "LEFT JOIN user AS creator ON (creator.userid = comment.create_by)\n");
$tbl->DefCol("p50",0,       "Creation Time",1,1,"comment.createTS",\&FKong::list::unixTimestamp, "");
$tbl->DefCol("p46",0,              "Format",0,0,"comment.format",           undef, "");
$tbl->DefCol("p48",0,                "Body",0,0,"comment.body",             undef, "");
$tbl->DefCol("p54",0,         "Modified By",1,1,"COALESCE(modify.username,comment.mod_by)",undef, "Who last modified the field",
             "LEFT JOIN user AS modify ON (modify.userid = comment.mod_by)\n");
$tbl->DefCol("p55",0,         "Modify Time",1,0,"comment.modifyTS",\&FKong::list::unixTimestamp, "When the field was last modified");


sub keeper_parameters
{
   return [ FKong::list::column_params($tbl) ];    # list reference
}

$FKong::table_func{'comment/list.html'} = \&show_table;
$FKong::table_func{'comment/list.csv'} = $FKong::table_func{'comment/list.html'};

sub show_table
{
   my($fktable) = @_;

   # check that they have permission 
   FKong::session::must_have_priv("view_features");
   # check for configure button
   if($FKong::cgi::form{'update'}) {  # If the now button was pressed
      update();
      return FKong::cgi::redirect("comments.html");
   }
   if($FKong::cgi::form{'delete'}) {  
      dirty_work_of_delete($fktable);
      return FKong::cgi::redirect("comments.html");
   }
   if($FKong::cgi::form{'cancel'}) {  
      return FKong::cgi::redirect("comments.html");
   }
   # update list object for specific table
   $tbl->DefCol("p23",0,"$$fktable{'name'} ID",1,1,"comment.$$fktable{'pkey'}",\&FKong::table::field_id_with_link, "", "", 1);
   # column headings
   my $keepers = keeper_parameters();
   my($colsql,$ordersql,$joins) = $tbl->get_column_sql($keepers,"-p50");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # submit the query
   my $query = "SELECT $colsql\nFROM $$fktable{'tablesql'}_comment AS comment\n".
               $joins.
               "GROUP BY commentId\n".
               "ORDER BY $ordersql\nLIMIT $maxRecords";
   $tbl->print_template_with_table("template/comments-template.html",$query,$keepers);
}

$FKong::table_func{'comment/delete.html'} = \&delete_comment;

sub delete_comment
{
   my($fktable) = @_;
   FKong::session::must_have_priv("edit_features");
   comment_keyword_details($fktable);
   FKong::cgi::print_expanded_template("template/comment_delete-template.html"); 
}

$FKong::table_func{'comment/edit.html'} = \&edit_comment;

sub edit_comment
{
   my($fktable) = @_;
   FKong::session::must_have_priv("view_features"); # The edit form doubles as the detail page
   comment_keyword_details($fktable);
   FKong::cgi::print_expanded_template("template/comment_edit-template.html"); 
} 

sub comment_keyword_details
{
   my($fktable) = @_;
   $FKong::cgi::form{'commentId'} or FKong::Fatal("Internal error: commentId missing.",'');
   $FKong::cgi::form{'commentId'} =~ /^\d+$/ or FKong::Fatal("Internal error: commentId malformed.",'');
   my $dbh = FKong::db::SendSQL("SELECT  format,subject,body,featureId,commentId \n".
                         "FROM $$fktable{'tablesql'}_comment\n".
                         "WHERE commentId = $FKong::cgi::form{'commentId'} LIMIT 1");
   my($format,$subject,$body,$featureId,$cid) = $dbh->fetchrow_array();
   $cid or FKong::Fatal("commentId $FKong::cgi::form{'commentId'} does not exist.",'');
   $FKong::cgi::keyword{'commentId'} = $FKong::cgi::form{'commentId'};
   $FKong::cgi::keyword{'format'} = FKong::cgi::value_quote($format);
   $FKong::cgi::keyword{'subject'} = FKong::cgi::value_quote($subject);
   $FKong::cgi::keyword{'body'} = FKong::cgi::value_quote($body);
   $FKong::cgi::keyword{'featureId'} = FKong::cgi::value_quote($featureId);
   $FKong::cgi::keyword{'hidden'} = "<input type=hidden name=commentId value=\"". FKong::cgi::value_quote($FKong::cgi::form{'commentId'}) ."\">\n";
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/comments.html");
}

$FKong::table_func{'comment/new.html'} = \&new_comment;

sub new_comment
{
   my($fktable) = @_;
   FKong::session::must_have_priv("edit_comment");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/comments.html");
   FKong::cgi::print_expanded_template("template/comment_new-template.html"); 
}

sub dirty_work_of_delete
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   FKong::session::must_have_priv("edit_comment");
   my $commentId = $FKong::cgi::form{'commentId'};
   if(!$commentId) {  
      FKong::Fatal("Internal error: commentId missing for delete",'');
   }
   FKong::db::SendSQL("LOCK TABLES ${tablesql}_comment WRITE ");
   FKong::db::SendSQL("DELETE FROM ${tablesql}_comment WHERE commentId = ". FKong::db::SqlQuote($commentId));
   FKong::db::SendSQL("UNLOCK TABLES");
}

sub update
{
FKong::Fatal("this is not working yet");
   FKong::session::must_have_priv("edit_comment");
   foreach (qw/body/) {
      FKong::Fatal("non-empty $_ required") if ! $FKong::cgi::form{$_};
      FKong::cgi::trim($FKong::cgi::form{$_});
   }
   my $commentId = $FKong::cgi::form{'commentId'};
   if(!$commentId) {  # if they used the create-new form
      my $dbh = FKong::db::SendSQL("SELECT commentId FROM comment WHERE commentName = ". FKong::db::SqlQuote($FKong::cgi::form{'commentName'}));
      $commentId = $dbh->fetchrow_array();
   }
   if($commentId) {
      # Check that the comment ID exists.
      my $dbh = FKong::db::SendSQL("SELECT commentId FROM comment WHERE commentId = ". FKong::db::SqlQuote($commentId));
      if(! $dbh->fetchrow_array()) {
         FKong::Fatal("Inernal error: commentId not found.\n",'');
      }
      FKong::db::SendSQL("UPDATE comment SET commentName = ". FKong::db::SqlQuote($FKong::cgi::form{'commentName'}) .",\n".
                  "modifyTS = UNIX_TIMESTAMP()\n".
                  "WHERE commentId = ". FKong::db::SqlQuote($commentId));
   } else {
      FKong::db::SendSQL("INSERT INTO comment SET commentName = ". FKong::db::SqlQuote($FKong::cgi::form{'commentName'}) .",\n".
                  "createTS = UNIX_TIMESTAMP(), create_by = $FKong::cgi::keyword{'userid'},\n".
                  "modifyTS = createTS, mod_by = $FKong::cgi::keyword{'userid'}");
      $commentId = FKong::db::last_insert_id();
   };
}

$FKong::table_func{'comment/columns.html'} = \&column_choice_table;

# This prints the form that lets users indicate which fields they want to see, 
# when viewing the table of all fields.
sub column_choice_table
{
   my($fktable) = @_;  # ignore
   FKong::Fatal("This table does not support comments.") if $$fktable{'comments'};
   my $tablesql = "$$fktable{'tablesql'}_comment";
   $FKong::cgi::keyword{'formurl'} = "list.html";
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$tablesql);
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

1;  # return code

