
#  Copyright 2003,2004 Frederick Dean

use strict;

package FKong::table;

use FKong::list;

sub field_id_with_link { 
   return FKong::cgi::Link("/$_[1]$_[0].html") . "$_[1]$_[0]</a>" 
};

sub delete_link { return FKong::cgi::Link("delete.html",["id=$_[0]"]) ."delete</a>" }

my %right_align = (mult_choice => 0, integer => 1, hexint => 1, money => 1, oneline => 0, multiline => 0, 
                   bool => 0, float => 1, constant => 0,user => 0, unix_ts => 1);

sub hex_format { return sprintf("0x%02X",$_[0]); }
sub money_format { 
   my $money = $_[0];
   my $short = 1 + $FKong::config{'MoneyDecimalPlaces'} - length $money;
   $money = ("0" x $short) . $money if $short > 0;  # append leading zeros if needed
   $money =~ s/(.{$FKong::config{'MoneyDecimalPlaces'}})$/.$1/;   # insert decimal
   return $money; 
}
sub yes_no { return $_[0] ? "yes" : (length($_[0]) ? '<font color="#888888">no</font>' : '') }

our %type_func = ( unix_ts => \&FKong::list::unixTimestamp, hexint => \&hex_format, money => \&money_format, bool => \&yes_no );

sub define_list_object
{
   my($tbl,$fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   my $dbh = FKong::db::SendSQL("SELECT fieldId, list_show, fieldName, short_help, type, sqlName FROM field_def\n".
                                "WHERE tablesql = ". FKong::db::SqlQuote($tablesql) ." ORDER BY sort, fieldName");
   #           nick private         title  align default   sql          display      descript                       
   $tbl->DefCol("T00",0,                  "ID",1,1,"$tablesql.$pkey",\&field_id_with_link, "Internal database ID of the $tablesql table");
   $tbl->DefCol("T01",0,                  "ID",1,0,"$tablesql.$pkey",\&delete_link, "Link to delete") if FKong::session::has_priv('delete_features');
   while(my($fieldId,$list_show,$fieldName,$short_help,$type,$sqlName) = $dbh->fetchrow_array()) {
      next if $type eq 'constant';
      my $join;
      if($type eq 'user') {
         $join = "LEFT JOIN user AS $sqlName ON ($tablesql.$sqlName = $sqlName.userid)\n";
         $sqlName = "$sqlName.username";
      };
      $tbl->DefCol("t$fieldId",0,$fieldName,$right_align{$type},$list_show,$sqlName,$type_func{$type}, $short_help,$join);
   };
   #$tbl->DefCol("T50",0,       "Created By ID",1,0,"$tablesql.create_by",undef, "");
   $tbl->DefCol("T51",0,           "Create By",1,0,"COALESCE(creator.username,$tablesql.create_by)",undef, "Who originally created the feature",
                "LEFT JOIN user AS creator ON (creator.userid = $tablesql.create_by)\n");
   $tbl->DefCol("T52",0,         "Create Time",1,0,"$tablesql.createTS",\&FKong::list::unixTimestamp, "When was the feature created");
   #$tbl->DefCol("T53",0,      "Modified By Id",1,0,"$tablesql.mod_by",undef, "");
   $tbl->DefCol("T54",0,         "Modified By",1,0,"COALESCE(modify.username,$tablesql.mod_by)",undef, "Who last modified the feature",
                "LEFT JOIN user AS modify ON (modify.userid = $tablesql.mod_by)\n");
   $tbl->DefCol("T55",0,         "Modify Time",1,0,"$tablesql.modifyTS",\&FKong::list::unixTimestamp, "When was the feature last modified");
   $tbl->DefCol("T60",0,            "Comments",1,1,"COUNT(${tablesql}_comment.commentId)", undef, "A count of the number of comments",
                "LEFT JOIN ${tablesql}_comment ON (${tablesql}_comment.$pkey = $tablesql.$pkey)\n") if $$fktable{'comments'};
}

sub show_table
{
   my($keep_list,$fktable,@wheres) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $recprefix = $$fktable{'recprefix'};
   # check that they have permission 
   FKong::session::must_have_priv("view_features");
   FKong::session::must_have_priv("view_fields") if $$fktable{'internal'};
   my $tbl = FKong::list->new($tablesql,$recprefix);
   $tbl->keep_list() if $keep_list;  # set flag to store recId list
   define_list_object($tbl,$fktable);
   # column headings
   my $keepers = [ FKong::list::column_params($tbl) ];    # list reference
   my($colsql,$ordersql,$joins) = $tbl->get_column_sql($keepers,"-T00");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # submit the query
   foreach my $param (sort keys %FKong::cgi::form) {
      next unless $param =~ /^t(\d+)$/;  # param must be a feature list param
      next unless $FKong::cgi::form{$param};   # param must be true
      my $fieldId = $1;
   };
   my $where = "";
   $where = "WHERE ". join("\nAND ",@wheres) ."\n" if scalar @wheres;
   my $query = "SELECT $keep_list $colsql\nFROM $tablesql\n".
               $joins .
               $where .
               "GROUP BY $tablesql.$$fktable{'pkey'} ORDER BY $ordersql\nLIMIT $maxRecords";
   $tbl->print_template_with_table("template/features-template.html",$query,$keepers);
}

our @search_params;  # These are the URL GET parameter names which matter to the search.  Used for form_query_link()

sub form_query_link
{
   my $query_url = "";
   foreach my $param (@search_params) {
      my $value = $FKong::cgi::form{$param};
      next unless defined $value && length $value;  # skip this param if empty
      $query_url .= "&" if $query_url;
      $query_url .= join('&',map { "$param=". FKong::cgi::urlQuote($_) } split(/\0/,$FKong::cgi::form{$param}));
      #$query_url .= "$param=". FKong::cgi::urlQuote($value);  # or am I confident a character nul will not cause problems?
   };
   return $query_url;
}

#  First we look through all the enum values.
#  If an enum value is listed then that field must be one of the values listed.
#  If two enum fields happen to allow the same value, we are broken.  FIXME
#  Any words which are not used for enum, are then matched for one of the text areas.
sub basic_query
{
   my($fktable,$suffix) = @_;
   # process free-form 'text' search criteria
   my %enums;
   my @extra_words;
   push(@search_params,'text');
   foreach my $word (split(/ /,$FKong::cgi::form{'text'} || "")) {
      my $dbh = FKong::db::SendSQL("SELECT sqlName FROM choice LEFT JOIN field_def USING (fieldId)\n".
                            "WHERE choice = ". FKong::db::SqlQuote($word));
      if(my $sqlName = $dbh->fetchrow_array()) {
         $enums{$sqlName} .= "\0" if $enums{$sqlName};
         $enums{$sqlName} .= $word;
      } else {
         push(@extra_words,$word);
      };
   }
   # Create SQL
   my @wheres;  # to keep all the AND'ed clauses
   foreach my $sqlName (keys %enums) {  # for every enum field
      my @choices = split(/\0/,$enums{$sqlName});
      push(@wheres,"(". join(" OR ",map { "$sqlName = ". FKong::db::SqlQuote($_) } @choices) .")");
   };
   # Now create SQL for extra words
   if(scalar(@extra_words)) {
      my $dbh = FKong::db::SendSQL("SELECT sqlName FROM field_def WHERE (adv_search OR basic_search)\n".
                                   "AND (type = 'oneline' OR type = 'multiline')\n".
                                   "AND tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}));
      my @sqlNames;
      while(my $sqlName = $dbh->fetchrow_array()) {
         push(@sqlNames,$sqlName);
      };
      foreach my $word (@extra_words) {  # for every extra word
         $word = FKong::db::SqlQuote(lc($word));
         push(@wheres,"(". join(" OR ",map { "INSTR(LOWER($_),$word)" } @sqlNames) .")");
      };
   };
   # Process field_def field specifications
   my $dbh = FKong::db::SendSQL("SELECT sqlName, type FROM field_def WHERE (basic_search OR adv_search)");
   while(my($sqlName,$type) = $dbh->fetchrow_array()) {
      if($type eq "oneline" || $type eq "multiline") {
         next unless $FKong::cgi::form{$sqlName};
         push(@wheres,"INSTR(LOWER($sqlName),". FKong::db::SqlQuote(lc($FKong::cgi::form{$sqlName})) .")");
         push(@search_params,$sqlName);
      } elsif($type eq "bool") {
         next unless defined $FKong::cgi::form{$sqlName} && length $FKong::cgi::form{$sqlName};
         push(@wheres,$FKong::cgi::form{$sqlName} ? "$sqlName" : "! $sqlName");
         push(@search_params,$sqlName);
      } elsif($type eq "mult_choice") {
         next unless $FKong::cgi::form{$sqlName};
         push(@wheres,"$sqlName IN (". (join(',',map { FKong::db::SqlQuote($_) } split(/\0/,$FKong::cgi::form{$sqlName}))) .")");
         push(@search_params,$sqlName);
      } elsif($type eq "integer" || $type eq 'hexint' || $type eq 'money' || $type eq "float") {
         if(defined $FKong::cgi::form{"$sqlName-min"} && length FKong::cgi::trim($FKong::cgi::form{"$sqlName-min"})) {
            push(@wheres,"$sqlName > ". FKong::db::SqlQuote($FKong::cgi::form{"$sqlName-min"}));
            push(@search_params,"$sqlName-min");
         }
         if(defined $FKong::cgi::form{"$sqlName-max"} && length FKong::cgi::trim($FKong::cgi::form{"$sqlName-max"})) {
            push(@wheres,"$sqlName < ". FKong::db::SqlQuote($FKong::cgi::form{"$sqlName-max"}));
            push(@search_params,"$sqlName-max");
         }
      }  # else do nothing
   };
   $FKong::cgi::keyword{'oldQuery'} = form_query_link();
   FKong::session::set_state("$$fktable{'tablesql'}-$suffix",$FKong::cgi::keyword{'oldQuery'});
   return \@wheres;
}

sub delete_record
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   FKong::session::must_have_priv('delete_features');
   FKong::session::must_have_priv("edit_fields") if $$fktable{'internal'};
   FKong::Fatal("Internal Error: delete has no id") if ! $FKong::cgi::form{'id'};
   FKong::Fatal("Internal Error: delete has malformed id") if $FKong::cgi::form{'id'} !~ /^\d+$/;
   FKong::db::SendSQL("DELETE FROM ${tablesql} WHERE $pkey = ". FKong::db::SqlQuote($FKong::cgi::form{'id'}));
   FKong::db::SendSQL("DELETE FROM ${tablesql}_comment WHERE $pkey = ". FKong::db::SqlQuote($FKong::cgi::form{'id'})) if $$fktable{'comments'};
   FKong::db::SendSQL("DELETE FROM ${tablesql}_change WHERE $pkey = ". FKong::db::SqlQuote($FKong::cgi::form{'id'})) if $$fktable{'changes'};
   FKong::cgi::redirect(FKong::cgi::Uri(""));
}

$FKong::table_func{'list.html'} = \&show_list;
$FKong::table_func{'list.csv'} = $FKong::table_func{'list.html'};

sub show_list
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   if($FKong::cgi::form{'delete_feature'}) {  
      delete_record($fktable);  
   } elsif($FKong::cgi::form{'search'}) {  # if they are basic searching
      my $wheres = basic_query($fktable,'query');
      show_table("$$fktable{'tablesql'}.$$fktable{'pkey'},",$fktable,@$wheres);  
   } elsif($FKong::cgi::form{'text'}) {  # if they are super-basic searching (from the header)
      my $wheres = basic_query($fktable,'query');
      show_table("$$fktable{'tablesql'}.$$fktable{'pkey'},",$fktable,@$wheres);  
   } elsif(my $list = ($FKong::cgi::form{'list'} || FKong::session::get_state("$tablesql-list"))) {  # else if they have a saved list
      $FKong::cgi::keyword{'oldQuery'} = (FKong::session::get_state("$tablesql-query") || "");
      $FKong::cgi::keyword{'theList'} = $list;
      $list =~ tr/0-9,//dc;  # delete non-numeral non-commas  (redundant safety precaution)
      show_table("",$fktable,"$tablesql.$$fktable{'pkey'} IN ($list)");
   } else {  # else redirect them to the search form
      #show_table("$tablesql.$$fktable{'pkey'},$fktable,");  # as a default for now show them all
      FKong::cgi::redirect("search.html?");  #  last resort show search form
   }
}

$FKong::table_func{'count.html'} = \&show_counts;
$FKong::table_func{'count.csv'} = $FKong::table_func{'count.html'};

sub show_counts
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   if($FKong::cgi::form{'count'}) {  # if they are basic searching
      push(@search_params,'vert','horiz','hrange','vrange');  
      my $wheres = basic_query($fktable,'query2');
      FKong::count::show_count(1,$fktable,@$wheres);  
   } elsif(my $list = ($FKong::cgi::form{'list'} || FKong::session::get_state("$tablesql-list"))) {  # else if they have a saved list
      $FKong::cgi::keyword{'oldQuery'} = (FKong::session::get_state("$tablesql-query2") || "");
      $FKong::cgi::keyword{'theList'} = $list;
      $list =~ tr/0-9,//dc;  # delete non-numeral non-commas  (redundant safety precaution)
      FKong::count::show_count(0,$fktable,"$tablesql.$$fktable{'pkey'} IN ($list)");
   } else {  # else redirect them to the search form
      FKong::cgi::redirect("count_form.html?");  #  last resort show count form
   }
}

$FKong::table_func{'columns.html'} = \&column_choice;

sub column_choice
{
   my($fktable) = @_;
   $FKong::cgi::keyword{'formurl'} = "list.html";
   my $tbl = FKong::list->new($$fktable{'tablesql'},$$fktable{'recprefix'});
   define_list_object($tbl,$fktable);
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$$fktable{'tablesql'});
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

sub Done
{
   @search_params = ();
}

1;

__END__



