package FKong;

# Copyright 2003,2004 Frederick Dean

use 5.008;
use strict;
use warnings;

our $VERSION = '3.00';

use Apache::RequestRec;
use Apache::RequestIO;
use Apache::RequestUtil;
use Apache::Util qw(:all);
use Apache::Response;
#use Apache::File;
use APR::Pool;
use APR::Table;

use Apache::Const -compile => qw(OK);

use FKong::cgi;
use FKong::config;
use FKong::db;
use FKong::session;
use FKong::record;
use FKong::history;
use FKong::search;
use FKong::table;
use FKong::submit;
use FKong::fktable;
use FKong::field;
use FKong::help;
use FKong::sqllog;
use FKong::pref;
use FKong::main;
use FKong::count;
#use FKong::comment;

use Date::Format;
use Date::Parse;

#our($debug,$htmldir,$db_host,$db_port,$db_name,$db_user,$db_pass);  # actually defined in featurekong_startup.pl

our $r;   # We need GlobalRequest, i.e. we must use the multi-process not multi-thread model.

sub log_message 
{
   FKong::db::SendSQL("INSERT INTO log SET remoteIP = ". FKong::session::remote_ip() .",\n".
                "create_by = ".  FKong::db::SqlQuote($FKong::cgi::keyword{'userid'}) .",\n". 
                "createTS = UNIX_TIMESTAMP(),\n".
                "pathfile = ". FKong::db::SqlQuote(substr($r->parsed_uri->path,length $r->location,100)) .",\n".
                "message = ". FKong::db::SqlQuote($_[0]));
}

my $num_fatalities_left;  # to prevent infinite looping

# The first arg is shown to the user.
# The second arg is logged to the database.
# Empty but defined second arg means log first arg stuff to db too.
sub Fatal
{
   my($msg,$log) = @_;
   $num_fatalities_left--;  
   goto FATALDONE if $num_fatalities_left < 0;
   goto DONE if $num_fatalities_left < 1;
   #die $_[1] if $fatalities++ > 3;  # prevent possible infinite recursive looping
   FKong::db::maybe_unlock_tables();   # Should not be needed, but just in case.
   if($FKong::r->status() == 200) {
      $FKong::r->status("500");
   };
   $FKong::r->content_type("text/html");
   $FKong::r->rflush;   # force it to send our content_type   WTF?
   $FKong::r->print("<p><font size=+2 color=red>Fatal Error</font>\n".
             "<p>$msg\n");
   if($msg =~ /open/i || $msg =~ /creat/i || $msg =~ /move/i || $msg =~ /delete/i) {
      $FKong::r->print("<p>Please check your unix file permissions.\n") 
   };
   $log = $msg if defined $log && $log eq '';
   log_message($log) if $log;
   goto DONE;  #   FKong::handler()
} 


#  You would think there is a way to do this more automatically.
sub sendfile
{
   my($r,$filename) = @_;
   if(! -r $filename) {  # if the file is not readable
      $r->status(403);
      # Add spaces so MSIE shows our error message
      $r->print("<h1>403 Access Forbidden</h1>\nFile permissions problem.<br>" . (" " x 1024));
      goto DONE;
   }
   if($filename =~ /\.jpe?g$/i) {
      $r->content_type("image/jpeg");
   } elsif($filename =~ /\.gif$/i) {
      $r->content_type("image/gif");
   } elsif($filename =~ /\.bmp$/i) {
      $r->content_type("image/bmp");
   } elsif($filename =~ /\.png$/i) {
      $r->content_type("image/png");
   } elsif($filename =~ /\.html?$/i) {
      $r->content_type("text/html");
   }
   #$r->set_last_modified(fileModTime($filename));   # Apache::File
   $r->mtime(fileModTime($filename));   # Apache::RequestRec
   $r->headers_out->set("Last-Modified",time2str("%a, %d %b %Y %H:%M:%S %Z",$r->mtime,'GMT')); # RFC 822, updated by RFC 1123
   return if $r->header_only;
   if(! $FKong::debug || $r->content_type !~ /^text/) {
      $r->set_content_length(-s $filename) 
   }
   $r->rflush;   # force it to send our content_type   WTF?
   $r->sendfile($filename);
}

sub cleanPath {
   my($path) = @_;
   $path =~ s|//+|/|g;  # eliminate repeated slashes
   while($path =~ s|/[^/]+/\.\./|/|g) {};  # eliminate parent dir references /../
   while($path =~ s|/\./|/|g) {};  # eliminate self dir references /./
   while($path =~ s|^\./||g) {};  # eliminate self dir references /./
   while($path =~ s|/\.$||g) {};  # eliminate self dir references /./
   #$path =~ s|./$||g;  # eliminate trailing slash
   return $path;
}

sub wide_footer
{
   my $footer = "<div id=footlink><hr noshade>\n";
   my  $fkroot = $FKong::cgi::keyword{'fkroot'};
   my $tableurl = FKong::cgi::Uri("$fkroot$FKong::cgi::keyword{'tableurl'}");
   if($FKong::cgi::keyword{"userid"} == 99) {
      $footer .= "<a href=\"${fkroot}login.html\">Login</a><br>\n";
   } else {
      $footer .= "<a href=\"${fkroot}index.html?logout=1\">Logout</a> as ". FKong::cgi::htmlQuote($FKong::cgi::keyword{'username'}) ." | \n".
                                 "<a href=\"${fkroot}password.html\">Password Change</a><br>\n"; 
   }
   $footer .= "<a href=\"${fkroot}user/search.html\">Search Users</a> | \n".
                              "<a href=\"${fkroot}user/list.html\">List Users</a> | \n".
                              "<a href=\"${fkroot}user/new.html\">New User</a><br>\n" if FKong::session::has_priv('view_users');
   $footer .= "<a href=\"$tableurl/field/list.html\">Design Table</a> \n" if FKong::session::has_priv('view_fields');
   $footer .= " | ". FKong::cgi::Link("",["edit=1"]) ."Show Field Edit Links</a>\n" if 
                  FKong::session::has_priv('view_fields') && $FKong::cgi::keyword{'fform'};
   $footer .= "<br>\n" if FKong::session::has_priv('view_fields');
   $footer .= "<a href=\"${fkroot}config.html\">Global Config</a> | \n".
                              FKong::cgi::Link("",[ "toggle_debug=1" ]) ."Toggle Debug</a><br>\n" if FKong::session::has_priv('view_other');
   $footer .= "<a href=\"${fkroot}fklog/list.html\">List Log</a><br>\n" if FKong::session::has_priv('view_log');
   $footer .= "</div>\n";
   $footer .= FKong::cgi::return_expanded_template("template/footer-template.html");
   return $footer;
}

sub redirect_with_trailing_slash
{
   my $query = $r->parsed_uri->query;
   $r->headers_out->set(Location => $r->parsed_uri->path . ($query ? "/?$query" : "/"));
   $r->status(302); #  Apache::REDIRECT
}

sub fileModTime { return (stat $_[0])[9] };

#  This is where we register all our internal pages.
our %url_func;  # The hash key is a URL
our %table_func;  #  The hash key is a HTML filename, found after a table url.  i.e.  /tableurl/filename.html

$url_func{'dir_list.html'} = \&show_dir_listing;

sub show_dir_listing {
   $r->content_type("text/html");
   $r->rflush;   # force it to send our content_type   WTF?
   $r->print("<table width=600><tr valign=top><td width=40%>\n");
   $r->print("<h2>url_func</h2>\n");
   foreach (sort keys %url_func) { $r->print("<li>". FKong::cgi::Link($_) . FKong::cgi::htmlQuote($_) ."</a><br>\n"); };
   $r->print("</td><td>\n");
   $r->print("<h2>table_func</h2>\n");
   foreach (sort keys %table_func) { $r->print("<li>". FKong::cgi::Link("feature/$_") . FKong::cgi::htmlQuote($_) ."</a><br>\n"); };
   $r->print("</td><td>\n");
   $r->print("<h2>Tables</h2>\n");
   my $dbh = FKong::db::SendSQL("SELECT url FROM fktable");
   while(my @row = $dbh->fetchrow_array()) {
      my($url) = @row;
      $r->print("<li>". FKong::cgi::Link("/$url/list.html") . "$url</a>\n");
   };
   $r->print("</td></tr></table>\n");
}

$url_func{'index.html'} = \&show_root_page;
$url_func{''} = $url_func{'index.html'};

sub show_root_page {
   $FKong::cgi::keyword{'stuff'} = '';
   $FKong::cgi::keyword{'stuff'} .= "<h2>Tables:</h2>\n";
   $FKong::cgi::keyword{'stuff'} .= "<ul>\n";
   my $dbh = FKong::db::SendSQL("SELECT url, name FROM fktable WHERE ! internal");
   while(my @row = $dbh->fetchrow_array()) {
      my($url,$name) = @row;
      $FKong::cgi::keyword{'stuff'} .= "<li>". FKong::cgi::htmlQuote($name) ." : &nbsp;\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/") . "News</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/list.html") . "List</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/search.html") . "Search</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/new.html") . "Create</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/count_form.html") . "Count</a>\n";
      $FKong::cgi::keyword{'stuff'} .= "<br>\n";
   };
   $FKong::cgi::keyword{'stuff'} .= "</ul>\n";
   FKong::cgi::print_expanded_template("template/root.html");
}

sub handler {
   $r = shift;

   $num_fatalities_left = 3;  # to prevent infinite looping
   $FKong::debug = 0 if $FKong::debug eq "session";  # reset the debug flag 
   FKong::db::maybe_unlock_tables();   # Should not be needed, but just in case.
   FKong::cgi::Done($r);
   FKong::db::Done($r);
   FKong::table::Done($r);
   FKong::config::maybe_load_config();
   $r->content_type('text/html'); # default
   #my $pathfile = $r->path_info;  # strangely dependent on whether certain directories in the path exist!
   my $pathfile = substr($r->parsed_uri->path,length $r->location);
   print STDERR "------------- featurekong pathfile=$pathfile\n" if $FKong::debug;
   if($pathfile eq "") {  # if we need to redirect with a trailing slash
      redirect_with_trailing_slash();  
      goto DONE;
   }
   $pathfile = "/$pathfile" if $pathfile !~ /^\//;  # pre-pend a slash if not present
   $pathfile = cleanPath($pathfile);
   # if the path after simplification begins with a .. element, then it is illegal
   if($pathfile =~ /^\/?\.\.\// || $pathfile eq "/..") {
      $r->status(400);
      Fatal("400 illegal path. The path you request is illegal because it has too many parent references (..)");
   }
   if($pathfile !~ /^([\w\-+=:'`!\@^~\., \/]*)$/) {  # if not all allowable characters
      $r->status(403);
      Fatal("403 Forbidden. Your path contains forbidden characters.");
   }
   $pathfile = $1;  # untaint
   $pathfile =~ /(.*\/)(.*)/s or Fatal("500","internal error 2"); # separate with last slash
   my($path,$filename) = ($1,$2);  # $path always has a leading and trailing slash.  $filename never has a slash.

   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("");
   $FKong::cgi::keyword{"nowtime"} = Date::Format::time2str($FKong::config{'TimeFormat'},time()); 
   $FKong::cgi::keyword{'go_to_feature'} = FKong::cgi::value_quote($FKong::cgi::form{'go_to_feature'} || "");
   $FKong::cgi::keyword{'text'} = FKong::cgi::value_quote($FKong::cgi::form{'text'} || "");
   $FKong::cgi::keyword{'search_comments'} = FKong::cgi::value_quote($FKong::cgi::form{'search_comments'} || "");
   $FKong::cgi::keyword{'warning'} = "";
   ($FKong::cgi::keyword{'fkroot'} = substr($path,1)) =~ s/[^\/]+/../gs;  # replace every token with ".." and remove leading slash
   $FKong::cgi::keyword{'footer'} = \&wide_footer;
   $FKong::cgi::keyword{'referer'} = FKong::cgi::value_quote($r->headers_in->get('Referer'));
   $FKong::cgi::keyword{'tablename'} = 'Feature';
   $FKong::cgi::keyword{'tableurl'} = 'feature';

   FKong::cgi::MakeFormHash($r,10000,10,10000000);
   FKong::cgi::MakeCookieHash($r);
   FKong::session::Check();

   if(my $func = $url_func{lc(substr($pathfile,1))}) {
      &$func();
      goto DONE;
   }
   if($pathfile =~ /^\/(\D+)(\d+)(.html?)?$/i) {   # if it looks like a record
      my($recprefix,$recnum) = ($1,$2);
      my $fktable = FKong::fktable::New("recprefix = ". FKong::db::SqlQuote($recprefix)); 
      if($fktable) {
         FKong::record::show_edit_form($recnum,$fktable);
         goto DONE;
      };
   } 

   # Check for table url
   if($path eq "/") {   
      (my $filebasename = $filename) =~ s/\.\w+$//;
      my $dbh = FKong::db::SendSQL("SELECT name, tablesql FROM fktable WHERE url = ". FKong::db::SqlQuote($filebasename)); 
      if(my @row = $dbh->fetchrow_array()) {
         redirect_with_trailing_slash();  # this makes the relative paths in the derived pages consistent, and thus easier
         goto DONE;
      };
   } else {  # else it did not need a trailing slash
      my(undef,$firstdir,$remain) = split("/",$pathfile,3);
      my $fktable = FKong::fktable::New("url = ". FKong::db::SqlQuote($firstdir)); 
      if($fktable) {
         if($table_func{$remain}) {
            &{$table_func{$remain}}($fktable);
            goto DONE;
         };
         if($remain =~ /^(\D+)(\d+)(.html?)?$/i && $1 eq $$fktable{'recprefix'}) {   # if it looks like our record
            FKong::record::show_edit_form($2,$fktable);
            goto DONE;
         };
      };
   }

   # check for some illegal paths
   if($path =~ /\/CVS\//) {  # if has /CVS/ in name
      $r->status(403);
      Fatal("403 forbidden because CVS.");
   }
   if($filename =~ /~$/ ||            # if filename ends with ~
      $filename =~ /^#/ ||            # if filename begins with #
      $filename =~ /^\./ ) {          # or begins with a dot
      $r->status(403);
      Fatal("403 Access forbidden.  Bad filename.");
   }

   my $diskfile = "$FKong::htmldir/$pathfile";
   if(! -e $diskfile) {  # if the file does not exist
      $r->status(404);
      Fatal("404 Not found.");
   } elsif(! -r $diskfile) {  # if the file is not readable
      $r->status(403);
      Fatal("403 Access forbidden.  File permissions.");
   } else {   # send raw file
      sendfile($r,$diskfile);
      goto DONE;
   }

DONE:
   FKong::db::maybe_unlock_tables();   # Should not be needed, but just in case.
   FKong::cgi::debug_prints($r) if $r->content_type =~ m/^text\//i;
   FKong::cgi::Done($r);
   FKong::db::Done($r);
   FKong::table::Done($r);
FATALDONE:
   $r = undef;
   return Apache::OK;
}


1;
__END__

