
use strict;

# Copyright 2003,2004 Frederick Dean

package FKong::config;

#
#  Our config parameter from the DB are stored in %FKong::config
%FKong::config = ();
my %descript = ();
my @names;
my $last_load_time = 0;

sub maybe_load_config
{
   my $new_load_time = time();
   my $dbh = FKong::db::SendSQL("SELECT name, value FROM config WHERE mtime >= $last_load_time");
   while(my @row = $dbh->fetchrow_array()) {
      my($name,$value) = @row;
      $FKong::config{$name} = $value;
      $last_load_time = $new_load_time;
   }
}

sub DefConfigParam
{
   my($name,$type,$default,$descript) = @_;
   push(@names,$name);
   $FKong::config{$name} = $default;
   $descript{$name} = $descript;

}


DefConfigParam('MaxIdleTime','integer',30*24*360,
               'Maximum time a session survives without a hit');

DefConfigParam('TimeFormat','oneline','%a %b %d, %Y %l:%M%P %Z',
                "How we should show the time by default.\n".
                "The codes are explained in perldoc Date::Format.");

DefConfigParam('ListTimeFormat','oneline', '%Y-%b-%d <nobr>%l:%M%P %Z</nobr>',
                "How we should show the time in lists (tables).\n".
                "The codes are explained in perldoc Date::Format.");

DefConfigParam('bugzilla_url', 'oneline', 'http://bugzilla/show_bug.cgi?id=',
              'This is the URL prefix to link bug numbers to.');

DefConfigParam('MoneyDecimalPlaces', 'integer', '2',
              'How many digits are right of the decimal point for fixed precision decimals.');

DefConfigParam('UserPulldown', 'bool', '1',
              'If few users exists it may be convenient to have a pulldown instead of a text entry.');

$FKong::url_func{'config.html'} = \&show_config_page;

sub show_config_page
{
   my($recprefix,$name,$url,$tablesql) = @_;

   FKong::session::must_have_priv("view_other");
   if($FKong::cgi::form{'cancel'}) {
      FKong::cgi::redirect("");
   } elsif($FKong::cgi::form{'commit'}) {
      FKong::session::must_have_priv("edit_other");
      my @sql;
      foreach my $name (@names) {
         if($FKong::cgi::form{$name}) {
            FKong::cgi::trim($FKong::cgi::form{$name});
            if($FKong::cgi::form{$name} ne $FKong::config{$name}) {
               push(@sql,"(UNIX_TIMESTAMP(),". FKong::db::SqlQuote($name) .",".  FKong::db::SqlQuote($FKong::cgi::form{$name}) .")");
            };
         }
      };
      if(scalar @sql) {
         FKong::db::SendSQL("REPLACE config (mtime, name, value) VALUES\n". join(",\n",@sql));
      }
      FKong::cgi::redirect("");
   } else {
      $FKong::cgi::keyword{'config_form'} = '';
      foreach my $name (@names) {
         $FKong::cgi::keyword{'fform'} .= "<tr><td>". FKong::cgi::htmlQuote($name) ."</td>\n".
         "<td><input name=\"". FKong::cgi::value_quote($name) .'" size=50 value="'. 
         FKong::cgi::value_quote($FKong::config{$name}) ."\"> </td></tr>\n".
         "<tr><td colspan=2 bgcolor=#dddddd>". FKong::cgi::htmlQuote($descript{$name}) .
         "</td></tr>\n";
      };
      FKong::cgi::print_expanded_template("template/config.html");
   };
}


