
# Copyright 2003,2004 Frederick Dean

use strict;

use FKong::list;
use FKong::session;  

package FKong::sqllog;

my $tbl = FKong::list->new('log','event');
#           nick private         title  align default   sql          display      descript                       
$tbl->DefCol("L10",0,              "Log ID",1,1,"log.logId",        undef, "");
$tbl->DefCol("L52",0,                "Time",1,1,"log.createTS",\&FKong::list::unixTimestamp, "");
$tbl->DefCol("L34",0,            "Username",1,1,"user.username",      undef, "",
             "LEFT JOIN user ON (user.userid = log.userid)\n");
$tbl->DefCol("L20",0,           "Remote IP",1,1,"log.remoteip",\&FKong::list::ipAddress, "");
$tbl->DefCol("L40",0,             "FK Path",1,1,"log.pathfile",      undef, "");
$tbl->DefCol("L70",0,             "Message",1,1,"log.message",        undef, "");

sub keeper_parameters
{
   return [ FKong::list::column_params($tbl) ];    # list reference
}

$FKong::url_func{'fklog/list.html'} = \&show_table;
$FKong::url_func{'fklog/list.csv'} = $FKong::url_func{'fklog/list.html'};

sub show_table
{
   my($filename) = @_;

   # check that they have permission 
   FKong::session::must_have_priv("view_log");
   # check for configure button
   if($FKong::cgi::form{'cancel'}) {  
      return FKong::cgi::redirect(FKong::cgi::Uri("/fklong/list.html"));
   }
   # column headings
   my $keepers = keeper_parameters();
   my($colsql,$ordersql,$joins) = $tbl->get_column_sql($keepers,"-L52");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # Filter by fieldId
   my $where = "";
   # submit the query
   my $query = "SELECT $colsql\nFROM log\n".
               $joins . $where .
               "ORDER BY $ordersql\nLIMIT $maxRecords";
   $tbl->print_template_with_table("template/fklog.html",$query,$keepers);
}

$FKong::url_func{'fklog/columns.html'} = \&column_choice_table;

# This prints the form that lets users indicate which fields they want to see, 
# when viewing the table of all fields.
sub column_choice_table
{
   my($fktable) = @_;  # ignore
   my $tablesql = 'field_def';
   $FKong::cgi::keyword{'formurl'} = "list.html";
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$tablesql);
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

1;  # return code

