use strict;

# Copyright 2003,2004 Frederick Dean

package FKong::count;

sub show_count
{
   my($keep_list,$fktable,@wheres) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $recprefix = $$fktable{'recprefix'};
   # check that they have permission 
   FKong::session::must_have_priv("view_features");
   FKong::session::must_have_priv("view_fields") if $$fktable{'internal'};
   # verify and learn about the axis
   my $vert = $FKong::cgi::form{'vert'} or FKong::Fatal("Vertical axis not specified.");
   my $horiz = $FKong::cgi::form{'horiz'} or FKong::Fatal("Horizontal axis not specified.");
   my $dbh = FKong::db::SendSQL("SELECT sqlName, type, fieldName FROM field_def WHERE sqlName = ". FKong::db::SqlQuote($horiz) ."\n".
                                "AND tablesql = ". FKong::db::SqlQuote($tablesql));
   my($horizSql,$horizType,$horizName) = $dbh->fetchrow_array;
   my $dbh = FKong::db::SendSQL("SELECT sqlName, type, fieldName FROM field_def WHERE sqlName = ". FKong::db::SqlQuote($vert) ."\n".
                                "AND tablesql = ". FKong::db::SqlQuote($tablesql));
   my($vertSql,$vertType,$vertName) = $dbh->fetchrow_array;
   defined $vertSql or FKong::Fatal("Vertical axis not recognized.");
   defined $horizSql or FKong::Fatal("Horizontal axis not recognized.");

   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # run the query
   my $join = '';
   if($horizType eq 'user') {
         $join .= "LEFT JOIN user AS $horizSql ON ($tablesql.$horizSql = $horizSql.userid)\n";
         $horizSql = "$horizSql.username";
   };
   if($vertType eq 'user') {
         $join .= "LEFT JOIN user AS $vertSql ON ($tablesql.$vertSql = $vertSql.userid)\n";
         $vertSql = "$vertSql.username";
   };
   my $where = "";
   $where = "WHERE ". join("\nAND ",@wheres) ."\n" if scalar @wheres;

   #  process the range specifications
   my $problems = '';
   my(@verticals,@horizontals);  # These are the units requested by the user
   if($FKong::search::decoration{$vertType} eq "*") {
      my(@dbvalue); # Same as above but translated for the database 
      @verticals = grep { ! /^\s*$/ } split(/^/,$FKong::cgi::form{'vrange'});  # separate into lines, remove blank ones
      foreach (@verticals) {
         s/\s+$//s; # remove trailing white space
         if(exists $FKong::submit::to_db_type_func{$vertType}) {
            push(@dbvalue, &{$FKong::submit::to_db_type_func{$vertType}}($_));
            $problems .= FKong::cgi::htmlQuote($_) ." not understood for vertical range boundary.<br>" if ! defined $dbvalue[-1];
         } else {  # else no translation required
            $problems .= FKong::cgi::htmlQuote($_) ." not understood for vertical range boundary.<br>" if $_ !~ /^\s*-?\.?\d+\.?\d*\s*$/;
            push(@dbvalue,$_);
         }
      }
      @verticals = ("NULL",map { "&lt; $_" } (@verticals,"Inf"));
      $vertSql = "INTERVAL($vertSql,". join(',',@dbvalue) .")";
      $vertSql = "0" if scalar(@dbvalue) == 0;  # if no interval values
   } elsif ($vertType eq 'bool') {
      @verticals = ("NULL","no","yes");
   };
   if($FKong::search::decoration{$horizType} eq "*") {
      my(@dbvalue); # Same as above but translated for the database 
      @horizontals = grep { ! /^\s*$/ } split(/^/,$FKong::cgi::form{'vrange'});  # separate into lines, remove blank ones
      foreach (@horizontals) {
         s/\s+$//s; # remove trailing white space
         if(exists $FKong::submit::to_db_type_func{$horizType}) {
            push(@dbvalue, &{$FKong::submit::to_db_type_func{$horizType}}($_));
            $problems .= FKong::cgi::htmlQuote($_) ." not understood for horizical range boundary.<br>" if ! defined $dbvalue[-1];
         } else {  # else no translation required
            $problems .= FKong::cgi::htmlQuote($_) ." not understood for horizical range boundary.<br>" if $_ !~ /^\s*-?\.?\d+\.?\d*\s*$/;
            push(@dbvalue,$_);
         }
      }
      @horizontals = ("NULL",map { "&lt; $_" } (@horizontals,"Inf"));
      $horizSql = "INTERVAL($horizSql,". join(',',@dbvalue) .")";
      $horizSql = "0" if scalar(@dbvalue) == 0;  # if no interval values
   } elsif ($horizType eq 'bool') {
      @horizontals = ("NULL","no","yes");
   } 
   FKong::Fatal($problems) if $problems;

   # process results
   my %col_names;
   my %row_names;
   my %row_stuff;
   my %row_list;
   my $count = 0;
   my $theList = '';
   my $dbh = FKong::db::SendSQL("SELECT $$fktable{'pkey'}, $horizSql, $vertSql\nFROM $tablesql\n".
                                $join .  $where . "LIMIT $maxRecords");
   while(my($recId,$col,$row) = $dbh->fetchrow_array) {
      $count++;

      if(scalar @verticals) {   # if we have some ranges, translate
         $row = $verticals[$row+1];
      } else {
         $row = "(empty)" if ! defined $row || $row eq "";
      };
      if(scalar @horizontals) {   # if we have some ranges, translate
         $col = $horizontals[$col+1];
      } else {
         $col = "(empty)" if ! defined $col || $col eq "";
      };

      $row_stuff{$row}{$col} ++;  # autovivification is nice
      $row_list{$row}{$col} .= "$recId," if $row_stuff{$row}{$col} < 100;  

      $col_names{$col}++;
      $row_names{$row}++;

      $theList .= "$recId," if $keep_list && $count < 200;   # not worth keeping if too long
   }
   if($keep_list) {
      $theList =~ s/,$//;  # delete trailing comma
      FKong::session::set_state($$fktable{'tablesql'} ."-list",$count < 200 ? $theList : '');  # keep list only if complete
      #$FKong::cgi::keyword{'theList'} = $theList;
   };

   # determine the values of the axes
   if(! scalar @verticals) {
      @verticals = sort(keys(%row_stuff));
   };
   if(! scalar @horizontals) {
      @horizontals = sort(keys(%col_names));
   };
   # install totals
   for my $col (@horizontals) {
       $row_stuff{"totals"}{$col} = $col_names{$col};
   }
   for my $row (@verticals) {
       $row_stuff{$row}{"totals"} = $row_names{$row};
   }
   $row_stuff{"totals"}{"totals"} = $count;
   push(@horizontals,"totals");
   push(@verticals,"totals");
   # for titles
   unshift(@horizontals," "); 
   unshift(@verticals," ");

   if($FKong::r->parsed_uri->path =~ /\.csv/i) {  # if comma separated variable format
      #$FKong::r->content_type('text/csv');
      $FKong::r->content_type('text/plain');
      $FKong::r->rflush;   # force it to send our content_type   WTF?
      for(my $row=0;defined($verticals[$row]);$row++) {
         for(my $col=0;defined($horizontals[$col]);$col++) {
            if($row == 0) {
               my $show = $horizontals[$col];
               $show =~ s/@.*$//;
               $FKong::r->print("$show,");
            } elsif ($col == 0) { 
               my $show = $verticals[$row];
               $show =~ s/@.*$//;
               $FKong::r->print("$show,");
            } else {
               my $count = $row_stuff{$verticals[$row]}{$horizontals[$col]};
               if(defined($count) && $count > 0) {
                  $FKong::r->print("$count,");
               } else {
                  $FKong::r->print("0,");
               };
           };
         };
         $FKong::r->print("\n");
      };
      $FKong::r->print("\n" . Date::Format::time2str($FKong::config{'TimeFormat'}, time()) . "\n\n");
      goto DONE;
   };

   my $table = "<table>\n".
      "  <tr><td></td><td align=center>". FKong::cgi::htmlQuote($horizName) ."</td></tr>\n".
      "  <tr><td>". FKong::cgi::htmlQuote($vertName) ."</td><td>";
   # print the table of numbers and headers
   $table .= "<table>";
   my @colors = ("ffffff","dfefff",
                 "dddddd","c3d3ed");
   for(my $row=0;defined($verticals[$row]);$row++) {
      $table .= " <tr>";
      my $curr_vert = $verticals[$row];
      for(my $col=0;defined($horizontals[$col]);$col++) {
         my $curr_horiz = $horizontals[$col];
         my $color = $colors[2 * ($row & 1) + ($col & 1)];
         $color = "ffeeee" if $curr_horiz eq "totals";
         $color = "ffeeee" if $curr_vert eq "totals";
         $table .= "<td bgcolor=$color align=center>";
         if($row == 0) {
            my $show = $curr_horiz;
            $show =~ s/@.*$//;
            $table .= $show;
         } elsif ($col == 0) { 
            my $show = $curr_vert;
            $show =~ s/@.*$//;
            $table .= $show;
         } else {
            my $count = $row_stuff{$curr_vert}{$curr_horiz};
            if(defined($count) && $count > 0) {
               if(length $row_list{$curr_vert}{$curr_horiz}) {
                  $row_list{$curr_vert}{$curr_horiz} =~ s/,$//;  # delete trailing comma
                  $table .= "<a href=\"list.html?list=". $row_list{$curr_vert}{$curr_horiz} ."\">$count</a>\n";
               } else {
                  $table .= "$count\n";
               }
            } else {
               $table .= ".";
            };
         };
         $table .= "</td>";
      };
      $table .= "</tr>\n";
   };
   # close tables
   $table .= "</table>\n".
             "</td></tr></table>\n".
             "</CENTER>\n";
   $FKong::cgi::keyword{'table'} .= $table;

   FKong::cgi::print_expanded_template("template/count.html");
}

1;

