
# Copyright 2003,2004 Frederick Dean

use strict;

use Carp;
use IO::File;

use APR::Table;
use APR::URI;
use Apache::URI;
use APR::Util qw(:all);
use Apache::Util qw(:all);
#use Apache::File;

require 5.008;

package FKong::cgi;

our %form;  # This is the has of form data submitted
           # The keys are the "name=" of the HTML form

our %fileh;  # here we store anonymous file handles to attachments
             # The stated filename is stored in %form

sub DoMultipartPost
{
   my($r,$max_form_bytes,$max_num_files,$max_file_bytes,$boundary) = @_;   

   (my $boundary_regex = $boundary) =~ s/(\W)/\\$1/gs;  # escape non-word charaters
   $r->setup_client_block;
   my $data = '';  # Here we buffer the incomming data
   my($paramname,$filename);
   while((length($data) || $r->should_client_block)) {  # for each line of the head
      # Get a line of input, loading blocks as needed
      my $line;
      while(1) {  # while we may load block to find the end of a line
          if($data =~ s/(.*?)\r?\n//) {  # if we found a line in our buffer, remove it
             $line = $1;
             last;
          } 
          my $read_len = $r->get_client_block(my $buf, 1024);
          FKong::Fatal("get_client_block() error") if $read_len == -1;
          FKong::Fatal("too much form data error") if length($data) > $max_form_bytes;
          $data .= $buf;
          if($read_len == 0) {   # no more to read, no newlines in data, line is remainder of data
             $line = $data;
             return;  # WARNING: end of input early
          }
      }
      # Okay now we have a line in $line
      if($line =~ /^content-disposition:[^;]+(.*)/i) {
         my $value = $1;
         while($value =~ s/^\s*;\s*([^\s=;]+)\s*=\s*"(.+?)"([^"])/$3/ || $value =~ s/^\s*;\s*([^\s=;]+)\s*=\s*"(.+?)"$//) {
            my($n,$v) = ($1,$2);
            $paramname = $v if $n =~ /^name$/i;
            $filename = $v if $n =~ /^filename$/i;
         }
      }
      next unless $line eq "" && $paramname;   # if not end of head (empty line) or we have a parameter name
      # Okay now we are at the end of the head of a part.
      if($filename) {  # if it is a file
         my $fh;
         if($max_num_files) {  # check for too many files
            $max_num_files--;
            $fh = IO::File::new_tmpfile() or FKong::Fatal("No upload because new_tmpfile() not supported");
            $fileh{$paramname} = $fh;
         } else {
            $fh = IO::File::open(">/dev/null");
         }
         $form{$paramname} = $filename;
         while(1) {  # while we load big blocks looking for an end of boundary
            if($data =~ s/(.*?)\r?\n--$boundary_regex(--)?\r?\n//s) {  # if we found the end of data
               return if $2 eq '--';  # normal end of multipart
               print $fh $1;
               last;  # end of attachment
            }
            if(length($data) > length($boundary) + 6) {  # if we can write some data clearly before the boundary 
               print $fh substr($data,0,length($data) - length($boundary) - 6);
               $data = substr($data,length($data) - length($boundary) - 6);
            }
            my $read_len = $r->get_client_block(my $buf, 10240);
            FKong::Fatal("get_client_block() error") if $read_len == -1;
            $data .= $buf;
            FKong::Fatal("too much form file data error") if length $data + $fh->ftell > $max_file_bytes;
            if($read_len == 0) {   # no more to read, no newlines in data, line is remainder of data
               print $fh $data;
               return;  # WARNING: end of input early
            };
         };
      } else {  # else it is a regular parameter
         $form{$paramname} = $form{$paramname} ? "\0$form{$paramname}" : '';  # concatenate multiple values with a character nul
         while(1) {  # while we load big blocks looking for an end of boundary
            if($data =~ s/(.*?)\r?\n--$boundary_regex(--)?\r?\n//s) {  # if we found the end of data
               $form{$paramname} .= $1;  # append
               return if $2 eq '--';  # normal end of multipart
               last;  # end of part
            };
            if(length($data) > length($boundary) + 6) {  # if we can write some data clearly before the boundary 
               $form{$paramname} .= substr($data,0,length($data) - length($boundary) - 6);
               $data = substr($data,length($data) - length($boundary) - 6);
            };
            my $read_len = $r->get_client_block(my $buf, 10240);
            FKong::Fatal("get_client_block() error") if $read_len == -1;
            $data .= $buf;
            FKong::Fatal("too much form file data error") if length $data + length($form{$paramname}) > $max_file_bytes;
            if($read_len == 0) {   # no more to read, no newlines in data, line is remainder of data
               $form{$paramname} .= $data;  # append
               return;  # WARNING: end of input early
            };
        };
      };
      ($paramname,$filename) = (undef,undef);
   };
}

sub FetchContent {
    my($r,$max_bytes) = @_;

    $r->setup_client_block;
    return '' unless $r->should_client_block;
    my $data = '';
    while (length $data < $max_bytes && (my $read_len = $r->get_client_block(my $buf, $max_bytes - length $data))) {
        if ($read_len == -1) {
            FKong::Fatal("get_client_block() error");
        }
        $data .= $buf;
    }
    return $data;
}

sub MakeFormHash
{
   my($r,$max_form_bytes,$max_num_files,$max_file_bytes) = @_;   # Apache::RequestRec

   my $queryString = "";
   my $content_type = $r->headers_in->get("Content-Type") || '';
   if($content_type =~ /multipart\/form-data.*boundary=([^;]+)/i) { # if multipart
      DoMultipartPost($r,$max_form_bytes,$max_num_files,$max_file_bytes,$1);   
      return;
   } elsif($r->method eq "POST") {
      # $content_type should be 'application/x-www-form-urlencoded'
      #$r->read($queryString,$r->headers_in->{'content-length'});  # does not work
      $queryString = FetchContent($r,$max_form_bytes);
   } else {
      $queryString = $r->parsed_uri->query;
   }
   # $queryString looks like pw=passwd&name=rick+dean
   $queryString =~ tr/+/ /;   # map + to space
   foreach my $pair (split(/&/, $queryString)) {
      $pair = Apache::unescape_url($pair);
      my($name,$value) = split(/=/,$pair,2);
      $form{$name} = $form{$name} ? "$form{$name}\0$value" : $value; # concatenate multiple values with a character nul
   };
}

# Trim leading and trailing white space.
# This alters the value in place.  i.e. passed by reference.
sub trim 
{
   $_[0] =~ s/^\s*//;
   $_[0] =~ s/\s*$//;
   return $_[0];  # return value
}

our %cookie;
our $cookielessFlag = 0;

# Based on the headers sent by the client, we initialize the cookie hash.
sub MakeCookieHash {
   my $r = shift;   # Apache::RequestRec

   defined $r or Carp::confess "$r";
   ref $r eq "Apache::RequestRec" or Carp::confess "$r";
   my $header = $r->headers_in->get("Cookie");
   if (defined $header) {
      foreach my $pair (split(/;/, $header)) {
         if ($pair =~ /^\s*([^=]*)=(.*)\s*$/) {
             $cookie{$1} = $2;
         } else {
             $cookie{$pair} = "";
         }
      }
   }
}


# This makes a new link being smart about the state we want to keep.
# The args are a list of "param=value".  
# The value should not be URL encoded because this function will.
sub Uri
{
   my ($filename,$params,$keepers) = @_;
   my %answer;
   # get all the keepers from the current page
   if(defined $keepers) {
      for my $keeper (@$keepers) {  # for every keeper
         if(defined($form{$keeper}) && $form{$keeper} ne "") {
            $answer{$keeper} = $form{$keeper};
         };
      };
   };
   # incorporate all the new parameters
   if(defined $params) {
      for my $parampair (@$params) {   # for every new parameter
         next if(!defined($parampair));
         my($param,$value) = split("=",$parampair,2);
         $answer{$param} = $value if $value ne "";
      };
   };
   my $answer = "";
   for my $key (keys(%answer)) {  # for every answer param
      $answer .= "$key=" . urlQuote($answer{$key}) . '&'; # append
   }
   chop($answer); # kill trailing '&'
   $answer = "?$answer" if $answer ne "";
   if($filename eq "") {  # if empty use self
      return($FKong::r->parsed_uri->path .  $answer);
   } elsif($filename =~ /^\//) {  # if begins with slash
      return($FKong::r->location . $filename . $answer);
   } else {
      return("$filename$answer");
   }
}
sub Link
{
   return("<a href=\"". &Uri ."\">");  # call Uri() with same parameters
}

# Quotify a string, suitable for putting into a URL.
sub urlQuote {
   my($toencode) = (@_);
   $toencode=~s/([^a-zA-Z0-9_\-.^'\$~*])/uc sprintf("%%%02x",ord($1))/eg;
   # RFC 2616    ( ) < > @ , ; : \ / [ ] ? = { } " SP HT
   return $toencode;
}

# returns a string converted to html
# double spaces and newlines are not processed
sub htmlQuote {
   my ($html) = (@_);
   return "&nbsp;" if !defined($html) || $html eq "";
   $html =~ s/\&/\&amp;/g;
   $html =~ s/</\&lt;/g;
   $html =~ s/>/\&gt;/g;
   $html =~ s/\n/\n<br>/g;
   return $html;
}
sub value_quote {
    my ($var) = (@_);
    $var = "" if ! defined $var;
    $var =~ s/\&/\&amp;/g;
    $var =~ s/</\&lt;/g;
    $var =~ s/>/\&gt;/g;
    $var =~ s/"/\&quot;/g;
    # See bug http://bugzilla.mozilla.org/show_bug.cgi?id=4928 for 
    # explanaion of why bugzilla does this linebreak substitution. 
    # This caused form submission problems in mozilla (bug 22983, 32000).
    $var =~ s/\r\n/\&#013;/g;
    $var =~ s/\n\r/\&#013;/g;
    $var =~ s/\r/\&#013;/g;
    $var =~ s/\n/\&#013;/g;
    return $var;
}
sub htmlQuoteForPre {
   my ($html) = (@_);
   return "&nbsp;" if !defined($html) || $html eq "";
   $html =~ s/\&/\&amp;/g;
   $html =~ s/</\&lt;/g;
   $html =~ s/>/\&gt;/g;
   return $html;
}
# Create a new has of everythin html quoted
sub htmlQuoteHash {
   my ($orig) = (@_);

   my %quoted;
   for my $key (keys(%$orig)) {
      $quoted{$key} = htmlQuote($$orig{$key});
   };
   return \%quoted;
}

our %keyword;  # This is the hash which stores all the replacements for the templates
our %templates;  # We count the number of times we use each template

sub fk_document_root() { $FKong::htmldir = "$INC[0]/html" }

sub expanded_keyword {
    my($key) = @_;
    my $answer = $keyword{$key};
    if(ref $answer) {   # if keyword hash contains a function reference
       $answer = &$answer;  # call the function for the answer
       $keyword{$key} = $answer;  # replace for effficiency and pretty form hash debug output
    } elsif(!defined($answer)) {  # else if the keyword has didn't have an answer
       if(-r "$FKong::htmldir/template/$key-template.html") {  # look for a template
          $answer = return_expanded_template("template/$key-template.html"); 
       } else {  # else nothing to replace with, make orange for error
          $answer = "<font color=orange>{{$key}}</font>";
       };
    };
    return $answer;
}

# This function uses %keyword the hash above. 
sub return_expanded_template {
    my($templateFilename) = @_;
    $templates{$templateFilename}++;
    local(*FILE);
    $templateFilename = "$FKong::htmldir/$templateFilename" if $templateFilename !~ /^\//;  # if not begging with slash
    open(FILE, "<$templateFilename") or FKong::Fatal("Couldn't open $templateFilename: $!\n");
    read(FILE,my $answer,100000);
    close FILE;
    #$answer =~ s/{{(.*?)}}/$keyword{$1}/g;
    $answer =~ s/{{(.*?)}}/expanded_keyword($1)/eg;
    return($answer);
}
sub print_expanded_template {
    my($templateFilename) = @_;
    $templates{$templateFilename}++;
    $FKong::r->content_type("text/html");
    $FKong::r->rflush;   # force it to send our content_type   WTF?
    local(*FILE);
    $templateFilename = "$FKong::htmldir/$templateFilename" if $templateFilename !~ /^\//;  # if not begging with slash
    open(FILE, "<$templateFilename") or FKong::Fatal("Couldn't open $templateFilename: $!\n");
    while(defined(my $line = <FILE>)) {
       $line =~ s/{{(.*?)}}/expanded_keyword($1)/eg;
       $FKong::r->print($line);
    };
    close FILE;
}

sub debug_prints
{
   my($r,$fktable) = @_;

   return if ! $FKong::debug;
   $r->content_type("text/html");
   $r->rflush;   # force it to send our content_type   WTF?
   $r->print("</font></div></table></table>". ("<br>" x 15) .
             "The following shows because you are in debugging mode.  See <font color=red><tt>FKong/config.pm</tt></font>\n");
   
   $r->print("<hr><font size=+1>Form <tt>&nbsp; \$FKong::cgi::form{'<font color=blue>blue</font>'}</font></tt><br>\n<table>\n");
   my $rownum = 0;
   foreach (sort keys %form) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td align=right><font color=blue>$_</font></td><td>". htmlQuote($form{$_}) ."</td></tr>");
   };
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>Keyword <tt>&nbsp; \$FKong::cgi::keyword{'<font color=darkorange>orange</font>'}</tt></font><br>\n<table>\n");
   foreach (sort keys %keyword) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td align=right><font color=darkorange>$_</font></td><td>". htmlQuote($keyword{$_}) ."</td></tr>");
   };
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>Templates used from <tt>$FKong::htmldir</tt></font><br>\n<table>\n");
   foreach (sort keys %templates) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      my $plural = ($templates{$_} > 1) ? 's' : '';
      $r->print("<tr bgcolor=\"$color\"><td align=left><font color=red>$_</font></td><td>$templates{$_} time$plural</td></tr>");
   };
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>mod_perl stuff <tt>&nbsp; \$FKong::r-><font color=blue>blue</font></tt></font><br>\n<table>\n");
   for my $func (sort qw/bytes_sent canonical_filename content_type filename get_server_port get_server_name 
                         connection->remote_ip connection->local_ip auth_type auth_name 
                         header_only hostname location method mtime no_cache path_info document_root 
                         protocol proxyreq remaining request_time status status_line uri/) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td align=right><font color=darkblue>$func</font></td><td>". htmlQuote(eval("\$r->$func")) ."</td></tr>");
   }
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>Extra headers <tt>&nbsp;\$FKong::r->headers_in-><font color=green>green</font></tt></font><br><table>\n");
   foreach (sort keys %{$r->headers_in}) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td><font color=green>$_</font></td><td>". htmlQuote($r->headers_in->get($_)) ."</td></tr>");
   };
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>URI <tt>&nbsp;\$FKong::r->parsed_uri-><font color=purple>purple</font></tt></font><br>\n<table>\n");
   my $uri = $r->parsed_uri;
   for my $part (qw/scheme hostinfo user password hostname port path query fragment/) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td align=right><font color=purple>$part</font></td><td>". htmlQuote(eval("\$uri->$part")) ."</td></tr>");
   }
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>Cookies hash <tt>&nbsp; \$FKong::cgi::cookie{'<font color=olive>olive</font>'}</font></tt><br>\n<table>\n");
   for my $key (sort keys %cookie) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td align=right><font color=olive>$key</font></td><td>". htmlQuote($cookie{$key}) ."</td></tr>");
   }
   $r->print("</table>\n");

   $r->print("<hr><font size=+1>Environment <tt>&nbsp; \$ENV{'<font colol=brown>brown</font>'}</tt></font><br>\n<table>\n");
   for my $key (sort keys %ENV) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $r->print("<tr bgcolor=\"$color\"><td align=right><font color=brown>$key</font></td><td>". htmlQuote($ENV{$key}) ."</td></tr>");
   }
   $r->print("</table>\n");

   FKong::db::print_debug_sqls();
   FKong::fktable::print_debug($fktable) if $fktable;

   $r->print("<hr><font size=+1>". Link("/dir_list.html") ."page listings</a></font><br>\n<table>\n");
   $r->print("<hr>Done.\n");
}

sub Linkify
{
   $_[0] =~ s/(http:\/\/\S+)/<a href=\"$1\">$1<\/a>/gi;  # show links as links
   $_[0] =~ s/(\s)([\w\-][\w\-\.]*\.[\w\-\.\/]*[\w\-])(?=\s)/$1<a href=\"http:\/\/$2\">$2<\/a>/gi;  # do suspected hostnames (surrounded by space)
   $_[0] =~ s/([\w\-][\w\-\.]*\.[\w\-\.\/]*[\w\-])(\s*)$/<a href=\"http:\/\/$1\">$1<\/a>$2/gmi;  # do suspected hostnames (end of text)
   $_[0] =~ s/(bugs?[\s\W]*)(\d+)/$1<a href=\"$FKong::config{'bugzilla_url'}$2\">$2<\/a>/gi;  # bug links
   return $_[0];
}

sub redirect 
{
   my($url) = @_;
   if($FKong::debug) {  # if debug flag is set
      $FKong::r->content_type("text/html");
      $FKong::r->rflush;   # force it to send our content_type   WTF?
      $FKong::r->print("We redirect to avoid double submits on page reloads.<br>\n".
                       "I would redirect you to <a href=\"$url\">$url</a> but you are in debug mode.<br>\n".
                       "<br>\n<br>\n<br>\n<Br>\n<br>\n");
   } else { # else we are not in debug mode, so redirect
      $FKong::r->headers_out->set(Location => $url);
      $FKong::r->status(302); #  Apache::REDIRECT
   }
   FKong::session::set_state('warning',$keyword{'warning'}) if $keyword{'warning'};
   goto DONE;
}

#  Free up some memory and destroy state from last session
sub Done
{
   %form = ();
   %fileh = ();   # this will close, and thus delete the files
   %cookie = ();
   %keyword = ();
   %templates = ();
}

1;  # return value

