
use strict;

# Copyright 2003,2004 Frederick Dean

package FKong::config;

#
#  Our config parameter from the DB are stored in %FKong::config
%FKong::config = ();
my %descript = ();
my %type = ();
my @names;
my $last_load_time = 0;

sub maybe_load_config
{
   my $new_load_time = time();
   my $dbh = FKong::db::SendSQL("SELECT name, value FROM config WHERE mtime >= $last_load_time");
   while(my @row = $dbh->fetchrow_array()) {
      my($name,$value) = @row;
      $FKong::config{$name} = $value;
      $last_load_time = $new_load_time;
   }
}

sub DefConfigParam
{
   my($name,$typee,$default,$descrip) = @_;
   push(@names,$name);
   $FKong::config{$name} = $default;
   $descript{$name} = $descrip;
   $type{$name} = $typee;
}


DefConfigParam('MaxIdleTime','integer',30*24*360,
               'Maximum time a session survives without a hit');

DefConfigParam('TimeFormat','oneline','%a %b %d, %Y %l:%M%P %Z',
                "How we should show the time by default.\n".
                "The codes are explained in perldoc Date::Format.");

DefConfigParam('ListTimeFormat','oneline', '%Y-%b-%d <nobr>%l:%M%P %Z</nobr>',
                "How we should show the time in lists (tables).\n".
                "The codes are explained in perldoc Date::Format.");

DefConfigParam('bugzilla_url', 'oneline', 'http://bugzilla/show_bug.cgi?id=',
              'This is the URL prefix to link bug numbers to.');

DefConfigParam('MoneyDecimalPlaces', 'integer', '2',
              'How many digits are right of the decimal point for fixed precision decimals.');

DefConfigParam('UserPulldown', 'bool', '1',
              'If few users exists it may be convenient to have a pulldown instead of a text entry.');

DefConfigParam('FromAddress', 'oneline', '"FeatureKong" <featurekong@localhost>',
              'When featurekong sends emails, this is who they claim to be from.');

$FKong::url_func{'config.html'} = \&show_config_page;

sub show_config_page
{
   my($recprefix,$name,$url,$tablesql) = @_;

   FKong::session::must_have_priv("view_other");
   if($FKong::cgi::form{'cancel'}) {
      FKong::cgi::redirect("config.html");
   } elsif($FKong::cgi::form{'commit'}) {
      FKong::session::must_have_priv("edit_other");
      my @sql;
      foreach my $name (@names) {
         my $formval = $FKong::cgi::form{$name};
         if(defined $formval) {
            FKong::cgi::trim($formval);
            if($formval ne $FKong::config{$name}) {
               push(@sql,"(UNIX_TIMESTAMP(),". FKong::db::SqlQuote($name) .",".  FKong::db::SqlQuote($formval) .")");
            };
         }
      };
      if(scalar @sql) {
         FKong::db::SendSQL("REPLACE config (mtime, name, value) VALUES\n". join(",\n",@sql));
      }
      FKong::cgi::redirect("config.html");
   } else {
      $FKong::cgi::keyword{'config_form'} = '';
      foreach my $name (@names) {
         my $input = '';
         if($type{$name} eq 'bool') {
            $input = "<input name=\"". FKong::cgi::value_quote($name) .'" type=radio value=1 '. ($FKong::config{$name}?"CHECKED":'') ."> yes \n".
                     " &nbsp;  &nbsp; &nbsp; ".
                     "<input name=\"". FKong::cgi::value_quote($name) .'" type=radio value=0 '. ($FKong::config{$name}?'':"CHECKED") ."> no \n";
         } elsif($type{$name} eq 'multiline') {
            $input .= " <textarea WRAP=HARD NAME=\"". FKong::cgi::value_quote($name) ."\" ROWS=5 COLS=80>".
            FKong::cgi::htmlQuoteForPre($FKong::config{$name}) ."</textarea>\n";
         } else {
            $input = "<input name=\"". FKong::cgi::value_quote($name) .'" size=50 value="'. 
            FKong::cgi::value_quote($FKong::config{$name}) .'">';
         };
         $FKong::cgi::keyword{'config_form'} .= "<tr><td colspan=2><hr></td></tr>\n".
         "<tr><td>". FKong::cgi::htmlQuote($name) ."</td>\n".
         "<td>$input</td></tr>\n".
         "<tr><td colspan=2 class=config_desc>". FKong::cgi::htmlQuote($descript{$name}) .
         "</td></tr>\n";
      };
      FKong::cgi::print_expanded_template("template/config.html");
   };
}


