
#  Copyright 2003,2004 Frederick Dean

use strict;

package FKong::comment;

use FKong::list;

sub field_id_with_link { 
   my($commentId,$recId) = split(/,/,$_[0]);
   return FKong::cgi::Link("/$_[1]$recId.html#$commentId") . "$commentId</a>" 
};

sub define_list_object
{
   my($tbl,$fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $tablename = $$fktable{'name'};
   my $pkey = $$fktable{'pkey'};
   my $dbh = FKong::db::SendSQL("SELECT fieldId, cmt_list_show, fieldName, short_help, type, sqlName FROM field_def\n".
                                "WHERE tablesql = ". FKong::db::SqlQuote($tablesql) ."\n".
                                "AND type != 'constant' ORDER BY sort, fieldName");
   #           nick private         title  align default   sql          display      descript                       
   $tbl->DefCol("T00",0,           "Comment ID",1,1,"CONCAT(${tablesql}_comment.commentId,',',$tablesql.$pkey)",\&field_id_with_link, "Internal database ID of the comment");
   $tbl->DefCol("T01",0,        "$tablename ID",1,1,"$tablesql.$pkey",\&FKong::table::field_id_with_link, "Internal database ID of the $tablesql table");
   $tbl->DefCol("T04",0,      "Comment Subject",1,1,"${tablesql}_comment.subject",        undef, "A one line summary of the comment");
   $tbl->DefCol("T05",0,         "Comment Body",1,0,"${tablesql}_comment.body",           undef, "The free text entered for the comment");
   $tbl->DefCol("T06",0,  "Comment Body Length",1,1,"LENGTH(${tablesql}_comment.body)",   undef, "Number of characters in the comment body");
  #$tbl->DefCol("T08",0,       "Comment Parent",1,1,"CONCAT(${tablesql}_comment.parentId,',',$tablesql.$pkey)",\&field_id_with_link, "The comment this responds to");

   #$tbl->DefCol("T30",0, "Comment Created By ID",1,0,"$tablesql.create_by",undef, "");
   $tbl->DefCol("T31",0,      "Comment Create By",1,1,"COALESCE(ccreator.username,${tablesql}_comment.create_by)",undef, "Who originally created the comment",
                "LEFT JOIN user AS ccreator ON (ccreator.userid = ${tablesql}_comment.create_by)\n");
   $tbl->DefCol("T32",0,    "Comment Create Time",1,1,"${tablesql}_comment.createTS",\&FKong::list::unixTimestamp, "When was the comment created");
   #$tbl->DefCol("T33",0,"Comment Modified By Id",1,0,"${tablesql}_comment.mod_by",undef, "");
   $tbl->DefCol("T34",0,    "Comment Modified By",1,0,"COALESCE(cmodify.username,${tablesql}_comment.mod_by)",undef, "Who last modified the comment",
                "LEFT JOIN user AS cmodify ON (cmodify.userid = ${tablesql}_comment.mod_by)\n");
   $tbl->DefCol("T35",0,    "Comment Modify Time",1,0,"${tablesql}_comment.modifyTS",\&FKong::list::unixTimestamp, "When was the comment last modified");

   $tbl->DefCol("T41",0,                     "ID",1,0,"$tablesql.commentId",\&FKong::table::delete_link, "Link to delete comment") if FKong::session::has_priv('delete_features');
   while(my($fieldId,$list_show,$fieldName,$short_help,$type,$sqlName) = $dbh->fetchrow_array()) {
      my $join;
      if($type eq 'user') {
         $join = "LEFT JOIN user AS $sqlName ON ($tablesql.$sqlName = $sqlName.userid)\n";
         $sqlName = "$sqlName.username";
      };
      $tbl->DefCol("t$fieldId",0,$fieldName,$FKong::table::right_align{$type},$list_show,$sqlName,$FKong::table::type_func{$type}, $short_help,$join);
   };
   #$tbl->DefCol("T50",0, "$tablename Created By ID",1,0,"$tablesql.create_by",undef, "");
   $tbl->DefCol("T51",0,      "$tablename Create By",1,0,"COALESCE(creator.username,$tablesql.create_by)",undef, "Who originally created the feature",
                "LEFT JOIN user AS creator ON (creator.userid = $tablesql.create_by)\n");
   $tbl->DefCol("T52",0,    "$tablename Create Time",1,0,"$tablesql.createTS",\&FKong::list::unixTimestamp, "When was the feature created");
   #$tbl->DefCol("T53",0,"$tablename Modified By Id",1,0,"$tablesql.mod_by",undef, "");
   $tbl->DefCol("T54",0,    "$tablename Modified By",1,0,"COALESCE(modify.username,$tablesql.mod_by)",undef, "Who last modified the feature",
                "LEFT JOIN user AS modify ON (modify.userid = $tablesql.mod_by)\n");
   $tbl->DefCol("T55",0,    "$tablename Modify Time",1,0,"$tablesql.modifyTS",\&FKong::list::unixTimestamp, "When was the feature last modified");

   #$tbl->DefCol("T60",0,            "Comments",1,1,"COUNT(${tablesql}_comment.commentId)", undef, "A count of the number of comments",
   #             "LEFT JOIN ${tablesql}_comment ON (${tablesql}_comment.$pkey = $tablesql.$pkey)\n") if $$fktable{'comments'};
}

# Normally we save the column choices when composing a list, but can miss that opportunity
# when redirecting to the search form, so this form forces that to happen an should be callled
# when change_columns form parameter is defined.
sub force_save_column_choice
{
   my($fktable) = @_;
   my $tbl = FKong::list->new($$fktable{'tablesql'} ."_comment",$$fktable{'recprefix'},$$fktable{'url'});
   define_list_object($tbl,$fktable);
   $tbl->get_column_sql([],"-T00");
}

sub show_table
{
   my($keep_list,$fktable,@wheres) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $recprefix = $$fktable{'recprefix'};
   # check that they have permission 
   FKong::session::must_have_priv("view_features");
   FKong::session::must_have_priv("view_fields") if $$fktable{'internal'};
   my $tbl = FKong::list->new("${tablesql}_comment",$recprefix,$$fktable{'url'});
   $tbl->keep_list() if $keep_list;  # set flag to store recId list
   define_list_object($tbl,$fktable);
   # column headings
   my $keepers = [ FKong::list::column_params($tbl) ];    # list reference
   my($colsql,$ordersql,$joins) = $tbl->get_column_sql($keepers,"-T00");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # submit the query
   foreach my $param (sort keys %FKong::cgi::form) {
      next unless $param =~ /^t(\d+)$/;  # param must be a feature list param
      next unless $FKong::cgi::form{$param};   # param must be true
      my $fieldId = $1;
   };
   my $where = "";
   $where = "WHERE ". join("\nAND ",@wheres) ."\n" if scalar @wheres;
   my $query = "SELECT $keep_list $colsql\nFROM ${tablesql}_comment\n".
               "LEFT JOIN $tablesql ON ($tablesql.$$fktable{'pkey'} = ${tablesql}_comment.$$fktable{'pkey'})\n".
               $joins .
               $where .
               "GROUP BY $tablesql.$$fktable{'pkey'} ORDER BY $ordersql\nLIMIT $maxRecords";
   $tbl->print_template_with_table("template/features-template.html",$query,$keepers);
}

our @search_params;  # These are the URL GET parameter names which matter to the search.  Used for form_query_link()

sub form_query_link
{
   my $query_url = "";
   foreach my $param (@search_params) {
      my $value = $FKong::cgi::form{$param};
      next unless defined $value && length $value;  # skip this param if empty
      $query_url .= "&" if $query_url;
      $query_url .= join('&',map { "$param=". FKong::cgi::urlQuote($_) } split(/\0/,$FKong::cgi::form{$param}));
      #$query_url .= "$param=". FKong::cgi::urlQuote($value);  # or am I confident a character nul will not cause problems?
   };
   return $query_url;
}

sub query_for_comment
{
   my($fktable,$suffix) = @_;

   my @wheres;
   foreach my $word (split(/\s+/,$FKong::cgi::form{'search_comments'} || "")) {
      push(@wheres,"INSTR(LOWER(body),". FKong::db::SqlQuote(lc($word)).")");
   }
   return [ @wheres,@{FKong::table::basic_query($fktable,$suffix)} ];
}

sub delete_comment
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   FKong::session::must_have_priv('delete_features');
   FKong::session::must_have_priv("edit_fields") if $$fktable{'internal'};
   FKong::Fatal("Internal Error: comment delete has no id") if ! $FKong::cgi::form{'id'};
   FKong::Fatal("Internal Error: comment delete has malformed id") if $FKong::cgi::form{'id'} !~ /^\d+$/;
   FKong::Fatal("Internal Error: table doesn't keep comments") if $$fktable{'comments'};
   FKong::db::SendSQL("DELETE FROM ${tablesql}_comment WHERE commentId = ". FKong::db::SqlQuote($FKong::cgi::form{'id'}));
   FKong::cgi::redirect(FKong::cgi::Uri(""));
}

$FKong::table_func{'comment/list.html'} = \&show_list;
$FKong::table_func{'comment/list.csv'} = $FKong::table_func{'comment/list.html'};

sub show_list
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   if($FKong::cgi::form{'delete_comment'}) {  
      delete_comment($fktable);  
   } elsif($FKong::cgi::form{'search_comments'} && $FKong::cgi::form{'search_comments'} =~ /\S/) {  # if they are searching comments
      my $wheres = query_for_comment($fktable,'query');
      show_table("$$fktable{'tablesql'}.$$fktable{'pkey'},",$fktable,@$wheres);  
   } elsif($FKong::cgi::form{'search'}) {  # if they are not searching comments (only records)
      FKong::cgi::redirect("../list.html?". $FKong::r->parsed_uri->query);   # go to the record list
   } elsif(my $list = ($FKong::cgi::form{'list'} || FKong::session::get_state("${tablesql}_comment-list"))) {  # else if they have a saved list
      $FKong::cgi::keyword{'oldQuery'} = (FKong::session::get_state("$tablesql-query") || "");
      $FKong::cgi::keyword{'theList'} = $list;
      $list =~ tr/0-9,//dc;  # delete non-numeral non-commas  (redundant safety precaution)
      show_table("",$fktable,"$tablesql.$$fktable{'pkey'} IN ($list)");
   } else {  # else redirect them to the search form
      force_save_column_choice($fktable) if $FKong::cgi::form{'change_columns'};
      #show_table("$tablesql.$$fktable{'pkey'},$fktable,");  # as a default for now show them all
      FKong::cgi::redirect("search.html?");  #  last resort show search form
   }
}

$FKong::table_func{'comment/count.html'} = \&show_counts;
$FKong::table_func{'comment/count.csv'} = $FKong::table_func{'comment/count.html'};

sub show_counts
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   if($FKong::cgi::form{'count'}) {  # if they are basic searching
      push(@search_params,'vert','horiz','hrange','vrange');  
      my $wheres = query_for_comment($fktable,'query2');
      FKong::count::show_count(1,$fktable,@$wheres);  
   } elsif(my $list = ($FKong::cgi::form{'list'} || FKong::session::get_state("${tablesql}_comment-list"))) {  # else if they have a saved list
      $FKong::cgi::keyword{'oldQuery'} = (FKong::session::get_state("$tablesql-query2") || "");
      $FKong::cgi::keyword{'theList'} = $list;
      $list =~ tr/0-9,//dc;  # delete non-numeral non-commas  (redundant safety precaution)
      FKong::count::show_count(0,$fktable,"$tablesql.$$fktable{'pkey'} IN ($list)");
   } else {  # else redirect them to the search form
      FKong::cgi::redirect("count_form.html?");  #  last resort show count form
   }
}

$FKong::table_func{'comment/columns.html'} = \&column_choice;

sub column_choice
{
   my($fktable) = @_;
   $FKong::cgi::keyword{'formurl'} = "list.html";
   my $tbl = FKong::list->new("$$fktable{'tablesql'}_comment",$$fktable{'recprefix'},$$fktable{'url'});
   define_list_object($tbl,$fktable);
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$$fktable{'tablesql'});
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

sub Done
{
   @search_params = ();
}

1;

__END__



