#!/usr/bin/perl -w
use strict;

# copyright 2004 Frederick Dean

use lib "..";
require "../featurekong_startup.pl";
use FKong::db;

my $ansiBright = "\033[1m";
my $ansiBlue = "\033[34m";
my $ansiGreen = "\033[32m";
my $ansiRed = "\033[31m";
my $ansiNormal = "\033[0m";

if(! defined $ARGV[0] || $ARGV[0] ne "--dataloss") {
   print("$ansiBright${ansiRed}WARNING: This script will corrupt your data.$ansiNormal\n");
   print("$ansiBright${ansiRed}WARNING: This script will corrupt your data.$ansiNormal\n");
   print("$ansiBright${ansiRed}WARNING: This script will corrupt your data.$ansiNormal\n");
   print("If you really want to, then rerun with the --dataloss flag.\n");
   exit -1;
}

my $numFeatures = 6;
my $numComments = 12;

srand(10);

#
#  Load some jibberish
#
open(WORDS,"</usr/share/dict/words") or die;
my @words;
while(my $word = <WORDS>) {
   next unless $word =~ /^[a-z]{3,8}$/;
   chomp $word;
   push(@words,$word);
}
close(WORDS);
#print(($#words+1) .  " words loaded.\n");

sub random_word
{ 
   my $index = int(rand($#words+1));
   my $word = splice(@words,$index,1,());  # remove word form list so only used once
   #my $name = $words[int(rand($#words+1))];
   return $word; 
}

sub random_multiline
{
   my $body = ucfirst(random_word()) ." ";
   my $numwords = int(rand()*140) + 3;
   foreach (0 .. $numwords) {
      my $r = rand();
      if($r < 0.05) {
         $body =~ s/ $/./;  # replace trailing space with period
         $body .= "\n\n". ucfirst(random_word()) ." ";
      } elsif($r < 0.08) {
         $body .= "http://". random_word() .".com/". random_word() .".html ";
      } elsif($r < 0.10) {
         $body .= "bug ". int(rand()*10000) ." ";
      } elsif($r < 0.11) {
         $body .= random_word() .".com ";
      } elsif($r < 0.12) {
         $body .= random_word() .".com/". random_word() .".html ";
      } else {
         $body .= random_word() ." ";
      }
   }
$body =~ s/(.{60} )/$1\n/g;
   return "$body.";
}

# Make more users if needed
my $dbh = FKong::db::SendSQL("SELECT COUNT(*) FROM user");
my $num_users = $dbh->fetchrow_array();
while($num_users < 10) {
   my $name = random_word();
   FKong::db::SendSQL("INSERT INTO user SET username = ". FKong::db::SqlQuote($name) .", email = ". FKong::db::SqlQuote("$name\@fdd.bogus") .",\n".
               "realname = ". FKong::db::SqlQuote(ucfirst($name) ." ". ucfirst(random_word())) .", phone = ". FKong::db::SqlQuote(int(rand() * 999999)) .",\n".
               "lastTS = UNIX_TIMESTAMP(), createTS = UNIX_TIMESTAMP() - 10 + $num_users, modifyTS = UNIX_TIMESTAMP(), privs = 6144");
   $num_users++;
}

# load field definitions from field_def table
$dbh = FKong::db::SendSQL("SELECT sqlName, type FROM field_def WHERE tablesql = 'feature'");
my(@sqlNames,@types);
while(my($sqlName,$type) = $dbh->fetchrow_array()) {
  push(@sqlNames,$sqlName);
  push(@types,$type);
}

# check the features table definition for valid choices of enum fields
my @choices;
foreach my $index (0..$#sqlNames) {
   if($types[$index] eq 'mult_choice') {
      $dbh = FKong::db::SendSQL("DESCRIBE feature $sqlNames[$index]");
      my(undef,$def) = $dbh->fetchrow_array();
      my @blah = split(/','/,$def);
      $choices[$index] = scalar(@blah);
   };
}

foreach my $index (0..$numFeatures) {
   my $user = int(rand() * ($num_users-2)) + 100;
   my $sql = "INSERT INTO feature SET createTS = UNIX_TIMESTAMP() - $numFeatures + $index, modifyTS = UNIX_TIMESTAMP(),\n".
             "create_by = $user,mod_by = $user\n";

   foreach my $index (0..$#sqlNames) {
      if($types[$index] eq "mult_choice") {
         $sql .= ",$sqlNames[$index] = ". int(rand() * $choices[$index] + 1) ."\n";
      } elsif($types[$index] eq "float") {
         $sql .= ",$sqlNames[$index] = ". sprintf("%.2f",rand() * 10) ."\n";
      } elsif($types[$index] eq "integer" || $types[$index] eq 'hexint' || $types[$index] eq 'money') {
         $sql .= ",$sqlNames[$index] = ". int(rand() * 100) ."\n";
      } elsif($types[$index] eq "user") {
         $sql .= ",$sqlNames[$index] = ". int(rand() * ($num_users-2) + 100) ."\n";
      } elsif($types[$index] eq "oneline") {
         $sql .= ",$sqlNames[$index] = ". FKong::db::SqlQuote(ucfirst(random_word()) ." ". ucfirst(random_word()) ." ". ucfirst(random_word())) ."\n";
      } elsif($types[$index] eq "multiline") {
         my $body = random_multiline();
         $sql .= ",$sqlNames[$index] = ". FKong::db::SqlQuote($body) ."\n";
      };
   };
   FKong::db::SendSQL($sql);
};


foreach my $index (0..$numComments) {
   my $user = int(rand() * ($num_users-2)) + 100;
   my $body = random_multiline();
   FKong::db::SendSQL("INSERT INTO feature_comment SET\n".
                "featureId = ". int(rand()*$numFeatures+1) .",\n".
                "createTS  = ". (time() + $index) .",\n".
                "modifyTS  = createTS,\n".
                "create_by = $user,\n".
                   "mod_by = $user,\n".
                   "format = 'text',\n".
                  "subject = ". FKong::db::SqlQuote(ucfirst(random_word()) ." ". random_word() ." ". random_word()) .",\n".
                     "body = ". FKong::db::SqlQuote($body) ."\n"
                          );
}


