
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::fktable;

my %extra_privs = ('user' => 'view_users', session => 'view_users');

sub New
{
   my($where) = @_;
   my $dbh = FKong::db::SendSQL("SELECT * FROM fktable WHERE $where"); 
   my $fktable = $dbh->fetchrow_hashref();
   if(! defined $fktable) {
      return undef;
   }
   $FKong::cgi::keyword{'tablename'} = $$fktable{'name'};
   $FKong::cgi::keyword{'tableurl'} = FKong::cgi::Uri($$fktable{'url'});
   $FKong::cgi::keyword{'tablesql'} = FKong::cgi::Uri($$fktable{'tablesql'});
   if(length $$fktable{'down_maint'} && ! FKong::session::has_priv('edit_fields')) {
      $FKong::cgi::keyword{'down_maint'} = $$fktable{'down_maint'};
      FKong::cgi::print_expanded_template("template/down_maint.html");
      goto DONE;
   } elsif(length $$fktable{'down_maint'}) {
      $FKong::cgi::keyword{'warning'} .= "<div class=warn>This table is ". FKong::cgi::Link("/fktable/fkt$$fktable{'fktableId'}.html").  
                     "down for maintenance</a>.  Only designers like you can see it.<br></div>\n";
   }
   my $extra = $extra_privs{$$fktable{'tablesql'}};
   FKong::session::must_have_priv($extra) if $extra;
   return bless $fktable;
} 

=unused
$FKong::table_func{'drop.html'} = \&confirm_drop_table;

sub confirm_drop_table
{
   my($fktable) = @_;  
#   FKong::session::must_have_priv("delete_features");
   #$FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/$$fktable{'url'}/field/list.html");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/fktable/list.html");
   $FKong::cgi::keyword{'hidden'} = qq(<input type=hidden name=tablesql value=\"". FKong::cgi::value_quote($FKong::cgi::form{'sql'}) ."\">\n);
   FKong::cgi::print_expanded_template("template/drop_confirm.html");
}
=cut

sub print_debug
{
   my($fktable) = @_;
   $FKong::r->print("<hr><tt><font size=+1>\$\$fktable{'<font color=blue>blue</font>'}</font></tt><br>\n<table>\n");
   my $rownum;
   for my $key (sort keys %$fktable) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $FKong::r->print("<tr bgcolor=\"$color\"><td align=right><font color=navy>$key</font></td><td>". FKong::cgi::htmlQuote($$fktable{$key}) ."</td></tr>\n");
   }
   $FKong::r->print("</table>\n");
}

sub TableExists ($)
{
   my ($table) = @_;
   my $sth = FKong::db::SendSQL("SHOW TABLES");
   while ( my($dbtable) = $sth->fetchrow_array ) {
      return 1 if ($dbtable eq $table);
   }
   return 0;
}

$FKong::url_func{'fktable/new.html'} = \&show_create_table;

sub show_create_table
{
   FKong::session::must_have_priv("edit_features");
   FKong::cgi::trim(my $tablesql = $FKong::cgi::keyword{'tablesql'} = $FKong::cgi::form{'tablesql'} || '');
   FKong::cgi::trim(my $url = $FKong::cgi::keyword{'url'} = $FKong::cgi::form{'url'} || '');
   FKong::cgi::trim(my $recprefix = $FKong::cgi::keyword{'recprefix'} = $FKong::cgi::form{'recprefix'} || '');
   FKong::cgi::trim(my $name = $FKong::cgi::keyword{'name'} = $FKong::cgi::form{'name'} || '');
   FKong::cgi::trim(my $sort_ = $FKong::cgi::keyword{'sort'} = $FKong::cgi::form{'sort'} || '1000');
   my $changes = $FKong::cgi::keyword{'changes'} = $FKong::cgi::form{'changes'} ? "CHECKED" : "";
   my $comments = $FKong::cgi::keyword{'comments'} = $FKong::cgi::form{'comments'} ? "CHECKED" : "";
   my $advertise = $FKong::cgi::keyword{'advertise'} = $FKong::cgi::form{'advertise'} ? "CHECKED" : "";
   if($FKong::cgi::form{'cancel'}) {
     FKong::cgi::redirect(FKong::cgi::Uri("/"));
   } elsif($FKong::cgi::form{'update'}) {
     if(! $tablesql) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table SQL is required</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     if($tablesql !~ /^\w+$/) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Illegal character in Table SQL</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     (my $pkey = "${tablesql}Id") =~ s/.*\.//;  # delete database prefix
     if(! $url) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table URL is required</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     if(! $name) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table Name is required</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     if(TableExists($tablesql)) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table $tablesql already exists.</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     };
     my $userid = $FKong::cgi::keyword{'userid'};
     my $changeid = $changes ? "changeId int(10) unsigned NOT NULL default '0',\n" : '';
     FKong::db::SendSQL("CREATE TABLE `$tablesql` (\n".
                        "$pkey int(10) unsigned NOT NULL auto_increment primary key,\n".
                        "create_by int(10) unsigned default NULL,\n".
                        "createTS int(10) unsigned default NULL,\n".
                        "mod_by mediumint(8) unsigned default NULL,\n".
                        "modifyTS int(10) unsigned NOT NULL default '0',\n".
                        $changeid .
                        "KEY `modifyTS` (`modifyTS`)\n".
                        ")");
     FKong::db::SendSQL("CREATE TABLE `${tablesql}_change` (\n".
                        "changeId int(10) unsigned NOT NULL auto_increment primary key,\n".
                        "$pkey int unsigned not null,\n".
                        "create_by int(10) unsigned default NULL,\n".
                        "createTS int(10) unsigned default NULL,\n".
                        "fieldId mediumint(8) unsigned NOT NULL default '0',\n".
                        "old_val text,\n".
                        "index($pkey,createTS),\n".
                        "index($pkey,changeId),\n".
                        "index(create_by,createTS),\n".
                        "index(fieldId,createTS)\n".
                        ")") if $changes;
     FKong::db::SendSQL("CREATE TABLE `${tablesql}_comment` (\n".
                        "commentId int(10) unsigned NOT NULL auto_increment primary key,\n".
                        "$pkey int unsigned not null,\n".
                        "create_by int(10) unsigned default NULL,\n".
                        "createTS int(10) unsigned default NULL,\n".
                        "mod_by mediumint(8) unsigned default NULL,\n".
                        "modifyTS int(10) unsigned NOT NULL default '0',\n".
                        "format enum('text','html') default NULL,\n".
                        "subject text,\n".
                        "body text,\n".
                        $changeid .
                        "index($pkey,createTS),\n".
                        "index($pkey,changeId),\n".
                        "index(create_by,createTS),\n".
                        "fulltext(subject,body)\n".
                        ")") if $comments;
     FKong::db::SendSQL("INSERT INTO field_def (fieldName, tablesql, sqlName, type, sort) VALUES\n". 
                        "('Creator',          '$tablesql', 'create_by', 'user',    10040),\n".
                        "('Create Time',      '$tablesql', 'createTS',  'unix_ts', 10042),\n".
                        "('Last Modifer',     '$tablesql', 'mod_by',    'user',    10044),\n".
                        "('Last Modify Time', '$tablesql', 'modifyTS',  'unix_ts', 10046)");
     FKong::db::SendSQL("UPDATE field_def SET on_new_form = 0, create_by = $userid, mod_by = $userid,\n".
                        "modifyTS = UNIX_TIMESTAMP(), createTS = UNIX_TIMESTAMP(), read_only = 1, fixed_sql = 1,\n".
                        "on_new_form = 0\n".
                        "WHERE tablesql = ". FKong::db::SqlQuote($tablesql) ."\n");
     FKong::db::SendSQL("INSERT INTO fktable SET \n".
                        "tablesql =  ". FKong::db::SqlQuote($tablesql) .",\n".
                        "name =      ". FKong::db::SqlQuote($name) .",\n".
                        "recprefix = ". FKong::db::SqlQuote($recprefix) .",\n".
                        "url =       ". FKong::db::SqlQuote($url) .",\n".
                        "pkey =      ". FKong::db::SqlQuote($pkey) .",\n".
                        "changes =   ". FKong::db::SqlQuote(! ! $changes) .",\n".
                        "comments =  ". FKong::db::SqlQuote(! ! $comments) .",\n".
                        "advertise = ". FKong::db::SqlQuote(! ! $advertise) .",\n".
                        "sort =      ". FKong::db::SqlQuote($sort_) .",\n".
                        "down_maint =". FKong::db::SqlQuote("The $name table is still being designed.") .",\n".
                        "create_by = $userid, mod_by = $userid,\n".
                        "createTS = UNIX_TIMESTAMP(), modifyTS = UNIX_TIMESTAMP()");
     $FKong::cgi::keyword{'warning'} = "<div class=warn>Table $tablesql created.  Please create a field...</div>\n";
     FKong::cgi::redirect(FKong::cgi::Uri("/". FKong::cgi::urlQuote($url) ."/field/type.html"));
   };
   FKong::cgi::print_expanded_template("template/create-table.html"); 
}


1;

