
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::history;


sub show_history
{
   my($template,$recId,$andwhere,$fktable) = @_;
   my $pkey = $$fktable{'pkey'};
   FKong::Fatal("I cannot show the history because the table required ($$fktable{'tablesql'}_changes) does not exist.") if ! $$fktable{'changes'};
   if($$fktable{'ext_mod'}) {
      FKong::Fatal("I cannot show the history because an external application changes the table without updating $$fktable{'tablesql'}_changes.");
   };
   my $tablesql = $$fktable{'tablesql'};
   # download the current values
   my $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql WHERE $pkey = ". FKong::db::SqlQuote($recId));
   my $sqlhash = $dbh->fetchrow_hashref();
   FKong::Fatal("Internal Error: Feature not found. Mid-air delete?",'mid-air Delete?') if ! $$sqlhash{$pkey};
   # we are ready to now process the feature_change  table
   # We create a temporary table to sort field changes and comment postings together.
   FKong::db::SendSQL("CREATE TEMPORARY TABLE temp (primary key (createTS,fieldId))\n".   # put *_changes into temp table
               "SELECT createTS, create_by, fieldId, old_val, 0 as commentId\n".
               "FROM ${tablesql}_change\n".
               "WHERE $pkey = ". FKong::db::SqlQuote($recId) ." $andwhere\n");
   FKong::db::SendSQL("INSERT INTO temp (createTS, create_by, old_val, commentId)\n".   # put comments into temp table
               "SELECT createTS, create_by, subject, commentId \n".
               "FROM ${tablesql}_comment\n".
               "WHERE $pkey = ". FKong::db::SqlQuote($recId) ." $andwhere\n") if $$fktable{'comments'};
   $dbh = FKong::db::SendSQL("SELECT temp.createTS, username, sqlName, old_val, fieldName, commentId, field_def.type\n".
               "FROM temp\n".
               "LEFT JOIN user ON (temp.create_by = user.userid)\n".
               "LEFT JOIN field_def ON (temp.fieldId = field_def.fieldId)\n".
               "ORDER by createTS DESC, fieldName");
   my $table = "";
   my($rowCount,$numEvent,$numChangeThisEvent) = (0,0,0);
   my $lastTime = 0;
   # We display them from most recent to least recent in part because we
   # need to process them that way to determine/report the newer value at each change.
   while(1) {
      my($timestamp,$who,$sqlName,$old_val,$fieldName,$commentId,$type) = $dbh->fetchrow_array();
      last if ! $timestamp;  # quit if no more changes
      my $htmltime = "";
      my $id = ($numChangeThisEvent & 1) ? "histAddRowEven" : "histAddRowOdd";
      if($timestamp != $lastTime) {
         $lastTime = $timestamp;
         $htmltime = Date::Format::time2str($FKong::config{'ListTimeFormat'},$timestamp);
         $numEvent++;
         $id = "histEventRow";
         $numChangeThisEvent = 0;
      } else {
         $who = "";
         $numChangeThisEvent++;
      }
      if($sqlName) {  # if it was a field change
         my $old_printable = $FKong::table::type_func{$type} ? &{$FKong::table::type_func{$type}}($old_val)            : $old_val;
         $old_printable = " " if ! defined $old_printable || $old_printable eq "";  # ensure the table element shows (Moz bug)
         my $new_printable = $FKong::table::type_func{$type} ? &{$FKong::table::type_func{$type}}($$sqlhash{$sqlName}) : $$sqlhash{$sqlName};
         $new_printable = " " if ! defined $new_printable || $new_printable eq "";  # ensure the table element shows (Moz bug)
         $table .= "<tr id=$id><td>$htmltime</td>\n".
                   " <td>".  FKong::cgi::htmlQuote($who) ."</td>\n <td>". FKong::cgi::htmlQuote($fieldName) ."</td>".
                   " <td>$old_printable</td>\n <td>$new_printable</td></tr>";
         $$sqlhash{$sqlName} = $old_val;
      } else {  # else it was a comment posting
         $table .= "<tr id=$id><td>$htmltime</td>\n".
                   " <td>".  FKong::cgi::htmlQuote($who) ."</td>\n <td>subject</td>".
                   " <td colspan=2><a href=\"$$fktable{'recprefix'}$recId.html#$commentId\">". FKong::cgi::htmlQuote($old_val) ."</a></td></tr>";
      };
      $rowCount++;
   };
   FKong::db::SendSQL("DROP TABLE temp");
   # determine the username of who create it
   $dbh = FKong::db::SendSQL("SELECT username FROM user WHERE userid = $$sqlhash{'create_by'}");
   my $who = $dbh->fetchrow_array() || $$sqlhash{'create_by'};
   $table .= "<tr id=\"HistEventRow\"><td>". Date::Format::time2str($FKong::config{'ListTimeFormat'},$$sqlhash{'createTS'}) ."</td>\n".   
             " <td>".  FKong::cgi::htmlQuote($who) ."</td>\n <td colspan=3>Created</td></td>" if ! $andwhere;
   $FKong::cgi::keyword{'rowCount'} = "$rowCount changes shown in $numEvent events";
   $FKong::cgi::keyword{'table'} = $table;
   FKong::cgi::print_expanded_template($template);
}

$FKong::table_func{'history.html'} = \&show_full_history;

sub show_full_history
{
   my($fktable) = @_;
   FKong::session::must_have_priv('view_features');
#   my($recprefix,$name,$url,$tablesql) = @_;
   my $dirty_feature = $FKong::cgi::form{'id'};
   if(! $dirty_feature) {  # if they didn't request a feature
      FKong::cgi::redirect("search.html");  # redirect to search form
   }
   if($dirty_feature !~ /(\d+)/) {
      FKong::Fatal("$$fktable{'name'} ". FKong::cgi::htmlQuote($dirty_feature) ." not understood.");
   }
   my $recId = $1;
   $FKong::cgi::keyword{'feature_name'} = "$$fktable{'recprefix'}$recId";
   show_history("template/history-template.html",$recId,'',$fktable);
}


1;


