
# Copyright 2003,2004 Frederick Dean

use strict;
#use diagnostics;

#
#  Copyright (c) 2002,2003 Frederick Dean
#

use Date::Format;

use FKong::cgi;
use FKong::db;

package FKong::list;

sub terseDuration {
   my($sec) = @_;
   my $answer = "";
   if($sec > 86400) {  # if longer than a day
      $answer .= int($sec/86400) . "d ";
      $sec = $sec % 86400;
   }
   if($sec > 3600) { # if longer than an hour
      $answer .= int($sec/3600) . "h ";
      $sec = $sec % 3600;
   }
   if($sec > 60) { # if longer than a minute
      $answer .= int($sec/60) . "m ";
      $sec = $sec % 60;
   }
   if($sec > 0) { 
      $answer .= $sec . "s";
   };
   return $answer;
}
sub unixTimestamp {
   return "" if ! $_[0];  # if zero or undefined
   return Date::Format::time2str($FKong::config{'ListTimeFormat'},$_[0]);
}
sub hexdump {
   return unpack("H*",$_[0]);
}
sub ipAddress {
   return "" if ! $_[0];
   return sprintf("%d.%d.%d.%d",unpack("C4",pack("N",$_[0])));
}

# The args here are passed to the column callback
sub new 
{
   my $self = { tablesql => $_[1], arg2 => $_[2], arg3 => $_[3] };
   return bless $self;
}

sub column_params
{
   my($self) = @_;
   return @{$self->{nicks}};
}

# Call this once for each column.  
# The order you define the columns controls the order in which they display.
sub DefCol {
   my($self,$nickname,$private,$title,$align,$default,$sql,$colfunc,$descript,$join,$replace) = @_;
   push(@{$self->{nicks}},$nickname) if ! $replace;
   $self->{private}{$nickname} = $private; 
   if($self->{coltitle}{$nickname} && ! $replace) {
      FKong::Fatal('internal error',"duplicate column nick $nickname for $title and $self->{coltitle}{$nickname} *****\n"); 
   };
   $self->{coltitle}{$nickname} = $title;  # top of table
   $self->{colalign}{$nickname} = $align;
   $self->{coldefault}{$nickname} = $default if $default;
   $self->{coldeflt} .= ",$nickname" if $default;
   $self->{colsql}{$nickname} = $sql;
   $self->{colfunc}{$nickname} = $colfunc;   
   $self->{coldesc}{$nickname} = $descript; # for column selection
   $self->{coljoin}{$nickname} = $join; 
}

# If you call this you should prepend an extra parameter to the start of your sql column list.
sub keep_list
{
   my($self) = @_;
   $self->{keeplist} = 1;
}

#  Actually, returns a list with the column sql and the ordering sql.
#  Here we happen to format the header too because its convenient.
sub get_column_sql 
{
   my($self,$keepers,$default_sort) = @_;

   # determine the sort order
   my $sort = $FKong::cgi::form{'sort'};
   if($sort) {  # if they set the sort
      FKong::session::set_state($self->{tablesql} ."-sort",$sort);  # remember the sort
   } else {
      $sort = FKong::session::get_state($self->{tablesql} ."-sort") || $default_sort;  # recall the sort
   };
   my $desc = ($sort =~ s/^-//) ? " DESC" : "";  # remove optional leading negation
   if(! defined $self->{colsql}{$sort}) {  # if sort is invalid
      $sort = $default_sort;  # use default 
      $desc = ($sort =~ s/^-//) ? " DESC" : "";  # remove optional leading negation
   }
   my $ordersql = "sorter $desc";
   # determine the columns
   my @cols2; # this is were we store the list of cols after we checked they are okay
   foreach my $nick (@{$self->{nicks}}) {  # for each possible column
      push(@cols2,$nick) if $FKong::cgi::form{$nick};  # keep the column if chosen for display
   };
   if(scalar(@cols2 > 1)) {  # if the user specified the columns
      FKong::session::set_state($self->{tablesql} ."-cols",join(",",@cols2));  # save the user's specification
   } else {   # else the user did not specify the columns
      @cols2 =  split(/,/, FKong::session::get_state($self->{tablesql} ."-cols") || $self->{coldeflt}) ;
      @cols2 = grep { $self->{colsql}{$_} } @cols2;  # keep only columns that are valid
   }
   unshift(@cols2,$sort) unless grep { $_ eq $sort } @cols2;  # ensure the sort column shows
   @cols2 = @{$self->{nicks}} if $FKong::cgi::form{'allcols'};  # override with all cols if the user specified it
   $self->{cols2} = \@cols2;   # save for when we print the table 
   # determine the column sql
   my(@sql);
   $self->{heading} = "";
   my %joins;
   foreach my $nick (@cols2) {  # for each column we are preparing for
      if($sort eq $nick) {
         push @sql, "$self->{colsql}{$nick} as sorter";
      } else{
         push @sql, $self->{colsql}{$nick};
      }
      my $class = ($sort eq $nick) ? "class=\"listSort\"" : "class=list";
      my $direction = "";
      $direction = "-" if $sort eq $nick && ! $desc;
      $self->{heading} .= "<th $class>".FKong::cgi::Link("",["sort=$direction$nick"],["allcols"]).
                  "$self->{coltitle}{$nick}</a></th>\n";
      $joins{$self->{coljoin}{$nick}}++ if $self->{coljoin}{$nick};
   }
   $self->{heading} = "<table width=100%><tr>\n$self->{heading}</tr>\n";
   my $colsql = join(",\n  ",@sql);
   FKong::Fatal("Internal error: no columns.",'') if($#sql == -1);
   return ($colsql,$ordersql,join("",keys %joins));
}

sub print_csv
{
   my($self,$dbh) = @_;
   # print a header
   $FKong::r->content_type('text/csv');
   $FKong::r->rflush;   # force it to send our content_type   WTF?
   $FKong::r->print($FKong::cgi::keyword{'nowtime'} ."\n\n"); 
   foreach my $nick (@{$self->{cols2}}) {  # for every column of the row
       (my $title = $self->{coltitle}{$nick}) =~ s/"/""/g;  # escape
       $FKong::r->print('"'. $title .'",');
   }
   $FKong::r->print("\n");
   while(1) { 
      my @row = $dbh->fetchrow_array();
      shift @row if $self->{keeplist};   # remove list item
      last if scalar(@row) == 0;  # if no values returned
      foreach my $nick (@{$self->{cols2}}) {  # for every column of the row
         my $value = shift(@row);
         if(defined $self->{'colfunc'}{$nick}) {
            $value = &{$self->{'colfunc'}{$nick}}($value,$self->{'arg2'},$self->{'arg3'});
            $value =~ s/<[^>]*>//g;  # remove HTML tags
            # unquote some HTML
            $value =~ s/\&amp;/\&/ig;
            $value =~ s/\&lt;/</ig;
            $value =~ s/\&gt;/>/ig;
            $value =~ s/\&#(\d{1,3});/pack("C",$1)/ige;
            # change newlines to spaces
            $value =~ s/\n/ /g unless $FKtable::cgi::form{'newline'};  
         };
         $value = "" if ! defined $value;  # ensure everything is defined
         $value =~ s/"/""/g;  # escape double quotes if not all words
         $FKong::r->print("\"$value\",");
      };
      $FKong::r->print("\n");
   };
   $FKong::r->print("\n");
   goto DONE;
}

#
#  print_template_with_table() assumes you have already FKong::db::SendSQL() with the query.
#  print_template_with_table() will fetch the data.
#  Thus, we also assume you have already called get_column_sql() so  $self->{heading} and $self->{cols2} are defined.
sub print_template_with_table 
{
   my($self,$template,$query,$keepers) = @_;

   my $dbh = FKong::db::SendSQL($query);
   return print_csv($self,$dbh) if $FKong::r->parsed_uri->path =~ /\.csv$/;
   my $rowIndex = 0;
   my $table = $self->{'heading'};
   my $list = "";  # comma separated for storing state
   while(1) { 
      my @row = $dbh->fetchrow_array();
      last if scalar(@row) == 0;  # if no values returned
      $rowIndex++;
      $list .= ",". shift(@row) if $self->{'keeplist'}; 
      $table .= ($rowIndex & 1) ? " <tr class=listOdd>\n" : " <tr class=list>\n";
      for my $nick (@{$self->{'cols2'}}) {  # for every column of the row
         my $value = shift(@row);
         defined($value) or $value = "";
         if($self->{'colalign'}{$nick}) {
            $table .= "  <td align=right>";
         } else {
            $table .= "  <td>";
         };
         if(defined $self->{'colfunc'}{$nick}) {
            $table .= &{$self->{'colfunc'}{$nick}}($value,$self->{'arg2'},$self->{'arg3'});
         } elsif(!defined $value || length $value == 0) {
            $table .= "&nbsp;";  # work around old netscape bug of empty table elements not having background color
         } else {
            $table .= FKong::cgi::htmlQuote_nonempty($value);
         }
         $table .= "</td>\n";   
      }
      $table .= " </tr>\n";
      $table .= "</table>\n$self->{heading}" if ($rowIndex&127) == 127;  # huge tables display slowly
   } 
   $table .= "</table>\n";
   $list =~ s/^,//;  # remove leading comma
   FKong::session::set_state($self->{'tablesql'} ."-list",$list) if $self->{'keeplist'};
   $FKong::cgi::keyword{'theList'} = $list if $self->{'keeplist'};
   $FKong::cgi::keyword{'table'} = $table;
   $FKong::cgi::keyword{'rowCount'} = "$rowIndex records shown";
   $FKong::cgi::keyword{'allColsUrl'} = FKong::cgi::Uri("",["allcols=1"],$keepers);
   FKong::cgi::print_expanded_template($template);
   $FKong::cgi::keyword{'table'} = "-- deleted in ". __FILE__ ." line ". __LINE__ ." --";  # so the debugging info is not too big
}

sub column_choice
{
   my($self,$tablesql) = @_;
   my $rowIndex = 0;
   my $table = "<div id=colChoice>\n".
               "<table><tr>\n" .
               "  <th>Show</th>\n" .
               "  <th>Title</th>\n" .
               "  <th>Description</th></tr>\n";
   my @cols2; # this is were we store the list of cols after we checked they are okay
   foreach my $nick (@{$self->{'nicks'}}) {  # for each possible column
      push(@cols2,$nick) if $FKong::cgi::form{$nick};  # keep the column if chosen for display
   };
   if(scalar(@cols2) < 1) {  # if the user did not specify the columns
      @cols2 =  split(/,/, FKong::session::get_state("$tablesql-cols") || $self->{'coldeflt'});
   }; 
   my %cols;  # store in a hash for easy checking (although they are already sorted)
   foreach (@cols2) { $cols{$_} = 1 };  
   foreach my $nick (@{$self->{'nicks'}}) { # for each row of html
      my $id = ($rowIndex++ & 1)  ? ' id=colChoiceEven' : ' id="colChoiceOdd"';
      my $check = $cols{$nick} ? "CHECKED" : "";
      $table .=  "<tr$id><td align=center><input type=checkbox name=$nick $check></td>\n" .
                 "   <td>" . FKong::cgi::htmlQuote_nonempty($self->{"coltitle"}{$nick}) . "\n" .
                 "   <td>" . FKong::cgi::htmlQuote_nonempty($self->{"coldesc"}{$nick}) . " </tr>\n";
   }
   $table .= "</table></div>\n";
   return $table;
}


1;

