
# Copyright 2003,2004 Frederick Dean

use strict;

use FKong::db;
use FKong::cgi;

package FKong::help;


$FKong::table_func{'help.html'} = \&show_long_help;

sub show_long_help
{
   my($fktable) = @_;  
   
   FKong::session::must_have_priv("view_features");
   $FKong::cgi::keyword{'help'} = "";
   my $dbh = FKong::db::SendSQL("SELECT fieldName, long_help, short_help FROM field_def\n".
                                "WHERE tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ." ORDER BY sort");
   $FKong::cgi::keyword{'help_stuff'} = '';
   while(my @row = $dbh->fetchrow_array()) {
      my($fieldName,$long_help,$short_help) = @row;
      $FKong::cgi::keyword{'fieldName'} = $fieldName;
      $FKong::cgi::keyword{'long_help'} = $long_help;
      $FKong::cgi::keyword{'short_help'} = $short_help;
      $FKong::cgi::keyword{'help'} = length($long_help) ?  $FKong::cgi::keyword{'long_help'} : $FKong::cgi::keyword{'short_help'};
      $FKong::cgi::keyword{'help_stuff'} .= FKong::cgi::return_expanded_template("template/help_entry.html");
   }
   FKong::cgi::print_expanded_template("template/help.html");
}

1;  # return code

