
#  Copyright 2003,2004 Frederick Dean

use strict;

use FKong::list;
use FKong::session;        

package FKong::user;

sub commands { 
   my($userid) = @_;
   return FKong::cgi::Link("edit.html",["userid=$userid"]) ."Edit</a>";
}

sub email { return "<a href=\"mailto:$_[0]\">$_[0]</a>"; }

sub privs { 
   my($privs) = @_;
   my $str = "";
   foreach my $priv (keys %FKong::session::privname) {
       $str .= "$priv<br>" if ($FKong::session::privname{$priv} & $privs);
   }
   return $str;
}

my $tbl = FKong::list->new('user','user');
#           nick private         title  align default   sql          display      descript                       
$tbl->DefCol("u90",0,                "Cmds",1,1,"user.userid",     \&commands, "");
$tbl->DefCol("u10",0,               "DB ID",1,0,"user.userid",          undef, "Internal database id for user table");
$tbl->DefCol("u20",0,            "Username",1,1,"user.username",        undef, "");
$tbl->DefCol("u30",0,           "Real Name",1,1,"user.realname",        undef, "");
$tbl->DefCol("u36",0,               "Email",1,1,"user.email",         \&email, "");
$tbl->DefCol("u85",0,               "Phone",1,1,"user.phone",           undef, "");
$tbl->DefCol("u56",0,           "Last Time",1,1,"user.lastTS",  \&FKong::list::unixTimestamp, "Last page view by user.");
$tbl->DefCol("u52",0,         "Modify Time",1,0,"user.modifyTS",  \&FKong::list::unixTimestamp, "Last administrative account information change.");
$tbl->DefCol("u70",0,          "Privileges",1,1,"user.privs",         \&privs, "");
$tbl->DefCol("u60",0,       "Disabled Text",1,0,"user.disabledText",    undef, "This shows when account is disabled");
$tbl->DefCol("u62",0,"Disabled Text Length",1,1,"LENGTH(user.disabledText)",undef, "");
$tbl->DefCol("u50",0,       "Creation Time",1,1,"user.createTS",\&FKong::list::unixTimestamp, "When was the user created.");
$tbl->DefCol("u80",0,             "Comment",1,0,"user.comment",         undef, "Administrative stored comment about user.");
$tbl->DefCol("u82",0,      "Comment Length",1,1,"LENGTH(user.comment)", undef, "");

sub keeper_parameters
{
   return [ FKong::list::column_params($tbl), 'search' ];    # list reference
}

$FKong::url_func{'user/search.html'} = \&Search;

sub Search
{
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("search.html");
   $FKong::cgi::keyword{'search'} = FKong::cgi::htmlQuote($FKong::cgi::form{'search'} || "");
   $FKong::cgi::keyword{'rowCount'} = "";
   my @terms;
   for my $term (split(/ +/,$FKong::cgi::form{'search'} || "")) {
      next unless $term;
      $term = FKong::db::SqlQuote(lc($term));  # SQL quote
      push @terms, "(INSTR(LOWER(user.username),$term) OR INSTR(LOWER(user.realname),$term) OR ".
                   "INSTR(LOWER(user.email),$term))";
   }
   if(scalar(@terms) == 0) {
      $FKong::cgi::keyword{'table'} = '';
      FKong::cgi::print_expanded_template("template/user_search-template.html");
   } else {
      show_table("template/user_search-template.html","WHERE ". join("\n AND ",@terms) ."\n");
   }
}

$FKong::url_func{'user/list.html'} = sub { show_table("template/users-template.html",""); };
$FKong::url_func{'user/list.csv'} = $FKong::url_func{'user/list.html'};

sub show_table
{
   my($template,$where) = @_;
   # check that they have permission 
   FKong::session::must_have_priv("view_users");
   # check for configure button
   if($FKong::cgi::form{'update'}) {  # If the update button was pressed
      update();
      return FKong::cgi::redirect("list.html");
   }
   if($FKong::cgi::form{'cancel'}) {  # If the cancel button was pressed
      return FKong::cgi::redirect("list.html");
   }
   # column headings
   my $keepers = keeper_parameters();
   my($colsql,$ordersql) = $tbl->get_column_sql($keepers,"u20");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # submit the query
   my $query = "SELECT $colsql\nFROM user\n".
               $where .
               "ORDER BY $ordersql LIMIT $maxRecords";
   $tbl->print_template_with_table($template,$query,$keepers);
}

# These descriptions are HTML
my %priv_title = ( view_features => "Can view features", 
                   edit_features => "Can create and edit features", 
                   view_fields => "Can view field definitions", 
                   edit_fields => "Can create and edit field definitions", 
                   delete_features => "Can delete features", 
                   view_users => "Can view user account information of others", 
                   edit_users => "Can create and edit user account information of others", 
                   recv_appl => "Receives an email about new account applications",
                   view_log => "Can view the log (bad logins and application errors)", 
                   view_other => "Can view other stuff like the global config and debug info.", 
                   edit_other => "Can edit other stuff like the global config and debug info.", 
                 );

sub priv_opts
{
   my($privs) = @_;
   $FKong::cgi::keyword{'priv_opts'} = "";
   foreach my $priv (sort { $FKong::session::privname{$a} <=> $FKong::session::privname{$b} } keys %FKong::session::privname) {
      # this is for the final form
      $FKong::cgi::keyword{'param'} = $priv;
      $FKong::cgi::keyword{'param'} .= ($privs & $FKong::session::privname{$priv}) ? " CHECKED" : "";
      $FKong::cgi::keyword{'title'} = $priv_title{$priv} || $priv;
      $FKong::cgi::keyword{'priv_opts'} .= FKong::cgi::return_expanded_template("template/user_priv-template.html");
   }
}

$FKong::url_func{'user/edit.html'} = \&edit_user;

sub edit_user
{
   FKong::session::must_have_priv("view_users");
   $FKong::cgi::form{'userid'} or FKong::Fatal("Internal error: userid missing.",'');
   $FKong::cgi::form{'userid'} =~ /^\d+$/ or FKong::Fatal("Internal error: userid malformed.",'');
   my $dbh = FKong::db::SendSQL("SELECT user.username, user.email, user.realname, user.privs, user.disabledtext,user.comment,user.phone \n".
               "FROM user\n".
               "WHERE user.userid = $FKong::cgi::form{'userid'} LIMIT 1");
   my($username,$email,$realname,$privs,$disabledtext,$comment,$phone) = $dbh->fetchrow_array();
   $username or FKong::Fatal("userid $FKong::cgi::form{'userid'} does not exist.",'');
   $FKong::cgi::keyword{'form_username'} = FKong::cgi::value_quote($username);
   $FKong::cgi::keyword{'userid'} = FKong::cgi::value_quote($FKong::cgi::form{'userid'});
   $FKong::cgi::keyword{'email'} = FKong::cgi::value_quote($email);
   $FKong::cgi::keyword{'realname'} = FKong::cgi::value_quote($realname);
   $FKong::cgi::keyword{'disabledtext'} = FKong::cgi::htmlQuoteForPre($disabledtext);
   $FKong::cgi::keyword{'comment'} = FKong::cgi::htmlQuoteForPre($comment);
   $FKong::cgi::keyword{'phone'} = FKong::cgi::value_quote($phone || "");
   priv_opts($privs);
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("list.html");
   FKong::cgi::print_expanded_template("template/user_edit-template.html"); 
}

$FKong::url_func{'user/new.html'} = \&new_user;

sub new_user
{
   FKong::session::must_have_priv("edit_users");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("list.html");
   my $dbh = FKong::db::SendSQL("SELECT privs, disabledtext FROM user WHERE userid = 97");
   my($privs,$dtext) = $dbh->fetchrow_array();
   priv_opts($privs || 0);
   $FKong::cgi::keyword{'disabledtext'} = $dtext;
   FKong::cgi::print_expanded_template("template/user_new-template.html"); 
}

sub update
{
   FKong::session::must_have_priv("edit_users");  # redundant
   my $privs = 0;
   foreach my $priv (keys %FKong::session::privname) {
      $privs += $FKong::session::privname{$priv} if $FKong::cgi::form{$priv};
   }
   foreach (qw/email form_username realname/) {
      FKong::Fatal("non-empty $_ required") if ! $FKong::cgi::form{$_};
   }
   if($FKong::cgi::form{'update'} && $FKong::cgi::form{'update'} =~ /create/i) {  # if this is a new user
      my $dbh = FKong::db::SendSQL("SELECT userid FROM user WHERE username = ". FKong::db::SqlQuote($FKong::cgi::form{'form_username'}));
      if($dbh->fetchrow_array()) {  # if the username already exists
         FKong::Fatal("That username already exists.");
      };
      $dbh = FKong::db::SendSQL("SELECT username FROM user WHERE email = ". FKong::db::SqlQuote($FKong::cgi::form{'email'}));
      my $name = $dbh->fetchrow_array();
      if($name) {
         FKong::Fatal("That email already exists for username $name.");
      };
   }
   set_user($FKong::cgi::form{'userid'},$FKong::cgi::form{'form_username'},$FKong::cgi::form{'passwd'},$FKong::cgi::form{'realname'},$FKong::cgi::form{'email'},
            $FKong::cgi::form{'disabledtext'},$FKong::cgi::form{'comment'},$privs,$FKong::cgi::form{'phone'});
   if(($FKong::cgi::form{'update'} || "") =~ /create/i) {  # if this is a new user
      FKong::db::SendSQL("UPDATE user SET \n".
                  "modifyTS = UNIX_TIMESTAMP()\n".
                  "WHERE username = ". FKong::db::SqlQuote($FKong::cgi::form{'form_username'}));
      if(! $FKong::cgi::form{'password'}) {  # if they don't have a password
         send_password($FKong::cgi::form{'form_username'});
      };
   };
}
 
# You can specify the user by username or userid, but if both are specified,
# then the username is changed in the record of the specified userid.
sub set_user 
{
   my($userid,$username,$password,$realname,$email,$disabledtext,$comment,$privs,$phone) = @_;

   my $query = "";
   if($password) {  # if password is defined and not empty
      my $dbh = FKong::db::SendSQL("SELECT RAND(), RAND(), RAND(), RAND()");
      my $data = time() . $$ . rand() . \@_ . join($password,$dbh->fetchrow_array());
      if(-r "/dev/urandom" && open(RAND,"</dev/urandom")) {
         binmode(RAND);
         read(RAND,my $randstuff,32);
         close(RAND);
         $data .= $randstuff;
      };
      my $salt = Digest::MD5::md5_base64($data);
      $salt = "md5" . Digest::MD5::md5_base64($salt.rand());
      my $hash = Digest::MD5::md5_base64($salt . $password);
      my $cryptpassword = $salt . $hash; 
      $query .= "\n, cryptpassword = ".FKong::db::SqlQuote($cryptpassword);
   }
   $query .= "\n, realname = ".FKong::db::SqlQuote($realname) if defined $realname;
   $query .= "\n, email = ".FKong::db::SqlQuote($email) if defined $email;
   $disabledtext = "" if defined $disabledtext && $disabledtext =~ /^\s+$/s;  # if all white space
   $query .= "\n, disabledtext = ".FKong::db::SqlQuote($disabledtext) if defined $disabledtext;
   $comment = "" if defined $comment && $comment =~ /^\s+$/s;  # if all white space
   $query .= "\n, comment = ".FKong::db::SqlQuote($comment) if defined $comment;
   $query .= "\n, privs = ".FKong::db::SqlQuote($privs) if defined $privs;
   $query .= "\n, phone = ".FKong::db::SqlQuote($phone) if defined $phone;
   # We will not just use SQL REPLACE because that changes the userid.
   if(! defined $userid) {
      defined $username or FKong::Fatal("Inernal error, username undefined");
      my $dbh = FKong::db::SendSQL("SELECT userid FROM user WHERE username = ".FKong::db::SqlQuote($username));
      $userid = $dbh->fetchrow_array();
   } 
   $query .= "\n, username = ".FKong::db::SqlQuote($username) if defined $username;
   if(defined $userid) {
      $query = "UPDATE user SET modifyTS = UNIX_TIMESTAMP() $query WHERE userid = ".FKong::db::SqlQuote($userid);
   } else {
      $query = "INSERT user SET createTS = UNIX_TIMESTAMP(), modifyTS = UNIX_TIMESTAMP() ". $query;
   }
   FKong::db::SendSQL($query);
}

$FKong::url_func{'user/columns.html'} = \&column_choice_table;

sub column_choice_table
{
my $tablesql = 'user';
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("list.html");
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$tablesql);
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

# This implements password policy.  Minimum length and estimated entropy.
# We do not check administratively assigned passwords.
sub ugly_passwd_problems
{
   my($pw1,$pw2) = @_;
   my $problems = "";
   if(length $pw1 < 6) {
      $problems .= "Your new password was too short (6 character minimum).\n";
   };
   (my $nonalpha = $pw1) =~ tr/a-zA-Z//d;  # delete alpha characters
   if(0 == length $nonalpha) {
      $problems .= "Your new password must not be all letters.  Numbers and puctuation work well.\n";
   };
   (my $alpha = $pw1) =~ tr/a-zA-Z//cd;  # delete non-alpha characters
   if(0 == length $alpha) {
      $problems .= "Your new password must have at least three letters.\n";
   };
   if($pw1 ne $pw2) {
      $problems .= "Your new passwords didn't match.\n";
   };
   return $problems;
}

sub send_password
{
   my($send_name) = @_;
   FKong::cgi::trim($send_name);
   FKong::Fatal("You must specify a username or email address when requesting a password be sent.") if ! $send_name;
   my $dbh = FKong::db::SendSQL("SELECT userid FROM user WHERE email = ". FKong::db::SqlQuote($send_name) ."\n".
               "OR username = ". FKong::db::SqlQuote($send_name) ." OR realname = ". FKong::db::SqlQuote($send_name));
   my $userid = $dbh->fetchrow_array();
   if(! $userid) {
      FKong::Fatal("I could not find the user account.\n".
                     "The search was done case-insesitively.\n".
                     "You must provide the entire email address or username.");
   }
   my $randata = time() . $$ . rand() . \@_ . join("x",values %ENV);
   if(-r "/dev/urandom" && open(RAN,"</dev/urandom")) {  # If we can read from /dev/urandom
      read(RAN,$randata,32,length $randata);  # append more random data.
      close(RAN);
   }
   my $passwd = substr(Digest::MD5::md5_base64($randata),0,8);  
   set_user($userid,undef,$passwd); 
   $dbh = FKong::db::SendSQL("SELECT email, username, realname FROM user WHERE userid = ". FKong::db::SqlQuote($userid));
   my($email,$username,$realname) = $dbh->fetchrow_array();
   $email or FKong::Fatal("Internal error: missing email addresss.");
   $email =~ /\S+\@\S+/ or FKong::Fatal("Internal error: malformed email addresss.");
   $FKong::cgi::keyword{'full_login_url'} = $FKong::config{'featurekong_url'} . FKong::cgi::Uri('/',[ "l_u=$username", "l_p=$passwd", "login=1" ]);
   $FKong::cgi::keyword{'send_for_passwd'} = $passwd;
   $FKong::cgi::keyword{'send_for_username'} = $username;
   my $body = FKong::cgi::return_expanded_template("template/send_password.email");
   FKong::sendmail::send_mail($email,"Your password for FeatureKong.", $body);
};

sub apply_for_login
{
   my $problems = "";
   foreach my $param (qw/apply_username apply_password apply_password2 apply_realname 
                         apply_email apply_phone/) {
      if(! $FKong::cgi::form{$param}) {
         $problems .= "You are missing your $param<br>"; 
      };
      FKong::cgi::trim($FKong::cgi::form{$param});  # trim leading and trailing white space
      $FKong::cgi::form{$param} =~ tr/\r\0//d;  # delete nul and carrage return 
      #print STDERR "--apply-- $param -> $FKong::cgi::form{$param}\n";
   };
   my $dbh = FKong::db::SendSQL("SELECT userid FROM user where username = ". FKong::db::SqlQuote($FKong::cgi::form{'apply_username'}));
   if($dbh->fetchrow_array()) {  # If the username is already taken.
      $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=send_name value=\"".  
                                        FKong::cgi::htmlQuote($FKong::cgi::form{'apply_username'})  ."\">\n";
      $FKong::cgi::keyword{'taken'} .= "username";
      FKong::cgi::print_expanded_template("template/send_offer-template.html");
      goto DONE;
   }
   $dbh = FKong::db::SendSQL("SELECT userid FROM user where email = ". FKong::db::SqlQuote($FKong::cgi::form{'apply_email'}));
   if($dbh->fetchrow_array()) {  # If the username is already taken.
      $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=send_name value=\"". 
                                        FKong::cgi::htmlQuote($FKong::cgi::form{'apply_email'})  ."\">\n";
      $FKong::cgi::keyword{'taken'} .= "email";
      FKong::cgi::print_expanded_template("template/send_offer-template.html");
      goto DONE;
   }
   $problems .= ugly_passwd_problems($FKong::cgi::form{'apply_password'},$FKong::cgi::form{'apply_password2'});
   FKong::Fatal($problems) if $problems;  
   $dbh = FKong::db::SendSQL("SELECT privs, disabledtext FROM user WHERE userid = 98");
   my($privs,$dtext) = $dbh->fetchrow_array();
   FKong::db::ignore_cancel();  # so we are sure to send the emails
   FKong::db::SendSQL("INSERT INTO user SET username = ". FKong::db::SqlQuote($FKong::cgi::form{'apply_username'}) .",\n".
               "email = ". FKong::db::SqlQuote($FKong::cgi::form{'apply_email'}) .",\n".
               "realname = ". FKong::db::SqlQuote($FKong::cgi::form{'apply_realname'}) .",\n".
               "phone = ". FKong::db::SqlQuote($FKong::cgi::form{'apply_phone'}) .",\n".
               "privs = ". FKong::db::SqlQuote($privs) .",\n".
               "disabledtext = ". FKong::db::SqlQuote($dtext) .",\n".
               "createTS = UNIX_TIMESTAMP(), modifyTS = UNIX_TIMESTAMP()");
   my $userid = FKong::db::last_insert_id();
   set_user($userid,undef,$FKong::cgi::form{'apply_password'});  # set the password
   FKong::session::make_session_valid($userid);
   # notify the people who need to know about new accounts
   $dbh = FKong::db::SendSQL("SELECT email FROM user WHERE (privs & $FKong::session::privname{'recv_appl'})");
   my $to = "";
   # note: RFC822 header continuation lines begin with white space
   while(my $dude = $dbh->fetchrow_array()) { $to .= "\n $dude,"; }
   if($to) {  # if anyone wants to be notified
      my $letter = qq{A new person has applied for an account:\n\n};
      foreach (qw/realname username email phone/) {
         my $blah = $FKong::cgi::form{"apply_$_"} || "";
         $blah =~ tr/\0-\e//d;  # delete control characters
         $letter .= "    $_: $blah\n";
      }
      $letter .= "\n\n". $FKong::config{'featurekong_url'} . $FKong::r->location . "/user_edit.html?userid=$userid\n\n";
      FKong::sendmail::send_mail($to,"New Feature Kong Applicant",$letter);
   }
   $FKong::cgi::keyword{'warning'} .= "<div class=warn>Thanks.  Your account was created.  Depending on how the\n".
                                      "adminitrator has configured things, you may not have many\n".
                                      "privileges yet.</div>\n";
   FKong::cgi::redirect(FKong::cgi::Uri("/"));
   goto DONE;
}

my %user_cache;  # for the user_pulldown
my $user_cache_date = 0;  # the last time we fetched usernames
my $user_cache_date_db = 0;  # the most recent modifyTS we have seen

sub user_pulldown
{
   my($name,$selected,$nochange_opt) = @_;
   my $html = "   <select name=\"$name\">\n";
   $html .= "      <option value=\"\" SELECTED>*** No Change ***</option>\n" if $nochange_opt;
   if($user_cache_date < time - 2 && scalar(keys %user_cache) < 100) {  # rate limit our checking and how many we keep
      my $dbh = FKong::db::SendSQL("SELECT userid, realname, username, modifyTS FROM user\n".
                                   "WHERE userid >= 100 AND modifyTS > $user_cache_date_db LIMIT 100");
      while(my($userid,$realname,$username,$modifyTS) = $dbh->fetchrow_array) {
         last if scalar(keys %user_cache) > 100;  # quit if we have too many
         my $display = ($realname && $FKong::config{'ShowRealnames'} ? "$realname ($username)" : $username);
         $user_cache{$display} = $userid;
         $user_cache_date_db = $modifyTS if $user_cache_date_db < $modifyTS;
      };
      $user_cache_date = time;
   }
   foreach (sort keys %user_cache) {
      my $select = ($user_cache{$_} == $selected) ? ' SELECTED' : '';
      $html .= "      <option value=$user_cache{$_}$select>". FKong::cgi::htmlQuote($_) ."</option>\n";
   }
   $html .= "      </select>\n";
   return $html;
}

1;  # return code

