#!/usr/bin/perl -w
use strict;

#
#  With this script we manipulate the database directly and
#  check some text of pages produced by record.pm that
#  represent an individual records.
#

use lib ".";
use lib "..";
require "../featurekong_startup.pl";
use FKong::db;
use FKong::cgi;

my $base_url = 'http://127.0.0.1/fkong/';

# log ourselves in (hopefully as the administrator)
my $cookie_val = 'abcdefghijklmnopqrstuv';
FKong::db::SendSQL("REPLACE session SET cookie = ". FKong::db::SqlQuote($cookie_val) .",\n".
                   "userid = 100, isvalid = 1, remoteip = 2130706433, lastused = UNIX_TIMESTAMP() ");

my $curl_cmd = "curl -s --header 'Cookie: featurekong_session=$cookie_val' ";

my $featureId = 3;
my $tablesql = 'feature';

my $dbh = FKong::db::SendSQL("SELECT pkey, recprefix FROM fktable\n".
             "WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
my($pkey, $recprefix) = $dbh->fetchrow_array();
defined $pkey || die;
defined $recprefix || die;

sub do_type_test
{
   my($type, $read_only, $db_val, $form_val) = @_;

   my $dbh = FKong::db::SendSQL("SELECT fieldId, fieldName, sqlName, width FROM field_def\n".
                 "WHERE tablesql = ". FKong::db::SqlQuote($tablesql) ."\n".
                 "AND read_only = ". FKong::db::SqlQuote($read_only) ."\n".
                 "AND type = ". FKong::db::SqlQuote($type));
   while(my($fieldId, $fieldName, $sqlName, $width) = $dbh->fetchrow_array()) {
      my $dbv = defined $db_val ? $db_val : 'undef';
      #print "fieldId=$fieldId fieldName=$fieldName db_val=$dbv\n";
      # save old database
      my $dbh2 = FKong::db::SendSQL("SELECT $sqlName FROM $tablesql\n".   
                         "WHERE $tablesql.$pkey = $featureId"); 
      my($origValue) = $dbh2->fetchrow_array();
      # make database good for the test
      FKong::db::SendSQL("UPDATE $tablesql SET $sqlName = ". FKong::db::SqlQuote($db_val) ."\n".
                         "WHERE $tablesql.$pkey = $featureId"); 
      my $pattern = "$fieldName ". rand();
      FKong::db::SendSQL("UPDATE field_def SET fieldName = ". FKong::db::SqlQuote($pattern) ."\n".
                         "WHERE fieldId = $fieldId");
      $pattern =~ s/(\W)/\\$1/g;  # escape for regex pattern matching
      my $page = `$curl_cmd $base_url/$recprefix$featureId.html`;
      my @rows = split("<tr>",$page);
      my $found;
      foreach my $row (@rows) {
         next unless $row =~ /$pattern/;
         $found = 1;
         (my $pattern2 = $form_val) =~ s/([^\w\s='"<>:])/\\$1/g;  # regexp escape
         $pattern2 = "<div class=read_only>$pattern2</div>" if $read_only;
         $pattern2 =~ s/sqlName/$sqlName/;
         $pattern2 =~ s/ SIZE/ size=$width/ if $width;
         $pattern2 =~ s/ SIZE// if ! $width;
         $row =~ /<td[^>]*>$pattern2<\/td>/ or warn "bad value for fieldName=$fieldName db_val=$dbv form_val=$form_val\n".
                                                    "$row\npattern2=$pattern2\n";
         last;
      }
      defined $found or warn "field name not found for $pattern\n";
      # repair and restore
      FKong::db::SendSQL("UPDATE field_def SET fieldName = ". FKong::db::SqlQuote($fieldName) ."\n".
                         "WHERE fieldId = $fieldId");
      FKong::db::SendSQL("UPDATE $tablesql SET $sqlName = ". FKong::db::SqlQuote($origValue) ."\n".
                         "WHERE $tablesql.$pkey = $featureId");
   }

}

do_type_test('money', 0, 0,      '<input name="sqlName" SIZE value="0.00">');
do_type_test('money', 0, 1,      '<input name="sqlName" SIZE value="0.01">');
do_type_test('money', 0, 91,     '<input name="sqlName" SIZE value="0.91">');
do_type_test('money', 0, 200,    '<input name="sqlName" SIZE value="2.00">');
do_type_test('money', 0, 4000,   '<input name="sqlName" SIZE value="40.00">');
do_type_test('money', 0, -123456,'<input name="sqlName" SIZE value="-1234.56">');
do_type_test('money', 0, -3,     '<input name="sqlName" SIZE value="-0.03">');
do_type_test('money', 0, -14,    '<input name="sqlName" SIZE value="-0.14">');
do_type_test('money', 0, -800,   '<input name="sqlName" SIZE value="-8.00">');
do_type_test('money', 0, undef,  '<input name="sqlName" SIZE value="">');
do_type_test('money', 1, undef,  '&nbsp;');
do_type_test('money', 1, 0,      '0.00');
do_type_test('money', 1, 100,    '1.00');
do_type_test('money', 1, -200,   '-2.00');

do_type_test('ip',    0, sprintf("%u",0x01020304), '<input name="sqlName" SIZE value="1.2.3.4">');
do_type_test('ip',    0, sprintf("%u",0xfffefdfc), '<input name="sqlName" SIZE value="255.254.253.252">');
do_type_test('ip',    0, sprintf("%u",0xfcfdfeff), '<input name="sqlName" SIZE value="252.253.254.255">');
do_type_test('ip',    0, 0,                        '<input name="sqlName" SIZE value="0.0.0.0">');
do_type_test('ip',    0, undef,                    '<input name="sqlName" SIZE value="">');
do_type_test('ip',    1, sprintf("%u",0xfcfdfeff), '<a href="http://252.253.254.255">252.253.254.255</a>');

do_type_test('integer', 0, 0,          '<input name="sqlName" SIZE value="0">');
do_type_test('integer', 0, 1,          '<input name="sqlName" SIZE value="1">');
do_type_test('integer', 0, -1,         '<input name="sqlName" SIZE value="-1">');
do_type_test('integer', 0, 999999999,  '<input name="sqlName" SIZE value="999999999">');
do_type_test('integer', 0, -999999999, '<input name="sqlName" SIZE value="-999999999">');
do_type_test('integer', 0, undef,      '<input name="sqlName" SIZE value="">');
do_type_test('integer', 1, undef,      '&nbsp;');
do_type_test('integer', 1, 3,  '3');

do_type_test('float', 0, 0,      '<input name="sqlName" SIZE value="0">');
do_type_test('float', 0, 1,      '<input name="sqlName" SIZE value="1">');
do_type_test('float', 0, .1,     '<input name="sqlName" SIZE value="0.1">');
do_type_test('float', 0, -.1,    '<input name="sqlName" SIZE value="-0.1">');
do_type_test('float', 0, 1.0,    '<input name="sqlName" SIZE value="1">');
do_type_test('float', 0, -1.0,   '<input name="sqlName" SIZE value="-1">');
do_type_test('float', 0, undef,  '<input name="sqlName" SIZE value="">');
do_type_test('float', 1, undef,  '&nbsp;');

do_type_test('hexint', 0, 15,     '<input name="sqlName" SIZE value="0x0f">');
do_type_test('hexint', 0, 1,      '<input name="sqlName" SIZE value="0x01">');
do_type_test('hexint', 0, 0,      '<input name="sqlName" SIZE value="0x00">');
do_type_test('hexint', 0, 256,    '<input name="sqlName" SIZE value="0x100">');
do_type_test('hexint', 0, sprintf("%u",0x12345678), '<input name="sqlName" SIZE value="0x12345678">');
do_type_test('hexint', 0, sprintf("%u",0xfedcba98), '<input name="sqlName" SIZE value="0xfedcba98">');
do_type_test('hexint', 0, undef,  '<input name="sqlName" SIZE value="">');
do_type_test('hexint', 1, undef,  '&nbsp;');

do_type_test('unix_ts', 0, undef,  '<input name="sqlName" SIZE value="">');
do_type_test('unix_ts', 0, 0,  '<input name="sqlName" SIZE value="">');
do_type_test('unix_ts', 0, 1000000,  '<input name="sqlName" SIZE value="Mon Jan 12, 1970  7:46am CST">');
do_type_test('unix_ts', 1, 1000060,  'Mon Jan 12, 1970  7:47am CST');
do_type_test('unix_ts', 1, undef,  '&nbsp;');
do_type_test('unix_ts', 1, 0,  '&nbsp;');

do_type_test('oneline', 1, 'blue green red',  'blue green red');
do_type_test('oneline', 1, 'blue& green red',  'blue&amp; green red');
do_type_test('oneline', 1, 'blue< green> red',  'blue&lt; green&gt; red');
do_type_test('oneline', 1, "blue\nred",  "blue\n<br>red");   # should never happen
do_type_test('oneline', 1, undef,  '&nbsp;');
do_type_test('oneline', 1, '',  '&nbsp;');
do_type_test('oneline', 0, undef,  '<input name="sqlName" SIZE value="">');
do_type_test('oneline', 0, '',  '<input name="sqlName" SIZE value="">');
do_type_test('oneline', 1, 'sailing.fdd.com',  '<a href="http://sailing.fdd.com">sailing.fdd.com</a>');
do_type_test('oneline', 0, 'sailing.fdd.com',  '<input name="sqlName" size=80 value="sailing.fdd.com"> <a href="http://sailing.fdd.com/">Link</a> ');

do_type_test('bool', 1, 1,  'yes');
do_type_test('bool', 1, 0,  'no');
do_type_test('bool', 0, 1,  '<input name="sqlName" type=checkbox CHECKED>');
do_type_test('bool', 0, 0,  '<input name="sqlName" type=checkbox >');

do_type_test('multiline', 0, 'foo',  '<textarea WRAP=HARD NAME="sqlName" ROWS=8 COLS=80>foo</textarea>');
do_type_test('multiline', 0, '',  '<textarea WRAP=HARD NAME="sqlName" ROWS=8 COLS=80></textarea>');
do_type_test('multiline', 0, undef,  '<textarea WRAP=HARD NAME="sqlName" ROWS=8 COLS=80></textarea>');
do_type_test('multiline', 0, "foo\nbar",  qq{<textarea WRAP=HARD NAME="sqlName" ROWS=8 COLS=80>foo\nbar</textarea>});
do_type_test('multiline', 1, '',  '&nbsp;');
do_type_test('multiline', 1, undef,  '&nbsp;');
do_type_test('multiline', 1, 'foo',  'foo');
do_type_test('multiline', 1, "foo\nbar",  qq{foo\n<br>bar});
do_type_test('multiline', 1, "foo\nbar\nme",  qq{foo\n<br>bar\n<br>me});
do_type_test('multiline', 1, "foo\nbar\nme\n",  qq{foo\n<br>bar\n<br>me\n<br>});
do_type_test('multiline', 1, "foo\nbar\nme\n\n",  qq{foo\n<br>bar\n<br>me\n<br>\n<br>});
do_type_test('multiline', 1, "\nfoo\nbar",  qq{\n<br>foo\n<br>bar});
do_type_test('multiline', 1, "\n\nfoo\nbar",  qq{\n<br>\n<br>foo\n<br>bar});

#'constant',
#'user',


sub do_multi_type_test
{
   my $dbh = FKong::db::SendSQL("SELECT fieldId, fieldName, sqlName, mult_choices FROM field_def\n".
                 "WHERE tablesql = ". FKong::db::SqlQuote($tablesql) ."\n".
                 "AND read_only = 0\n". 
                 "AND type = 'mult_choice'");
   while(my($fieldId, $fieldName, $sqlName, $mult_choices) = $dbh->fetchrow_array()) {
      #print "fieldId=$fieldId fieldName=$fieldName\n";
      # save old database
      my $dbh2 = FKong::db::SendSQL("SELECT $sqlName FROM $tablesql\n".   
                         "WHERE $tablesql.$pkey = $featureId"); 
      my($origValue) = $dbh2->fetchrow_array();
      # make database good for the test
      my $pattern = "$fieldName ". rand();
      FKong::db::SendSQL("UPDATE field_def SET fieldName = ". FKong::db::SqlQuote($pattern) ."\n".
                         "WHERE fieldId = $fieldId");
      $pattern =~ s/(\W)/\\$1/g;  # escape for regex pattern matching
      foreach my $db_val (split(/^/,$mult_choices)) {
         chomp($db_val);
         FKong::db::SendSQL("UPDATE $tablesql SET $sqlName = ". FKong::db::SqlQuote($db_val) ."\n".
                            "WHERE $tablesql.$pkey = $featureId"); 
         my $page = `$curl_cmd $base_url/$recprefix$featureId.html`;
         my @rows = split("<tr>",$page);
         my $found;
         foreach my $row (@rows) {
            next unless $row =~ /$pattern/;
            $found = 1;
            my $pattern2 = '';
            foreach (split(/^/,$mult_choices)) {
               chomp;
               my $selected = ($_ eq $db_val) ? 'SELECTED' : '';
               $pattern2 .= "      <option value=\"". FKong::cgi::value_quote($_) ."\" $selected>". FKong::cgi::htmlQuote($_) ."</option>\n";
            }
            $pattern2 =~ s/([^\w\s='"<>:])/\\$1/g;  # regexp escape
            $row =~ /<td[^>]*><select name="$sqlName">\s+$pattern2\s+<\/select><\/td>/s 
                     or die "bad value for fieldName=$fieldName db_val=$db_val\n".
                             "$row\npattern2=$pattern2\n";
            last;
         }
         defined $found or warn "field name not found for $pattern\n";
      };
      # repair and restore
      FKong::db::SendSQL("UPDATE field_def SET fieldName = ". FKong::db::SqlQuote($fieldName) ."\n".
                         "WHERE fieldId = $fieldId");
      FKong::db::SendSQL("UPDATE $tablesql SET $sqlName = ". FKong::db::SqlQuote($origValue) ."\n".
                         "WHERE $tablesql.$pkey = $featureId");
   }

}

do_multi_type_test();


