
# Copyright 2003,2004 Frederick Dean

use strict;

use FKong::list;

package FKong::fieldset;

sub commands { 
   my($fieldsetId) = @_;
   return FKong::cgi::Link("edit.html",["fieldsetId=$fieldsetId"]) ."Edit</a>\n" .
          FKong::cgi::Link("delete.html",["fieldsetId=$fieldsetId"]) ."Delete</a>\n".
          FKong::cgi::Link("list.html",["fieldsetId=$fieldsetId"]) ."Fields</a>";
}

my $tbl = FKong::list->new('fieldset','fieldset');
#           nick private         title  align default   sql          display      descript                       
$tbl->DefCol("p90",0,            "Commands",1,1,"fieldset.fieldsetId",   \&commands, "");
$tbl->DefCol("p10",0,               "DB ID",1,0,"fieldset.fieldsetId",        undef, "");
$tbl->DefCol("p20",0,       "Fieldset Name",1,1,"fieldset.fieldsetName",      undef, "");
$tbl->DefCol("p23",0,           "Table SQL",1,1,"fieldset.tablesql",      undef, "");
$tbl->DefCol("p50",0,       "Creation Time",1,1,"fieldset.createTS",\&FKong::list::unixTimestamp, "");
$tbl->DefCol("p52",0,          "Created By",1,1,"COALESCE(creator.username,fieldset.create_by)",undef, "",
             "LEFT JOIN user AS creator ON (creator.userid = fieldset.create_by)\n");
$tbl->DefCol("p60",0,        "Num Features",1,1,"COUNT(DISTINCT feature.recId)",undef, "",
             "LEFT JOIN feature ON (feature.fieldsetId = fieldset.fieldsetId)\n");
$tbl->DefCol("p63",0,          "Num Fields",1,1,"COUNT(field_def.fieldId)",   undef, "",
             "LEFT JOIN field_def ON (field_def.fieldsetId = fieldset.fieldsetId)\n");

sub keeper_parameters
{
   return [ FKong::list::column_params($tbl) ];    # list reference
}

$FKong::table_func{'fieldset/list.html'} = \&show_table;
$FKong::table_func{'fieldset/list.csv'} = $FKong::table_func{'fieldset/list.html'};

sub show_table
{
   my($fktable) = @_;

   # check that they have permission 
   FKong::session::must_have_priv("view_fieldsets");
   # check for configure button
   if($FKong::cgi::form{'update'}) {  # If the now button was pressed
      update();
      return FKong::cgi::redirect("fieldsets.html");
   }
   if($FKong::cgi::form{'delete'}) {  
      dirty_work_of_delete();
      return FKong::cgi::redirect("fieldsets.html");
   }
   if($FKong::cgi::form{'cancel'}) {  
      return FKong::cgi::redirect("fieldsets.html");
   }
   # column headings
   my $keepers = keeper_parameters();
   my($colsql,$ordersql,$joins) = $tbl->get_column_sql($keepers,"p20");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # submit the query
   my $query = "SELECT $colsql\nFROM fieldset\n".
               $joins.
               "WHERE fieldset.tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ."\n".
               "GROUP BY fieldsetId\n".
               "ORDER BY $ordersql\nLIMIT $maxRecords";
   $tbl->print_template_with_table("template/fieldsets-template.html",$query,$keepers);
}

$FKong::table_func{'fieldset/delete.html'} = \&delete_fieldset;

sub delete_fieldset
{
   my($fktable) = @_;
   FKong::session::must_have_priv("edit_fieldsets");
   fieldset_keyword_details();
   FKong::cgi::print_expanded_template("template/fieldset_delete-template.html"); 
}

$FKong::table_func{'fieldset/edit.html'} = \&edit_fieldset;

sub edit_fieldset
{
   my($fktable) = @_;
   FKong::session::must_have_priv("view_fieldsets"); # The edit form doubles as the detail page
   fieldset_keyword_details();
   FKong::cgi::print_expanded_template("template/fieldset_edit-template.html"); 
} 

sub fieldset_keyword_details
{
   $FKong::cgi::form{'fieldsetId'} or FKong::Fatal("Internal error: fieldsetId missing.",'');
   $FKong::cgi::form{'fieldsetId'} =~ /^\d+$/ or FKong::Fatal("Internal error: fieldsetId malformed.",'');
   my $dbh = FKong::db::SendSQL("SELECT  fieldsetName \n".
                         "FROM fieldset\n".
                         "WHERE fieldsetId = $FKong::cgi::form{'fieldsetId'} LIMIT 1");
   my($fieldsetName) = $dbh->fetchrow_array();
   $fieldsetName or FKong::Fatal("fieldsetId $FKong::cgi::form{'fieldsetId'} does not exist.",'');
   $FKong::cgi::keyword{'fieldsetId'} = $FKong::cgi::form{'fieldsetId'};
   $FKong::cgi::keyword{'fieldsetName'} = FKong::cgi::value_quote($fieldsetName);
   $FKong::cgi::keyword{'hidden'} = "<input type=hidden name=fieldsetId value=\"". FKong::cgi::value_quote($FKong::cgi::form{'fieldsetId'}) ."\">\n";
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/fieldsets.html");
}

$FKong::table_func{'fieldset/new.html'} = \&new_fieldset;

sub new_fieldset
{
   my($fktable) = @_;
   FKong::session::must_have_priv("edit_fieldsets");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/fieldsets.html");
   FKong::cgi::print_expanded_template("template/fieldset_new-template.html"); 
}

sub dirty_work_of_delete
{
   FKong::session::must_have_priv("edit_fieldsets");
   my $fieldsetId = $FKong::cgi::form{'fieldsetId'};
   if(!$fieldsetId) {  
      FKong::Fatal("Internal error: fieldsetId missing for delete",'');
   }
   FKong::db::SendSQL("LOCK TABLES fieldset WRITE ");
   FKong::db::SendSQL("DELETE FROM fieldset WHERE fieldsetId = ". FKong::db::SqlQuote($fieldsetId));
   FKong::db::SendSQL("UNLOCK TABLES");
}

sub update
{
   FKong::session::must_have_priv("edit_fieldsets");
   foreach (qw/fieldsetName/) {
      FKong::Fatal("non-empty $_ required") if ! $FKong::cgi::form{$_};
      FKong::cgi::trim($FKong::cgi::form{$_});
   }
   my $fieldsetId = $FKong::cgi::form{'fieldsetId'};
   if(!$fieldsetId) {  # if they used the create-new form
      my $dbh = FKong::db::SendSQL("SELECT fieldsetId FROM fieldset WHERE fieldsetName = ". FKong::db::SqlQuote($FKong::cgi::form{'fieldsetName'}));
      $fieldsetId = $dbh->fetchrow_array();
   }
   if($fieldsetId) {
      # Check that the fieldset ID exists.
      my $dbh = FKong::db::SendSQL("SELECT fieldsetId FROM fieldset WHERE fieldsetId = ". FKong::db::SqlQuote($fieldsetId));
      if(! $dbh->fetchrow_array()) {
         FKong::Fatal("Inernal error: fieldsetId not found.\n",'');
      }
      FKong::db::SendSQL("UPDATE fieldset SET fieldsetName = ". FKong::db::SqlQuote($FKong::cgi::form{'fieldsetName'}) .",\n".
                  "modifyTS = UNIX_TIMESTAMP()\n".
                  "WHERE fieldsetId = ". FKong::db::SqlQuote($fieldsetId));
   } else {
      FKong::db::SendSQL("INSERT INTO fieldset SET fieldsetName = ". FKong::db::SqlQuote($FKong::cgi::form{'fieldsetName'}) .",\n".
                  "createTS = UNIX_TIMESTAMP(), create_by = $FKong::cgi::keyword{'userid'},\n".
                  "modifyTS = createTS, mod_by = $FKong::cgi::keyword{'userid'}");
      $fieldsetId = FKong::db::last_insert_id();
   };
}

$FKong::table_func{'fieldset/columns.html'} = \&column_choice_table;

# This prints the form that lets users indicate which fields they want to see, 
# when viewing the table of all fields.
sub column_choice_table
{
   my($fktable) = @_;  # ignore
   my $tablesql = 'field_def';
   $FKong::cgi::keyword{'formurl'} = "list.html";
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$tablesql);
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

1;  # return code

