
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::search;

my $max_mc_per_row = 6;   # for pagination of multiple choice fields

sub show_form
{
   my($template,$fktable,@wheres) = @_;

   # get field definitions
   my $fieldsetId = $FKong::cgi::form{'fieldsetId'};
   push(@wheres, "(fieldsetId <=> ". FKong::db::SqlQuote($fieldsetId) ." OR fieldsetId IS NULL)") if $fieldsetId;
   push(@wheres, "field_def.tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}));
   my $where = "";
   $where = "WHERE ". join("\nAND ",@wheres) ."\n" if scalar(@wheres);
   my $dbh = FKong::db::SendSQL("SELECT fieldId, fieldName, sqlName, type, mult_choices, min, max, deflt,\n".
               "on_new_form, sort, short_help, long_help \n".
               "FROM field_def\n".
               $where .
               "ORDER BY sort, type, fieldName");
   my $num_mc_this_row = 0;
   my $form = "";
   $FKong::cgi::keyword{'text'} = FKong::cgi::value_quote($FKong::cgi::form{'text'});
   while(1) {  # for each field_def defined field
      my($fieldId,$fieldName,$sqlName,$type,$mult_choices,$min,$max,$default,$on_new_form,
         undef,$short_help,$long_help) = $dbh->fetchrow_array();
      if($num_mc_this_row && ($num_mc_this_row > $max_mc_per_row || ! defined $type || $type ne "mult_choice")) {  # terminate mult-choice row?
         $form .= "</tr></table></td></tr>";
         $num_mc_this_row = 0; 
      };
      last if ! defined $fieldId;
      my $edit = $FKong::cgi::form{'edit'} ? "<a href=\"edit_field.html?fieldId=$fieldId\"><font color=\"#669966\" size=-1>E</font></a> " : "";
      my $value = $FKong::cgi::form{$sqlName};
      $value = "" if ! defined $value;
      if($type eq "mult_choice") {                       ##### if multiple choice
         $form .= "<tr><Td colspan=2>\n <table><tr>" if $num_mc_this_row++ == 0;
         $form .= "   <td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."<br>\n".
                  "       <select name=\"$sqlName\" multiple=\"multiple\" size=5>\n";
         my %selects;
         foreach (split(/\0/,$value)) { $selects{$_} = 1 };
         foreach my $choice (split(/^/,$mult_choices)) {
            chomp($choice);
            my $selected = "";
            $selected = $selects{$choice} ? "SELECTED" : "";
            $form .= "      <option value=\"". FKong::cgi::value_quote($choice) ."\" $selected>". FKong::cgi::htmlQuote($choice) ."</option>\n";
         }
         $form .= "      </select></td>\n";
      } elsif($type eq "integer" || $type eq 'hexint' || $type eq 'money' || $type eq "float") {  ##### if numeric
         my $min = $FKong::cgi::form{"$sqlName-min"};
         my $max = $FKong::cgi::form{"$sqlName-max"};
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ." Min</td>\n". 
                  " <td colspan=3> <input name=\"$sqlName-min\" size=12 value=\"". FKong::cgi::value_quote($min) ."\">\n".
                  " Max <input name=\"$sqlName-max\" size=12 value=\"". FKong::cgi::value_quote($max) ."\"> </td></tr>\n";
      } elsif($type eq "bool") {                         ##### if boolean
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td><input name=\"$sqlName\" type=radio value=1 ". ($value?"CHECKED":"") ."> Yes \n".
                  "<input name=\"$sqlName\" type=radio value=0 ". ($value eq "0"?"CHECKED":"") ."> No \n".
                  "<input name=\"$sqlName\" type=radio value=\"\" ". ($value eq ""?"CHECKED":"") ."> Don't care</td></tr>\n";
      } elsif($type eq "oneline" || $type eq "multiline") {  ##### if text entry
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td colspan=3><input name=\"$sqlName\" size=60 value=\"". FKong::cgi::value_quote($value) ."\"></td></tr>\n";
      } elsif($type eq 'constant') {                     ##### if constant
         $form .= "<tr><td class=t colspan=4>$edit". ($default || $fieldName) ."</td></tr>\n";
      };
   };
   $FKong::cgi::keyword{'search_comments'} = FKong::cgi::value_quote($FKong::cgi::form{'search_comments'});
   $FKong::cgi::keyword{'fform'} = $form;
   $FKong::cgi::keyword{'oldQuery'} = (FKong::session::get_state("features-query") || "");
   FKong::cgi::print_expanded_template($template);
}

$FKong::table_func{'search.html'} = sub { 
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("list.html");
   show_form("template/search-template.html",@_[0],"basic_search"); 
};

$FKong::table_func{'advanced.html'} = sub { 
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("list.html");
   show_form("template/search-template.html",$_[0],"adv_search"); 
};

our %decoration = ( mult_choice => "", integer => "*", hexint => '*', money => '*',
                   oneline => "**", multiline => "**", user => "", unix_ts => '*',
                   bool => "", float => '*', constant => " (error)");

$FKong::table_func{'count_form.html'} = \&show_count_form;

sub show_count_form
{
   my($fktable) = @_;
   my $hform = "<select name=horiz size=10>\n";
   my $vform = "<select name=vert size=10>\n";
   my $dbh = FKong::db::SendSQL("SELECT fieldName, fieldId, type, sqlName FROM field_def\n".
                                "WHERE tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'})  ."\n".
                                "AND type != 'constant' ORDER BY fieldName");
   while(my($fieldName,$fieldId,$type,$sqlName) = $dbh->fetchrow_array) {
      next if $decoration{$type} eq "**";   #  we will support this later
      my $hselected = $FKong::cgi::form{'horiz'} eq $sqlName ? 'SELECTED' : '';
      $hform .= "  <option value=\"". FKong::cgi::value_quote($sqlName) ."\" $hselected>". 
                FKong::cgi::htmlQuote("$fieldName$decoration{$type}") ."</option>\n";
      my $vselected = $FKong::cgi::form{'vert'} eq $sqlName ? 'SELECTED' : '';
      $vform .= "  <option value=\"". FKong::cgi::value_quote($sqlName) ."\" $vselected>". 
                FKong::cgi::htmlQuote("$fieldName$decoration{$type}") ."</option>\n";
   }
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("count.html");
   $FKong::cgi::keyword{'vform'} = $vform ."</select>";
   $FKong::cgi::keyword{'hform'} = $hform ."<select>";
   $FKong::cgi::keyword{'hrange'} = FKong::cgi::htmlQuoteForPre($FKong::cgi::form{'hrange'} || '');
   $FKong::cgi::keyword{'vrange'} = FKong::cgi::htmlQuoteForPre($FKong::cgi::form{'vrange'} || '');
   FKong::search::show_form("template/count_form.html",$fktable,"basic_search"); 
}

1;

