
# Copyright 2003,2004 Frederick Dean

use strict;

use FKong::list;

package FKong::comment;

sub commands { 
   my($commentId) = @_;
   return FKong::cgi::Link("edit.html",["commentId=$commentId"]) ."Edit</a>\n" .
          FKong::cgi::Link("delete.html",["commentId=$commentId"]) ."Delete</a>\n".
          FKong::cgi::Link("list.html",["commentId=$commentId"]) ."Fields</a>";
}

my $tbl = FKong::list->new('comment','comment');
#           nick private         title  align default   sql          display      descript                       
$tbl->DefCol("p90",0,            "Commands",1,1,"comment.commentId",   \&commands, "");
$tbl->DefCol("p10",0,               "DB ID",1,0,"comment.commentId",        undef, "");
$tbl->DefCol("p23",0,           "Table SQL",1,1,"comment.tablesql",      undef, "");
$tbl->DefCol("p50",0,       "Creation Time",1,1,"comment.createTS",\&FKong::list::unixTimestamp, "");
$tbl->DefCol("p52",0,          "Created By",1,1,"COALESCE(creator.username,comment.create_by)",undef, "",
             "LEFT JOIN user AS creator ON (creator.userid = comment.create_by)\n");
$tbl->DefCol("p60",0,        "Num Features",1,1,"COUNT(DISTINCT feature.recId)",undef, "",
             "LEFT JOIN feature ON (feature.commentId = comment.commentId)\n");
$tbl->DefCol("p63",0,          "Num Fields",1,1,"COUNT(field_def.fieldId)",   undef, "",
             "LEFT JOIN field_def ON (field_def.commentId = comment.commentId)\n");

sub keeper_parameters
{
   return [ FKong::list::column_params($tbl) ];    # list reference
}

$FKong::table_func{'comment/list.html'} = \&show_table;
$FKong::table_func{'comment/list.csv'} = $FKong::table_func{'comment/list.html'};

sub show_table
{
   my($fktable) = @_;

   # check that they have permission 
   FKong::session::must_have_priv("view_comments");
   # check for configure button
   if($FKong::cgi::form{'update'}) {  # If the now button was pressed
      update();
      return FKong::cgi::redirect("comments.html");
   }
   if($FKong::cgi::form{'delete'}) {  
      dirty_work_of_delete();
      return FKong::cgi::redirect("comments.html");
   }
   if($FKong::cgi::form{'cancel'}) {  
      return FKong::cgi::redirect("comments.html");
   }
   # column headings
   my $keepers = keeper_parameters();
   my($colsql,$ordersql,$joins) = $tbl->get_column_sql($keepers,"p20");
   # maximum number of records stuff
   my $maxRecords = $FKong::cgi::form{'max_records'} || 100;
   $maxRecords = 1000 if $maxRecords > 1000;
   # submit the query
   my $query = "SELECT $colsql\nFROM comment\n".
               $joins.
               "WHERE comment.tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ."\n".
               "GROUP BY commentId\n".
               "ORDER BY $ordersql\nLIMIT $maxRecords";
   $tbl->print_template_with_table("template/comments-template.html",$query,$keepers);
}

$FKong::table_func{'comment/delete.html'} = \&delete_comment;

sub delete_comment
{
   my($fktable) = @_;
   FKong::session::must_have_priv("edit_comments");
   comment_keyword_details();
   FKong::cgi::print_expanded_template("template/comment_delete-template.html"); 
}

$FKong::table_func{'comment/edit.html'} = \&edit_comment;

sub edit_comment
{
   my($fktable) = @_;
   FKong::session::must_have_priv("view_comments"); # The edit form doubles as the detail page
   comment_keyword_details();
   FKong::cgi::print_expanded_template("template/comment_edit-template.html"); 
} 

sub comment_keyword_details
{
   $FKong::cgi::form{'commentId'} or FKong::Fatal("Internal error: commentId missing.",'');
   $FKong::cgi::form{'commentId'} =~ /^\d+$/ or FKong::Fatal("Internal error: commentId malformed.",'');
   my $dbh = FKong::db::SendSQL("SELECT  commentName \n".
                         "FROM comment\n".
                         "WHERE commentId = $FKong::cgi::form{'commentId'} LIMIT 1");
   my($commentName) = $dbh->fetchrow_array();
   $commentName or FKong::Fatal("commentId $FKong::cgi::form{'commentId'} does not exist.",'');
   $FKong::cgi::keyword{'commentId'} = $FKong::cgi::form{'commentId'};
   $FKong::cgi::keyword{'commentName'} = FKong::cgi::value_quote($commentName);
   $FKong::cgi::keyword{'hidden'} = "<input type=hidden name=commentId value=\"". FKong::cgi::value_quote($FKong::cgi::form{'commentId'}) ."\">\n";
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/comments.html");
}

$FKong::table_func{'comment/new.html'} = \&new_comment;

sub new_comment
{
   my($fktable) = @_;
   FKong::session::must_have_priv("edit_comments");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/comments.html");
   FKong::cgi::print_expanded_template("template/comment_new-template.html"); 
}

sub dirty_work_of_delete
{
   FKong::session::must_have_priv("edit_comments");
   my $commentId = $FKong::cgi::form{'commentId'};
   if(!$commentId) {  
      FKong::Fatal("Internal error: commentId missing for delete",'');
   }
   FKong::db::SendSQL("LOCK TABLES comment WRITE ");
   FKong::db::SendSQL("DELETE FROM comment WHERE commentId = ". FKong::db::SqlQuote($commentId));
   FKong::db::SendSQL("UNLOCK TABLES");
}

sub update
{
   FKong::session::must_have_priv("edit_comments");
   foreach (qw/commentName/) {
      FKong::Fatal("non-empty $_ required") if ! $FKong::cgi::form{$_};
      FKong::cgi::trim($FKong::cgi::form{$_});
   }
   my $commentId = $FKong::cgi::form{'commentId'};
   if(!$commentId) {  # if they used the create-new form
      my $dbh = FKong::db::SendSQL("SELECT commentId FROM comment WHERE commentName = ". FKong::db::SqlQuote($FKong::cgi::form{'commentName'}));
      $commentId = $dbh->fetchrow_array();
   }
   if($commentId) {
      # Check that the comment ID exists.
      my $dbh = FKong::db::SendSQL("SELECT commentId FROM comment WHERE commentId = ". FKong::db::SqlQuote($commentId));
      if(! $dbh->fetchrow_array()) {
         FKong::Fatal("Inernal error: commentId not found.\n",'');
      }
      FKong::db::SendSQL("UPDATE comment SET commentName = ". FKong::db::SqlQuote($FKong::cgi::form{'commentName'}) .",\n".
                  "modifyTS = UNIX_TIMESTAMP()\n".
                  "WHERE commentId = ". FKong::db::SqlQuote($commentId));
   } else {
      FKong::db::SendSQL("INSERT INTO comment SET commentName = ". FKong::db::SqlQuote($FKong::cgi::form{'commentName'}) .",\n".
                  "createTS = UNIX_TIMESTAMP(), create_by = $FKong::cgi::keyword{'userid'},\n".
                  "modifyTS = createTS, mod_by = $FKong::cgi::keyword{'userid'}");
      $commentId = FKong::db::last_insert_id();
   };
}

$FKong::table_func{'comment/columns.html'} = \&column_choice_table;

# This prints the form that lets users indicate which fields they want to see, 
# when viewing the table of all fields.
sub column_choice_table
{
   my($fktable) = @_;  # ignore
   my $tablesql = 'field_def';
   $FKong::cgi::keyword{'formurl'} = "list.html";
   $FKong::cgi::keyword{'table'} = FKong::list::column_choice($tbl,$tablesql);
   FKong::cgi::print_expanded_template("template/column_choice-template.html");
}

1;  # return code

