
# Copyright 2003,2004 Frederick Dean

# -*- Mode: perl; indent-tabs-mode: nil -*-

package FKong::db;

use strict;

use DBI;
use FKong::config;
use FKong::cgi;



my $db;

sub ConnectToDatabase {
    return if defined($db);
    $db = DBI->connect("DBI:mysql:host=$FKong::db_host;database=$FKong::db_name", 
                       $FKong::db_user, $FKong::db_pass)
        || FKong::Fatal($FKong::r,"Content-Type: text/plain\n\n".
            "I am currently broken. Please try again later.\n" . 
            "If the problem persists, please contact xxx.\n" .
            "The error you should quote is:\n" . $DBI::errstr .
            "\n".
            "If this is the first time using FKong, then\n".
            "you probably need to edit the database connection\n".
            "parameters in FKong::db.pm");
}

my(@sqls,@callers);  # for debug

my $locked;

sub SendSQL {
    my ($str) = (@_);
    if($FKong::debug && scalar(@sqls) < 30) {  # if we haven't saved too many SQL statements
       my($package, $filename, $line) = caller;
       $filename =~ s/.*\///; # remove path
       my(undef, undef, undef, $subroutine) = caller(1);
       $subroutine ||= "";  # ensure defined
       push(@sqls,"<font color=black>$subroutine()</font> <font color=gray>file $filename line $line</font>\n".
                  "<font color=green>". FKong::cgi::htmlQuoteForPre($str) ."</font>\n");
    };
    ConnectToDatabase() unless $db;
#print STDERR map("SQL--> $_",split(/^/, $str)), "\n\n";
    my $dbh = $db->prepare($str);
    if(! $dbh->execute) {  # if there was an error
       my($package, $filename, $line) = caller;
       if($FKong::debug) {  # if in debug mode
          FKong::Fatal("<pre>called from $filename line $line\n".
              $db->errstr ."\n".
              $str ."\n</pre>\n",'');
       } else {  # else not in debug mode
          FKong::Fatal("FeatureKong had an internal error.  \"Internal\" means it was not your fault.\n".
                       "Please contact the adminitrator for help.\n".
                       "If you are the administrator please check the system log, or enable debugging.\n",
                       "called from $filename line $line\n".   # log details to the system error_log
                       $db->errstr ."\n".
                       $str ."\n");
       };
    }
    $locked = 1 if $str =~ /^\s*LOCK/i;
    $locked = 0 if $str =~ /^\s*UNLOCK/i;
    return $dbh;
}

sub last_insert_id
{
   return $db->{ mysql_insertid };
   #my $dbh = SendSQL("SELECT LAST_INSERT_ID()");
   #my @row = $dbh->fetchrow_array();
   #return $row[0];
}

sub maybe_unlock_tables
{
   SendSQL("UNLOCK TABLES") if $locked;
}

# This routine is largely copied from Mysql.pm.
sub SqlQuote {
    my ($str) = (@_);
    return "NULL" if !defined($str);
    $str =~ s/([\\\'])/\\$1/g;
    $str =~ s/\0/\\0/g;
    # If it's been SqlQuote()ed, then it's safe, so we tell -T that.
    #$str = detaint_string($str);
    return "'$str'";
}

my %mapping = ( r => "\r", "'" => "'", n => "\n", 0 => "\0", "\\" => "\\" );

# This function assumes the bounding single quotes are already removed.
# This function is probably broken.
sub SqlUnquoteInside {
    my ($str) = (@_);
    $str =~ s/''/'/g;
    $str =~ s/\\([rn0'\\])/$mapping{$1}/ge;
    return $str;
}

sub print_debug_sqls
{
   $FKong::r->print("<hr><font size=+1>SQL history</font><br>\n");
   $FKong::r->print("<pre>\n");
   $FKong::r->print(join("\n",@sqls));
   $FKong::r->print("</pre>\n");
}

# We ignore these signals so a web browser cancel doesn't stop interrupt atomic updates.
# It is not needed for every LOCK TABLES because mysql will unlock when the connection drops.
# You should call it right after you successfully lock the tables (when necessisary).
sub ignore_cancel
{
   # FIXME  we should not be doing this stuff with mod_perl right?
   $::SIG{PIPE} = 'IGNORE';
   $::SIG{TERM} = 'IGNORE'; 
}

#  Free up some memory and destroy state from last session
sub Done
{
   @sqls = ();
   @callers = ();
}

1;



