
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::record;

sub do_comment_keywords
{
   my($recId,$fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   if(! $$fktable{'comments'}) {
      $FKong::cgi::keyword{'comments'} = "<i>No ${tablesql}_comment table</i>";
      return;
   };
   my $comments = "";
   my $dbh = FKong::db::SendSQL("SELECT commentId, comment.createTS, format, subject, body,\n".
               "COALESCE(user.realname,user.username,comment.createTS)\n".
               "FROM ${tablesql}_comment AS comment\n".
               "LEFT JOIN user ON (comment.create_by = user.userid)\n".
               "WHERE comment.$$fktable{'pkey'} = $recId\n".
               "ORDER BY createTS");
   while(my($commentId,$when,$format,$subject,$body,$who) = $dbh->fetchrow_array()) {
      $FKong::cgi::keyword{'commentId'} = $commentId;
      $FKong::cgi::keyword{'subject'} = FKong::cgi::htmlQuote($subject);
      $FKong::cgi::keyword{'body'} = FKong::cgi::htmlQuoteForPre($body);
      FKong::cgi::Linkify($FKong::cgi::keyword{'body'});
      $FKong::cgi::keyword{'when'} = Date::Format::time2str($FKong::config{'TimeFormat'},$when);
      $FKong::cgi::keyword{'who'} = FKong::cgi::htmlQuote($who);
      $comments .= FKong::cgi::return_expanded_template("template/comment-template.html");
   };
   $FKong::cgi::keyword{'comments'} = $comments;
}

sub translate_to_username
{
   my($value,$cacheref) = @_;
   return $value if ! $value;
   return $$cacheref{$value} if $$cacheref{$value};  # check cache before database
   my $dbh = FKong::db::SendSQL("SELECT username FROM user WHERE userid = ". FKong::db::SqlQuote($value));
   my $name = $dbh->fetchrow_array();
   $$cacheref{$value} = $name;  # save in cache
   return $name if defined $name;
   return $value
}

sub unixTimestamp2 {
   return "" if ! $_[0];  # if zero or undefined
   return Date::Format::time2str($FKong::config{'TimeFormat'},$_[0]);
}

my %length_of_type = ( oneline => 60, integer => 12, hexint => 12, money => 12, unix_ts => 30, user => 30, float => 12 );

sub unixTimestamp {
   return "" if ! $_[0];  # if zero or undefined
   return Date::Format::time2str($FKong::config{'TimeFormat'},$_[0]);
}
our %type_func = ( unix_ts => \&unixTimestamp, hexint => \&FKong::table::hex_format, money => \&FKong::table::money_format );

sub show_fields
{
   my($template,$hashref,$andwhere,$fktable) = @_;
   my $lh = $FKong::cgi::form{'lh'} ? ', long_help' : '';  # show long help inline?
   my $dbh = FKong::db::SendSQL("SELECT fieldId, fieldName, sqlName, type, mult_choices, deflt, short_help $lh\n".
               "FROM field_def\n".
               "WHERE tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ."\n". $andwhere .
               "ORDER BY sort, type, fieldName");
   my %usercache;
   my $form = "";
   while(my($fieldId,$fieldName,$sqlName,$type,$mult_choices,$default,
         $short_help,$long_help) = $dbh->fetchrow_array()) {  # for each possible field
      my $value = $$hashref{$sqlName};
      $value = $default if ! defined $value;
      $FKong::cgi::keyword{$sqlName} = FKong::cgi::htmlQuote($value);  # for custom templates
      my $edit = $FKong::cgi::form{'edit'} ? 
               "<a href=\"$$fktable{'url'}/field/edit.html?fieldId=$fieldId\"><font color=\"#669966\" size=-1>E</font></a> " : "";
      if($type eq "mult_choice") {
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  "    <td><select name=\"$sqlName\">\n";
         foreach (split(/^/,$mult_choices)) {
            chomp($_);
            my $selected = $value eq $_ ? "SELECTED" : "";
            $form .= "      <option value=\"". FKong::cgi::value_quote($_) ."\" $selected>". FKong::cgi::htmlQuote($_) ."</option>\n";
         }
         $form .= "      </select></td>\n".
                  " <td>$short_help</td></tr>\n";
      } elsif($type eq "bool") {
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td><input name=\"$sqlName\" type=checkbox ". ($value?"CHECKED":"") ."></td>\n".
                  " <td colspan=2>$short_help</td></tr>\n";
      } elsif($type eq "oneline") {
         my $link = '';
         if($value =~ m/(http:\/\/\S+)/) {  # if field contains a link
            $link = "<a href=\"$1\">Link</a> ";
         } elsif ($value =~ m/([\w\-\.]+\.[a-zA-Z\-\.]+\/[\/\w\.\-\%\?\=\&]*)\s*$/i) {  # or probably a hostname with path
            $link = "<a href=\"http://$1\">Link</a> ";
         } elsif ($value =~ m/([\w\-\.]+\.[a-zA-Z\-\.]+)\s*$/i) {  # or probably a hostname
            $link = "<a href=\"http://$1\/\">Link</a> ";
         }
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td colspan=3><input name=\"$sqlName\" size=60 value=\"". FKong::cgi::value_quote($value) ."\"> $link</td>\n".
                  " <td>$short_help</td></tr>\n";
      } elsif($type eq "user") {
         $value = $FKong::cgi::keyword{'userid'} if ! $value;  # use ourselves if the defailt is not a real user.
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td colspan=3>";
         if($FKong::config{'UserPulldown'}) {
            $form .= FKong::user::user_pulldown($sqlName,$value);
         } else {
            $value = translate_to_username($value,\%usercache);
            $form .= "<input name=\"$sqlName\" size=60 value=\"". FKong::cgi::value_quote($value) ."\">";
         };
         $form .= "</td>\n<td>$short_help</td></tr>\n";
      } elsif($type eq "multiline") {
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td colspan=3><textarea WRAP=HARD NAME=\"$sqlName\" ROWS=4 COLS=60>". 
                  FKong::cgi::htmlQuoteForPre($value) ."</textarea></td></tr>\n";
         $FKong::cgi::keyword{$sqlName} = FKong::cgi::htmlQuoteForPre($value); # for custom templates
      } elsif($type eq 'constant') {
         $form .= "<tr><td class=t colspan=4>". ($default || $fieldName) ."</td></tr>\n";
      } else {
         $form .= "<tr><td class=t>$edit" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td><input name=\"$sqlName\" size=". ($length_of_type{$type} || 60) ." value=\"". 
                  FKong::cgi::htmlQuote( $type_func{$type} ? &{$type_func{$type}}($value) : $value ) ."\"></td>\n".
                  " <td>$short_help</td></tr>\n";
      };
      $form .= "<tr><td class=h colspan=4>$long_help</td></tr>\n" if $lh;  # append long help
   };
   $FKong::cgi::keyword{'fform'} = $form;
   FKong::cgi::print_expanded_template($template);
   $FKong::cgi::keyword{'comments'} = "-- deleted in ". __FILE__ ." line ". __LINE__ ." --";  # so the debugging info is not too big
}

$FKong::table_func{'batch_row.html'} = \&show_batch_row;

sub show_batch_row
{
   my($fktable) = @_;

   $FKong::cgi::keyword{'formurl'} = "submit.html"; 
   my $recs = FKong::session::get_state("$$fktable{'tablesql'}-list");
   if($recs) {
      $FKong::cgi::keyword{'hidden'} .= "";
      $FKong::cgi::keyword{'records'} = join(" &nbsp; ",map { "<input type=checkbox name=f$_ CHECKED><a href=\"$$fktable{'recprefix'}$_.html\">".
                                                       "$$fktable{'recprefix'}$_</a>" } split(/,/, $recs));
   } else {
      $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=ids value=all>\n";
      $FKong::cgi::keyword{'records'} = "<font color=red>all records</font>"
   };

   my $lh = $FKong::cgi::form{'lh'} ? ', long_help' : '';  # show long help inline?
   my $dbh = FKong::db::SendSQL("SELECT fieldName, sqlName, type, mult_choices, deflt, short_help $lh\n".
               "FROM field_def\n".
               "WHERE batch AND tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ."\n".
               "ORDER BY sort, type, fieldName");
   my $form = "";
   while(my($fieldName,$sqlName,$type,$mult_choices,$default,$short_help,$long_help) = $dbh->fetchrow_array()) {  # for each possible field
      if($type eq "mult_choice") {
         $form .= "<tr><td class=t>" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  "    <td><select name=\"$sqlName\">\n";
         $form .= "      <option value=\"\" SELECTED>*** No Change ***</option>\n";
         foreach (split(/^/,$mult_choices)) {
            chomp($_);
            $form .= "      <option value=\"". FKong::cgi::value_quote($_) ."\">". FKong::cgi::htmlQuote($_) ."</option>\n";
         }
         $form .= "      </select></td>\n".
                  " <td>$short_help</td></tr>\n";
      } elsif($type eq "multiline") {
         $form .= "<tr><td class=t>" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td colspan=3><textarea WRAP=HARD NAME=\"$sqlName\" ROWS=4 COLS=60></textarea></td></tr>\n";
      } elsif($type eq 'constant') {
         $form .= "<tr><td class=t colspan=4>". ($default || $fieldName) ."</td></tr>\n";
      } elsif($type eq 'bool') {
         $form .= "<tr><td class=t>" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td><input name=\"$sqlName\" type=radio value=1> Yes \n".
                  "<input name=\"$sqlName\" type=radio value=0> No \n".
                  "<input name=\"$sqlName\" type=radio value=\"\" CHECKED> Unchanged</td></tr>\n";
      } elsif($type eq 'user' && $FKong::config{'UserPulldown'}) {
         $form .= "<tr><td class=t>" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td>".  FKong::user::user_pulldown($sqlName,0,1) ."></td>\n".
                  " <td>$short_help</td></tr>\n";
      } else {
         $form .= "<tr><td class=t>" . FKong::cgi::htmlQuote($fieldName) ."</td>\n". 
                  " <td><input name=\"$sqlName\" size=". ($length_of_type{$type} || 60) ."></td>\n".
                  " <td>$short_help</td></tr>\n";
      };
      $form .= "<tr><td class=h colspan=4>$long_help</td></tr>\n" if $lh;  # append long help
   }
   $FKong::cgi::keyword{'fform'} = $form;
   FKong::cgi::print_expanded_template("template/batch_row.html");
}

sub show_new_form
{
   my($fktable) = @_;
   my $tablesql  = $$fktable{'tablesql'};
   FKong::session::must_have_priv("edit_features");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/$$fktable{'url'}/submit.html");  # important so the redirect doesn't trash this page.
   my $hashref = { };
   if($FKong::cgi::form{'duplicate'} && $FKong::cgi::form{'duplicate'} =~ /(\d+)/ ) {
      my $dbh2 = FKong::db::SendSQL("SELECT * FROM $tablesql WHERE $$fktable{'pkey'} = $1");
      $hashref = $dbh2->fetchrow_hashref() || {};
   };
   my $dbh = FKong::db::SendSQL("SELECT sqlName, deflt, rset_on_dup FROM field_def WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
   while(my($sqlName,$default,$rset_on_dup) = $dbh->fetchrow_array()) {
      $$hashref{$sqlName} = $default if ! defined $$hashref{$sqlName} || $rset_on_dup;
   }
   show_fields("template/feature-new-template.html",$hashref,"AND on_new_form\n",$fktable);
}

$FKong::table_func{'new.html'} = \&show_new_form;

sub find_index
{
   my $pattern = shift;
   my $index = 0;
   foreach (@_) { return $index if $_ eq $pattern; $index++ }
   return undef;
}


sub show_edit_form
{
   my($recId,$fktable) = @_;

   my $recprefix = $$fktable{'recprefix'};
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   # check that they have permission 
   FKong::session::must_have_priv("view_features");
   FKong::session::must_have_priv("view_fields") if $$fktable{'internal'};
   my $feature_name = "$recprefix$recId"; 
   $FKong::cgi::keyword{'feature_name'} = $feature_name; 
   my $dbh = FKong::db::SendSQL("SELECT $tablesql.$pkey, ".
               "COALESCE(creator.username,$tablesql.create_by),$tablesql.createTS,\n".
               "COALESCE(modifier.username,$tablesql.mod_by),$tablesql.modifyTS, UNIX_TIMESTAMP()\n".
               "FROM $tablesql\n".
               "LEFT JOIN user AS creator ON (creator.userid = $tablesql.create_by)\n".
               "LEFT JOIN user AS modifier ON (modifier.userid = $tablesql.mod_by)\n".
               "WHERE $tablesql.$pkey = $recId\n");
   my($found,$create_by,$createTS,$mod_by,$modifyTS,$now) = $dbh->fetchrow_array();
   if(! $found) {
      FKong::Fatal("Feature ". FKong::cgi::htmlQuote($feature_name) ." does not exist."); 
      return;
   }
   FKong::FKong::cgi::log_message("clock skew $feature_name ". ($modifyTS-$now)) if $modifyTS > $now;
   $FKong::cgi::keyword{'create_by'} = FKong::cgi::htmlQuote($create_by);
   $FKong::cgi::keyword{'modify_by'} = FKong::cgi::htmlQuote($mod_by);
   $FKong::cgi::keyword{'create_when'} = Date::Format::time2str($FKong::config{'TimeFormat'},$createTS); 
   $FKong::cgi::keyword{'mod_when'} = Date::Format::time2str($FKong::config{'TimeFormat'},$modifyTS); 
   $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=feature_id value=$recId>\n".
                              "<input type=hidden name=modifyTS value=$modifyTS>";  # to detect mid-air collisions
   $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql WHERE $pkey = $recId");
   my $hashref = $dbh->fetchrow_hashref();
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/$$fktable{'url'}/submit.html");  # important so the redirect doesn't trash this page.
   # format list links
   my($list,$query) = FKong::session::get_state("$tablesql-list","$tablesql-query");
   if($list) {
      my @ids = split(/,/,$list);
      my $index = find_index($recId,@ids);
      if(defined $index) {  # if current is in the list
         $FKong::cgi::keyword{'list_links'} .= "(". ($index+1) ." of ". scalar(@ids) .") &nbsp; \n";
      } else {  # else current is not in the list
         $FKong::cgi::keyword{'list_links'} .= "(not in list) &nbsp; \n";
      };
      $FKong::cgi::keyword{'list_links'} .= "<a href=\"". FKong::cgi::value_quote("$recprefix$ids[0].html") .
                                                   "\">First</a> &nbsp; \n";
      if(defined $index) {  # if current is in the list
         $FKong::cgi::keyword{'list_links'} .= "<a href=\"". FKong::cgi::value_quote("$recprefix$ids[$index-1].html") .
                                                      "\">Previous</a> &nbsp; \n";
         if($index == $#ids) {  # if current is last
            $FKong::cgi::keyword{'list_links'} .= "<a href=\"". FKong::cgi::value_quote("$recprefix$ids[0].html") .
                                                        "\">Next</a> &nbsp; \n";
         } else {  # else current is not last
            $FKong::cgi::keyword{'list_links'} .= "<a href=\"". FKong::cgi::value_quote("$recprefix$ids[$index+1].html") .
                                                        "\">Next</a> &nbsp; \n";
         };
      } else {  # else not in list
         $FKong::cgi::keyword{'list_links'} .= "Previous &nbsp; Next &nbsp; \n";
      }
      $FKong::cgi::keyword{'list_links'} .= "<a href=\"". FKong::cgi::value_quote("$recprefix$ids[-1].html") ."\">Last</a> &nbsp; \n";
      $FKong::cgi::keyword{'list_links'} .= " &nbsp; &nbsp; <a href=list.html>List</a> \n";
   } else {  # else there is no current list
      $FKong::cgi::keyword{'list_links'} .= "<font color=#888888>(no current list)</font> &nbsp; \n";
   }
   $query ||= "";  # ensure defined
   $FKong::cgi::keyword{'list_links'} .= " &nbsp; &nbsp; <a href=search.html?$query>Query</a> \n";
   $FKong::cgi::keyword{'delete'} = FKong::session::has_priv('delete_features') ? 
                             " &nbsp; ". FKong::cgi::Link("/delete.html",["id=$recId"]) ."delete</a>" : "";
   do_comment_keywords($$hashref{$pkey},$fktable);
   # Finally, show the damn thing
   show_fields("template/feature-template.html",$hashref,"",$fktable);
}


sub delete_confirm
{
   my($fktable) = @_;
   my $recprefix = $$fktable{'recprefix'};
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   FKong::session::must_have_priv("view_features");
   FKong::session::must_have_priv('delete_features');
   FKong::Fatal("Internal Error: delete has no id") if ! $FKong::cgi::form{'id'};
   FKong::Fatal("Internal Error: delete has malformed id") if $FKong::cgi::form{'id'} !~ /^\d+$/;
   $FKong::cgi::keyword{'hidden'} = qq(<input type=hidden name=id value=$FKong::cgi::form{'id'}>\n);
   my $dbh = FKong::db::SendSQL("SELECT $tablesql.$pkey\n".
                         "FROM $tablesql \n".
                         "WHERE $tablesql.$pkey = ". FKong::db::SqlQuote($FKong::cgi::form{'id'}) ." GROUP BY $tablesql.$pkey");
   my($id,$company,$owner,$contact,$num_license) = $dbh->fetchrow_array();
   FKong::Fatal("Internal Error: feature does not exist") if ! $id;
   $FKong::cgi::keyword{'featureName'} = FKong::cgi::Link("/$recprefix$id.html") ."$recprefix$id</a>";
   $FKong::cgi::keyword{'fieldRows'} = "";
   $FKong::cgi::keyword{'formurl'} = "list.html";
   FKong::cgi::print_expanded_template("template/delete_confirm-template.html");
}

$FKong::table_func{'delete.html'} = \&delete_confirm;


1;

