package FKong;

# Copyright 2003,2004 Frederick Dean

use 5.008;
use strict;
use warnings;

our $VERSION = '3.00';

use Apache2::RequestRec;
use Apache2::RequestIO;
use Apache2::RequestUtil;
use Apache2::Util qw(:all);
use Apache2::Response;
#use Apache2::File;
use APR::Pool;
use APR::Table;

use Apache2::Const -compile => qw(OK);

use FKong::cgi;
use FKong::config;
use FKong::db;
use FKong::session;
use FKong::record;
use FKong::history;
use FKong::search;
use FKong::table;
use FKong::submit;
use FKong::fktable;
use FKong::field;
use FKong::help;
use FKong::sqllog;
use FKong::pref;
use FKong::main;
use FKong::count;
use FKong::comment;
use FKong::sendmail;

use Date::Format;
use Date::Parse;

#our($debug,$htmldir,$db_host,$db_port,$db_name,$db_user,$db_pass);  # actually defined in featurekong_startup.pl

our $r;   # We need GlobalRequest, i.e. we must use the multi-process not multi-thread model.

sub log_message 
{
   FKong::db::SendSQL("INSERT INTO log SET remoteIP = ". FKong::session::remote_ip() .",\n".
                "create_by = ".  FKong::db::SqlQuote($FKong::cgi::keyword{'userid'}) .",\n". 
                "createTS = UNIX_TIMESTAMP(),\n".
                "pathfile = ". FKong::db::SqlQuote(substr($r->parsed_uri->path,length $r->location,100)) .",\n".
                "message = ". FKong::db::SqlQuote($_[0]));
}

my $num_fatalities_left;  # to prevent infinite looping

# The first arg is shown to the user.
# The second arg is logged to the database.
# Empty but defined second arg means log first arg stuff to db too.
sub Fatal
{
   my($msg,$log) = @_;
   $num_fatalities_left--;  
   goto FATALDONE if $num_fatalities_left < 0;
   goto DONE if $num_fatalities_left < 1;
   #die $_[1] if $fatalities++ > 3;  # prevent possible infinite recursive looping
   FKong::db::maybe_unlock_tables();   # Should not be needed, but just in case.
   if($FKong::r->status() == 200) {
      $FKong::r->status("500");
   };
   if($num_fatalities_left >= 2) {
      # ensure some keywords are defined so the template doesn't look so butt ugly
      $FKong::cgi::keyword{'fkroot'} ||= "./"; 
      $FKong::cgi::keyword{'tablename'} ||= $FKong::config{'DefaultTableName'} || 'Error'; 
      $FKong::cgi::keyword{'tableurl'} ||= $FKong::config{'DefaultTableUrl'} || '.'; 
      $FKong::cgi::keyword{'login_logout'} ||= ""; 
      $FKong::cgi::keyword{'tables'} ||= ""; 
      $FKong::cgi::keyword{'design_tab'} ||= "";
      $FKong::cgi::keyword{'warning'} .= "<div class=error>$msg</div>";
      FKong::cgi::print_expanded_template("template/fatal.html");
   } else {
      $FKong::r->content_type("text/html");
      $FKong::r->rflush;   # force it to send our content_type   WTF?
      $FKong::r->print("<p><font size=+2 color=red>Fatal Error</font>\n".
                "<p>$msg\n");
      if($msg =~ /open/i || $msg =~ /creat/i || $msg =~ /move/i || $msg =~ /delete/i) {
         $FKong::r->print("<p>Please check your unix file permissions.\n") 
      };
   };
   $log = $msg if defined $log && $log eq '';
   log_message($log) if $log;
   goto DONE;  #   FKong::handler()
} 


#  You would think there is a way to do this more automatically.
sub sendfile
{
   my($r,$filename) = @_;
   if(! -r $filename) {  # if the file is not readable
      $r->status(403);
      # Add spaces so MSIE shows our error message
      $r->print("<h1>403 Access Forbidden</h1>\nFile permissions problem.<br>" . (" " x 1024));
      goto DONE;
   }
   if($filename =~ /\.jpe?g$/i) {
      $r->content_type("image/jpeg");
   } elsif($filename =~ /\.gif$/i) {
      $r->content_type("image/gif");
   } elsif($filename =~ /\.bmp$/i) {
      $r->content_type("image/bmp");
   } elsif($filename =~ /\.png$/i) {
      $r->content_type("image/png");
   } elsif($filename =~ /\.html?$/i) {
      $r->content_type("text/html");
   }
   #$r->set_last_modified(fileModTime($filename));   # Apache2::File
   $r->mtime(fileModTime($filename));   # Apache2::RequestRec
   $r->headers_out->set("Last-Modified",time2str("%a, %d %b %Y %H:%M:%S %Z",$r->mtime,'GMT')); # RFC 822, updated by RFC 1123
   return if $r->header_only;
   if(! $FKong::debug || $r->content_type !~ /^text/) {
      $r->set_content_length(-s $filename) 
   }
   $r->rflush;   # force it to send our content_type   WTF?
   $r->sendfile($filename);
}

sub cleanPath {
   my($path) = @_;
   $path =~ s|//+|/|g;  # eliminate repeated slashes
   while($path =~ s|/[^/]+/\.\./|/|g) {};  # eliminate parent dir references /../
   while($path =~ s|/\./|/|g) {};  # eliminate self dir references /./
   while($path =~ s|^\./||g) {};  # eliminate self dir references /./
   while($path =~ s|/\.$||g) {};  # eliminate self dir references /./
   #$path =~ s|./$||g;  # eliminate trailing slash
   return $path;
}

sub design_tab
{
   return '' if ! FKong::session::has_priv('view_fields');
   return "<li>". FKong::cgi::Link("/$FKong::cgi::keyword{'tableurl'}/field/list.html") ."Design</a></li>"; 
}

our $tables_keyword_mtime = 0;
our @tables_cache;  # ordered list of [tablename, tableurl]

# This is the tabs at the very top of the page. 
sub tables_keyword
{
   my($keyword,$remain,$admin_tab_flag) = @_;
   $remain ||= 'list.html';
   my $qh = FKong::db::SendSQL("SELECT modifyTS FROM fktable ORDER BY modifyTS DESC LIMIT 1");
   my($mtime) = $qh->fetchrow_array();
   if($mtime != $tables_keyword_mtime) {  # if fktable has changed
      $tables_keyword_mtime = $mtime;
      @tables_cache = ();
      my $qh = FKong::db::SendSQL("SELECT name, url FROM fktable WHERE advertise ORDER BY name");
      while(my($name,$url) = $qh->fetchrow_array()) {  # for every table to show
         push(@tables_cache, [$name, $url]);
      };
   };
   my $found_flag = $admin_tab_flag;
   my @links;
   foreach my $ref (@tables_cache) {
      my($name,$url) = @$ref;
      if($url eq $FKong::cgi::keyword{'tableurl'} && ! $admin_tab_flag) {
         push @links, "<span>". FKong::cgi::htmlQuote($name) ."</span>";
         $found_flag = 1;
      } else {
         push @links, FKong::cgi::Link("/$url/$remain") . FKong::cgi::htmlQuote($name) ."</a>";
      };
   }
   if($FKong::cgi::keyword{'privs'} & ~0x1800) { 
      if($admin_tab_flag) {
          push(@links, "<span>Admin</span>");
      } else {
          push(@links,FKong::cgi::Link("/admin.html") ."Admin</a>");
      }
   };
   if(! $found_flag) { 
      push @links, "<span>". FKong::cgi::htmlQuote($FKong::cgi::keyword{'tablename'}) ."</span>";
   }
   my $tables_keyword = ''; # default assume there is only one non-internal table (show nothing)
   if(scalar(@links) > 1) {  # if there is more than one table to show 
      $tables_keyword .= qq{<div id="header"><ul>\n}; # default assume there is only one non-internal table (show nothing)
      $tables_keyword .= join('', map(" <li>$_</li>\n", @links));
      $tables_keyword .= qq{</ul></div\n}; # default assume there is only one non-internal table (show nothing)
   }
   return $tables_keyword;
}

sub redirect_with_trailing_slash
{
   my $query = $r->parsed_uri->query;
   $r->headers_out->set(Location => $r->parsed_uri->path . ($query ? "/?$query" : "/"));
   $r->status(302); #  Apache2::Const::REDIRECT
}

sub fileModTime { return (stat $_[0])[9] };

#  This is where we register all our internal pages.
our %url_func;  # The hash key is a URL
our %table_func;  #  The hash key is a HTML filename, found after a table url.  i.e.  /tableurl/filename.html

$url_func{'admin.html'} = sub { $FKong::cgi::keyword{'tables'} = tables_keyword(0,0,1);  # show admin tab
                                FKong::cgi::print_expanded_template("template/admin.html"); };
$url_func{'dir_list.html'} = \&show_dir_listing;
$table_func{'dir_list.html'} = \&show_dir_listing;
$table_func{'fatal.html'} = sub { Fatal("This is what a fatal error looks like.") };


sub show_dir_listing {
   FKong::session::must_have_priv('view_other');
   $r->content_type("text/html");
   $r->rflush;   # force it to send our content_type   WTF?
   $r->print("<table width=600><tr valign=top><td width=40%>\n");
   $r->print("<h2>\%url_func</h2>\n");
   foreach (sort keys %url_func) { $r->print("<li>". FKong::cgi::Link("/$_") . FKong::cgi::htmlQuote($_) ."</a><br>\n"); };
   $r->print("</td><td>\n");
   $r->print("<h2>\%table_func</h2>\n");
   foreach (sort keys %table_func) { $r->print("<li>". FKong::cgi::Link("/$FKong::cgi::keyword{'tableurl'}/$_") . FKong::cgi::htmlQuote($_) ."</a><br>\n"); };
   $r->print("</td><td>\n");
   $r->print("<h2>Tables</h2>\n");
   my $dbh = FKong::db::SendSQL("SELECT url FROM fktable ORDER BY sort, url");
   while(my @row = $dbh->fetchrow_array()) {
      my($url) = @row;
      $r->print("<li>". FKong::cgi::Link("/$url/dir_list.html") . "$url</a>\n");
   };
   $r->print("</td></tr></table>\n");
}

$url_func{'index.html'} = \&show_root_page;
$url_func{''} = $url_func{'index.html'};

sub show_root_page {
   $FKong::cgi::keyword{'stuff'} = '';
   $FKong::cgi::keyword{'stuff'} .= "<h2>Tables:</h2>\n";
   $FKong::cgi::keyword{'stuff'} .= "<ul>\n";
   my $dbh = FKong::db::SendSQL("SELECT url, name FROM fktable WHERE advertise ORDER BY sort, name");
   while(my @row = $dbh->fetchrow_array()) {
      my($url,$name) = @row;
      $FKong::cgi::keyword{'stuff'} .= "<li>". FKong::cgi::htmlQuote($name) ." : &nbsp;\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/new.html") . "New</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/search.html") . "Search</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/list.html") . "List</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/count_form.html") . "Count</a> |\n";
      $FKong::cgi::keyword{'stuff'} .= FKong::cgi::Link("/$url/") . "News</a>\n";
      $FKong::cgi::keyword{'stuff'} .= "<br>\n";
   };
   $FKong::cgi::keyword{'stuff'} .= "</ul>\n";
   FKong::cgi::print_expanded_template("template/root.html");
}

sub handler {
   $r = shift;

   $num_fatalities_left = 3;  # to prevent infinite looping
   $FKong::debug = 0 if $FKong::debug eq "session";  # reset the debug flag 
   FKong::db::maybe_unlock_tables();   # Should not be needed, but just in case.
   FKong::cgi::Done($r);
   FKong::db::Done($r);
   FKong::table::Done($r);
   FKong::session::Done($r);
   $r->content_type('text/html'); # default
   my $pathfile = substr($r->parsed_uri->path,length $r->location);
   #my $pathfile = $r->path_info;  # strangely dependent on whether certain directories in the path exist!
   print STDERR "------------- featurekong pathfile=$pathfile\n" if $FKong::debug;
   if($pathfile eq "") {  # if we need to redirect with a trailing slash
      redirect_with_trailing_slash();  
      goto DONE;
   }
   $FKong::cgi::keyword{'warning'} = "";
   $FKong::cgi::keyword{'version'} = "3.1";
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("");
   $FKong::cgi::keyword{'go_to_feature'} = FKong::cgi::value_quote($FKong::cgi::form{'go_to_feature'} || "");
   $FKong::cgi::keyword{'text'} = FKong::cgi::value_quote($FKong::cgi::form{'text'} || "");
   $FKong::cgi::keyword{'search_comments'} = FKong::cgi::value_quote($FKong::cgi::form{'search_comments'} || "");
   $FKong::cgi::keyword{'referer'} = FKong::cgi::value_quote($r->headers_in->get('Referer'));
   FKong::config::maybe_load_config();
   $FKong::cgi::keyword{"nowtime"} = Date::Format::time2str($FKong::config{'TimeFormat'},time()); 
   $FKong::cgi::keyword{'tablename'} = $FKong::config{'DefaultTableName'}; 
   $FKong::cgi::keyword{'tableurl'} = $FKong::config{'DefaultTableUrl'}; 
   $pathfile = "/$pathfile" if $pathfile !~ /^\//;  # pre-pend a slash if not present
   $pathfile = cleanPath($pathfile);
   # if the path after simplification begins with a .. element, then it is illegal
   if($pathfile =~ /^\/?\.\.\// || $pathfile eq "/..") {
      $r->status(400);
      Fatal("400 illegal path. The path you request is illegal because it has too many parent references (..)");
   }
   if($pathfile !~ /^([\w\-+=:'`!\@^~\., \/]*)$/) {  # if not all allowable characters
      $r->status(403);
      Fatal("403 Forbidden. Your path contains forbidden characters.");
   }
   $pathfile = $1;  # untaint
   $pathfile =~ /(.*\/)(.*)/s or Fatal("500","internal error 2"); # separate with last slash
   my($path,$filename) = ($1,$2);  # $path always has a leading and trailing slash.  $filename never has a slash.
   ($FKong::cgi::keyword{'fkroot'} = substr($path,1)) =~ s/[^\/]+/../gs;  # replace every token with ".." and remove leading slash
   $FKong::cgi::keyword{'login_logout'} = "<a href=\"$FKong::cgi::keyword{'fkroot'}login.html\">Login</a>";
   $FKong::cgi::keyword{'design_tab'} = \&design_tab;
   $FKong::cgi::keyword{'tables'} = \&tables_keyword;

   FKong::cgi::MakeFormHash($r,10000,10,10000000);
   FKong::cgi::MakeCookieHash($r);
   FKong::session::Check();

   if($FKong::cgi::keyword{"userid"} > 99) {
      $FKong::cgi::keyword{'login_logout'} = "<a href=\"$FKong::cgi::keyword{'fkroot'}index.html?logout=1\">Logout (". 
                                             FKong::cgi::htmlQuote($FKong::cgi::keyword{'username'}) .")</a>";
   }
   if(my $warning = FKong::session::get_state('warning')) {  # check for status from submit redirect page
      $FKong::cgi::keyword{'warning'} = $warning;
      FKong::session::delete_state('warning');
   };

   if(my $func = $url_func{lc(substr($pathfile,1))}) {
      if(substr($pathfile,1) =~ /\//) {  # if page has a subdir
         $FKong::cgi::keyword{'tables'} = tables_keyword(1);  # show admin tab
      }
      &$func();
      goto DONE;
   } elsif($pathfile =~ /\/user\/~(\d+?)(?:.html?)?$/) {
      $FKong::cgi::form{'userid'} = $1;
      FKong::user::edit_user();
      goto DONE;
   } elsif($pathfile =~ /\/user\/~(.+?)(?:.html?)?$/) {
      my $dbh = FKong::db::SendSQL("SELECT userid FROM user WHERE username = ". FKong::db::SqlQuote($1)); 
      if(my($userid) = $dbh->fetchrow_array()) {
         $FKong::cgi::form{'userid'} = $userid;
         FKong::user::edit_user();
         goto DONE;
      }
   };
   my $fktable;
   if($pathfile =~ /^\/(\D+)(\d+)(?:.html?)?$/i) {   # if it looks like a record
      my($recprefix,$recnum) = ($1,$2);
      $fktable = FKong::fktable::New("recprefix = ". FKong::db::SqlQuote($recprefix)); 
      if($fktable) {
         FKong::record::show_edit_form($recnum,$fktable);
         goto DONE;
      };
   } 

   # Check for table url
   if($path eq "/") {   
      (my $filebasename = $filename) =~ s/\.\w+$//;
      my $dbh = FKong::db::SendSQL("SELECT name, tablesql FROM fktable WHERE url = ". FKong::db::SqlQuote($filebasename)); 
      if(my @row = $dbh->fetchrow_array()) {
         redirect_with_trailing_slash();  # this makes the relative paths in the derived pages consistent, and thus easier
         goto DONE;
      };
   } else {  # else it did not need a trailing slash
      my(undef,$firstdir,$remain) = split("/",$pathfile,3);
      $fktable = FKong::fktable::New("url = ". FKong::db::SqlQuote($firstdir)); 
      if($fktable) {
         if($table_func{$remain}) {
            $FKong::cgi::keyword{'tables'} = tables_keyword(0,$remain);
            &{$table_func{$remain}}($fktable);
            goto DONE;
         };
         if($remain =~ /^(\D+)(\d+)(?:.html?)?$/i && $1 eq $$fktable{'recprefix'}) {   # if it looks like our record
            FKong::record::show_edit_form($2,$fktable);
            goto DONE;
         };
      };
   }

   # check for some illegal paths
   if($path =~ /\/CVS\//) {  # if has /CVS/ in name
      $r->status(403);
      Fatal("403 forbidden because CVS.");
   }
   if($filename =~ /~$/ ||            # if filename ends with ~
      $filename =~ /^#/ ||            # if filename begins with #
      $filename =~ /^\./ ) {          # or begins with a dot
      $r->status(403);
      Fatal("403 Access forbidden.  Bad filename.");
   }

   my $diskfile = "$FKong::htmldir/$pathfile";
   if(! -e $diskfile) {  # if the file does not exist
      $r->status(404);
      Fatal("404 File Not found.");
   } elsif(! -r $diskfile) {  # if the file is not readable
      $r->status(403);
      Fatal("403 Access forbidden.  File permissions.");
   } else {   # send raw file
      sendfile($r,$diskfile);
      goto DONE;
   }

DONE:
   FKong::db::maybe_unlock_tables();   # Should not be needed, but just in case.
   FKong::cgi::debug_prints($r,$fktable) if $r->content_type =~ m/^text\//i;
   FKong::cgi::Done($r);
   FKong::db::Done($r);
   FKong::table::Done($r);
   FKong::session::Done($r);
FATALDONE:
   $r = undef;
   return Apache2::Const::OK;
}


1;
__END__

