
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::fktable;

my %extra_privs = ('user' => 'view_users', session => 'view_users');

sub New
{
   my($where) = @_;
   my $dbh = FKong::db::SendSQL("SELECT * FROM fktable WHERE $where"); 
   my $fktable = $dbh->fetchrow_hashref();
   if(! defined $fktable) {
      return undef;
   }
   $FKong::cgi::keyword{'tablename'} = $$fktable{'name'};
   $FKong::cgi::keyword{'tableurl'} = FKong::cgi::Uri($$fktable{'url'});
   $FKong::cgi::keyword{'tablesql'} = FKong::cgi::Uri($$fktable{'tablesql'});
   if(length $$fktable{'down_maint'} && ! FKong::session::has_priv('edit_fields')) {
      $FKong::cgi::keyword{'down_maint'} = $$fktable{'down_maint'};
      FKong::cgi::print_expanded_template("template/down_maint.html");
      goto DONE;
   } elsif(length $$fktable{'down_maint'}) {
      $FKong::cgi::keyword{'warning'} .= "<div class=warn>This table \"$$fktable{'name'}\" is ". 
                     FKong::cgi::Link("/fktable/fkt$$fktable{'fktableId'}.html") .  
                     "down for maintenance</a>.  Only designers like you can see it.<br>\n".
                     "Remove the Down Maint text to make it usable by others.</div>\n";
   }
   my $extra = $extra_privs{$$fktable{'tablesql'}};
   FKong::session::must_have_priv($extra) if $extra;
   return bless $fktable;
} 

=unused
$FKong::table_func{'drop.html'} = \&confirm_drop_table;

sub confirm_drop_table
{
   my($fktable) = @_;  
#   FKong::session::must_have_priv("delete_features");
   #$FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/$$fktable{'url'}/field/list.html");
   $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("/fktable/list.html");
   $FKong::cgi::keyword{'hidden'} = qq(<input type=hidden name=tablesql value=\"". FKong::cgi::value_quote($FKong::cgi::form{'sql'}) ."\">\n);
   FKong::cgi::print_expanded_template("template/drop_confirm.html");
}
=cut

sub print_debug
{
   my($fktable) = @_;
   $FKong::r->print("<hr><tt><font size=+1>\$\$fktable{'<font color=blue>blue</font>'}</font></tt><br>\n<table>\n");
   my $rownum;
   for my $key (sort keys %$fktable) {
      my $color = ($rownum++ & 1) ? '#eeeeee' : '#dddddd';
      $FKong::r->print("<tr bgcolor=\"$color\"><td align=right><font color=navy>$key</font></td><td>". FKong::cgi::htmlQuote($$fktable{$key}) ."</td></tr>\n");
   }
   $FKong::r->print("</table>\n");
}

sub TableExists ($)
{
   my ($table) = @_;
   my($db,$tbl) = split(/\./,$table,2);
   my $sth;
   if($tbl) {
      $sth = FKong::db::SendSQL("SHOW TABLES FROM $db LIKE ". FKong::db::SqlQuote($tbl));
   } else {
      $sth = FKong::db::SendSQL("SHOW TABLES LIKE ". FKong::db::SqlQuote($table));
   }
   while ( my($dbtable) = $sth->fetchrow_array ) {
      return 1 if ($dbtable eq ($tbl || $table));
   }
   return 0;
}

sub ensure_column_exists
{
   my($tablesql, $fieldsql, $initial) = @_;

   my $dbh = FKong::db::SendSQL("DESCRIBE $tablesql $fieldsql");
   my($field, $dbtype, $null, $key, $default, $extra) = $dbh->fetchrow_array();
   if(! $dbtype) {
       FKong::db::SendSQL("ALTER TABLE $tablesql ADD COLUMN $fieldsql int unsigned");
       FKong::db::SendSQL("UPDATE $tablesql SET $fieldsql = $initial");
   }
}

sub auto_field_def
{
   my($tablesql) = @_;

   my $dbh = FKong::db::SendSQL("SHOW FIELDS FROM $tablesql");
   my $pkey = 'foo';
   my $order = 200;
   while(my($field,$type,$null,$key,$default,$extra) = $dbh->fetchrow_array()) {
       my $sql;
       $pkey = $field if $key =~ /PRI/i;
       my @choices;  # used for multiple choice
       if($type =~ /^enum\('(.*)'\)$/i) {
           $sql = "type = 'mult_choice',\n";
           @choices = split(/','/,$1);
       } elsif($type =~ /^tinyint\(1\)/i || $type =~ /^bool/i || $type =~ /^bit/i) {
           $sql = "type = 'bool',\n";
       } elsif($type =~ /^float/i || $type =~ /^double/i || $type =~ /^real/i || $type =~ /^dec/i) {
           $sql = "type = 'float',\n";
       } elsif($type =~ /^int/i) {
           $sql = "type = 'integer',\n";
       } else {
           $sql = "type = 'oneline',\n";
       }
       my $fixed_sql = ($field =~ /^_/) ? "0" : "1";
       (my $fieldName = $field) =~ s/^_(.)/$1/;  # delete leading underscore if present
       my $dbh2 = FKong::db::SendSQL("INSERT INTO field_def SET\n".
                                     "tablesql = ". FKong::db::SqlQuote($tablesql) .",\n".
                                     "sqlName = ". FKong::db::SqlQuote($field) .",\n".
                                     "fieldName = ". FKong::db::SqlQuote($fieldName) .",\n".
                                     $sql .
                                     "sort = $order,\n".
                                     "fixed_sql = 0,\n".
                                     "list_show = 1\n");
       my $fieldId = FKong::db::last_insert_id();
       foreach my $choice (@choices) {
          FKong::db::SendSQL("INSERT INTO choice SET fieldId = $fieldId, choice = ". FKong::db::SqlQuote($choice));
       };
       $order += 10;
   }
   ensure_column_exists($tablesql, "createTS", "UNIX_TIMESTAMP()");
   ensure_column_exists($tablesql, "modifyTS", "UNIX_TIMESTAMP()");
   ensure_column_exists($tablesql, "create_by", $FKong::cgi::keyword{'userid'});
   ensure_column_exists($tablesql, "mod_by", $FKong::cgi::keyword{'userid'});
   return $pkey;
}

$FKong::url_func{'fktable/new.html'} = \&show_create_table;

sub show_create_table
{
   FKong::session::must_have_priv("edit_features");
   FKong::fktable::New("url = 'fktable'");
   FKong::cgi::trim(my $tablesql = $FKong::cgi::keyword{'tablesql'} = $FKong::cgi::form{'tablesql'} || '');
   FKong::cgi::trim(my $url = $FKong::cgi::keyword{'url'} = $FKong::cgi::form{'url'} || '');
   FKong::cgi::trim(my $recprefix = $FKong::cgi::keyword{'recprefix'} = $FKong::cgi::form{'recprefix'} || '');
   FKong::cgi::trim(my $name = $FKong::cgi::keyword{'name'} = $FKong::cgi::form{'name'} || '');
   FKong::cgi::trim(my $sort_ = $FKong::cgi::keyword{'sort'} = $FKong::cgi::form{'sort'} || '1000');
   my $changes = $FKong::cgi::form{'changes'};
   $changes = 1 if ! defined $changes;
   $changes = $FKong::cgi::keyword{'changes'} = $changes ? "CHECKED" : "";
   my $comments = $FKong::cgi::form{'comments'};
   $comments = 1 if ! defined $comments;
   $comments = $FKong::cgi::keyword{'comments'} = $comments ? "CHECKED" : "";
   my $advertise = $FKong::cgi::form{'advertise'};
   $advertise = 1 if ! defined $advertise;
   $advertise = $FKong::cgi::keyword{'advertise'} = $advertise ? "CHECKED" : "";
   if($FKong::cgi::form{'cancel'}) {
     FKong::cgi::redirect(FKong::cgi::Uri("/"));
   } elsif($FKong::cgi::form{'update'}) {
     if(! $tablesql) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table SQL is required</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     if($tablesql !~ /^[\w\.]+$/) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Illegal character in Table SQL</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     (my $pkey = "${tablesql}Id") =~ s/.*\.//;  # delete database prefix
     if(! $url) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table URL is required</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     if(! $name) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table Name is required</div>\n";
        FKong::cgi::print_expanded_template("template/create-table.html"); 
        return;
     }
     my $userid = $FKong::cgi::keyword{'userid'};
     my $changeid = $changes ? "changeId int(10) unsigned NOT NULL default '0',\n" : '';
     my $page = 'type';
     if(TableExists($tablesql)) {
        $FKong::cgi::keyword{'warning'} .= "<div class=warn>Table $tablesql already exists. Field definitions imported.</div>\n";
        $pkey = auto_field_def($tablesql);
        $page = 'list';
     } else {
         FKong::db::SendSQL("CREATE TABLE `$tablesql` (\n".
                        "$pkey int(10) unsigned NOT NULL auto_increment primary key,\n".
                        "create_by int(10) unsigned default NULL,\n".
                        "createTS int(10) unsigned default NULL,\n".
                        "mod_by mediumint(8) unsigned default NULL,\n".
                        "modifyTS int(10) unsigned NOT NULL default '0',\n".
                        $changeid .
                        "KEY `modifyTS` (`modifyTS`)\n".
                        ")");
        $FKong::cgi::keyword{'warning'} .= "<div class=warn>Table $tablesql created.  Please create a field...</div>\n";
     };
     if(TableExists($tablesql ."_changes")) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table ${tablesql}_changes already exists.</div>\n";
     } else {
         FKong::db::SendSQL("CREATE TABLE `${tablesql}_change` (\n".
                        "changeId int(10) unsigned NOT NULL auto_increment primary key,\n".
                        "$pkey int unsigned not null,\n".
                        "create_by int(10) unsigned default NULL,\n".
                        "createTS int(10) unsigned default NULL,\n".
                        "fieldId mediumint(8) unsigned NOT NULL default '0',\n".
                        "old_val text,\n".
                        "index($pkey,createTS),\n".
                        "index($pkey,changeId),\n".
                        "index(create_by,createTS),\n".
                        "index(fieldId,createTS)\n".
                        ")") if $FKong::cgi::form{'changes'};
     }
     if(TableExists($tablesql ."_comments")) {
        $FKong::cgi::keyword{'warning'} .= "<div class=error>Table ${tablesql}_comments already exists.</div>\n";
     } else {
        FKong::db::SendSQL("CREATE TABLE `${tablesql}_comment` (\n".
                        "commentId int(10) unsigned NOT NULL auto_increment primary key,\n".
                        "$pkey int unsigned not null,\n".
                        "create_by int(10) unsigned default NULL,\n".
                        "createTS int(10) unsigned default NULL,\n".
                        "mod_by mediumint(8) unsigned default NULL,\n".
                        "modifyTS int(10) unsigned NOT NULL default '0',\n".
                        "format enum('text','html') default NULL,\n".
                        "subject text,\n".
                        "body text,\n".
                        $changeid .
                        "index($pkey,createTS),\n".
                        ($changeid ? "index($pkey,changeId),\n" : '') .
                        "index(create_by,createTS),\n".
                        "fulltext(subject,body)\n".
                        ")") if $FKong::cgi::form{'comments'};
     }
     FKong::db::SendSQL("INSERT INTO field_def (fieldName, tablesql, sqlName, type, sort) VALUES\n". 
                        "('Creator',          '$tablesql', 'create_by', 'user',    10040),\n".
                        "('Create Time',      '$tablesql', 'createTS',  'unix_ts', 10042),\n".
                        "('Last Modifier',    '$tablesql', 'mod_by',    'user',    10044),\n".
                        "('Last Modify Time', '$tablesql', 'modifyTS',  'unix_ts', 10046)");
     FKong::db::SendSQL("UPDATE field_def SET on_new_form = 0, create_by = $userid, mod_by = $userid,\n".
                        "modifyTS = UNIX_TIMESTAMP(), createTS = UNIX_TIMESTAMP(), read_only = 1, fixed_sql = 1,\n".
                        "on_new_form = 0\n".
                        "WHERE tablesql = ". FKong::db::SqlQuote($tablesql) ."\n".
                        "AND fieldName NOT LIKE '\\_%'");
     FKong::db::SendSQL("INSERT INTO fktable SET \n".
                        "tablesql =  ". FKong::db::SqlQuote($tablesql) .",\n".
                        "name =      ". FKong::db::SqlQuote($name) .",\n".
                        "recprefix = ". FKong::db::SqlQuote($recprefix) .",\n".
                        "url =       ". FKong::db::SqlQuote($url) .",\n".
                        "pkey =      ". FKong::db::SqlQuote($pkey) .",\n".
                        "changes =   ". FKong::db::SqlQuote(! ! $FKong::cgi::form{'changes'}) .",\n".
                        "comments =  ". FKong::db::SqlQuote(! ! $FKong::cgi::form{'comments'}) .",\n".
                        "advertise = ". FKong::db::SqlQuote(! ! $FKong::cgi::form{'advertise'}) .",\n".
                        "sort =      ". FKong::db::SqlQuote($sort_) .",\n".
                        #"down_maint =". FKong::db::SqlQuote("The $name table is still being designed.") .",\n".
                        "create_by = $userid, mod_by = $userid,\n".
                        "createTS = UNIX_TIMESTAMP(), modifyTS = UNIX_TIMESTAMP()");
     FKong::cgi::redirect(FKong::cgi::Uri("/". FKong::cgi::urlQuote($url) ."/field/$page.html"));
   };  # end of create a new table
=alternative
   my $fktable = New("tablesql = 'fktable'");
   $fktable->{'internal'} = 0;   # so they can access the new form
   FKong::record::show_new_form($fktable); 
=cut
   FKong::cgi::print_expanded_template("template/create-table.html"); 
}


1;

