
# Copyright 2003,2004 Frederick Dean

use strict;

use FKong::db;
use FKong::cgi;

package FKong::help;


$FKong::table_func{'help.html'} = \&show_long_help;

sub show_long_help
{
   my($fktable) = @_;  
   
   FKong::session::must_have_priv("view_features");
   $FKong::cgi::keyword{'help'} = "";
   my $dbh = FKong::db::SendSQL("SELECT fieldName, long_help, short_help, fieldId FROM field_def\n".
                                "WHERE tablesql = ". FKong::db::SqlQuote($$fktable{'tablesql'}) ." ORDER BY sort");
   $FKong::cgi::keyword{'help_stuff'} = '';
   while(my @row = $dbh->fetchrow_array()) {
      my($fieldName,$long_help,$short_help,$fieldId) = @row;
      $FKong::cgi::keyword{'fieldName'} = $fieldName;
      $FKong::cgi::keyword{'long_help'} = $long_help;
      $FKong::cgi::keyword{'short_help'} = $short_help;
      $FKong::cgi::keyword{'help'} = length($long_help) ?  $FKong::cgi::keyword{'long_help'} : $FKong::cgi::keyword{'short_help'};
      $FKong::cgi::keyword{'edit'} = $FKong::cgi::form{'edit'} ? 
               "<a href=\"$FKong::cgi::keyword{'fkroot'}$$fktable{'url'}/field/edit.html?fieldId=$fieldId#help\">".
               "<font color=\"#669966\" size=-1>E</font></a> " : "";
      $FKong::cgi::keyword{'help_stuff'} .= FKong::cgi::return_expanded_template("template/help_entry.html");
   }
   $FKong::cgi::keyword{'edit_links'} = FKong::session::has_priv('view_fields') ? 
            FKong::cgi::Link("",["edit=". ! $FKong::cgi::form{'edit'}]) ."Field Edit Links</a> | " : "";
   FKong::cgi::print_expanded_template("template/help.html");
}

1;  # return code

