
# Copyright 2003,2004 Frederick Dean

use strict;

package FKong::pref;

sub prefs_keywords
{
   $FKong::cgi::keyword{'toggle_debug'} = FKong::session::has_priv('view_other') ? 
            " | ". FKong::cgi::Link("",["toggle_debug=1"]) ."Toggle Debug</a>" : "";
}

sub change_password
{
   if(! FKong::session::isPasswordValid($FKong::cgi::keyword{'username'},$FKong::cgi::form{'old_password'})) {
      FKong::Fatal("Your old password was incorrect.");
   }
   my $problems = FKong::user::ugly_passwd_problems($FKong::cgi::form{'new_password'},$FKong::cgi::form{'new_password2'});
   FKong::Fatal($problems) if $problems;
   FKong::user::set_user($FKong::cgi::keyword{'userid'},undef,$FKong::cgi::form{'new_password'});
   $FKong::cgi::keyword{'warning'} .= "<div class=warn>Your password change succeeded.</div>";
   FKong::cgi::redirect(FKong::cgi::Uri("/"));
}

$FKong::url_func{'thanks2.html'} = \&Thanks2;

sub Thanks2
{
   if($FKong::cgi::form{'new_password'}) {
      change_password();
      return;
   }
   FKong::Fatal("Sorry, I didn't see what you changed.");
}

$FKong::url_func{'password.html'} = \&password_form;

sub password_form
{
   $FKong::cgi::keyword{'hidden'} = "";
   prefs_keywords();
   FKong::cgi::print_expanded_template("template/password-template.html"); 
}

$FKong::url_func{'email.html'} = \&email_form;

sub email_form 
{
   my($recprefix,$name,$url,$tablesql) = @_;

   FKong::session::require_login();
   prefs_keywords();
   if(! $FKong::config{'SendUpdateEmails'} && $FKong::cgi::keyword{'warning'} !~ /sending of emails about updates/) {
      $FKong::cgi::keyword{'warning'} .= "<div class=warn>Warning: Your administrator has disabled the sending of emails about updates.<br></div>\n"; 
   }
   if($FKong::cgi::form{'cancel'}) {
      FKong::cgi::redirect(FKong::cgi::Uri("/"));
   } elsif($FKong::cgi::form{'commit'}) {
      my @ids;
      foreach my $name (%FKong::cgi::form) {
         next unless $name =~ /field_(\d+)/;
         next if $FKong::cgi::form{$name};
         push(@ids,$1);
      };
      FKong::db::SendSQL("UPDATE user SET email_pref = ". FKong::db::SqlQuote(join(",",@ids)) ." WHERE userid = $FKong::cgi::keyword{'userid'}");
      $FKong::cgi::keyword{"warning"} .= "<div class=warn>Email preferences updated.</div>\n";
      FKong::cgi::redirect(FKong::cgi::Uri("/"));
   } else {
      my $dbh = FKong::db::SendSQL("SELECT email_pref FROM user WHERE userid = $FKong::cgi::keyword{'userid'}");
      my($pref_string) = $dbh->fetchrow_array() || '';
      my %pref_hash;
      map { $pref_hash{$_} = 1 } split(/[^\d]/,$pref_string);  # separate by non-numbers

      my $form = '';
      $dbh = FKong::db::SendSQL("SELECT fieldName, fktable.name, fktable.tablesql, fieldId\n".
                                "FROM field_def\n".
                                "INNER JOIN fktable ON (field_def.tablesql = fktable.tablesql)\n".
                                "WHERE field_def.type IN ('user','multiuser') AND ! fktable.internal\n".
                                "ORDER BY fktable.name, fieldName");
      while(my($field_name,$table_name,$tablesql,$field_id) = $dbh->fetchrow_array()) {
         $form .= "<tr><td>". FKong::cgi::htmlQuote("$table_name $field_name") ."</td>\n".
                  "<td><input name=field_$field_id type=radio value=1". ($pref_hash{$field_id}?'':" CHECKED") ."> yes \n".
                  " &nbsp;  &nbsp; &nbsp; ".
                  "<input name=field_$field_id type=radio value=0". ($pref_hash{$field_id}?" CHECKED":'') ."> no </td></tr>\n";
      };
      $FKong::cgi::keyword{'email_form'} = $form;
      FKong::cgi::print_expanded_template("template/email.html");
   };
}

1;
