
#  Copyright 2003,2004 Frederick Dean

use strict;

package FKong::submit;

# Modify a feature


sub find_index
{
   my $pattern = shift;
   my $index = 0;
   foreach (@_) { return $index if $_ eq $pattern; $index++ }
   return undef;
}

sub check_list_and_redirect
{
   my($recId,$fktable) = @_;
   # if to show next and list exists
   if($FKong::cgi::form{'ok_show_next'} and my($list) = FKong::session::get_state($$fktable{'tablesql'} ."-list")) {  
      my @ids = split(/,/,$list);
      my $index = find_index($recId,@ids);
      if(defined $index && $index < $#ids) {  # if found in list and is not last.
         FKong::cgi::redirect($$fktable{'recprefix'}. $ids[$index+1] .".html");
      } else {
         FKong::cgi::redirect("list.html");   
      };
   } else {
      FKong::cgi::redirect("list.html");   
   };
}

# The client enters a slang for a user.  The slang can be username, realname, or email of an actual users.
# Here we determine the userid for that user, or present some error text.
# identify_user() returns a list of (userid,error_message).
sub identify_user
{
   my($slang,$fieldName,$cacheref) = @_;
   $slang =~ s/\s+$//; # remove trailing white space
   $slang =~ s/^\s+//; # remove leading white space
   $slang =~ s/\s+/ /; # condense duplicate white space
   return $1 if $slang =~ /^(\d+)$/;  # if all numeric
   return undef if ! defined $slang || $slang eq '';
   return $$cacheref{$slang} if exists $$cacheref{$slang}; # if we found the userid translation in the cache
   my $dbh = FKong::db::SendSQL("SELECT userid FROM user WHERE username = ". FKong::db::SqlQuote($slang) ."\n".
               "OR email = ". FKong::db::SqlQuote($slang) ." OR realname = ". FKong::db::SqlQuote($slang) ." LIMIT 1"); 
   my $userid = $dbh->fetchrow_array();
   if(! $userid) {  # if userid not found in database
      if($slang =~ /^\s*\d+\s*$/) { # if just numeric
         $userid = int($slang);
      } else {
         return ("","$fieldName user ". FKong::cgi::htmlQuote($slang) ." not found.<br>\n");
      };
   }
   $$cacheref{$slang} = $userid;
   return $userid;
}

sub money_to_int
{
   my($value) = @_;
   return undef if $value !~ /\d/;  # if no digits
   # The pattern allows a leading or trailing dollar sign.
   # The pattern allows a comma or a decimal, but only one.
   return undef if $value !~ /^\$?\s*([+\-]?\d*)[\.,]?(\d*?)0*\s*\$?$/;  # ugh
   my $decimal = $2 || '';
   return undef if length $decimal > $FKong::config{'MoneyDecimalPlaces'};  # if too man decimal digits
   $decimal .= "0" x ($FKong::config{'MoneyDecimalPlaces'} - length $decimal);  # append zeros
   return int("$1$decimal");   # essentially strip leading zeros
}

sub LockTablesForSubmit
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $locksql = "LOCK TABLE $tablesql WRITE, field_def READ, user READ";
   $locksql .= ", ${tablesql}_change WRITE" if $$fktable{'changes'};
   $locksql .= ", ${tablesql}_comment WRITE" if $$fktable{'comments'};
   (my $escaped_tablesql = $tablesql) =~ s/(\W)/\\$1/g;  # escape for a regex pattern match
   $locksql =~ s/, $escaped_tablesql READ//;  # remove duplicates
   FKong::db::SendSQL($locksql);
}

# Here we add another line to the keyword used in emailed updated notification.
sub field_info_line_for_email
{
   my($name,$type,$old,$new,$uc) = @_;
   $FKong::cgi::keyword{'info_for_email'} .= "** means changed\n" if 0 == length $FKong::cgi::keyword{'info_for_email'};
   $old = '' if ! defined $old;
   $new = '' if ! defined $new;
   my $changed = ($old eq $new) ? '  ' : '**';
   $new = &{$FKong::record::type_func{$type}}($new,$uc) if $FKong::record::type_func{$type};
   $old = &{$FKong::record::type_func{$type}}($old,$uc) if $FKong::record::type_func{$type};
   return if $new =~ '\n' || $old =~ '\n';  # don't process fields with newlines
   if($old ne $new && length $old < 24 && length $new < 24 && $type ne 'bool') {  # if both new and old are short
      $new = "$new (was $old)";  # mention the old value
   };
   $name = FKong::cgi::urlUnquote($name);
   $FKong::cgi::keyword{'info_for_email'} .= sprintf("$changed%20.20s: %-56.56s\n",$name,$new);
}

sub hex_to_int { 
   return hex($_[0]) if $_[0] =~ /^(?:0x)?[a-f0-9]+$/i;
   return undef;
}

sub integer_to_int { 
   return hex($_[0]) if $_[0] =~ /^0x[a-f0-9]/i;  # if begins with 0x
   return $_[0] if $_[0] =~ /^[\-+]?\d+$/i;
   return undef;
}

sub float_check { 
   return $_[0] if $_[0] =~ /^[\-+]?\d*\.?\d+(?:e[\-+]?\d+)?$/i;
   return $_[0] if $_[0] =~ /^[\-+]?\d+\.\d*(?:e[\-+]?\d+)?$/i;
   return undef;
}

sub ip_to_int { 
   $_[0] =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/ or return undef;
   return (((($1*256)+$2)*256)+$3)*256+$4;
}

# This takes the human supplied form and converts its to what the database likes
our %to_db_type_func = ( hexint => \&hex_to_int, 
                         money => \&money_to_int, 
                         unix_ts => \&Date::Parse::str2time,
                         ip => \&ip_to_int,
                         integer => \&integer_to_int,
                         float => \&float_check,
                         bool => sub { $_[0] ? 1 : 0 },
                       );

sub FatallyValidateSql
{
   my($fktable,$oldhash,$recId,$andwhere) = @_;

   # download the field_def
   my $tablesql = $$fktable{'tablesql'};
   my $dbh = FKong::db::SendSQL("SELECT fieldId, fieldName, sqlName, type, min, max, unique_ FROM field_def\n".
                                "WHERE type != 'constant' && tablesql = ". FKong::db::SqlQuote($tablesql) ." $andwhere\n".
                                "ORDER BY sort");
   my($problems,$featureSql,@changes,@formstuff) = ("","");
   my %usercache;  # sadly for both directions
   while(my($fieldId,$fieldName,$sqlName,$type,$min,$max,$unique) = $dbh->fetchrow_array()) { # for each field
      my $newValue = $FKong::cgi::form{$sqlName};
      push(@formstuff,$sqlName,$newValue) if defined $newValue;
      if(defined $newValue || $type eq 'bool') {
         $newValue = FKong::cgi::trim($newValue);  # eliminate leading and trailing white space
         $newValue =~ s/\x0d\x0a/\x0a/g;  # convert CRLF to just LF
         if($type eq 'user') { 
            $problems .= "$fieldName is required.<br>\n" if $min && length $newValue == 0;
            ($newValue,my $problem) = identify_user($newValue,$fieldName,\%usercache);  # translate username to userid
            $problems .= $problem if $problem;
         } elsif($type eq 'multiuser') { 
            my @newValues;
            foreach my $uname (split(/^/m,$newValue)) {
               next unless $uname;
               ($newValue,my $problem) = identify_user($uname,$fieldName,\%usercache);  # translate username to userid
               $problems .= $problem if $problem;
               push(@newValues,$newValue) if $newValue;
            }
            $newValue = join(",",sort @newValues);
         } elsif(exists $to_db_type_func{$type} && $newValue eq '' && $type ne 'bool') { 
            $newValue = undef;
         } elsif(exists $to_db_type_func{$type}) { 
            $newValue = &{$to_db_type_func{$type}}($newValue);  
            $problems .= "$fieldName value is not understood.<br>\n" if ! defined $newValue;
         };
         field_info_line_for_email($fieldName,$type,$$oldhash{$sqlName},$newValue,\%usercache);
         if(defined $$oldhash{$sqlName}) {
            next if defined $newValue && $newValue eq $$oldhash{$sqlName};  # skip if no change
         } else {
            next if ! defined $newValue;
         }
         unshift(@changes,[$fieldId,$sqlName]);
         if($to_db_type_func{$type}) { 
            if(defined $max && $newValue > $max) {
               $max = &{$FKong::record::type_func{$type}}($max) if $FKong::record::type_func{$type};
               $problems .= "$fieldName is greater than maximum of $max.<br>\n";
            } elsif(defined $min && $newValue < $min) {
               $min = &{$FKong::record::type_func{$type}}($min) if $FKong::record::type_func{$type};
               $problems .= "$fieldName is less than minimum of $min.<br>\n";
            };
         } elsif($type eq 'oneline' || $type eq 'multiline') { 
            $problems .= "$fieldName is longer than maximum of $max characters.<br>\n" if $max && length $newValue > $max;
            $problems .= "$fieldName is shorter than minimum of $max characters.<br>\n" if $min && length $newValue < $min;
         }
         $featureSql .= ",\n$sqlName = ". FKong::db::SqlQuote($newValue);
         if($unique) {
            my $sth = FKong::db::SendSQL("SELECT $$fktable{'pkey'} FROM $tablesql WHERE $sqlName = ". 
                           FKong::db::SqlQuote($newValue) ."\nAND $$fktable{'pkey'} != ". FKong::db::SqlQuote($recId) ." LIMIT 1");
            if(my($dup) = $sth->fetchrow_array()) {
               $problems .= "$fieldName must be unique, but <a href=\"$$fktable{'recprefix'}$dup.html\">".
                            "feature $$fktable{'recprefix'}$dup</a> already has that value.<br>\n";
            };
         };
      } else {
         field_info_line_for_email($fieldName,$type,$$oldhash{$sqlName},$$oldhash{$sqlName},\%usercache);
      };
   }
   if($problems) {
      FKong::db::SendSQL("UNLOCK TABLE");
      # We need to do a redirect to stop the re-submit warnings.
      # We save the state on the serverside.
      FKong::session::set_state("$tablesql-$recId-fail",pack("N N (n/a*)*",
                         $FKong::cgi::form{'modifyTS'},$FKong::cgi::form{'changeId'},$problems,@formstuff));
      FKong::cgi::redirect($recId ? "$$fktable{'recprefix'}$recId.html" : 'new.html');  # to avoid POST warnings
   };
   return ($featureSql,\@changes);
}

sub send_email_notifications
{
   my($fktable,$recId) = @_;
  
   return if ! $FKong::config{'SendUpdateEmails'};
   my $tablesql = $$fktable{'tablesql'};
   # determine all the user-type fields
   my $dbh = FKong::db::SendSQL("SELECT sqlName, fieldId FROM field_def WHERE\n".
              "type IN ('user','multiuser') AND tablesql = ". FKong::db::SqlQuote($tablesql));
   my(@sqlNames,@field_ids);
   while(my($sql,$fieldId) = $dbh->fetchrow_array()) {
      push(@sqlNames,$sql);
      push(@field_ids,$fieldId);
   }
   if(0 == scalar @sqlNames) {
      return;   # no user fields
   }
   # determine who are the current users 
   $dbh = FKong::db::SendSQL("SELECT ". join(",",@sqlNames) ." FROM $tablesql WHERE $$fktable{'pkey'} = $recId");
   my(@userids) = $dbh->fetchrow_array();
   @userids = grep { defined } @userids;
   if(0 == scalar @userids) {
      return;   # record not found
   }
   @userids = map { split(/\D/,$_) } @userids; # for multiuser
   # determine how to contact them and if we should
   my @emails;
   my @esc_userids = map { FKong::db::SqlQuote($_) } @userids;
   $dbh = FKong::db::SendSQL("SELECT username, realname, email, email_pref, userid  FROM user WHERE userid IN (". join(",",@esc_userids) .")");
   # for every user who will receive email
   while(my($username,$realname,$email,$email_pref,$userid) = $dbh->fetchrow_array()) {
      next if ! $email || $email !~ /\w/;  # if email address is empty 
      next if $userid == $FKong::cgi::keyword{'userid'};  # don't send email to the user who authored it
      next if $userid < 100;  #  don't send to pseudo-accounts (new, anon, etc.)
      # check if the user wanted to be notified
      my %no_email_field_ids;
      $email_pref =~ s/(\d+)/$no_email_field_ids{$1} = 1/ge;  # convert number to a hash
      my $send_it = 0;
      foreach my $i (0 .. $#userids) {  # for every user-type field
         next if $userids[$i] != $userid;  # if that user is this user
         $send_it |= ! $no_email_field_ids{$field_ids[$i]};   
      }
      $send_it or next;
      # beautify the email address
      if($realname && $email !~ /[<"]/ && $realname !~ /[<"]/ && $FKong::config{'ShowRealnames'}) {
         $email = qq{"$realname" <$email>};
      };
      push(@emails,$email);
      # give the user feedback
      if($realname && $FKong::config{'ShowRealnames'}) {
         $FKong::cgi::keyword{"warning"} .= " &nbsp; &nbsp; Sent email to $realname ($username).<Br>\n";
      } else {
         $FKong::cgi::keyword{"warning"} .= " &nbsp; &nbsp; Sent email to $username.<Br>\n";
      };
   };
   if(scalar @emails) {
      $FKong::cgi::keyword{'recname'} = $$fktable{'recprefix'} . $recId;
      $FKong::cgi::keyword{'full_rec_url'} = $FKong::config{'featurekong_url'} . $FKong::r->location ."/$$fktable{'url'}/". 
                                             FKong::cgi::urlQuote($FKong::cgi::keyword{'recname'}) .".html";
      $FKong::cgi::keyword{'comment'} = $FKong::cgi::form{'commenT'} || '';
      $FKong::cgi::keyword{'comment_subject'} = $FKong::cgi::form{'subjecT'} ? "Subject: $FKong::cgi::form{'subjecT'}\n" : '';
      my $body = FKong::cgi::return_expanded_template("template/update.email");
      FKong::sendmail::send_mail(join(",\n    ",@emails),"$$fktable{'name'} $$fktable{'recprefix'}$recId has changed",$body);
   }

}

# On successful submit, this function outputs nothing.
sub Submit
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};
   FKong::session::must_have_priv("edit_features");
   FKong::session::must_have_priv("edit_fields") if $$fktable{'internal'};
   my $recId = $FKong::cgi::form{'feature_id'};
   FKong::Fatal("Internal Error: feature_id missing",'feature_id missing') if ! $recId;
   FKong::Fatal("Internal Error: feature_id non-numeric",'feature_id non-numeric') if $recId !~ /^\d+$/;
   my $form_changeId = $FKong::cgi::form{'changeId'};
   if(! defined $form_changeId || $form_changeId !~ /^\d+$/) {  # if missing or malformed changeId
      FKong::Fatal("Internal Error: missing or malformed changeId","bad changeId recId=$recId");
   }
   if(! defined $FKong::cgi::form{'modifyTS'} || $FKong::cgi::form{'modifyTS'} !~ /^\d+$/) {  # if missing or malformed modifyTS
      FKong::Fatal("Internal Error: missing or malformed modifyTS","bad modifyTS recId=$recId");
   }
   # download the current (old) values
   LockTablesForSubmit($fktable);
   my $dbh = FKong::db::SendSQL("SELECT * FROM $tablesql WHERE $pkey = $recId");
   my $oldhash = $dbh->fetchrow_hashref();
   FKong::Fatal("Internal Error: Feature not found. Mid-air delete?","mid-air delete? id=$recId") if ! $oldhash || ! $$oldhash{$pkey};
   # Get the database time
   $dbh = FKong::db::SendSQL("SELECT UNIX_TIMESTAMP()");    # we want to use the same time everywhere
   my($now) = $dbh->fetchrow_array; 
   # get the log and roll back the values to what the form was created with so we know what was changed by the user
   if($$fktable{'changes'}) {  # if the ${tablesql}_change table exists
      $dbh = FKong::db::SendSQL("SELECT sqlName, old_val\n".
                  "FROM ${tablesql}_change\n".
                  "LEFT JOIN field_def USING (fieldId)\n".
                  "WHERE $pkey = $recId AND ${tablesql}_change.changeId > $form_changeId\n". 
                  "ORDER BY ${tablesql}_change.changeId DESC");
      while(my($sqlName,$oldValue) = $dbh->fetchrow_array()) {
         $$oldhash{$sqlName} = $oldValue if $sqlName;   # roll back 
      }
   } else { # else no ${tablesql}_change table
      $form_changeId = $FKong::cgi::form{'modifyTS'};   # fake out changeId
      $$oldhash{'changeId'} = $$oldhash{'modifyTS'};

   };
   my($featureSql,$changes) = FatallyValidateSql($fktable,$oldhash,$recId,'AND ! read_only AND on_edit_form');
   my $changeId;
   if(scalar @$changes) { # if there is something to change
      # Check for mid-air collision
      if($form_changeId < $$oldhash{'changeId'}) {  # if collision (our guy committed from out-of-date form)
         $FKong::cgi::keyword{'formurl'} = FKong::cgi::Uri("submit.html");  # important so the redirect doesn't trash this page.
         $FKong::cgi::keyword{'submit_name'} = 'ok_show_list';   # take the same action as before
         $FKong::cgi::keyword{'submit_name'} = 'ok_show_next' if $FKong::cgi::form{'ok_show_next'}; 
         $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=changeId value=$$oldhash{'changeId'}>\n".# to detect another mid-air collision
                                           "<input type=hidden name=modifyTS value=$$oldhash{'modifyTS'}>\n";# to detect another mid-air collision
         foreach (qw/feature_id subjecT commenT/) {   # for each param to copy to collision page
            $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=\"$_\" value=\"". FKong::cgi::value_quote($FKong::cgi::form{$_}) ."\">\n";
         }
         foreach my $change (@$changes) {  # for each change to not in the collision page
            my($fieldId,$sqlName) = @$change;
            $FKong::cgi::keyword{'hidden'} .= "<input type=hidden name=\"$sqlName\" value=\"". 
                                               FKong::cgi::value_quote($FKong::cgi::form{$sqlName}) ."\">\n";
         }
         $FKong::cgi::keyword{'featureName'} = "$$fktable{'recprefix'}$recId";  
         FKong::db::SendSQL("UNLOCK TABLE");
         if($$fktable{'changes'}) {
            FKong::history::show_history("template/collision-template.html",$recId,
                                         'AND createTS > '. FKong::db::SqlQuote($FKong::cgi::form{'modifyTS'}),$fktable);
         } else {
            $FKong::cgi::keyword{'who_changed'} = FKong::cgi::htmlQuote(FKong::record::translate_to_username($$oldhash{'mod_by'},{ } ));
            $FKong::cgi::keyword{'when_changed'} = $$oldhash{'modifyTS'} ? 
                Date::Format::time2str($FKong::config{'TimeFormat'},$$oldhash{'modifyTS'}) : 'unknown';
            FKong::cgi::print_expanded_template("template/collision-mtime-template.html");
         };
         return;
      };
      if($$fktable{'changes'}) {
         # We update the change log
         foreach my $change (@$changes) {  # for each change 
            my($fieldId,$sqlName) = @$change;
            FKong::db::SendSQL("INSERT INTO ${tablesql}_change (fieldId,createTS,create_by,old_val,$pkey)\n".
                               "SELECT $fieldId, $now, $FKong::cgi::keyword{'userid'}, $sqlName, $recId\n". 
                               "FROM $tablesql WHERE $pkey = $recId");
            $changeId = FKong::db::last_insert_id();
         };
         #  The statement below does the same as the foreach above.  Which is more efficient?  It probabaly varies.
         #FKong::db::SendSQL("INSERT INTO ${tablesql}_change (fieldId,createTS,create_by,old_val,$pkey) VALUES\n". join(",",
         #      map { "($$_[0],$now,$FKong::cgi::keyword{'userid'},". FKong::db::SqlQuote($$oldhash{$$_[1]}) .",$recId)" } @$changes));
         # We update the feature table
         FKong::db::SendSQL("UPDATE ${tablesql} SET modifyTS = $now, mod_by = $FKong::cgi::keyword{'userid'}, changeId = $changeId $featureSql\n".
                     "WHERE $pkey = $recId");
      } else {
         FKong::db::SendSQL("UPDATE ${tablesql} SET modifyTS = $now, mod_by = $FKong::cgi::keyword{'userid'} $featureSql\n".
                     "WHERE $pkey = $recId");
      };
   };   
   my $was_posted = post_a_comment($recId,$fktable,$now,$changeId);
   FKong::db::SendSQL("UNLOCK TABLE");
   if(scalar(@$changes) || $was_posted) {  # if anything was updated
      $FKong::cgi::keyword{"warning"} .= "<div class=warn>Updated ". FKong::cgi::Link("/$FKong::cgi::keyword{'tableurl'}/".
                              "$$fktable{'recprefix'}$recId.html") ."$$fktable{'name'} $$fktable{'recprefix'}$recId</a><br>\n";
      send_email_notifications($fktable,$recId);
      $FKong::cgi::keyword{"warning"} .= "</div>\n";
   };
   check_list_and_redirect($recId,$fktable);
}

# On successful submit, this function outputs nothing.
sub BatchRow
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   my $pkey = $$fktable{'pkey'};  # this is the column name (recId would be its value)
   FKong::session::must_have_priv("edit_features");
   FKong::session::must_have_priv("edit_fields") if $$fktable{'internal'};
   LockTablesForSubmit($fktable);
   # Get the database time
   my $dbh = FKong::db::SendSQL("SELECT UNIX_TIMESTAMP()");    # we want to use the same time everywhere
   my($now) = $dbh->fetchrow_array; 
   # We run through a query of field_def to determine which ones are commanded to change
   my @sqlNames;
   $dbh = FKong::db::SendSQL("SELECT sqlName FROM field_def WHERE tablesql = ". 
                             FKong::db::SqlQuote($tablesql) ." AND batch AND ! unique_ AND ! read_only");
   while(my($sqlName) = $dbh->fetchrow_array) {  # for every possible field
      my $newValue = $FKong::cgi::form{$sqlName};
      next if ! defined $newValue;  # skip field if it was not on the form
      next if $newValue =~ /^\s*$/;  # skip field if all white space or empty
      push(@sqlNames,$sqlName);
   }
   my($featureSql,$changes) = FatallyValidateSql($fktable,{},0,"AND sqlName IN ('". join("','",@sqlNames) ."')");
   my(@recIds,$recIdSQL);
   my $warning = '';
   if($FKong::cgi::form{'ids'} && $FKong::cgi::form{'ids'} eq 'all') {
      $warning = 'Updated all records.';
      #foreach my $id () { post_a_comment($id,$fktable,$now,$changeId); }  # for every record
   } else {
      $warning = 'Updated ';
      foreach my $param (sort keys %FKong::cgi::form) {  # for each form parameter looking for the record numbers
         next unless $param =~ /^f(\d+)$/;  # only designated features
         next unless $FKong::cgi::form{$param};  # and only ones checked
         push(@recIds,$1);
         $warning .= " ". FKong::cgi::Link("/$FKong::cgi::keyword{'tableurl'}/".
                                 "$$fktable{'recprefix'}$1.html") ."$$fktable{'recprefix'}$1</a>\n";
      }
      if(! scalar @recIds) {
         FKong::db::SendSQL("UNLOCK TABLE");
         $FKong::cgi::keyword{"warning"} .= "<div class=warn>No records were selected for update.</div>";
         FKong::cgi::redirect("list.html");
         return;
      };
      $recIdSQL = "\nWHERE $$fktable{'pkey'} IN (". join(",",@recIds) .")";
   } 
   my $changeId;
   if($$fktable{'changes'}) {  # if we have a _changes table 
      # we modify the temporary table name in case we have an SQL error and it is never dropped.
      FKong::db::SendSQL("CREATE TEMPORARY TABLE oldvals$now (\n".
                         "fieldId mediumint unsigned not null,\n".
                         "old_val text,\n".
                         "$pkey int unsigned not null)");
      foreach my $change (@$changes) {  # for each changed column of $tablesql (gather every row)
         my($fieldId,$sqlName) = @$change;
         FKong::db::SendSQL("INSERT INTO oldvals$now (fieldId,old_val,$pkey)\n".
                            "SELECT $fieldId, $sqlName, $pkey\n". 
                            "FROM $tablesql $recIdSQL");
      };
      FKong::db::SendSQL("INSERT INTO ${tablesql}_change (fieldId,createTS,create_by,old_val,$pkey)\n".
                         "SELECT fieldId, $now, $FKong::cgi::keyword{'userid'}, old_val, $pkey\n". 
                         "FROM oldvals$now");
      $changeId = FKong::db::last_insert_id() if scalar @$changes;
      FKong::db::SendSQL("DROP TABLE oldvals$now");
      # finally update the actual records
      $dbh = FKong::db::SendSQL("UPDATE $tablesql SET mod_by = $FKong::cgi::keyword{'userid'}, modifyTS = $now". 
                                ",changeId = $changeId $featureSql $recIdSQL") if scalar @$changes;
   } else {  # else we do not have a _changes table
      $dbh = FKong::db::SendSQL("UPDATE $tablesql SET mod_by = $FKong::cgi::keyword{'userid'}, modifyTS = $now". 
                                "$featureSql $recIdSQL") if scalar @$changes;
   };
   foreach my $recId (@recIds) {
      post_a_comment($recId,$fktable,$now,$changeId);
   }
   FKong::db::SendSQL("UNLOCK TABLE");
   $FKong::cgi::keyword{"warning"} .= "<div class=warn>$warning</div>\n";
   FKong::cgi::redirect("list.html");
}

# On successful submit, this function outputs nothing.
sub Create
{
   my($fktable) = @_;
   my $tablesql = $$fktable{'tablesql'};
   FKong::session::must_have_priv("edit_features");
   if($$fktable{'internal'}) {
      FKong::Fatal("Sorry. You cannot edit internal tables with this form.");
   };
   my($featureSql,$changes) = FatallyValidateSql($fktable,{},0,"AND on_new_form");
   if(! scalar @$changes) { # quit here if there is nothing to create
      FKong::cgi::redirect("list.html");   
      return;
   };   
   # Get the database time
   my $dbh = FKong::db::SendSQL("SELECT UNIX_TIMESTAMP()");    # we want to use the same time everywhere
   my($now) = $dbh->fetchrow_array; 
   # We update the feature table
   FKong::db::SendSQL("INSERT INTO ${tablesql} SET createTS = UNIX_TIMESTAMP(), create_by = $FKong::cgi::keyword{'userid'},\n".
               "modifyTS = $now, mod_by = $FKong::cgi::keyword{'userid'} $featureSql");
   my $recId = FKong::db::last_insert_id();
   post_a_comment($recId,$fktable,$now);
   $FKong::cgi::keyword{"warning"} .= "<div class=warn>Created ". FKong::cgi::Link("/$FKong::cgi::keyword{'tableurl'}/".
                           "$$fktable{'recprefix'}$recId.html") ."$$fktable{'name'} $$fktable{'recprefix'}$recId</a><br>\n";
   send_email_notifications($fktable,$recId);
   $FKong::cgi::keyword{"warning"} .= "</div>\n";
   my $list = FKong::session::get_state($fktable->{'tablesql'} ."-list");
   $list = $list ? "$recId,$list" : $recId;  # add new record to search query results list
   FKong::session::set_state($fktable->{'tablesql'} ."-list",$list);
   FKong::cgi::redirect("list.html");   
}

sub post_a_comment
{
   my($recId,$fktable,$now,$changeId) = @_;
   return 0 if ! $$fktable{'comments'};  # only if this table supports comments
   # leading plus so we don't collide with a field_def defined field.
   my $subject = $FKong::cgi::form{'subjecT'};
   my $body = $FKong::cgi::form{'commenT'};
   if(defined $changeId) {
      $changeId = ",\nchangeId = $changeId";  # convert changeId into SQL
   } elsif($$fktable{'changes'}) {  # else we need a changeId
      my $dbh = FKong::db::SendSQL("SELECT changeId FROM $$fktable{'tablesql'}_change ORDER BY changeId DESC LIMIT 1");
      ($changeId) = $dbh->fetchrow_array();  # get maximum changeId
      $changeId = $changeId ? ",\nchangeId = $changeId" : '';  # convert changeId into SQL
   } else {  # else we do not need a changeId
      $changeId = '';
   };
   return 0 if $body =~ /^\s*$/s;  # if all white space then don't
   FKong::db::SendSQL("INSERT INTO $$fktable{'tablesql'}_comment SET createTS = $now,\n".
               "create_by = $FKong::cgi::keyword{'userid'}, format = 'text',$$fktable{'pkey'} = $recId,\n".
               "subject = ". FKong::db::SqlQuote($subject) .",\nbody = ". FKong::db::SqlQuote($body) . $changeId);
   return 1;  # return "yes, comment was posted"
}


$FKong::table_func{'submit.html'} = \&show_general_submit;

sub show_general_submit
{
   my($fktable) = @_;
   if($FKong::cgi::form{'ok_show_list'} || $FKong::cgi::form{'ok_show_next'}) {
      Submit(@_);
   } elsif($FKong::cgi::form{'create'}) {
      Create(@_);
   } elsif($FKong::cgi::form{'batch_row'}) {
      BatchRow(@_);
   } elsif($FKong::cgi::form{'cancel'}) { 
      FKong::cgi::redirect("list.html");   
   } else {  # nothing to submit?
      FKong::Fatal("Internal Error: form trouble.  Submit with nothing recognized.",'bad submit form');
   }
}

1;  # return value

