#!/usr/bin/perl -w
use strict;

#
#
#

use lib ".";
use lib "..";
require "../featurekong_startup.pl";
use Date::Format;
use FKong::db;
use htmlform;
use Carp;
use Getopt::Long;

my $base_url = 'http://127.0.0.1/fkong/';

my $tablename = 'Table2';
my $tablesql = 'tbl2';
my $recprefix = 't';
my $tableurl = 't2url';

# This is safe to call for non-existent tables for which it returns undef
sub get_table_definition($)
{
   my($tablesql) = @_;
   my $dbh = FKong::db::SendSQL("SHOW TABLES");
   while(my($name) = $dbh->fetchrow_array()) {
      if($name eq $tablesql) {
         $dbh = FKong::db::SendSQL("SHOW CREATE TABLE $tablesql");
         (undef, my $creation_sql) = $dbh->fetchrow_array();
         return $creation_sql;
      };
   };
   return undef;
}

sub drop_table_if_exists
{
   my($tablesql) = @_;
   FKong::db::SendSQL("DROP TABLE IF EXISTS $tablesql");
}

my $debug = 0;

# The choice table is redundant and used for multiple-choice types (enum)
sub delete_unused_choices
{
   my $dbh = FKong::db::SendSQL("SELECT choice.fieldId FROM choice LEFT JOIN field_def USING (fieldId)\n".
                                "WHERE fieldName IS NULL GROUP BY fieldId");
   while(my @row = $dbh->fetchrow_array) {
      FKong::db::SendSQL("DELETE FROM choice WHERE fieldId = $row[0]");
   }
}

sub create_table
{
   my($changes, $comments, $advertise, $existing) = @_;
   # First manually delete the test table if present because the
   # application cannot do that
   FKong::db::SendSQL("DELETE FROM fktable WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
   FKong::db::SendSQL("DELETE FROM field_def WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
   delete_unused_choices();
   drop_table_if_exists($tablesql) if ! $existing;
   drop_table_if_exists("${tablesql}_change");
   drop_table_if_exists("${tablesql}_comment");
   # create the table
   print "### $base_url\n" if $debug;
   my $page = `$curl_cmd '$base_url'`;
   my $form = htmlform::new($page);
   my $href = $form->find_href_by_subtext("admin",$base_url);
   print "### $href\n" if $debug;
   $page = `$curl_cmd '$href'`;
   $form = htmlform::new($page);
   $href = $form->find_href_by_subtext("new",$href);
   print "### $href\n" if $debug;
   $page = `$curl_cmd '$href'`;
   $form = htmlform::new($page);
   $form->select_form_by_submit_value('Create') or confess;
   $form->set_value_by_pretext('Name',$tablename);
   $form->set_value_by_pretext('SQL',$tablesql);
   $form->set_value_by_pretext('URL',$tableurl);
   $form->set_value_by_pretext('Prefix',$recprefix);
   $form->set_value_by_name('descrip','blah blah blah');  # Description
   $form->set_value_by_pretext('hanges',$changes ? 'on' : '');
   $form->set_value_by_pretext('omment',$comments ? 'on' : '');
   $form->set_value_by_pretext('dvertise',$advertise ? 'on' : '');
   ($href, my $formcli) = $form->submit_by_name('update',$href);
   print "### $href\n" if $debug;
   $page = `$curl_cmd $formcli '$href'`;
   my $dbh = FKong::db::SendSQL("SELECT * FROM fktable WHERE tablesql = ". FKong::db::SqlQuote($tablesql));
   my $hr = $dbh->fetchrow_hashref();
   if(! $$hr{'tablesql'}) {
      confess "fktable was missing record describing this table.\nCheck error_log for SQL syntax error.\n";
   }
   if(! $changes ne ! $$hr{'changes'}) {
      confess "fktable had changes bit wrong ($changes and $$hr{'changes'})\n ";
   }
   if(! $comments ne ! $$hr{'comments'}) {
      confess "fktable had comments bit wrong ($comments and $$hr{'comments'})\n ";
   }
   if(! $advertise ne ! $$hr{'advertise'}) {
      confess "fktable had advertise bit wrong ($advertise and $$hr{'advertise'})\n ";
   }
   #if($$hr{'description'} ne 'blah blah blah') {
   #   confess "fktable had decription wrong ($$hr{'description'})\n";
   #}
   get_table_definition($tablesql) or confess;
   if(! get_table_definition($tablesql)) {
      confess "${tablesql} table did not exist\n ";
   }
   if(! $changes ne ! get_table_definition("${tablesql}_change")) {
      confess "${tablesql}_change table existence wrong\n ";
   }
   if(! $comments ne ! get_table_definition("${tablesql}_comment")) {
      confess "${tablesql}_comment table existence wrong\n ";
   }
}      

create_table(0,0,0);
create_table(1,0,0);
create_table(0,1,0);
create_table(1,1,1);

#$debug = 1;

my %sql_type = ( integer => "int", hexint => 'int unsigned', ip => 'int unsigned', float => "float", oneline => "text", money => 'int',
                 multiline => "text", bool => "tinyint", unix_ts => 'int unsigned', user => "mediumint unsigned", mult_choice => 'enum' );

sub get_column_definition
{
   my($tablesql, $sqlName) = @_;
   my $dbh = FKong::db::SendSQL("SHOW COLUMNS FROM $tablesql");
   while(my($field, $type, $null, $key, $default, $extra) = $dbh->fetchrow_array()) {
      if($field eq $sqlName) {
         return $type;
      };
   };
   return undef;
}

sub add_column
{
   my($name, $type, $read_only) = @_;

   my $href = "$base_url$tableurl/";
   print "### $href\n" if $debug;
   my $page = `$curl_cmd '$href'`;
   my $form = htmlform::new($page);
   $href = $form->find_href_by_subtext("Design",$href);
   print "### $href\n" if $debug;
   $page = `$curl_cmd '$href'`;
   $form = htmlform::new($page);
   $href = $form->find_href_by_subtext("New Field",$href);
   print "### $href\n" if $debug;
   $page = `$curl_cmd '$href'`;
   $form = htmlform::new($page);
   $form->select_form_by_submit_value('Next') or return;
   $form->set_value_by_name('type',$type);
   ($href, my $formcli) = $form->submit_by_name('do_field_type',$href);
   print "### $href\n" if $debug;
   $page = `$curl_cmd $formcli '$href'`;
   if($debug) { open(my $fd,">rick.html"); print $fd $page; close($fd); };
   $form = htmlform::new($page);
   $form->select_form_by_submit_value('Create') or return;
   $form->set_value_by_pretext('Name',$name);
   if($type ne 'constant') {
      $form->set_value_by_pretext('Read Only',$read_only || 0) or warn "read only not on form of $type\n";
   }
   if($type eq 'mult_choice') {
       $form->set_value_by_pretext('one per line',"blue\nred\norange smoothie\n");
   }
   ($href, $formcli) = $form->submit_by_name('Create',$href);
   print "### $href\n" if $debug;
   $page = `$curl_cmd $formcli '$href'`;
   # validation time
   my $dbh = FKong::db::SendSQL("SELECT * FROM field_def WHERE fieldName = ". FKong::db::SqlQuote($name));
   my $hr = $dbh->fetchrow_hashref;
   if(! defined $$hr{'fieldName'}) {
      print "creation of field $name failed\n";
      return;
   }
   if($type ne 'constant') {
      my $dbh = FKong::db::SendSQL("DESCRIBE $tablesql $$hr{'sqlName'}");
      my($field, $dbtype, $null, $key, $default, $extra) = $dbh->fetchrow_array();
      if($type eq 'mult_choice') {
         $dbtype =~ /\('blue','red','orange smoothie'\)/ or confess "wrong choices\n ";
      }
      if(! $dbtype) {
         warn "sql table does not have field type=$type sqlName=$$hr{'sqlName'}\n";
      } else {
         $dbtype =~ s/\(.*?\)//g;  # remove parenthetic stuff 
         $dbtype eq $sql_type{$type} or warn "wrong field type for type=$type dbtype=$dbtype\n";
      };
      #print "dbtype=$dbtype sql_type=$sql_type{$type}\n";
   };
}

add_column('foo', 'integer');
add_column('foo2', 'integer');

foreach my $type ('mult_choice','integer','oneline','multiline','bool',
                  'float','constant','user','unix_ts','hexint','money','ip') {
   add_column("Blue $type", $type);
   add_column("Orange $type", $type, 1);
}




FKong::db::SendSQL("INSERT INTO $tablesql SET mod_by = $userid, modifyTS = UNIX_TIMESTAMP(),\n".
                   "create_by = $userid, createTS = UNIX_TIMESTAMP()");
my $rec_id = FKong::db::last_insert_id();

sub change_col_type 
{
   my($fieldName, $old_val, $new_type, $new_val) = @_;

}

change_col_type("Blue money",300,'oneline','3.00');
change_col_type("Blue money",'3.00','integer',300);

exit if $keep;
# Here we check asking featurekong to track a table already existing
create_table(0,0,0,1);
delete_unused_choices();
# Check that the choices table caches the choices correctly.
my $dbh = FKong::db::SendSQL("SELECT fieldId FROM field_def WHERE type = 'mult_choice' AND tablesql = ". FKong::db::SqlQuote($tablesql));
while(my @row = $dbh->fetchrow_array()) {
   my $dbh2 = FKong::db::SendSQL("SELECT fieldId FROM choice WHERE fieldId = $row[0] AND choice = 'red'");
   $dbh2->fetchrow_array() or die "choices table incomplete";
}

sub check_column_def
{
   my($fieldsql) = @_;
   my $dbh = FKong::db::SendSQL("DESCRIBE $tablesql $fieldsql");
   my($field, $dbtype, $null, $key, $default, $extra) = $dbh->fetchrow_array();
   $dbtype or confess "mandatory columns missing for existing table creation"; 
   $dbtype =~ /int/i or confess "mandatory columns wrong type"; 
   $dbtype =~ /unsigned/i or confess "mandatory columns wrong type"; 

}

# Delete the mandatory columns and make sure they reappear.
FKong::db::SendSQL("ALTER TABLE $tablesql DROP mod_by");
FKong::db::SendSQL("ALTER TABLE $tablesql DROP create_by");
FKong::db::SendSQL("ALTER TABLE $tablesql DROP modifyTS");
FKong::db::SendSQL("ALTER TABLE $tablesql DROP createTS");
create_table(0,0,0,1);
check_column_def("mod_by");
check_column_def("create_by");
check_column_def("modifyTS");
check_column_def("createTS");



