# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): Terry Weissman <terry@mozilla.org>
#                 Dave Miller <justdave@syndicomm.com>
#                 Rick Dean <software@fdd.com>

use diagnostics;
use strict;

use RelationSet;

# Shut up misguided -w warnings about "used only once".  For some reason,
# "use vars" chokes on me when I try it here.

sub bug_form_pl_sillyness {
    my $zz;
    $zz = %::FORM;
    $zz = %::components;
    $zz = %::proddesc;
    $zz = %::prodmaxvotes;
    $zz = %::versions;
    $zz = @::legal_keywords;
    $zz = @::legal_sponsor;
    $zz = @::legal_committee;
    $zz = @::legal_plan;
    $zz = @::legal_severity;
    $zz = %::target_milestone;
}

my $loginok = quietly_check_login();

my $id = $::FORM{'id'};

my $query = "
select
        bugs.bug_id,
        plan,
        version,
        committee,
        sponsor,
        status,
        priority,
        bug_severity,
        component,
        assigned_to,
        reporter,
        bug_file_loc,
        short_desc,
        big_desc,
	target_milestone,
	qa_contact,
	status_whiteboard,
        date_format(creation_ts,'%Y-%m-%d %H:%i'),
        groupset,
	delta_ts,
	sum(votes.count)
from bugs left join votes using(bug_id)
where bugs.bug_id = $id
group by bugs.bug_id";

SendSQL($query);
my %bug;
my @row;
@row = FetchSQLData();
my $count = 0;
foreach my $field ("bug_id", "plan", "version", "committee",
                   "sponsor", "status", "priority",
                   "bug_severity", "component", "assigned_to", "reporter",
                   "bug_file_loc", "short_desc", "big_desc", "target_milestone",
                   "qa_contact", "status_whiteboard", "creation_ts",
                   "groupset", "delta_ts", "votes") {
    $bug{$field} = shift @row;
    if (!defined $bug{$field}) {
        $bug{$field} = "";
    }
    $count++;
}

my $assignedtoid = $bug{'assigned_to'};
my $reporterid = $bug{'reporter'};
my $qacontactid =  $bug{'qa_contact'};

$bug{'assigned_to_email'} = DBID_to_name($assignedtoid);
$bug{'assigned_to'} = DBID_to_real_or_loginname($bug{'assigned_to'});
$bug{'reporter'} = DBID_to_real_or_loginname($bug{'reporter'});

print qq{<FORM NAME="changeform" METHOD="POST" ACTION="process_bug.cgi">\n};

#  foreach my $i (sort(keys(%bug))) {
#      my $q = value_quote($bug{$i});
#      print qq{<INPUT TYPE="HIDDEN" NAME="orig-$i" VALUE="$q">\n};
#  }

$bug{'long_desc'} = GetLongDescriptionAsHTML($id);
$bug{'big_desc_hist'} = GetBigDescHistAsHTML($id) if $::FORM{'big_desc_hist'};
my $longdesclength = length($bug{'long_desc'});

GetVersionTable();



#
# These should be read from the database ...
#

my $committee_popup = make_options(\@::legal_committee, $bug{'committee'});
my($sev_popup,$sev_name);
if(Param("useseverity")) {
    $sev_popup = make_options(\@::legal_severity, $bug{'bug_severity'});
    $sev_popup = "<SELECT NAME=bug_severity>$sev_popup</SELECT>";
    $sev_name = "<B><A HREF=\"fields.html#severity\">Severity:</A></B>";
} else {
    $sev_popup = "<input type=hidden name=bug_severity value=\"$bug{'bug_severity'}\">";
    $sev_name = "";
};

my $component_popup = make_options($::components{$bug{'plan'}},
				   $bug{'component'});

my $ccSet = new RelationSet;
$ccSet->mergeFromDB("select who from cc where bug_id=$id");
my @ccList = $ccSet->toArrayOfStrings();
my $cc_element = "<INPUT TYPE=HIDDEN NAME=cc VALUE=\"\">";
if (scalar(@ccList) > 0) {
  $cc_element = "<SELECT NAME=cc MULTIPLE SIZE=5>\n";
  foreach my $ccName ( @ccList ) {
    $cc_element .= "<OPTION VALUE=\"$ccName\">$ccName\n";
  }
  $cc_element .= "</SELECT><BR>\n" .
        "<INPUT TYPE=CHECKBOX NAME=removecc>Remove selected CCs<br>\n";
}

my $URL = value_quote($bug{'bug_file_loc'});

if (defined $URL && $URL ne "none" && $URL ne "NULL" && $URL ne "") {
    $URL = "<B><A HREF=\"$URL\">URL:</A></B>";
} else {
    $URL = "<B>URL:</B>";
}

print "
<INPUT TYPE=HIDDEN NAME=\"delta_ts\" VALUE=\"$bug{'delta_ts'}\">
<INPUT TYPE=HIDDEN NAME=\"longdesclength\" VALUE=\"$longdesclength\">
<INPUT TYPE=HIDDEN NAME=\"id\" VALUE=$id>
  <TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0><TR>
    <TD ALIGN=RIGHT><B>Feature#:</B></TD><TD><A HREF=\"" . Param('urlbase') . "show_bug.cgi?id=$bug{'bug_id'}\">$bug{'bug_id'}</A></TD>
  <TD>&nbsp;</TD>
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html#committee\">Framework:</A></B></TD>
    <TD><SELECT NAME=committee>$committee_popup</SELECT></TD>
  <TD>&nbsp;</TD>
    <TD ALIGN=RIGHT><B>Reporter:</B></TD><TD>$bug{'reporter'}</TD>
</TR><TR>
    <TD ALIGN=RIGHT><B>Plan:</B></TD>
    <TD> $bug{'plan'} <INPUT TYPE=hidden NAME=plan VALUE=$bug{'plan'}></TD>
  <TD>&nbsp;</TD>
    <TD ALIGN=RIGHT><B>Sponsor:</B></TD>
    <TD><SELECT NAME=sponsor>" .
    make_options(\@::legal_sponsor, $bug{'sponsor'}) .
    "</SELECT></TD>
  <TD>&nbsp;</TD>
    <TD ALIGN=RIGHT NOWRAP><b>Add CC:</b></TD>
    <TD><INPUT NAME=newcc SIZE=30 VALUE=\"\"></TD>
</TR><TR>
    <TD ALIGN=RIGHT><B><A HREF=\"describecomponents.cgi?plan=" .
    url_quote($bug{'plan'}) . "\">Component:</A></B></TD>
      <TD><SELECT NAME=component>$component_popup</SELECT></TD>
  <TD>&nbsp;</TD>";
if (Param("useversion")) {
print "
    <TD ALIGN=RIGHT><B>Reported on Version:</B></TD>
    <TD><SELECT NAME=version>" .
    make_options($::versions{$bug{'plan'}}, $bug{'version'}) .
    "</SELECT></TD>";
} else {
    print "<TD>&nbsp;</TD><TD>&nbsp;</TD>\n";
};
$bug{'assigned_to'} = 0 if !defined($bug{'assigned_to'});
print "
  <TD>&nbsp;</TD>
    <TD ROWSPAN=4 ALIGN=RIGHT VALIGN=TOP><B>CC:</B></TD>
    <TD ROWSPAN=4 VALIGN=TOP> $cc_element </TD>
</TR><TR>
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html\">Status:</A></B></TD>
      <TD><SELECT NAME=status>" . 
    make_options(\@::legal_status, $bug{'status'}) . 
    "</SELECT></TD>
  <TD>&nbsp;</TD>
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html#priority\">Priority:</A></B></TD>
      <TD><INPUT NAME=priority VALUE=\"" . value_quote($bug{'priority'}) . "\" SIZE=10>
      (1 is most urgent)</TD>
  <TD>&nbsp;</TD>
</TR><TR>
    <TD ALIGN=RIGHT><B>&nbsp;</B></TD>
      <TD>&nbsp;</TD>
  <TD>&nbsp;</TD>
    <TD ALIGN=RIGHT>$sev_name</TD>
      <TD>$sev_popup</TD>
  <TD>&nbsp;</TD>
</TR><TR>
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html#assigned_to\">Assigned&nbsp;To:
        </A></B></TD>
      <TD>$bug{'assigned_to'}</TD>
  <TD>&nbsp;</TD>";

if (Param("usetargetmilestone")) {
    my $url = "";
    if (defined $::milestoneurl{$bug{'plan'}}) {
        $url = $::milestoneurl{$bug{'plan'}};
    }
    if ($url eq "") {
        $url = "notargetmilestone.html";
    }
    if ($bug{'target_milestone'} eq "") {
        $bug{'target_milestone'} = " ";
    }
    print "
<TD ALIGN=RIGHT><A href=\"$url\"><B>Target Release:</B></A></TD>
<TD><SELECT NAME=target_milestone>" .
    make_options($::target_milestone{$bug{'plan'}},
                 $bug{'target_milestone'}) .
                     "</SELECT></TD>
  <TD>&nbsp;</TD>";
} else { print "<TD></TD><TD></TD><TD>&nbsp;</TD>"; }

print "
</TR>";

if (Param("useqacontact")) {
    my $name = $bug{'qa_contact'} > 0 ? DBID_to_name($bug{'qa_contact'}) : "";
    print "
  <TR>
    <TD ALIGN=\"RIGHT\"><B>QA Contact:</B>
    <TD COLSPAN=7>
      <INPUT NAME=qa_contact VALUE=\"" .
    value_quote($name) .
    "\" SIZE=60></TD>
  </TR>";
}


print "
  <TR>
    <TD ALIGN=\"RIGHT\">$URL
    <TD COLSPAN=7>
      <INPUT NAME=bug_file_loc VALUE=\"" . value_quote($bug{'bug_file_loc'}) . "\" SIZE=60></TD>
  </TR><TR>
    <TD ALIGN=\"RIGHT\"><B>Feature Name:</B>
    <TD COLSPAN=6>
      <INPUT NAME=short_desc VALUE=\"" .
    value_quote($bug{'short_desc'}) .
    "\" SIZE=60></TD>
       <TD><INPUT TYPE=\"submit\" VALUE=\"Commit\"></TD>
  </TR>";

print "<TR><TD COLSPAN=8><B>Multi-line Description</B>
 (<A HREF=\"show_bug.cgi?id=$id&big_desc_hist=1#description-0\">see all versions</A>)
<BR>\n";
print qq{<TEXTAREA WRAP=HARD NAME=big_desc ROWS=20 COLS=80>}.value_quote($bug{big_desc}). qq{</TEXTAREA></TD></TR>};

if (Param("usestatuswhiteboard")) {
    print "
  <TR>
    <TD ALIGN=\"RIGHT\"><B>Status Whiteboard:</B>
    <TD COLSPAN=7>
      <INPUT NAME=status_whiteboard VALUE=\"" .
    value_quote($bug{'status_whiteboard'}) .
    "\" SIZE=60></TD>
  </TR>";
}

if (@::legal_keywords) {
    SendSQL("SELECT keyworddefs.name 
             FROM keyworddefs, keywords
             WHERE keywords.bug_id = $id AND keyworddefs.id = keywords.keywordid
             ORDER BY keyworddefs.name");
    my @list;
    while (MoreSQLData()) {
        push(@list, FetchOneColumn());
    }
    my $value = value_quote(join(', ', @list));
    print qq{
<TR>
<TD ALIGN=right><B><A HREF="describekeywords.cgi">Keywords:</A></B>
<TD COLSPAN=7><INPUT NAME="keywords" VALUE="$value" SIZE=60></TD>
</TR>
};
}

print "<tr><td align=right><B>Attachments:</b></td>\n";
SendSQL("select attach_id, creation_ts, mimetype, description from attachments where bug_id = $id");
while (MoreSQLData()) {
    my ($attachid, $date, $mimetype, $desc) = (FetchSQLData());
    if ($date =~ /^(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/) {
        $date = "$3/$4/$2 $5:$6";
    }
    my $link = "showattachment.cgi?attach_id=$attachid";
    $desc = value_quote($desc);
    print qq{<td><a href="$link">$date</a></td><td colspan=6>$desc&nbsp;&nbsp;&nbsp;($mimetype)</td></tr><tr><td></td>};
}
print "<td colspan=7><a href=\"createattachment.cgi?id=$id\">Create a new attachment</a> (proposed patch, testcase, etc.)</td></tr></table>\n";


sub EmitDependList {
    my ($desc, $myfield, $targetfield) = (@_);
    print "<th align=right>$desc:</th><td>";
    my @list;
    SendSQL("select $targetfield from dependencies where  
             $myfield = $id order by $targetfield");
    while (MoreSQLData()) {
        my ($i) = (FetchSQLData());
        push(@list, $i);
        print GetBugLink($i, $i);
        print " ";
    }
    print "</td><td><input name=$targetfield value=\"" .
        join(',', @list) . "\"></td>\n";
}

if (Param("usedependencies")) {
    print "<table><tr>\n";
    EmitDependList("Feature $id depends on", "blocked", "dependson");
    print qq{
<td rowspan=2><a href="showdependencytree.cgi?id=$id">Show dependency tree</a>
};
    if (Param("webdotbase") ne "") {
        print qq{
<br><a href="showdependencygraph.cgi?id=$id">Show dependency graph</a>
};
    }
    print "</td></tr><tr>";
    EmitDependList("Feature $id blocks", "dependson", "blocked");
    print "</tr></table>\n";
}

if ($::prodmaxvotes{$bug{'plan'}}) {
    print qq{
<table><tr>
<th><a href="votehelp.html">Votes</a> for feature $id:</th><td>
<a href="showvotes.cgi?bug_id=$id">$bug{'votes'}</a>
&nbsp;&nbsp;&nbsp;<a href="showvotes.cgi?voteon=$id">Vote for this bug</a>
</td></tr></table>
};
}

SendSQL("SELECT pool, units FROM pools WHERE plan = " . SqlQuote($bug{'plan'}));
my @pools = ();
my %units;  # index is $stage
while(my ($pool,$units) = FetchSQLData()) {
   push(@pools,$pool);
   $units{$pool} = $units;
};
SendSQL("SELECT stage FROM stages WHERE plan = " . SqlQuote($bug{'plan'}));
my @stages = ();
my %stageTotal;  # index is $stage
while(my($stage) = FetchSQLData()) {
   push(@stages,$stage);
   $stageTotal{$stage} = 0;
};

my %bucket;  # index is "$pool~$stage"
SendSQL("SELECT pool,stage,effort FROM buckets WHERE id = $id");
while(my($pool,$stage,$effort) = FetchSQLData()) {
  $bucket{"$pool~$stage"} = $effort;
  $stageTotal{$stage} += $effort;
}

$units{"total"} = "";
@pools = ("header",@pools,"total");
@stages = ("header",@stages,"units");
print("<table>\n");
for my $stage (@stages) {
  print(" <tr>\n");
  for my $pool (@pools) {
    if ($stage eq 'header') {
      if($pool eq 'header') {
        print("   <td>&nbsp;</td>\n");
      } else {
        print("   <th>$pool</th>\n"); 
      };
    } elsif($pool eq 'header') {
      print("   <th>$stage</th>\n"); 
    } elsif ($stage eq 'units') {
      print("   <td>$units{$pool}</td>\n"); 
    } elsif ($pool eq 'total') {
      print("   <td align=right>$stageTotal{$stage}</td>\n"); 
    } else {
      my $value = $bucket{"$pool~$stage"};
      $value = "" if(!defined($value));
      print("   <td><INPUT NAME=\"". html_quote(url_quote("$pool-bUcK-$stage")) ."\" VALUE=\"" . 
            value_quote($value) . "\" SIZE=10></TD>\n");
    }
  }
  print("</tr>\n");
}
print("</table>\n");

print "
<br>
<B>Additional Comments:</B>
<BR>
<TEXTAREA WRAP=HARD NAME=comment ROWS=10 COLS=80></TEXTAREA><BR>";


if ($::usergroupset ne '0') {
    SendSQL("select bit, name, description, (bit & $bug{'groupset'} != 0) " .
	    "from groups where bit & $::usergroupset != 0 " .
	    "and isbuggroup != 0 " . 
            # Include active groups as well as inactive groups to which
            # the feature already belongs.  This way the feature can be removed
            # from an inactive group but can only be added to active ones.
            "and (isactive = 1 or (bit & $bug{'groupset'} != 0)) " . 
	    "order by description");
    # We only print out a header bit for this section if there are any
    # results.
    my $groupFound = 0;
    while (MoreSQLData()) {
      my ($bit, $name, $description, $ison) = (FetchSQLData());
      # For plan groups, we only want to display the checkbox if either
      # (1) The bit is already set, or
      # (2) It's the group for this plan.
      # All other plan groups will be skipped.  Non-plan feature groups
      # will still be displayed.
      if($ison || ($name eq $bug{'plan'}) || (!defined $::proddesc{$name})) {
        if(!$groupFound) {
          print "<br><b>Only users in the selected groups can view this bug:</b><br>\n";
          print "<font size=\"-1\">(Leave all boxes unchecked to make this a public bug.)</font><br><br>\n";
          $groupFound = 1;
        }
        # Modifying this to use checkboxes instead
        my $checked = $ison ? " CHECKED" : "";
        # indent these a bit
        print "&nbsp;&nbsp;&nbsp;&nbsp;";
        print "<input type=checkbox name=\"bit-$bit\" value=1$checked>\n";
        print "$description<br>\n";
      }
    }

    # If the feature is restricted to a group, display checkboxes that allow
    # the user to set whether or not the reporter, assignee, QA contact, 
    # and cc list can see the feature even if they are not members of all 
    # groups to which the feature is restricted.
    if ( $bug{'groupset'} != 0 ) {
        # Determine whether or not the feature is always accessible by the reporter,
        # QA contact, and/or users on the cc: list.
        SendSQL("SELECT  reporter_accessible , assignee_accessible , 
                         qacontact_accessible , cclist_accessible
                 FROM    bugs
                 WHERE   bug_id = $id
                ");
        my ($reporter_accessible, $assignee_accessible, $qacontact_accessible, $cclist_accessible) = FetchSQLData();

        # Convert boolean data about which roles always have access to the bug
        # into "checked" attributes for the HTML checkboxes by which users
        # set and change these values.
        my $reporter_checked = $reporter_accessible ? " checked" : "";
        my $assignee_checked = $assignee_accessible ? " checked" : "";
        my $qacontact_checked = $qacontact_accessible ? " checked" : "";
        my $cclist_checked = $cclist_accessible ? " checked" : "";

        # Display interface for changing the values.
        print qq|
            <p>
            <b>But users in the roles selected below can always view this bug:</b><br>
            <small>(Does not take effect unless the feature is restricted to at least one group.)</small>
            </p>

            <p>
            <input type="checkbox" name="reporter_accessible" value="1" $reporter_checked>Reporter
            <input type="checkbox" name="assignee_accessible" value="1" $assignee_checked>Assignee
            <input type="checkbox" name="qacontact_accessible" value="1" $qacontact_checked>QA Contact
            <input type="checkbox" name="cclist_accessible" value="1" $cclist_checked>CC List
            </p>
        |;
    }
}

my $knum = 0;
my $canedit = UserInGroup("editbugs") || ($::userid == 0);
my $status = $bug{'status'};
print " <A HREF=\"fields.html#assigned_to\">Reassign</A> feature to
  <INPUT NAME=\"assigned_to\" SIZE=32 VALUE=\"$bug{'assigned_to_email'}\"> 
<br>\n";
print "Mark duplicate of feature # <INPUT NAME=dup_id SIZE=6><br>\n";
 
print "
<INPUT TYPE=\"submit\" VALUE=\"Commit\">
<INPUT TYPE=\"reset\" VALUE=\"Reset\">
<INPUT TYPE=\"hidden\" name=\"form_name\" VALUE=\"process_bug\">
<P>
<FONT size=\"+1\"><B>
 <A HREF=\"show_activity.cgi?id=$id\">View change history</A>
 &nbsp; | &nbsp;
 <A HREF=\"long_list.cgi?buglist=$id\">Format For Printing</A>
</B></FONT>
";

my $movers = Param("movers");
$movers =~ s/\s?,\s?/|/g;
$movers =~ s/@/\@/g;
if ( Param("move-enabled") && (defined $::COOKIE{"FeatureKong_login"}) && ($::COOKIE{"FeatureKong_login"} =~ /($movers)/) ){
  print "&nbsp; <FONT size=\"+1\"><B> | </B></FONT> &nbsp;"
       ."<INPUT TYPE=\"SUBMIT\" NAME=\"action\" VALUE=\"" 
       . Param("move-button-text") . "\">\n";
}

print "<BR></FORM>";

if($::FORM{big_desc_hist}) {
    print "
<table bgcolor=dddddd><tr><td><font color=000066>
<table><tr><td align=left><B>Description History:</B></td></table>
";
    print $bug{'big_desc_hist'};
    print "</font></td></tr></table>\n";
};

print "
<table><tr><td align=left><B>Comment Log:</B></td>
<td align=right width=70%>Opened: $bug{'creation_ts'}</td></tr></table>
<HR>
";
print $bug{'long_desc'};
print "The comment log is empty, but would show here otherwise." if !$bug{'long_desc'};
print "
<HR>\n";

# To add back option of editing the long description, insert after the above
# long_list.cgi line:
#  <A HREF=\"edit_desc.cgi?id=$id\">Edit Long Description</A>

navigation_header();

PutFooter();

1;
