#!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is mozilla.org code.
#
# The Initial Developer of the Original Code is Holger
# Schurig. Portions created by Holger Schurig are
# Copyright (C) 1999 Holger Schurig. All
# Rights Reserved.
#
# Contributor(s): Holger Schurig <holgerschurig@nikocity.de>
#               Terry Weissman <terry@mozilla.org>
#               Rick Dean <software@fdd.com>
#
#
# Direct any questions on this source code to
#
# Holger Schurig <holgerschurig@nikocity.de>

use diagnostics;
use strict;

require "CGI.pl";
require "globals.pl";


# TestPlan:  just returns if the specified plan does exists
# CheckPlan: same check, optionally  emit an error text
# TestStage:  just returns if the specified plan/pool combination exists
# CheckStage: same check, optionally emit an error text

sub TestPlan ($)
{
    my $prod = shift;

    # does the plan exist?
    SendSQL("SELECT plan
             FROM plans
             WHERE plan=" . SqlQuote($prod));
    return FetchOneColumn();
}

sub CheckPlan ($)
{
    my $prod = shift;

    # do we have a plan?
    unless ($prod) {
        print "Sorry, you haven't specified a plan.";
        PutTrailer();
        exit;
    }

    unless (TestPlan $prod) {
        print "Sorry, plan '$prod' does not exist.";
        PutTrailer();
        exit;
    }
}

sub TestStage ($$)
{
    my ($prod,$pool) = @_;

    # does the plan exist?
    SendSQL("SELECT plan,pool
             FROM pools
             WHERE plan=" . SqlQuote($prod) . " and pool=" . SqlQuote($pool));
    return FetchOneColumn();
}

sub CheckStage ($$)
{
    my ($prod,$pool) = @_;

    # do we have the pool?
    unless ($pool) {
        print "Sorry, you haven't specified a pool.";
        PutTrailer();
        exit;
    }

    CheckPlan($prod);

    unless (TestStage($prod,$pool)) {
        print "Sorry, pool '$pool' for plan '$prod' does not exist.";
        PutTrailer();
        exit;
    }
}


#
# Displays a text like "a.", "a or b.", "a, b or c.", "a, b, c or d."
#

sub PutTrailer (@)
{
    my (@links) = ("Back to the <A HREF=\"query.cgi\">query page</A>", @_);

    my $count = $#links;
    my $num = 0;
    print "<P>\n";
    foreach (@links) {
        print $_;
        if ($num == $count) {
            print ".\n";
        }
        elsif ($num == $count-1) {
            print " or ";
        }
        else {
            print ", ";
        }
        $num++;
    }
    PutFooter();
}







#
# Preliminary checks:
#

confirm_login();

print "Content-type: text/html\n\n";

my $plan = trim($::FORM{'plan'} || '');
my $pool = trim($::FORM{'pool'} || '');
my $action  = trim($::FORM{'action'}  || '');
my $units  = trim($::FORM{'units'}  || '');
my $description  = trim($::FORM{'description'}  || '');
my $localtrailer;

if ($pool) {
    $localtrailer = "<A HREF=\"editpools.cgi?plan=" . url_quote($plan) . "\">edit</A> more pools";
} else {
    $localtrailer = "<A HREF=\"editpools.cgi\">edit</A> more pools";
}

if($plan) {
    PutHeader("Edit pools for $plan");
} else {
    PutHeader("Edit pools");
}
if($::FORM{'debug'}) {
   for my $key (sort(keys(%::FORM))) {
      print("$key {{$::FORM{$key}}}<br>\n");
   };
};

unless (UserInGroup("editcomponents")) {
    print "Sorry, you aren't a member of the 'editcomponents' group.\n";
    print "And so, you aren't allowed to add, modify or delete pools.\n";
    PutTrailer();
    exit;
}

sub ShowPlans {
    SendSQL("SELECT plans.plan,plans.description,'xyzzy'
             FROM plans 
             GROUP BY plans.plan
             ORDER BY plans.plan");
    print "<TABLE BORDER=1 CELLPADDING=4 CELLSPACING=0><TR BGCOLOR=\"#6666FF\">\n";
    print "  <TH ALIGN=\"left\">Edit pools of ...</TH>\n";
    print "  <TH ALIGN=\"left\">Description</TH>\n";
    print "  <TH ALIGN=\"left\">Features</TH>\n";
    #print "  <TH ALIGN=\"left\">Edit</TH>\n";
    print "</TR>";
    while ( MoreSQLData() ) {
        my ($plan, $description, $bugs) = FetchSQLData();
        $description ||= "<FONT COLOR=\"red\">missing</FONT>";
        $bugs ||= "none";
        print "<TR>\n";
        print "  <TD VALIGN=\"top\"><A HREF=\"editpools.cgi?plan=", url_quote($plan), "\"><B>$plan</B></A></TD>\n";
        print "  <TD VALIGN=\"top\">$description</TD>\n";
        print "  <TD VALIGN=\"top\">$bugs</TD>\n";
        #print "  <TD VALIGN=\"top\"><A HREF=\"editpools.cgi?action=edit&plan=", url_quote($plan), "\">Edit</A></TD>\n";
    }
    print "</TR></TABLE>\n";

    PutTrailer();
    exit;
}

if($action =~ /add/i) {
    CheckPlan($plan);
    if (!$pool) {
        print "<font color=red>You must enter a text for the new pool.</font><br>\n";
    } elsif (TestStage($plan,$pool)) {
        print "<font color=red>The pool '$pool' already exists.</font><br>\n";
    } else {
        # insert the new pool
        SendSQL("INSERT INTO pools ( pool, plan, units, description ) VALUES ( " .
              SqlQuote($pool) . "," .  SqlQuote($plan) . "," . SqlQuote($units) . "," . SqlQuote($description) . ")");
        unlink "data/versioncache"; # Make versioncache flush
    };
}

# if user wants to delete
if ($action eq 'del') {
    CheckPlan($plan);
    SendSQL("LOCK TABLES buckets WRITE, pools WRITE, bugs READ, plans READ, profiles READ");
    SendSQL("SELECT bug_id FROM bugs WHERE plan=" . SqlQuote($plan));
    while (MoreSQLData()) {
        my $bugid = FetchOneColumn();
        PushGlobalSQLState();
        SendSQL("DELETE FROM buckets WHERE id=$bugid AND pool=". SqlQuote($pool));
        PopGlobalSQLState();
    }
    SendSQL("DELETE FROM pools WHERE plan=" . SqlQuote($plan) . " AND pool=" . SqlQuote($pool));
    #SendSQL("DELETE FROM buckets LEFT JOIN bugs bugs.bug_id=buckets.id WHERE plan=" . SqlQuote($plan) . "
    #           AND pool=" . SqlQuote($pool));
}

#
# when action='' -> Show nice list of pools
#

sub ShowStages {
    CheckPlan($plan);

    print "<FORM METHOD=GET ACTION=editpools.cgi>\n";
    print "<TABLE BORDER=1 CELLPADDING=4 CELLSPACING=0><TR BGCOLOR=\"#6666FF\">\n";
    print "  <TH ALIGN=\"left\">Edit pool ...</TH>\n";
    print "  <TH ALIGN=\"left\">Units</TH>\n";
    print "  <TH ALIGN=\"left\">Description</TH>\n";
    print "  <TH ALIGN=\"left\">Action</TH>\n";
    print "</TR>";
    SendSQL("SELECT pool,plan,units,description
             FROM pools 
             WHERE plan=" . SqlQuote($plan) . "
             ORDER BY pool");
    while ( MoreSQLData() ) {
        my ($pool,$dummy,$units,$description) = FetchSQLData();
        $units ||= '';
        $description ||= '';
        print "<TR>\n";
        print "  <TD VALIGN=\"top\"><A HREF=\"editpools.cgi?plan=", url_quote($plan), 
               "&pool=", url_quote($pool), "&units=", url_quote($units), 
                "&description=", url_quote($description), "&action=edit\"><B>$pool</B></A></TD>\n";
        print "  <TD VALIGN=\"top\">$units</TD>\n";
        print "  <TD VALIGN=\"top\">$description</TD>\n";
        print "  <TD VALIGN=\"top\"><A HREF=\"editpools.cgi?plan=", url_quote($plan), 
               "&pool=", url_quote($pool), "&units=", url_quote($units), 
               "&description=", url_quote($description), "&action=del\"><B>Delete</B></A></TD>\n";
        print "</TR>";
    }
    print "<TR>\n";
    print "  <TD VALIGN=\"top\"><INPUT SIZE=40 MAXLENGTH=40 NAME=\"pool\" VALUE=\"" .
          "\"></TD>\n";
    print "  <TD VALIGN=\"top\"><INPUT SIZE=20 MAXLENGTH=20 NAME=\"units\" VALUE=\"" .
          value_quote($units) . "\"></TD>\n";
    print "  <TD VALIGN=\"top\"><INPUT SIZE=20 MAXLENGTH=20 NAME=\"description\" VALUE=\"" .
          value_quote($description) . "\"></TD>\n";
    print "  <TD VALIGN=\"top\"><INPUT TYPE=SUBMIT NAME=action VALUE=\"Add\"></td>\n";
    print "</TR></TABLE>\n";
    print " <INPUT TYPE=hidden name=plan VALUE=\"". url_quote($plan) ."\"></td>\n";
    print "</form>\n";
    print "<p>\n";
}

# edit a single specific pool
sub ShowEdit {
    CheckStage($plan,$pool);

    print "<FORM METHOD=GET ACTION=editpools.cgi>\n";
    print "<TABLE BORDER=0 CELLPADDING=4 CELLSPACING=0>\n";
    print "  <tr><TH ALIGN=\"right\">Modify pool:</TH>\n";
    print "  <TD>$pool</td></tr>\n";

    print "  <tr><TH ALIGN=\"right\">New name:</TH>\n";
    print "  <TD><INPUT SIZE=64 MAXLENGTH=64 NAME=\"pool\" VALUE=\"" .
        value_quote($pool) . "\">\n";
    print "      <INPUT TYPE=HIDDEN NAME=\"plan\" VALUE=\"" .
        value_quote($plan) . "\">\n";
    print "  </td></tr>\n";
    print "  <tr><TH ALIGN=\"right\">Units:</TH>\n";
    print "  <TD><INPUT SIZE=64 MAXLENGTH=64 NAME=\"units\" VALUE=\"" .
        value_quote($units) . "\"></td>\n";
    print "  </td></tr>\n";
    print "  <tr><TH ALIGN=\"right\">Description:</TH>\n";
    print "  <TD><INPUT SIZE=64 MAXLENGTH=64 NAME=\"description\" VALUE=\"" .
        value_quote($description) . "\"></td>\n";

    print "</TR></TABLE>\n";

    print "<INPUT TYPE=HIDDEN NAME=\"poolold\" VALUE=\"" .
        value_quote($pool) . "\">\n";
    print "<INPUT TYPE=HIDDEN NAME=\"action\" VALUE=\"update\">\n";
    print "<INPUT TYPE=SUBMIT VALUE=\"Update\">\n";

    print "</FORM>\n";
    print "<p>";
}

my $poolold = trim($::FORM{poolold} || '');
if ($action eq 'update') {
    CheckStage($plan,$poolold);
    SendSQL("UPDATE pools SET units=".SqlQuote($units)." WHERE plan=" . SqlQuote($plan) . " AND pool=" . SqlQuote($poolold));
}
if ($action eq 'update') {
    CheckStage($plan,$poolold);
    SendSQL("UPDATE pools SET description=".SqlQuote($description)." WHERE plan=" . SqlQuote($plan) . " AND pool=" . SqlQuote($poolold));
}

if ($action eq 'update' && length($pool) && $pool ne $poolold) {
    CheckStage($plan,$poolold);
    SendSQL("LOCK TABLES buckets WRITE, pools WRITE, bugs READ, plans READ, profiles READ");
    SendSQL("SELECT bug_id FROM bugs WHERE plan=" . SqlQuote($plan));
    while (MoreSQLData()) {
        my $bugid = FetchOneColumn();
        PushGlobalSQLState();
        SendSQL("UPDATE buckets SET pool=".SqlQuote($pool)." WHERE id=$bugid AND pool=". SqlQuote($poolold));
        PopGlobalSQLState();
    }
    #SendSQL("UPDATE FROM buckets LEFT JOIN bugs bugs.bug_id=buckets.id WHERE plan=" . SqlQuote($plan) . "
    #           AND pool=" . SqlQuote($pool));
    SendSQL("UPDATE pools SET pool=".SqlQuote($pool)." WHERE plan=" . SqlQuote($plan) . " AND pool=" . SqlQuote($poolold));
}


ShowEdit() if ($action eq 'edit');
ShowStages() if $plan;
ShowPlans();
PutTrailer();

