#!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is mozilla.org code.
#
# The Initial Developer of the Original Code is Holger
# Schurig. Portions created by Holger Schurig are
# Copyright (C) 1999 Holger Schurig. All
# Rights Reserved.
#
# Contributor(s): Holger Schurig <holgerschurig@nikocity.de>
#               Terry Weissman <terry@mozilla.org>
#               Rick Dean <software@fdd.com>
#
#
# Direct any questions on this source code to
#
# Holger Schurig <holgerschurig@nikocity.de>

use diagnostics;
use strict;

require "CGI.pl";
require "globals.pl";


# TestPlan:  just returns if the specified plan does exists
# CheckPlan: same check, optionally  emit an error text
# TestPool:  just returns if the specified plan/stage combination exists
# CheckPool: same check, optionally emit an error text

sub TestPlan ($)
{
    my $prod = shift;

    # does the plan exist?
    SendSQL("SELECT plan
             FROM plans
             WHERE plan=" . SqlQuote($prod));
    return FetchOneColumn();
}

sub CheckPlan ($)
{
    my $prod = shift;

    # do we have a plan?
    unless ($prod) {
        print "Sorry, you haven't specified a plan.";
        PutTrailer();
        exit;
    }

    unless (TestPlan $prod) {
        print "Sorry, plan '$prod' does not exist.";
        PutTrailer();
        exit;
    }
}

sub TestPool ($$)
{
    my ($prod,$stage) = @_;

    # does the plan exist?
    SendSQL("SELECT plan,stage
             FROM stages
             WHERE plan=" . SqlQuote($prod) . " and stage=" . SqlQuote($stage));
    return FetchOneColumn();
}

sub CheckPool ($$)
{
    my ($prod,$stage) = @_;

    # do we have the stage?
    unless ($stage) {
        print "Sorry, you haven't specified a stage.";
        PutTrailer();
        exit;
    }

    CheckPlan($prod);

    unless (TestPool($prod,$stage)) {
        print "Sorry, stage '$stage' for plan '$prod' does not exist.";
        PutTrailer();
        exit;
    }
}


#
# Displays a text like "a.", "a or b.", "a, b or c.", "a, b, c or d."
#

sub PutTrailer (@)
{
    my (@links) = ("Back to the <A HREF=\"query.cgi\">query page</A>", @_);

    my $count = $#links;
    my $num = 0;
    print "<P>\n";
    foreach (@links) {
        print $_;
        if ($num == $count) {
            print ".\n";
        }
        elsif ($num == $count-1) {
            print " or ";
        }
        else {
            print ", ";
        }
        $num++;
    }
    PutFooter();
}







#
# Preliminary checks:
#

confirm_login();

print "Content-type: text/html\n\n";

my $plan = trim($::FORM{'plan'} || '');
my $stage = trim($::FORM{'stage'} || '');
my $action  = trim($::FORM{'action'}  || '');
my $description  = trim($::FORM{'description'}  || '');
my $localtrailer;

if ($stage) {
    $localtrailer = "<A HREF=\"editstages.cgi?plan=" . url_quote($plan) . "\">edit</A> more stages";
} else {
    $localtrailer = "<A HREF=\"editstages.cgi\">edit</A> more stages";
}

if($plan) {
    PutHeader("Edit stages for $plan");
} else {
    PutHeader("Edit stages");
}
if($::FORM{'debug'}) {
   for my $key (sort(keys(%::FORM))) {
      print("$key {{$::FORM{$key}}}<br>\n");
   };
};

unless (UserInGroup("editcomponents")) {
    print "Sorry, you aren't a member of the 'editcomponents' group.\n";
    print "And so, you aren't allowed to add, modify or delete stages.\n";
    PutTrailer();
    exit;
}

sub ShowPlans {
    SendSQL("SELECT plans.plan,plans.description,'xyzzy'
             FROM plans 
             GROUP BY plans.plan
             ORDER BY plans.plan");
    print "<TABLE BORDER=1 CELLPADDING=4 CELLSPACING=0><TR BGCOLOR=\"#6666FF\">\n";
    print "  <TH ALIGN=\"left\">Edit stages of ...</TH>\n";
    print "  <TH ALIGN=\"left\">Description</TH>\n";
    print "  <TH ALIGN=\"left\">Features</TH>\n";
    #print "  <TH ALIGN=\"left\">Edit</TH>\n";
    print "</TR>";
    while ( MoreSQLData() ) {
        my ($plan, $description, $bugs) = FetchSQLData();
        $description ||= "<FONT COLOR=\"red\">missing</FONT>";
        $bugs ||= "none";
        print "<TR>\n";
        print "  <TD VALIGN=\"top\"><A HREF=\"editstages.cgi?plan=", url_quote($plan), "\"><B>$plan</B></A></TD>\n";
        print "  <TD VALIGN=\"top\">$description</TD>\n";
        print "  <TD VALIGN=\"top\">$bugs</TD>\n";
        #print "  <TD VALIGN=\"top\"><A HREF=\"editstages.cgi?action=edit&plan=", url_quote($plan), "\">Edit</A></TD>\n";
    }
    print "</TR></TABLE>\n";

    PutTrailer();
    exit;
}

if($action =~ /add/i) {
    CheckPlan($plan);
    if (!$stage) {
        print "<font color=red>You must enter a text for the new stage.</font><br>\n";
    } elsif (TestPool($plan,$stage)) {
        print "<font color=red>The stage '$stage' already exists.</font><br>\n";
    } else {
        # insert the new stage
        SendSQL("INSERT INTO stages ( stage, plan, description ) VALUES ( " .
              SqlQuote($stage) . "," .  SqlQuote($plan) . "," . SqlQuote($description) . ")");
        unlink "data/versioncache"; # Make versioncache flush
    };
}

# if user wants to delete
if ($action eq 'del') {
    CheckPlan($plan);
    SendSQL("LOCK TABLES buckets WRITE, stages WRITE, bugs READ, plans READ, profiles READ");
    SendSQL("SELECT bug_id FROM bugs WHERE plan=" . SqlQuote($plan));
    while (MoreSQLData()) {
        my $bugid = FetchOneColumn();
        PushGlobalSQLState();
        SendSQL("DELETE FROM buckets WHERE id=$bugid AND stage=". SqlQuote($stage));
        PopGlobalSQLState();
    }
    SendSQL("DELETE FROM stages WHERE plan=" . SqlQuote($plan) . " AND stage=" . SqlQuote($stage));
    #SendSQL("DELETE FROM buckets LEFT JOIN bugs bugs.bug_id=buckets.id WHERE plan=" . SqlQuote($plan) . "
    #           AND stage=" . SqlQuote($stage));
}

#
# when action='' -> Show nice list of stages
#

sub ShowPools {
    CheckPlan($plan);

    print "<FORM METHOD=GET ACTION=editstages.cgi>\n";
    print "<TABLE BORDER=1 CELLPADDING=4 CELLSPACING=0><TR BGCOLOR=\"#6666FF\">\n";
    print "  <TH ALIGN=\"left\">Edit stage ...</TH>\n";
    print "  <TH ALIGN=\"left\">Description</TH>\n";
    print "  <TH ALIGN=\"left\">Action</TH>\n";
    print "</TR>";
    SendSQL("SELECT stage,plan,description
             FROM stages 
             WHERE plan=" . SqlQuote($plan) . "
             ORDER BY stage");
    while ( MoreSQLData() ) {
        my ($stage,$dummy,$description,$bugs) = FetchSQLData();
        $description ||= '';
        print "<TR>\n";
        print "  <TD VALIGN=\"top\"><A HREF=\"editstages.cgi?plan=", url_quote($plan), 
               "&stage=", url_quote($stage), "&description=", url_quote($description), "&action=edit\"><B>$stage</B></A></TD>\n";
        print "  <TD VALIGN=\"top\">$description</TD>\n";
        print "  <TD VALIGN=\"top\"><A HREF=\"editstages.cgi?plan=", url_quote($plan), 
               "&stage=", url_quote($stage), "&description=", url_quote($description), "&action=del\"><B>Delete</B></A></TD>\n";
        print "</TR>";
    }
    print "<TR>\n";
    print "  <TD VALIGN=\"top\"><INPUT SIZE=40 MAXLENGTH=40 NAME=\"stage\" VALUE=\"" .
          "\"></TD>\n";
    print "  <TD VALIGN=\"top\"><INPUT SIZE=20 MAXLENGTH=20 NAME=\"description\" VALUE=\"" .
          value_quote($description) . "\"></TD>\n";
    print "  <TD VALIGN=\"top\"><INPUT TYPE=SUBMIT NAME=action VALUE=\"Add\"></td>\n";
    print "</TR></TABLE>\n";
    print " <INPUT TYPE=hidden name=plan VALUE=\"". url_quote($plan) ."\"></td>\n";
    print "</form>\n";
    print "<p>\n";
}

# edit a single specific stage
sub ShowEdit {
    CheckPool($plan,$stage);

    print "<FORM METHOD=GET ACTION=editstages.cgi>\n";
    print "<TABLE BORDER=0 CELLPADDING=4 CELLSPACING=0>\n";
    print "  <tr><TH ALIGN=\"right\">Modify stage:</TH>\n";
    print "  <TD>$stage</td></tr>\n";

    print "  <tr><TH ALIGN=\"right\">New name:</TH>\n";
    print "  <TD><INPUT SIZE=64 MAXLENGTH=64 NAME=\"stage\" VALUE=\"" .
        value_quote($stage) . "\">\n";
    print "      <INPUT TYPE=HIDDEN NAME=\"plan\" VALUE=\"" .
        value_quote($plan) . "\">\n";
    print "  </td></tr>\n";
    print "  <tr><TH ALIGN=\"right\">Description:</TH>\n";
    print "  <TD><INPUT SIZE=64 MAXLENGTH=64 NAME=\"description\" VALUE=\"" .
        value_quote($description) . "\"></td>\n";

    print "</TR></TABLE>\n";

    print "<INPUT TYPE=HIDDEN NAME=\"stageold\" VALUE=\"" .
        value_quote($stage) . "\">\n";
    print "<INPUT TYPE=HIDDEN NAME=\"action\" VALUE=\"update\">\n";
    print "<INPUT TYPE=SUBMIT VALUE=\"Update\">\n";

    print "</FORM>\n";
    print "<p>";
}

my $stageold = trim($::FORM{stageold} || '');
if ($action eq 'update') {
    CheckPool($plan,$stageold);
    SendSQL("UPDATE stages SET description=".SqlQuote($description)." WHERE plan=" . SqlQuote($plan) . " AND stage=" . SqlQuote($stageold));
}
if ($action eq 'update' && length($stage) && $stage ne $stageold) {
    CheckPool($plan,$stageold);
    SendSQL("LOCK TABLES buckets WRITE, stages WRITE, bugs READ, plans READ, profiles READ");
    SendSQL("SELECT bug_id FROM bugs WHERE plan=" . SqlQuote($plan));
    while (MoreSQLData()) {
        my $bugid = FetchOneColumn();
        PushGlobalSQLState();
        SendSQL("UPDATE buckets SET stage=".SqlQuote($stage)." WHERE id=$bugid AND stage=". SqlQuote($stageold));
        PopGlobalSQLState();
    }
    #SendSQL("UPDATE FROM buckets LEFT JOIN bugs bugs.bug_id=buckets.id WHERE plan=" . SqlQuote($plan) . "
    #           AND stage=" . SqlQuote($stage));
    SendSQL("UPDATE stages SET stage=".SqlQuote($stage)." WHERE plan=" . SqlQuote($plan) . " AND stage=" . SqlQuote($stageold));
}


ShowEdit() if ($action eq 'edit');
ShowPools() if $plan;
ShowPlans();
PutTrailer();

