#!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
# 
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are Copyright (C) 1998
# Netscape Communications Corporation. All Rights Reserved.
# 
# Contributor(s): Terry Weissman <terry@mozilla.org>
#                 Dave Miller <justdave@syndicomm.com>
#                 Joe Robins <jmrobins@tgix.com>
#                 Rick Dean <software@fdd.com>


########################################################################
#
# enter_bug.cgi
# -------------
# Displays feature entry form. Bug fields are specified through popup menus, 
# drop-down lists, or text fields. Default for these values can be passed
# in as parameters to the cgi.
#
########################################################################

use diagnostics;
use strict;

require "CGI.pl";

# Shut up misguided -w warnings about "used only once".  "use vars" just
# doesn't work for me.

sub sillyness {
    my $zz;
    $zz = @::legal_sponsor;
    $zz = @::legal_committee;
    $zz = @::legal_severity;
    $zz = @::legal_status;
}

# I've moved the call to confirm_login up to here, since if we're using bug
# groups to restrict feature entry, we need to know who the user is right from
# the start.  If that parameter is turned off, there's still no harm done in
# doing it now instead of a bit later.  -JMR, 2/18/00
# Except that it will cause people without cookies enabled to have to log
# in an extra time.  Only do it here if we really need to.  -terry, 3/10/00
if (Param("usebuggroupsentry")) {
    confirm_login();
}

if (!defined $::FORM{'plan'}) {
    GetVersionTable();
    my @prodlist;
    foreach my $p (sort(keys %::versions)) {
        if (defined $::proddesc{$p} && $::proddesc{$p} eq '0') {
            # Special hack.  If we stuffed a "0" into proddesc, that means
            # that disallownew was set for this bug, and so we don't want
            # to allow people to specify that plan here.
            next;
        }
        if(Param("usebuggroupsentry")
           && GroupExists($p)
           && !UserInGroup($p)) {
          # If we're using feature groups to restrict entry on plans, and
          # this plan has a feature group, and the user is not in that
          # group, we don't want to include that plan in this list.
          next;
        }
        push(@prodlist, $p);
    }
    if (0 == @prodlist) {
        print "Content-type: text/html\n\n";
        PutHeader("No Plans Available");

        print "Either no plans have been defined to enter features against ";
        print "or you have not been given access to any.  Please email ";
        print "<A HREF=\"mailto:" . Param("maintainer") . "\">";
        print Param("maintainer") . "</A> if you feel this is in error.<P>\n";

        PutFooter();
        exit;
    } elsif (1 < @prodlist) {
        print "Content-type: text/html\n\n";
        PutHeader("Enter Bug");
        
        print "<H2>First, you must pick a plan on which to enter\n";
        print "a bug.</H2>\n";
        print "<table>";
        foreach my $p (@prodlist) {
# removed $::proddesc{$p} eq '0' check and UserInGroup($p) check from here
# because it's redundant.  See the foreach loop above that created @prodlist.
# 1/13/01 - dave@intrec.com
            print "<tr><th align=right valign=top><a href=\"enter_bug.cgi?plan=" . url_quote($p) . "\">$p</a>:</th>\n";
            if (defined $::proddesc{$p}) {
                print "<td valign=top>$::proddesc{$p}</td>\n";
            }
            print "</tr>";
        }
        print "</table>\n";
        PutFooter();
        exit;
    }
    $::FORM{'plan'} = $prodlist[0];
}

my $plan = $::FORM{'plan'};

confirm_login();

print "Content-type: text/html\n\n";

sub formvalue {
    my ($name, $default) = (@_);
    if (exists $::FORM{$name}) {
        return $::FORM{$name};
    }
    if (defined $default) {
        return $default;
    }
    return "";
}

sub pickcommittee {
    my $value = formvalue("committee");
    if ($value ne "") {
        return $value;
    }
    # default
    return "Other";
}



sub pickversion {
    my $version = formvalue('version');

    if (lsearch($::versions{$plan}, $version) >= 0) {
        return $version;
    } else {
        if (defined $::COOKIE{"VERSION-$plan"}) {
            if (lsearch($::versions{$plan},
                        $::COOKIE{"VERSION-$plan"}) >= 0) {
                return $::COOKIE{"VERSION-$plan"};
            }
        }
    }
    return $::versions{$plan}->[0];
}

sub pickmilestone {
    my $version = formvalue('milestone');

    if (lsearch($::milestone_list{$plan}, $version) >= 0) {
        return $version;
    } else {
        if (defined $::COOKIE{"MILESTONE-$plan"}) {
            if (lsearch($::versions{$plan},
                        $::COOKIE{"MILESTONE-$plan"}) >= 0) {
                return $::COOKIE{"MILESTONE-$plan"};
            }
        }
    }
    return $::milestones{$plan}->[0];
}

sub pickcomponent {
    my $result =formvalue('component');
    if ($result ne "" && lsearch($::components{$plan}, $result) < 0) {
        $result = "";
    }
    return $result;
}


sub picksponsor {
    if (formvalue('sponsor') ne "") {
        return formvalue('sponsor');
    }
    # default
    return "other";
}


GetVersionTable();

my $assign_element = GeneratePersonInput('assigned_to', 1,
                                         formvalue('assigned_to'));
my $cc_element = GeneratePeopleInput('cc', formvalue('cc'));


my $priority = Param('defaultpriority');

my ($sev_popup, $sev_name);
if(Param("useseverity")) {
    $sev_popup = make_popup('bug_severity', \@::legal_severity,
                           formvalue('bug_severity', 'normal'), 0);
    $sev_name = "<B><A HREF=\"fields.html#severity\">Severity:</A></B>";
} else {
    $sev_popup = "<input type=hidden name=severity value=normal>";
    $sev_name = "";
}
my $committee_popup = make_popup('committee', \@::legal_committee,
                                pickcommittee(), 0);
my $sponsor_popup = make_popup('sponsor', \@::legal_sponsor, picksponsor(), 0);
my $status_popup = make_popup('status', \@::legal_status,
                                $::legal_status[0], 0);

if (0 == @{$::components{$plan}}) {
	print "<H1>Permission Denied</H1>\n";
	print "Sorry.  You need to have at least one component for this plan\n";
	print "in order to create a new bug.  Go to the \"Components\" link to create\n";
	print "a new component\n";
	print "<P>\n";
	PutFooter();
	exit;
} elsif (1 == @{$::components{$plan}}) {
    # Only one component; just pick it.
    $::FORM{'component'} = $::components{$plan}->[0];
}

my $component_popup = make_popup('component', $::components{$plan},
                                 formvalue('component'), 1);

PutHeader ("Enter Feature","Enter Feature","This page lets you enter a new feature into FeatureKong.");

# Modified, -JMR, 2/24,00
# If the usebuggroupsentry parameter is set, we need to check and make sure
# that the user has permission to enter a feature against this plan.
# Modified, -DDM, 3/11/00
# added GroupExists check so we don't choke on a groupless plan
if(Param("usebuggroupsentry")
   && GroupExists($plan)
   && !UserInGroup($plan)) {
  print "<H1>Permission denied.</H1>\n";
  print "Sorry; you do not have the permissions necessary to enter\n";
  print "a feature against this plan.\n";
  print "<P>\n";
  PutFooter();
  exit;
}

# Modified, -JMR, 2/18/00
# I'm putting in a select box in order to select whether to restrict this feature to
# the plan's feature group or not, if the usebuggroups parameter is set, and if
# this plan has a feature group.  This box will default to selected, but can be
# turned off if this feature should be world-viewable for some reason.
#
# To do this, I need to (1) get the bit and description for the feature group from
# the database, (2) insert the select box in the giant print statements below,
# and (3) update post_bug.cgi to process the additional input field.

# Modified, -DDM, 3/11/00
# Only need the bit here, and not the description.  Description is gotten
# when the select boxes for all the groups this user has access to are read
# in later on.
# First we get the bit and description for the group.
my $group_bit=0;
if(Param("usebuggroups") && GroupExists($plan)) {
    SendSQL("select bit from groups ".
            "where name = ".SqlQuote($plan)." ".
            "and isbuggroup != 0");
    ($group_bit) = FetchSQLData();
}

print "
<FORM METHOD=POST ACTION=\"post_bug.cgi\">
<INPUT TYPE=HIDDEN NAME=reporter VALUE=\"$::COOKIE{'FeatureKong_login'}\">
<INPUT TYPE=HIDDEN NAME=plan VALUE=\""  . value_quote($plan) . "\">
  <TABLE CELLSPACING=2 CELLPADDING=0 BORDER=0>";

if (Param("entryheaderhtml")){
  print "
  <TR>
    <td></td>
    <td colspan=3>" .
  Param("entryheaderhtml") . "\n" .
  " </td> 
  </TR>
  <TR><td><br></td></TR>";
}

print "
  <TR>
    <td ALIGN=right valign=top><B>Reporter:</B></td>
    <td valign=top>$::COOKIE{'FeatureKong_login'}</td>
    <td ALIGN=right valign=top><B>Plan:</B></td>
    <td valign=top>$plan</td>
  </TR>
  <TR>
";
if (Param("useversion")) {       
    print "<td ALIGN=right valign=top><B>Reported on Version:</B></td>
    <td>" . Version_element(pickversion(), $plan) . "</td>\n";
} 
if(Param("usetargetmilestone")) {
    print "<td ALIGN=right valign=top><B>Target Release:</B></td>
    <td>" . Milestone_element(pickmilestone(), $plan) . "</td>\n";
} 
if(!Param("usetargetmilestone") && !Param("useversion")) {
    print "<td>&nbsp;</td><td>&nbsp;</td>\n";
}
print "
    <td align=right valign=top><b><a href=\"describecomponents.cgi?plan=" .
    url_quote($plan) . "\">Component:</a></b></td>
    <td>$component_popup</td>
  </TR>
  <tr><td>&nbsp<td> <td> <td> <td> <td> </tr>
  <TR>
    <td align=right><B><A HREF=\"fields.html#framework\">Framework:</A></B></td>
    <TD>$committee_popup</TD>
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html#sponsor\">Sponsor:</A></B></TD>
    <TD>$sponsor_popup</TD>
    <td align=right valign=top></td>
    <td rowspan=3></td>
    <td></td>
  </TR>
  <TR>";
if (Param('letsubmitterchoosepriority')) {
    print "
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html#priority\">
    Resolution<br>Priority</A>:</B></TD>
    <TD><INPUT NAME=priority SIZE=8 value=\"" . 
    value_quote($priority) . "\"> (1 is most urgent)</TD>";
} else {
    print '<INPUT TYPE=HIDDEN NAME=priority VALUE="' .
        value_quote($priority) . '">';
}
print "
    <TD ALIGN=RIGHT>$sev_name</TD>
    <TD>$sev_popup</TD>
    <td></td>
    <td></td>
  </TR>
  <tr><td>&nbsp<td> <td> <td> <td> <td> </tr>
";

print qq{
  <TR>
    <TD ALIGN="right"><B><A HREF="fields.html#status">State:</B></A></TD>
    <TD COLSPAN="5">$status_popup</TD></TR>
};

print "
  <tr>
    <TD ALIGN=RIGHT><B><A HREF=\"fields.html#assigned_to\">Assigned To:</A></B></TD>
    <TD colspan=5>$assign_element </td>
  </tr>
  <tr>
    <TD ALIGN=RIGHT><B>Cc:</B></TD>
    <TD colspan=5>$cc_element</TD>
  </tr>
  <tr><td>&nbsp<td> <td> <td> <td> <td> </tr>
  <TR>
    <TD ALIGN=RIGHT><B>URL:</B>
    <TD COLSPAN=5>
      <INPUT NAME=bug_file_loc SIZE=60 value=\"http://" .
    value_quote(formvalue('bug_file_loc')) .
    "\"></TD>
  </TR>
  <TR>
    <TD ALIGN=RIGHT><B>Feature Name:</B>
    <TD COLSPAN=5>
      <INPUT NAME=short_desc SIZE=60 value=\"" .
    value_quote(formvalue('short_desc')) .
    "\"></TD>
  </TR>
  <tr><td align=right valign=top><B>Description:</b></td>
<!--  </tr> <tr> -->
    <td colspan=5><TEXTAREA WRAP=HARD NAME=big_desc ROWS=20 COLS=80>" .
    value_quote(formvalue('comment')) .
    "</TEXTAREA><BR></td>
  </tr>";

print "
  <tr>
   <td></td><td colspan=5>
";

if ($::usergroupset ne '0') {
    SendSQL("SELECT bit, name, description FROM groups " .
            "WHERE bit & $::usergroupset != 0 " .
            "  AND isbuggroup != 0 AND isactive = 1 ORDER BY description");
    # We only print out a header bit for this section if there are any
    # results.
    my $groupFound = 0;
    while (MoreSQLData()) {
        my ($bit, $prodname, $description) = (FetchSQLData());
        # Don't want to include plan groups other than this plan.
        unless(($prodname eq $plan) || (!defined($::proddesc{$prodname}))) {
            next;
        }
        if(!$groupFound) {
          print "<br><b>Only users in the selected groups can view this bug:</b><br>\n";
          print "<font size=\"-1\">(Leave all boxes unchecked to make this a public bug.)</font><br><br>\n";
          $groupFound = 1;
        }
        # Rather than waste time with another Param check and another database
        # access, $group_bit will only have a non-zero value if we're using
        # feature groups and have  one for this plan, so I'll check on that
        # instead here.  -JMR, 2/18/00
        # Moved this check to this location to fix conflict with existing
        # select-box patch.  Also, if $group_bit is 0, it won't match the
        # current group, either, so I'll compare it to the current bit
        # instead of checking for non-zero. -DDM, 3/11/00
        # Modifying this to use checkboxes instead of a select list.
        # -JMR, 5/11/01
        # If this is the group for this plan, make it checked.
        my $check = ($group_bit == $bit);
        # If this is a bookmarked template, then we only want to set the bit
        # for those bits set in the template.
        if(formvalue("maketemplate","") eq "Remember values as bookmarkable template") {
          $check = formvalue("bit-$bit",0);
        }
        my $checked = $check ? " CHECKED" : "";
        # indent these a bit
        print "&nbsp;&nbsp;&nbsp;&nbsp;";
        print "<input type=checkbox name=\"bit-$bit\" value=1$checked>\n";
        print "$description<br>\n";
    }
}

print "
   </td>
  </tr>
  <tr>
    <td></td>
    <td colspan=5>
       <INPUT TYPE=\"submit\" VALUE=\"    Commit    \" ONCLICK=\"if (this.form.short_desc.value =='') { alert('Please enter a name for this feature.'); return false; }\">
       &nbsp;&nbsp;&nbsp;&nbsp;
       <INPUT TYPE=\"reset\" VALUE=\"Reset\">
       &nbsp;&nbsp;&nbsp;&nbsp;
       <INPUT TYPE=\"submit\" NAME=maketemplate VALUE=\"Remember values as bookmarkable template\">
    </td>
  </tr>";


SendSQL("SELECT pool, units FROM pools WHERE plan = " . SqlQuote($::FORM{'plan'}));
my @pools = ();
my %units;
while(my ($pool, $units) = FetchSQLData()) {
   push(@pools,$pool);
   $units{$pool} = $units;
};
SendSQL("SELECT stage FROM stages WHERE plan = " . SqlQuote($::FORM{'plan'}));
my @stages = ();
while(my($stage) = FetchSQLData()) {
   push(@stages,$stage);
};
 
@pools = ("header",@pools);
@stages = ("header",@stages, "units");
print("<tr><td>&nbsp;</td><td colspan=5><br>\n");
print("<table border=0 cellspacing=0 bgcolor=dddddd>\n");
for my $stage (@stages) {
  print(" <tr>\n");
  for my $pool (@pools) {
    if ($stage eq 'header') {
      if($pool eq 'header') {
        print("   <td>&nbsp;</td>\n");
      } else {
        print("   <th>$pool</th>\n");
      };
    } elsif($pool eq 'header') {
      print("   <th>$stage</th>\n");
    } elsif ($stage eq 'units') {
      print("   <td>$units{$pool}&nbsp;</td>\n");
    } else {
      print("   <td><INPUT NAME=\"". html_quote(url_quote("$pool-bUcK-$stage")) . "\" SIZE=10></TD>\n");
    }
  }
  print("</tr>\n");
}
print("</table>\n");
print("</td></tr>\n");

print "
  </TABLE>
  <INPUT TYPE=hidden name=form_name VALUE=enter_bug>\n
  </FORM>\n";

PutFooter();

print "</BODY></HTML>\n";

