#!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): Terry Weissman <terry@mozilla.org>
#                 Dan Mosedale <dmose@mozilla.org>
#                 Joe Robins <jmrobins@tgix.com>
#                 Rick Dean <software@fdd.com>

use diagnostics;
use strict;

require "CGI.pl";

# Shut up misguided -w warnings about "used only once".  For some reason,
# "use vars" chokes on me when I try it here.

sub sillyness {
    my $zz;
    $zz = $::buffer;
    $zz = $::usergroupset;
    $zz = %::COOKIE;
    $zz = %::components;
    $zz = %::versions;
    $zz = @::legal_status;
    $zz = @::legal_sponsor;
    $zz = @::legal_committee;
    $zz = @::legal_plan;
    $zz = @::legal_severity;
    $zz = %::target_milestone;
}

confirm_login();

print "Set-Cookie: PLATFORM=$::FORM{'plan'} ; path=/ ; expires=Sun, 30-Jun-2029 00:00:00 GMT\n" if ( exists $::FORM{'plan'} );
print "Set-Cookie: VERSION-$::FORM{'plan'}=$::FORM{'version'} ; path=/ ; expires=Sun, 30-Jun-2029 00:00:00 GMT\n" if ( exists $::FORM{'plan'} && exists $::FORM{'version'} );

print "Content-type: text/html\n\n";

if (defined $::FORM{'maketemplate'}) {
    print "<TITLE>Bookmarks are your friend.</TITLE>\n";
    print "<H1>Template constructed.</H1>\n";
    
    my $url = "enter_bug.cgi?$::buffer";

    print "If you put a bookmark <a href=\"$url\">to this link</a>, it will\n";
    print "bring up the submit-a-new-feature page with the fields initialized\n";
    print "as you've requested.\n";
    PutFooter();
    exit;
}

PutHeader("Posting Feature -- Please wait", "Posting Bug", "One moment please...");

umask 0;
ConnectToDatabase();

my $plan = $::FORM{'plan'};

if(Param("usebuggroupsentry") && GroupExists($plan)) {
  if(!UserInGroup($plan)) {
    print "<H1>Permission denied.</H1>\n";
    print "Sorry; you do not have the permissions necessary to enter\n";
    print "a feature against this plan.\n";
    print "<P>\n";
    PutFooter();
    exit;
  }
}

if (!defined $::FORM{'component'} || $::FORM{'component'} eq "") {
    PuntTryAgain("You must choose a component that corresponds to this bug. " .
                 "If necessary, just guess.");
}

if (!defined $::FORM{'short_desc'} || trim($::FORM{'short_desc'}) eq "") {
    PuntTryAgain("You must enter a summary for this bug.");
}

if ($::FORM{'assigned_to'} eq "") {
    SendSQL("select initialowner from components where plan=" .
            SqlQuote($::FORM{'plan'}) .
            " and value=" . SqlQuote($::FORM{'component'}));
    $::FORM{'assigned_to'} = FetchOneColumn();
} else {
    $::FORM{'assigned_to'} = DBNameToIdAndCheck($::FORM{'assigned_to'});
}

$::FORM{'reporter'} = DBNameToIdAndCheck($::FORM{'reporter'});


my @bug_fields = ("reporter", "plan", "version", "committee",
                  "bug_severity", "priority", "sponsor", "assigned_to",
                  "status", "bug_file_loc", "short_desc", "component",
                  "target_milestone", "big_desc");

if (Param("useqacontact")) {
    SendSQL("select initialqacontact from components where plan=" .
            SqlQuote($::FORM{'plan'}) .
            " and value=" . SqlQuote($::FORM{'component'}));
    my $qacontact = FetchOneColumn();
    if (defined $qacontact && $qacontact != 0) {
        $::FORM{'qa_contact'} = $qacontact;
        push(@bug_fields, "qa_contact");
    }
}

if (!$::FORM{'status'}) {
    $::FORM{'status'} = "New";
}

if (!exists $::FORM{'target_milestone'}) {
    SendSQL("SELECT defaultmilestone FROM plans " .
            "WHERE plan = " . SqlQuote($::FORM{'plan'}));
    $::FORM{'target_milestone'} = FetchOneColumn();
}

if ( Param("strictvaluechecks") ) {
    GetVersionTable();  
    CheckFormField(\%::FORM, 'reporter');
    CheckFormField(\%::FORM, 'plan', \@::legal_plan);
    CheckFormField(\%::FORM, 'version', \@{$::versions{$::FORM{'plan'}}});
    CheckFormField(\%::FORM, 'target_milestone',
                   \@{$::target_milestone{$::FORM{'plan'}}});
    CheckFormField(\%::FORM, 'committee', \@::legal_committee);
    CheckFormField(\%::FORM, 'bug_severity', \@::legal_severity);
    CheckFormField(\%::FORM, 'sponsor', \@::legal_sponsor);
    CheckFormFieldDefined(\%::FORM, 'assigned_to');
    CheckFormField(\%::FORM, 'status', \@::legal_status);
    CheckFormFieldDefined(\%::FORM, 'bug_file_loc');
    CheckFormField(\%::FORM, 'component', 
                   \@{$::components{$::FORM{'plan'}}});
    CheckFormFieldDefined(\%::FORM, 'big_desc');
    CheckFormFieldDefined(\%::FORM, 'priority');
}

my @used_fields;
foreach my $f (@bug_fields) {
    if (exists $::FORM{$f}) {
        push (@used_fields, $f);
    }
}

my $query = "INSERT INTO bugs (\n" . join(",\n", @used_fields) . ",
creation_ts, groupset)
VALUES (
";

foreach my $field (@used_fields) {
# fix for 42609. if there is a http:// only in bug_file_loc, strip
# it out and send an empty value. 
    if ($field eq 'bug_file_loc') {
       if ($::FORM{$field} eq 'http://') {
           $::FORM{$field} = "";
           $query .= SqlQuote($::FORM{$field}) . ",\n";
           next;
       } 
       else {
          $query .= SqlQuote($::FORM{$field}) . ",\n";
       }
    }
    else {
       $query .= SqlQuote($::FORM{$field}) . ",\n";
    }
}

my $big_desc = $::FORM{'big_desc'};
$big_desc =~ s/\r\n/\n/g;     # Get rid of windows-style line endings.
$big_desc =~ s/\r/\n/g;       # Get rid of mac-style line endings.
$big_desc = trim($big_desc);
# If big_desc is all whitespace, it'll be null at this point.  That's
# OK except for the fact that it causes e-mail to be suppressed.
$big_desc = $big_desc ? $big_desc : " ";

$query .= "now(), (0";

foreach my $b (grep(/^bit-\d*$/, keys %::FORM)) {
    if ($::FORM{$b}) {
        my $v = substr($b, 4);
        $v =~ /^(\d+)$/
          || PuntTryAgain("One of the group bits submitted was invalid.");
        if (!GroupIsActive($v)) {
            # Prevent the user from adding the feature to an inactive group.
            # Should only happen if there is a feature in FeatureKong or the user
            # hacked the "enter bug" form since otherwise the UI 
            # for adding the feature to the group won't appear on that form.
            PuntTryAgain("You can't add this feature to the inactive group " . 
                         "identified by the bit '$v'. This shouldn't happen, " . 
                         "so it may indicate a feature in FeatureKong.");
        }
        $query .= " + $v";    # Carefully written so that the math is
                                # done by MySQL, which can handle 64-bit math,
                                # and not by Perl, which I *think* can not.
    }
}



$query .= ") & $::usergroupset)\n";


my %ccids;


if (defined $::FORM{'cc'}) {
    foreach my $person (split(/[ ,]/, $::FORM{'cc'})) {
        if ($person ne "") {
            $ccids{DBNameToIdAndCheck($person)} = 1;
        }
    }
}

my $oldpriority = $::FORM{'priority'};
$::FORM{'priority'} =~ s/.*?(\d+).*/$1/;  # keep only integer
if($::FORM{'priority'} !~ /^\d+$/) {  # if not integerlike
    $::FORM{'priority'} = Param("defaultpriority");
};
if($::FORM{'priority'} ne $oldpriority) {
   print("<font color=red>Warning: priority changed from $oldpriority to $::FORM{'priority'}</font><br>\n");
}

# print "<PRE>$query</PRE>\n";

SendSQL($query);

SendSQL("select LAST_INSERT_ID()");
my $id = FetchOneColumn();

foreach my $person (keys %ccids) {
    SendSQL("insert into cc (bug_id, who) values ($id, $person)");
}

for my $key (keys(%::FORM)) {
   next if($key !~ /^(.*?)-bUcK-(.*?)$/);
   my($pool,$stage) = ($1,$2);
   $pool = url_decode(url_decode($pool));
   $stage = url_decode(url_decode($stage));
   my $effort = $::FORM{$key};
   if($effort =~ /^-?[\d\.]+$/) {
      SendSQL("REPLACE INTO buckets SET effort=$effort, pool=" .
              SqlQuote($pool) . ", stage=" .  SqlQuote($stage) . ", id=$id" );
   };
};

SendSQL("INSERT INTO big_desc_hist " .
        "(bug_id,who,bug_when,thetext,version) VALUES " .
        "($id,$::FORM{'reporter'},now(),".SqlQuote($::FORM{big_desc}).",0)");

print "<TABLE BORDER=1><TD><H2>Feature $id posted</H2>\n";
system("./processmail", $id, $::COOKIE{'FeatureKong_login'});
print "<TD><A HREF=\"show_bug.cgi?id=$id\">Back To Feature# $id</A></TABLE>\n";

print "<BR><A HREF=\"createattachment.cgi?id=$id\">Attach a file to this bug</a>\n";

navigation_header();

PutFooter();
exit;
