##!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): Rick Dean <software@fdd.com>
#                 Terry Weissman <terry@mozilla.org>
#                 Dan Mosedale <dmose@mozilla.org>

use diagnostics;
use strict;

require "CGI.pl";
use Date::Parse;

# Shut up misguided -w warnings about "used only once".  "use vars" just
# doesn't work for me.

sub sillyness {
    my $zz;
    $zz = $::defaultqueryname;
    $zz = $::unconfirmedstate;
    $zz = @::components;
    $zz = @::default_column_list;
    $zz = @::keywordsbyname;
    $zz = @::legal_keywords;
    $zz = @::legal_committee;
    $zz = @::legal_plan;
    $zz = @::legal_severity;
    $zz = @::versions;
    $zz = @::target_milestone;
};

my $serverpush = 0;

ConnectToDatabase();

#print "Content-type: text/plain\n\n";    # Handy for debugging.
#$::FORM{'debug'} = 1;


if (!defined $::FORM{'cmdtype'}) {
    # This can happen if there's an old bookmark to a query...
    $::FORM{'cmdtype'} = 'doit';
}


sub SqlifyDate {
    my ($str) = (@_);
    if (!defined $str) {
        $str = "";
    }
    my $date = str2time($str);
    if (!defined $date) {
        PuntTryAgain("The string '<tt>$str</tt>' is not a legal date.");
    }
    return time2str("%Y/%m/%d %H:%M:%S", $date);
}


sub GetByWordList {
    my ($field, $strs) = (@_);
    my @list;

    foreach my $w (split(/[\s,]+/, $strs)) {
        my $word = $w;
        if ($word ne "") {
            $word =~ tr/A-Z/a-z/;
            $word = SqlQuote(quotemeta($word));
            $word =~ s/^'//;
            $word =~ s/'$//;
            $word = '(^|[^a-z0-9])' . $word . '($|[^a-z0-9])';
            push(@list, "lower($field) regexp '$word'");
        }
    }

    return \@list;
}

sub Error {
    my ($str) = (@_);
    if (!$serverpush) {
        print "Content-type: text/html\n\n";
    }
    PuntTryAgain($str);
}

sub GenerateSQL {
    my $debug = 0;
    my ($fieldsref, $supptablesref, $wherepartref, $urlstr) = (@_);
    my @fields;
    my @supptables;
    my @wherepart;
    @fields = @$fieldsref if $fieldsref;
    @supptables = @$supptablesref if $supptablesref;
    @wherepart = @$wherepartref if $wherepartref;
    my %F;
    my %M;
    ParseUrlString($urlstr, \%F, \%M);
    my @specialchart;
    my @andlist;

    # First, deal with all the old hard-coded non-chart-based poop.

    unshift(@supptables,
            ("profiles map_assigned_to",
             "profiles map_reporter",
             "LEFT JOIN profiles map_qa_contact ON bugs.qa_contact = map_qa_contact.userid"));
    unshift(@wherepart,
            ("bugs.assigned_to = map_assigned_to.userid",
             "bugs.reporter = map_reporter.userid",
             "bugs.groupset & $::usergroupset = bugs.groupset"));
            

    my $minvotes;
    if (defined $F{'votes'}) {
        my $c = trim($F{'votes'});
        if ($c ne "") {
            if ($c !~ /^[0-9]*$/) {
                return Error("The 'At least ___ votes' field must be a\n" .
                             "simple number. You entered \"$c\", which\n" .
                             "doesn't cut it.");
            }
            push(@specialchart, ["votes", "greaterthan", $c - 1]);
        }
    }

    if ($M{'bug_id'}) {
        my $type = "anyexact";
        if ($F{'bugidtype'} && $F{'bugidtype'} eq 'exclude') {
            $type = "noexact";
        }
        push(@specialchart, ["bug_id", $type, join(',', @{$M{'bug_id'}})]);
    }

    if (defined $F{'sql'}) {
        die "Invalid sql: $F{'sql'}" if $F{'sql'} =~ /;/;
        push(@wherepart, "( $F{'sql'} )");
    }

    my @legal_fields = ("plan", "version", "committee", "sponsor",
                        "status", "priority", "bug_severity",
                        "assigned_to", "reporter", "component",
                        "target_milestone", "groupset");

    foreach my $field (keys %F) {
        if (lsearch(\@legal_fields, $field) != -1) {
            push(@specialchart, [$field, "anyexact",
                                 join(',', @{$M{$field}})]);
        }
    }

    if ($F{'keywords'}) {
        my $t = $F{'keywords_type'};
        if (!$t || $t eq "or") {
            $t = "anywords";
        }
        push(@specialchart, ["keywords", $t, $F{'keywords'}]);
    }

    foreach my $id ("1", "2") {
        if (!defined ($F{"email$id"})) {
            next;
        }
        my $email = trim($F{"email$id"});
        if ($email eq "") {
            next;
        }
        my $type = $F{"emailtype$id"};
        if ($type eq "exact") {
            $type = "anyexact";
            foreach my $name (split(',', $email)) {
                $name = trim($name);
                if ($name) {
                    DBNameToIdAndCheck($name);
                }
            }
        }

        my @clist;
        foreach my $field ("assigned_to", "reporter", "cc", "qa_contact") {
            if ($F{"email$field$id"}) {
                push(@clist, $field, $type, $email);
            }
        }
        if ($F{"emaillongdesc$id"}) {
            my $table = "longdescs_";
            push(@supptables, "longdescs $table");
            push(@wherepart, "$table.bug_id = bugs.bug_id");
            my $ptable = "longdescnames_";
            push(@supptables,
                 "LEFT JOIN profiles $ptable ON $table.who = $ptable.userid");
            push(@clist, "$ptable.login_name", $type, $email);
        }
        if (@clist) {
            push(@specialchart, \@clist);
        } else {
            return Error("You must specify one or more fields in which to\n" .
                  "search for <tt>$email</tt>.\n");
        }
    }

                
    if (defined $F{'changedin'}) {
        my $c = trim($F{'changedin'});
        if ($c ne "") {
            if ($c !~ /^[0-9]*$/) {
                return Error("The 'changed in last ___ days' field must be\n" .
                             "a simple number. You entered \"$c\", which\n" .
                             "doesn't cut it.");
            }
            push(@specialchart, ["changedin",
                                 "lessthan", $c + 1]);
        }
    }

    my $ref = $M{'chfield'};

    if (defined $ref) {
        my $which = lsearch($ref, "[feature creation]");
        if ($which >= 0) {
            splice(@$ref, $which, 1);
            push(@specialchart, ["creation_ts", "greaterthan",
                                 SqlifyDate($F{'chfieldfrom'})]);
            my $to = $F{'chfieldto'};
            if (defined $to) {
                $to = trim($to);
                if ($to ne "" && $to !~ /^now$/i) {
                    push(@specialchart, ["creation_ts", "lessthan",
                                         SqlifyDate($to)]);
                }
            }
        }
    }



    if (defined $ref && 0 < @$ref) {
        push(@supptables, "bugs_activity actcheck");
    
        my @list;
        foreach my $f (@$ref) {
            push(@list, "\nactcheck.fieldid = " . GetFieldID($f));
        }
        push(@wherepart, "actcheck.bug_id = bugs.bug_id");
        push(@wherepart, "(" . join(' OR ', @list) . ")");
        push(@wherepart, "actcheck.bug_when >= " .
             SqlQuote(SqlifyDate($F{'chfieldfrom'})));
        my $to = $F{'chfieldto'};
        if (defined $to) {
            $to = trim($to);
            if ($to ne "" && $to !~ /^now$/i) {
                push(@wherepart, "actcheck.bug_when <= " .
                     SqlQuote(SqlifyDate($to)));
            }
        }
        my $value = $F{'chfieldvalue'};
        if (defined $value) {
            $value = trim($value);
            if ($value ne "") {
                push(@wherepart, "actcheck.newvalue = " .
                     SqlQuote($value))
            }
        }
    }


    foreach my $f ("short_desc", "long_desc", "bug_file_loc",
                   "status_whiteboard") {
        if (defined $F{$f}) {
            my $s = trim($F{$f});
            if ($s ne "") {
                my $n = $f;
                my $q = SqlQuote($s);
                my $type = $F{$f . "_type"};
                push(@specialchart, [$f, $type, $s]);
            }
        }
    }
    

    my $chartid;
    my $f;
    my $ff;
    my $t;
    my $q;
    my $v;
    my $term;
    my %funcsbykey;
    my @funcdefs =
        (
         "^(assigned_to|reporter)," => sub {
             push(@supptables, "profiles map_$f");
             push(@wherepart, "bugs.$f = map_$f.userid");
             $f = "map_$f.login_name";
         },
         "^qa_contact," => sub {
             push(@supptables,
                  "LEFT JOIN profiles map_qa_contact ON bugs.qa_contact = map_qa_contact.userid");
             $f = "map_$f.login_name";
         },
         "^cc," => sub {
             push(@supptables,
                  ("LEFT JOIN cc cc_$chartid ON bugs.bug_id = cc_$chartid.bug_id LEFT JOIN profiles map_cc_$chartid ON cc_$chartid.who = map_cc_$chartid.userid"));
             $f = "map_cc_$chartid.login_name";
         },
         "^long_?desc,changedby" => sub {
             my $table = "longdescs_$chartid";
             push(@supptables, "longdescs $table");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             my $id = DBNameToIdAndCheck($v);
             $term = "$table.who = $id";
         },
         "^long_?desc,changedbefore" => sub {
             my $table = "longdescs_$chartid";
             push(@supptables, "longdescs $table");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             $term = "$table.bug_when < " . SqlQuote(SqlifyDate($v));
         },
         "^long_?desc,changedafter" => sub {
             my $table = "longdescs_$chartid";
             push(@supptables, "longdescs $table");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             $term = "$table.bug_when > " . SqlQuote(SqlifyDate($v));
         },
         "^long_?desc," => sub {
             my $table = "longdescs_$chartid";
             push(@supptables, "longdescs $table");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             $f = "$table.thetext";
         },
         "^attachments\..*," => sub {
             my $table = "attachments_$chartid";
             push(@supptables, "LEFT JOIN attachments $table ON bugs.bug_id = $table.bug_id");
             $f =~ m/^attachments\.(.*)$/;
             my $field = $1;
             if ($t eq "changedby") {
                 $v = DBNameToIdAndCheck($v);
                 $q = SqlQuote($v);
                 $field = "submitter_id";
                 $t = "equals";
             } elsif ($t eq "changedbefore") {
                 $v = SqlifyDate($v);
                 $q = SqlQuote($v);
                 $field = "creation_ts";
                 $t = "lessthan";
             } elsif ($t eq "changedafter") {
                 $v = SqlifyDate($v);
                 $q = SqlQuote($v);
                 $field = "creation_ts";
                 $t = "greaterthan";
             }
             if ($field eq "ispatch") {
                 if ($v ne "0" && $v ne "1") {
                     return Error("The only legal values for the 'Attachment is patch' field is 0 or 1.");
                 }
             }
             $f = "$table.$field";
         },
         "^changedin," => sub {
             $f = "(to_days(now()) - to_days(bugs.delta_ts))";
         },

         "^keywords," => sub {
             GetVersionTable();
             my @list;
             my $table = "keywords_$chartid";
             foreach my $value (split(/[\s,]+/, $v)) {
                 if ($value eq '') {
                     next;
                 }
                 my $id = $::keywordsbyname{$value};
                 if ($id) {
                     push(@list, "$table.keywordid = $id");
                 } else {
                     return Error("Unknown keyword named <code>$v</code>.\n" .
                                  "<P>The legal keyword names are\n" .
                                  "<A HREF=describekeywords.cgi>" . 
                                  "listed here</A>.\n");
                 }
             }
             my $haveawordterm;
             if (@list) {
                 $haveawordterm = "(" . join(' OR ', @list) . ")";
                 if ($t eq "anywords") {
                     $term = $haveawordterm;
                 } elsif ($t eq "allwords") {
                     $ref = $funcsbykey{",$t"};
                     &$ref;
                     if ($term && $haveawordterm) {
                         $term = "(($term) AND $haveawordterm)";
                     }
                 }
             }
             if ($term) {
                 push(@supptables, "keywords $table");
                 push(@wherepart, "$table.bug_id = bugs.bug_id");
             }
         },

	 "^(dependson|blocked)," => sub {
		push(@supptables, "dependencies");
		$ff = "dependencies.$f";
		$ref = $funcsbykey{",$t"};
		&$ref;
		push(@wherepart, "$term");
	 },


         ",equals" => sub {
             $term = "$ff = $q";
         },
         ",notequals" => sub {
             $term = "$ff != $q";
         },
         ",casesubstring" => sub {
             $term = "INSTR($ff, $q)";
         },
         ",(substring|substr)" => sub {
             $term = "INSTR(LOWER($ff), " . lc($q) . ")";
         },
         ",notsubstring" => sub {
             $term = "INSTR(LOWER($ff), " . lc($q) . ") = 0";
         },
         ",regexp" => sub {
             $term = "LOWER($ff) REGEXP $q";
         },
         ",notregexp" => sub {
             $term = "LOWER($ff) NOT REGEXP $q";
         },
         ",lessthan" => sub {
             $term = "$ff < $q";
         },
         ",greaterthan" => sub {
             $term = "$ff > $q";
         },
         ",anyexact" => sub {
             my @list;
             foreach my $w (split(/,/, $v)) {
                 if ($w eq "---" && $f !~ /milestone/) {
                     $w = "";
                 }
                 push(@list, "$ff = " . SqlQuote($w));
             }
             $term = join(" OR ", @list);
         },
         ",anywords" => sub {
             $term = join(" OR ", @{GetByWordList($ff, $v)});
         },
         ",allwords" => sub {
             $term = join(" AND ", @{GetByWordList($ff, $v)});
         },
         ",nowords" => sub {
             my @list = @{GetByWordList($ff, $v)};
             if (@list) {
                 $term = "NOT (" . join(" OR ", @list) . ")";
             }
         },
         ",changedbefore" => sub {
             my $table = "act_$chartid";
             my $ftable = "fielddefs_$chartid";
             push(@supptables, "bugs_activity $table");
             push(@supptables, "fielddefs $ftable");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             push(@wherepart, "$table.fieldid = $ftable.fieldid");
             $term = "($ftable.name = '$f' AND $table.bug_when < $q)";
         },
         ",changedafter" => sub {
             my $table = "act_$chartid";
             my $ftable = "fielddefs_$chartid";
             push(@supptables, "bugs_activity $table");
             push(@supptables, "fielddefs $ftable");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             push(@wherepart, "$table.fieldid = $ftable.fieldid");
             $term = "($ftable.name = '$f' AND $table.bug_when > $q)";
         },
         ",changedto" => sub {
             my $table = "act_$chartid";
             my $ftable = "fielddefs_$chartid";
             push(@supptables, "bugs_activity $table");
             push(@supptables, "fielddefs $ftable");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             push(@wherepart, "$table.fieldid = $ftable.fieldid");
             $term = "($ftable.name = '$f' AND $table.newvalue = $q)";
         },
         ",changedby" => sub {
             my $table = "act_$chartid";
             my $ftable = "fielddefs_$chartid";
             push(@supptables, "bugs_activity $table");
             push(@supptables, "fielddefs $ftable");
             push(@wherepart, "$table.bug_id = bugs.bug_id");
             push(@wherepart, "$table.fieldid = $ftable.fieldid");
             my $id = DBNameToIdAndCheck($v);
             $term = "($ftable.name = '$f' AND $table.who = $id)";
         },
         );
    my @funcnames;
    while (@funcdefs) {
        my $key = shift(@funcdefs);
        my $value = shift(@funcdefs);
        if ($key =~ /^[^,]*$/) {
            die "All defs in %funcs must have a comma in their name: $key";
        }
        if (exists $funcsbykey{$key}) {
            die "Duplicate key in %funcs: $key";
        }
        $funcsbykey{$key} = $value;
        push(@funcnames, $key);
    }


    my $chart = -1;
    my $row = 0;
    foreach my $ref (@specialchart) {
        my $col = 0;
        while (@$ref) {
            $F{"field$chart-$row-$col"} = shift(@$ref);
            $F{"type$chart-$row-$col"} = shift(@$ref);
            $F{"value$chart-$row-$col"} = shift(@$ref);
            if ($debug) {
                print qq{<P>$F{"field$chart-$row-$col"} | $F{"type$chart-$row-$col"} | $F{"value$chart-$row-$col"}*\n};
            }
            $col++;

        }
        $row++;
    }


    for ($chart=-1 ;
         $chart < 0 || exists $F{"field$chart-0-0"} ;
         $chart++) {
        $chartid = $chart >= 0 ? $chart : "";
        for (my $row = 0 ;
             exists $F{"field$chart-$row-0"} ;
             $row++) {
            my @orlist;
            for (my $col = 0 ;
                 exists $F{"field$chart-$row-$col"} ;
                 $col++) {
                $f = $F{"field$chart-$row-$col"} || "noop";
                $t = $F{"type$chart-$row-$col"} || "noop";
                $v = $F{"value$chart-$row-$col"};
                $v = "" if !defined $v;
                $v = trim($v);
                if ($f eq "noop" || $t eq "noop" || $v eq "") {
                    next;
                }
                $q = SqlQuote($v);
                my $func;
                $term = undef;
                foreach my $key (@funcnames) {
                    if ("$f,$t" =~ m/$key/) {
                        my $ref = $funcsbykey{$key};
                        if ($debug) {
                            print "<P>$key ($f , $t ) => ";
                        }
                        $ff = $f;
                        if ($f !~ /\./) {
                            $ff = "bugs.$f";
                        }
                        &$ref;
                        if ($debug) {
                            print "$f , $t , $term";
                        }
                        if ($term) {
                            last;
                        }
                    }
                }
                if ($term) {
                    push(@orlist, $term);
                } else {
                    my $errstr = "Can't seem to handle " .
                        qq{'<code>$F{"field$chart-$row-$col"}</code>' and } .
                            qq{'<code>$F{"type$chart-$row-$col"}</code>' } .
                                "together";
                    die "Internal error: $errstr" if $chart < 0;
                    return Error($errstr);
                }
            }
            if (@orlist) {
                push(@andlist, "(" . join(" OR ", @orlist) . ")");
            }
        }
    }
    my %suppseen = ("bugs" => 1);
    my $suppstring = "bugs";
    foreach my $str (@supptables) {
        if (!$suppseen{$str}) {
            if ($str !~ /^LEFT JOIN/i) {
                $suppstring .= ",";
            }
            $suppstring .= " $str";
            $suppseen{$str} = 1;
        }
    }
    my $query =  ("SELECT " . join(', ', @fields) .
                  " FROM $suppstring" .
                  " WHERE " . join(' AND ', (@wherepart, @andlist)) .
                  " GROUP BY bugs.bug_id");
    if ($debug) {
        print "<P><CODE>" . value_quote($query) . "</CODE><P>\n";
        exit();
    }
    return $query;
}

# ' vim color trouble
         
sub LookupNamedQuery {
    my ($name) = (@_);
    confirm_login();
    my $userid = DBNameToIdAndCheck($::COOKIE{"FeatureKong_login"});
    SendSQL("SELECT query FROM namedqueries " .
            "WHERE userid = $userid AND name = " . SqlQuote($name));
    my $result = FetchOneColumn();
    if (!defined $result) {
        print "Content-type: text/html\n\n";
        PutHeader("Something weird happened");
        print qq{The named query $name seems to no longer exist.};
        PutFooter();
        exit;
    }
    return $result;
}


        


CMD: for ($::FORM{'cmdtype'}) {
    /^runnamed$/ && do {
        $::buffer = LookupNamedQuery($::FORM{"namedcmd"});
        ProcessFormFields($::buffer);
        last CMD;
    };
    /^editnamed$/ && do {
	my $url = "query.cgi?" . LookupNamedQuery($::FORM{"namedcmd"});
        print qq{Content-type: text/html
Refresh: 0; URL=$url

<TITLE>What a hack.</TITLE>
<A HREF="$url">Loading your query named <B>$::FORM{'namedcmd'}</B>...</A>
};
        exit;
    };
    /^forgetnamed$/ && do {
        confirm_login();
        my $userid = DBNameToIdAndCheck($::COOKIE{"FeatureKong_login"});
        SendSQL("DELETE FROM namedqueries WHERE userid = $userid " .
                "AND name = " . SqlQuote($::FORM{'namedcmd'}));
        
        print "Content-type: text/html\n\n";
        PutHeader("Forget what?", "");

        print qq{
OK, the <B>$::FORM{'namedcmd'}</B> query is gone.
<P>
<A HREF="query.cgi">Go back to the query page.</A>
};
        PutFooter();
        exit;
    };
    /^asdefault$/ && do {
        confirm_login();
        my $userid = DBNameToIdAndCheck($::COOKIE{"FeatureKong_login"});
        print "Content-type: text/html\n\n";
        SendSQL("REPLACE INTO namedqueries (userid, name, query) VALUES " .
                "($userid, '$::defaultqueryname'," .
                SqlQuote($::buffer) . ")");
        PutHeader("OK, default is set");
        print qq{
OK, you now have a new default query.  You may also bookmark the result of any
individual query.

<P><A HREF="query.cgi">Go back to the query page, using the new default.</A>
};
        PutFooter();
        exit();
    };
    /^asnamed$/ && do {
        confirm_login();
        my $userid = DBNameToIdAndCheck($::COOKIE{"FeatureKong_login"});
        print "Content-type: text/html\n\n";
        my $name = trim($::FORM{'newqueryname'});
        if ($name eq "" || $name =~ /[<>&]/) {
            PutHeader("Please pick a valid name for your new query");
            print "Click the <B>Back</B> button and type in a valid name\n";
            print "for this query.  (Query names should not contain unusual\n";
            print "characters.)\n";
            PutFooter();
            exit();
        }
        $::buffer =~ s/[\&\?]cmdtype=[a-z]+//;
        my $qname = SqlQuote($name);
        SendSQL("SELECT query FROM namedqueries " .
                "WHERE userid = $userid AND name = $qname");
        if (!FetchOneColumn()) {
            SendSQL("REPLACE INTO namedqueries (userid, name, query) " .
                    "VALUES ($userid, $qname, " . SqlQuote($::buffer) . ")");
        } else {
            SendSQL("UPDATE namedqueries SET query = " . SqlQuote($::buffer) .
                    " WHERE userid = $userid AND name = $qname");
        }
        PutHeader("OK, query saved.");
        print qq{
OK, you have a new query named <code>$name</code>
<P>
<BR><A HREF="query.cgi">Go back to the query page</A>
};
        PutFooter();
        exit;
    };
}

sub DefCol {
    my ($name, $k, $t, $s, $q) = (@_);
    
    $::key{$name} = $k;
    $::title{$name} = $t;
    if (defined $s && $s ne "") {
        $::sortkey{$name} = $s;
    }
    if (!defined $q || $q eq "") {
        $q = 0;
    }
    $::needquote{$name} = $q;
}

DefCol("opendate", "date_format(bugs.creation_ts,'%Y-%m-%d')", "Opened",
       "bugs.creation_ts");
DefCol("changeddate", "date_format(bugs.delta_ts,'%Y-%m-%d')", "Changed",
       "bugs.delta_ts");
DefCol("severity", "bugs.bug_severity", "Sev",
       "bugs.bug_severity");
DefCol("priority", "bugs.priority", "Pri", "bugs.priority");
DefCol("committee", "bugs.committee", "Framework",
       "bugs.committee");
DefCol("owner", "map_assigned_to.login_name", "Owner",
       "map_assigned_to.login_name");
DefCol("reporter", "map_reporter.login_name", "Reporter",
       "map_reporter.login_name");
DefCol("qa_contact", "map_qa_contact.login_name", "QAContact", "map_qa_contact.login_name");
DefCol("status", "bugs.status", "State", "bugs.status");
DefCol("name", "substring(bugs.short_desc, 1, 60)", "name", "", 1);
DefCol("namefull", "bugs.short_desc", "Name", "", 1);
DefCol("status_whiteboard", "bugs.status_whiteboard", "StatusSummary", "bugs.status_whiteboard", 1);
DefCol("component", "bugs.component", "Comp",
       "bugs.component");
DefCol("plan", "bugs.plan", "Plan", "bugs.plan");
DefCol("version", "bugs.version", "Vers", "bugs.version");
DefCol("sponsor", "bugs.sponsor", "Sponsor", "bugs.sponsor");
DefCol("target_milestone", "bugs.target_milestone", "TargetM",
       "bugs.target_milestone");
DefCol("votes", "bugs.votes", "Votes", "bugs.votes desc");
DefCol("keywords", "bugs.keywords", "Keywords", "bugs.keywords");

my @collist;
@collist = ($::vertical, $::horizontal);

my $minvotes;
if (defined $::FORM{'votes'}) {
    if (trim($::FORM{'votes'}) ne "") {
        if (! (grep {/^votes$/} @collist)) {
            push(@collist, 'votes');
        }
    }
}

my @fields = ("bugs.bug_id", "bugs.groupset");

foreach my $c (@collist) {
    if (exists $::needquote{$c}) {
        push(@fields, "$::key{$c}");
    }
}

ReconnectToShadowDatabase();

my $query = GenerateSQL(\@fields, undef, undef, $::buffer);

#  For really big sites this is useful, for small ones it doesn't cost much
#  We have the database count how many bugs so we don't waste our time
#  if the query is not specific enough.  Users can raise the limit if they want.
my $count_query = $query;
$count_query =~ s/SELECT.*?FROM/SELECT count(bugs.bug_id) FROM/;
$count_query =~ s/GROUP.*//;
SendSQL($count_query);
my $matchCount = FetchSQLData();
$::FORM{'maxFeatures'} = 5000 if(!defined($::FORM{maxFeatures}) or $::FORM{'maxFeatures'} !~ /^\d+$/);
if($matchCount > $::FORM{'maxFeatures'}) {
   print("<hr><center><font color=red size=+1>Your query matched ");
   print("$matchCount features which is larger\n");
   print("than your specified maximum of $::FORM{'maxFeatures'}.</font></center>\n");
   return 1;
}

if ($::FORM{'debug'} && $serverpush) {
    print "<P><CODE>" . value_quote($query) . "</CODE><P>\n";
}

if (Param('expectbigqueries')) {
    SendSQL("set option SQL_BIG_TABLES=1");
}
SendSQL($query);

my $fields = $::buffer;
$fields =~ s/[&?]order=[^&]*//g;
$fields =~ s/[&?]cmdtype=[^&]*//g;


my $orderpart;
my $oldorder;

if (defined $::FORM{'order'} && trim($::FORM{'order'}) ne "") {
    $orderpart = "&order=" . url_quote("$::FORM{'order'}");
    $oldorder = url_quote(", $::FORM{'order'}");
} else {
    $orderpart = "";
    $oldorder = "";
}

my @row;
my %seen;
my @bugarray;
my %prodhash;
my %statushash;
my $buggroupset = "";
my %ownerhash;

my $pricol = -1;
my $sevcol = -1;
for (my $colcount = 0 ; $colcount < @collist ; $colcount++) {
    my $colname = $collist[$colcount];
    if ($colname eq "priority") {
        $pricol = $colcount;
    }
    if ($colname eq "severity") {
        $sevcol = $colcount;
    }
}

# Here is where we keep the totals.
# We have a has for each direction for the totals.
my %col_names;
my %row_names;
# and a hash of hashes for the internal stuff.
my %row_stuff;

my $count = 0;
while (my @bug = FetchSQLData()) {
    my ($bug_id, $group_set, $row, $col) = @bug;

    $count++;
    $row = "(empty)" if $row eq "";
    $col = "(empty)" if $col eq "";
    if(defined($row_stuff{$row})) {
        $row_stuff{$row}{$col} ++;
    } else {
        $row_stuff{$row}{$col} = 1;
    };
    $col_names{$col}++;
    $row_names{$row}++;
}

# we want the order to be correct for some of the enums
# and we want the complete set every week for the spreadsheet macro people.
sub axis_values
{
    my($hashref,$category) = @_;

    if($category eq "status") {
        return( @::legal_status );
    };
    if($category eq "severity") {
        return( @::legal_severity );
    };
    return(sort(keys(%$hashref)));
}

# determine the values of the axes
my @verticals = axis_values(\%row_stuff,$::vertical);
my @horizontals = axis_values(\%col_names,$::horizontal);
# To make printing & colors easier we make a phantom row & column of totals
# install totals
for my $col (@horizontals) {
    $row_stuff{"totals"}{$col} = $col_names{$col};
}
for my $row (@verticals) {
    $row_stuff{$row}{"totals"} = $row_names{$row};
}
$row_stuff{"totals"}{"totals"} = $count;
push(@horizontals,"totals");
push(@verticals,"totals");
# for titles
unshift(@horizontals," "); 
unshift(@verticals," ");
# description 
my $descript = $::buffer;  
$descript =~ s/[^&]*=&//g;  # remove parameters set to nothing
$descript =~ s/[^&]*=substring&//g;  # remove anything "=subsstring"
for my $param ("emailassigned_to1", "emailreporter2", "emailtype1", "emailtype2", 
               "field0-0-0", "type0-0-0", "cmdtype", "bugidtype", "order", "keywords_type") {
    $descript =~ s/&${param}=[^&]*//g;  # remove parameters set to nothing
};
$descript =~ s/chfieldto=[^&]*&?//g if ! ($descript =~ /chfieldlfrom=/);  
$descript =~ s/csv=[^&]&//g;  # remove csv= (first param)
$descript =~ s/\&/\n/g;  # convert "&" to newlines

if($::FORM{"csv"}) {  # if comma separated variable format
    for(my $row=0;defined($verticals[$row]);$row++) {
        for(my $col=0;defined($horizontals[$col]);$col++) {
            if($row == 0) {
                my $show = $horizontals[$col];
                $show =~ s/@.*$// if $::FORM{stripDN};
                print("$show,");
            } elsif ($col == 0) { 
                my $show = $verticals[$row];
                $show =~ s/@.*$// if $::FORM{stripDN};
                print("$show,");
            } else {
                my $count = $row_stuff{$verticals[$row]}{$horizontals[$col]};
                if(defined($count) && $count > 0) {
                    print("$count,");
                } else {
                    print("0,");
                };
            };
        };
        print("\n");
    };
    print("\n" . time2str("%a %b %e %T %Z %Y", time()) . "\n\n$descript");
    return 1;
};

# start printing the chart for the HTML (non-CSV) case
print "<HR SIZE=10>\n";
print "
<CENTER>
<B>" .  time2str("%a %b %e %T %Z %Y", time()) . "</B>";

if (defined $::FORM{'debug'}) {
    print "<P><CODE>" . value_quote($query) . "</CODE><P>\n";
}

sub ConstrainBuglist {
    my($link, $name, $value) = @_;
    return $link if $value eq "totals"; 
    my $param_name = $::key{$name};
    $param_name =~ s/^[^.]*\.//;  # delete stuff before the period (e.g. bugs.severity -> severity)
    if($name eq "owner") {
        $param_name = "email1";
        $link =~ s/emailassigned_to1=[^&]*&?//g;  # delete any other instance
        $link .= "&emailassigned_to1=1";
        $link =~ s/emailtype1=[^&]*&?//g;  # delete any other instance
        $link .= "&emailtype1=exact";
    };
    if($name eq "reporter") {
        $param_name = "email2";
        $link =~ s/emailreporter2=[^&]*&?//g;  # delete any other instance
        $link .= "&emailreporter2=1";
        $link =~ s/emailtype2=[^&]*&?//g;  # delete any other instance
        $link .= "&emailtype2=exact";
    };
    $link =~ s/$param_name=[^&]*&?//g;  # delete any other instance
    $link .= "&$param_name=" . url_quote($value); # append value
    return $link;
}

sub DeriveBuglistLink {
    my($curr_vert, $curr_horiz) = @_;
    my $link = $::buffer;
    $link = ConstrainBuglist($link,$::vertical,$curr_vert);
    $link = ConstrainBuglist($link,$::horizontal,$curr_horiz);
    $link = "buglist.cgi?" . $link;
    return $link;
}

# start the table which labels our axis categories
print("<table>
<tr><td></td><td align=center>$::horizontal</td></tr>
<tr><td>$::vertical</td><td>");

# print the table of numbers and headers
print("<table>");
my @colors = ("ffffff","dfefff",
              "dddddd","c3d3ed");
for(my $row=0;defined($verticals[$row]);$row++) {
    print(" <tr>");
    my $curr_vert = $verticals[$row];
    for(my $col=0;defined($horizontals[$col]);$col++) {
        my $curr_horiz = $horizontals[$col];
        my $color = $colors[2 * ($row & 1) + ($col & 1)];
        $color = "ffeeee" if $curr_horiz eq "totals";
        $color = "ffeeee" if $curr_vert eq "totals";
        print("<td bgcolor=$color align=center>");
        if($row == 0) {
            my $show = $curr_horiz;
            $show =~ s/@.*$// if ($::FORM{stripDN}); 
            print($show);
        } elsif ($col == 0) { 
            my $show = $curr_vert;
            $show =~ s/@.*$// if ($::FORM{stripDN});
            print($show);
        } else {
            my $count = $row_stuff{$curr_vert}{$curr_horiz};
            if(defined($count) && $count > 0) {
                print("<A HREF=\"" . DeriveBuglistLink($curr_vert,$curr_horiz) . "\">$count</a>\n");
            } else {
                print(".");
            };
        };
        print("</td>");
    };
    print("</tr>\n");
};

# close tables
print("</table>\n");
print("</td></tr></table>\n");
print "</CENTER>\n";

return 1;  #  needed for successful "do" statement which called us
