#!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Terry Weissman <terry@mozilla.org>
#                 Dan Mosedale <dmose@mozilla.org>
#                 Alan Raetz <al_raetz@yahoo.com>
#                 David Miller <justdave@syndicomm.com>
#

use diagnostics;
use strict;

require "CGI.pl";


use RelationSet;

# Shut up misguided -w warnings about "used only once".  "use vars" just
# doesn't work for me.
sub sillyness {
    my $zz;
    $zz = $::defaultqueryname;
    $zz = $::usergroupset;
}

my $userid;

my $showNewEmailTech;

# Note the use of arrays instead of hashes: we want the items
# displayed in the same order as they appear in the array.

my $defaultEmailFlagString =
        'ExcludeSelf~'               . 'on~' .

        'emailOwnerRemoveme~'        . 'on~' .
        'emailOwnerComments~'        . 'on~' .
        'emailOwnerAttachments~'     . 'on~' .
        'emailOwnerStatus~'          . 'on~' .
        'emailOwnerResolved~'        . 'on~' .
        'emailOwnerKeywords~'        . 'on~' .
        'emailOwnerCC~'              . 'on~' .
        'emailOwnerOther~'           . 'on~' .

        'emailReporterRemoveme~'     . 'on~' .
        'emailReporterComments~'     . 'on~' .
        'emailReporterAttachments~'  . 'on~' .
        'emailReporterStatus~'       . 'on~' .
        'emailReporterResolved~'     . 'on~' .
        'emailReporterKeywords~'     . 'on~' .
        'emailReporterCC~'           . 'on~' .
        'emailReporterOther~'        . 'on~' .

        'emailQAcontactRemoveme~'    . 'on~' .
        'emailQAcontactComments~'    . 'on~' .
        'emailQAcontactAttachments~' . 'on~' .
        'emailQAcontactStatus~'      . 'on~' .
        'emailQAcontactResolved~'    . 'on~' .
        'emailQAcontactKeywords~'    . 'on~' .
        'emailQAcontactCC~'          . 'on~' .
        'emailQAcontactOther~'       . 'on~' .

        'emailCClistRemoveme~'       . 'on~' .
        'emailCClistComments~'       . 'on~' .
        'emailCClistAttachments~'    . 'on~' .
        'emailCClistStatus~'         . 'on~' .
        'emailCClistResolved~'       . 'on~' .
        'emailCClistKeywords~'       . 'on~' .
        'emailCClistCC~'             . 'on~' .
        'emailCClistOther~'          . 'on~' .

        'emailVoterRemoveme~'        . 'on~' .
        'emailVoterComments~'        . 'on~' .
        'emailVoterAttachments~'     . 'on~' .
        'emailVoterStatus~'          . 'on~' .
        'emailVoterResolved~'        . 'on~' .
        'emailVoterKeywords~'        . 'on~' .
        'emailVoterCC~'              . 'on~' .
        'emailVoterOther~'           . 'on' ;

sub EmitEntry {
    my ($description, $entry) = (@_);
    print qq{<TR><TH ALIGN="right">$description:</TH><TD>$entry</TD></TR>\n};
}

sub Error {
    my ($msg) = (@_);
    print qq{
$msg
<P>
Please hit <B>back</B> and try again.
};
    PutFooter();
    exit();
}


sub ShowAccount {
    print qq{<FORM METHOD="POST">};
    print("<TABLE>\n");
    print("<tr><td bgcolor=dddddd colspan=2><b><center><b>Login settings</b></center></b></td></th>\n");
    print qq{<TR><TD COLSPAN="2"><HR></TD></TR>};
    print(qq{<TR><TH ALIGN="right">Username</TH><TD>$::COOKIE{FeatureKong_login}</TD></TR>\n});
    EmitEntry("Old password",
              qq|<input type=hidden name="FeatureKong_login" value="$::COOKIE{FeatureKong_login}">| .
              qq|<input type=password name="FeatureKong_password">|);
    EmitEntry("New password",
              qq{<input type=password name="pwd1">});
    EmitEntry("Re-enter new password", 
              qq{<input type=password name="pwd2">});
    SendSQL("SELECT realname FROM profiles WHERE userid = $userid");
    my ($realname) = (FetchSQLData());
    $realname = value_quote($realname);
    EmitEntry("Your real name (optional)",
              qq{<INPUT SIZE=35 NAME="realname" VALUE="$realname">});
    print("<tr><td colspan=2><b><center><b><input type=submit name=\"Account\" value=submit>\n");
    print("  </b></center></b></td></th>\n");
    print("</TABLE>\n");
    print qq{</FORM>\n};
}

sub SaveAccount {
    if ($::FORM{'FeatureKong_password'} ne ""
        || $::FORM{'pwd1'} ne "" || $::FORM{'pwd2'} ne "") {
        my $old = SqlQuote($::FORM{'FeatureKong_password'});
        my $pwd1 = SqlQuote($::FORM{'pwd1'});
        my $pwd2 = SqlQuote($::FORM{'pwd2'});
        SendSQL("SELECT cryptpassword FROM profiles WHERE userid = $userid");
        my $oldcryptedpwd = FetchOneColumn();
        if ( !$oldcryptedpwd ) {
            Error("I was unable to retrieve your old password from the database.");
        }
        if ( crypt($::FORM{'FeatureKong_password'}, $oldcryptedpwd) ne $oldcryptedpwd ) {
            Error("You did not enter your old password correctly.");
        }
        if ($pwd1 ne $pwd2) {
            Error("The two passwords you entered did not match.");
        }
        if ($::FORM{'pwd1'} eq '') {
            Error("You must enter a new password.");
        }
        my $passworderror = ValidatePassword($::FORM{'pwd1'});
        Error($passworderror) if $passworderror;

        my $cryptedpassword = SqlQuote(Crypt($::FORM{'pwd1'}));
        SendSQL("UPDATE  profiles 
                 SET     cryptpassword = $cryptedpassword 
                 WHERE   userid = $userid");
    }
    SendSQL("UPDATE profiles SET " .
            "realname = " . SqlQuote($::FORM{'realname'}) .
            " WHERE userid = $userid");
    print("<h2 size=+2>Password updated!</h2>");
}

#
# Set email flags in database based on the parameter string.
#
sub setEmailFlags ($) {

    my $emailFlagString = $_[0];

    SendSQL("UPDATE profiles SET emailflags = " .
            SqlQuote($emailFlagString) . " WHERE userid = $userid");
}


#<TABLE CELLSPACING="0" CELLPADDING="10" BORDER=0 WIDTH="100%">
sub ShowEmailOptions () {

    print qq{<FORM METHOD="POST">};
    print("<TABLE WIDTH=\"100%\">\n");
    print("<tr><th bgcolor=dddddd><b><center><b>Email settings</b></center></b></th></tr>\n");
    print("</TABLE>\n");
    print("<hr>");

    my $notify;
    my %userEmailFlags = ();

    SendSQL("SELECT emailflags FROM profiles WHERE userid = $userid");
    my ($flags) = FetchSQLData();

    # if the emailflags haven't been set before, that means that this user 
    # hasn't been to userprefs.cgi since the change to 
    # use emailflags.  Create a default flagset for them, based on
    # static defaults. 
    if ( !$flags ) {
        $flags = $defaultEmailFlagString;
        setEmailFlags($flags);
    }

    # the 255 param is here, because without a third param, split will
    # trim any trailing null fields, which causes perl to eject lots of
    # warnings.  any suitably large number would do.
    #
    %userEmailFlags = split(/~/ , $flags, 255);

    print(qq{<input type="checkbox" name="ExcludeSelf" VALUE="on"});
    print("CHECKED") if($userEmailFlags{'ExcludeSelf'} eq 'on');
    print(">\n do not email me about any changes that I make.<br>\n");
    print("<hr>");

    #$flags =~ s/(.*?)~(.*?)~/$1 -> $2<br>\n/g;
    #print("$flags");

    my %whats = (heading => "if I am....",
                 Removeme => "added or removed from this capacity",
                 Comments => "new comments ",
                 Attachments => "new attachments ",
                 Status => "priority, status, severity, and milestone changes ",
                 Resolved => "resolved or verified ",
                 Keywords => "keyword field changes ",
                 CC => "cc field changes ",
                 Other => "any other not mentioned above ");

    print("<table>");
    for my $what (qw{heading Removeme Comments Attachments Status Resolved Keywords CC Other}) {
       print(" <tr>\n");
       for my $who (qw{heading Owner Reporter QAcontact CClist Voter}) {
          print("  <td>\n");
          if($who eq "heading") {
              print("   $whats{$what}\n");
          } elsif($what eq "heading") {
              print("   $who\n");
          } else {
              print("   <input type=\"checkbox\" name=\"email$who$what\" VALUE=\"on\"");
              print("CHECKED") if($userEmailFlags{"email$who$what"} eq 'on');
              print(">\n");
          };
          print(" </td>");
       }
       print(" </tr>");
    }
    print("</table>");
    print("<hr>");

    if (Param("supportwatchers")) {
        my $watcheduserSet = new RelationSet;
        $watcheduserSet->mergeFromDB("SELECT watched FROM watch WHERE" .
                                    " watcher=$userid");
        my $watchedusers = $watcheduserSet->toString();
        print qq{
If you want to help cover for someone when they're on vacation, or if<br>
you need to do the QA related to all of their features, you can tell FeatureKong<br>
to send mail related to their features to you also.  List the email addresses<br>
of any users you wish to watch here, separated by commas.<br>
};
        print(qq{<INPUT SIZE=35 NAME="watchedusers" VALUE="$watchedusers">});
    }
    print("<br><input type=submit name=\"Email\" value=\"Submit\">\n");
    print qq{</FORM>\n};
}

sub SaveEmailOptions {

    my $flags = "";
    if ( defined $::FORM{'ExcludeSelf'}) {
        $flags .= 'ExcludeSelf~on';
    } else {
        $flags .= 'ExcludeSelf~';
    }
    for my $what (qw{Removeme Comments Attachments Status Resolved Keywords CC Other}) {
       for my $who (qw{Owner Reporter QAcontact CClist Voter}) {
          $flags .= "~email$who$what";
          if($::FORM{"email$who$what"}) {
             $flags .= "~on";
          } else {
             $flags .= "~off";
          };
       };
    };
    SendSQL("UPDATE profiles SET emailflags = " .
            SqlQuote($flags) . " WHERE userid = $userid");

    if (Param("supportwatchers") ) {

        if (exists $::FORM{'watchedusers'}) {

            # Just in case.  Note that this much locking is actually overkill:
            # we don't really care if anyone reads the watch table.  So 
            # some small amount of contention could be gotten rid of by
            # using user-defined locks rather than table locking.
            #
            SendSQL("LOCK TABLES watch WRITE, profiles READ");

            # what the db looks like now
            #
            my $origWatchedUsers = new RelationSet;
            $origWatchedUsers->mergeFromDB("SELECT watched FROM watch WHERE" .
                                           " watcher=$userid");

            # update the database to look like the form
            #
            my $newWatchedUsers = new RelationSet($::FORM{'watchedusers'});
            my @CCDELTAS = $origWatchedUsers->generateSqlDeltas(
                                                             $newWatchedUsers, 
                                                             "watch", 
                                                             "watcher", 
                                                             $userid,
                                                             "watched");
            $CCDELTAS[0] eq "" || SendSQL($CCDELTAS[0]);
            $CCDELTAS[1] eq "" || SendSQL($CCDELTAS[1]);

            # all done
            #
            SendSQL("UNLOCK TABLES");
        
        }
    }
    print("<h2>Email preferences updated!</h2>\n");
}


sub ShowFooter {
    print("<TABLE WIDTH=\"100%\">\n");
    print("<tr><th bgcolor=dddddd><b><center><b>Footer settings</b></center></b></th></tr>\n");
    print("</TABLE>\n");
    print("<hr>\n");
    print("<table>\n");
    print qq{<FORM METHOD="POST">};
    SendSQL("SELECT mybugslink FROM profiles " .
            "WHERE userid = $userid");
    my ($mybugslink) = (FetchSQLData());
    my $entry =
        BuildPulldown("mybugslink",
                      [["1", "should appear"],
                       ["0", "should not be displayed"]],
                      $mybugslink);
    EmitEntry("The 'My bugs' link at the footer of each page", $entry);
    SendSQL("SELECT name, linkinfooter FROM namedqueries " .
            "WHERE userid = $userid");
    my $count = 0;
    while (MoreSQLData()) {
        my ($name, $linkinfooter) = (FetchSQLData());
        if ($name eq $::defaultqueryname) {
            next;
        }
        my $entry =
            BuildPulldown("query-$count",
                          [["0", "should only appear in the query page"],
                           ["1", "should appear on the footer of every page"]],
                          $linkinfooter);
        EmitEntry("Your query named '$name'", $entry);
        my $q = value_quote($name);
        print qq{<INPUT TYPE=HIDDEN NAME="name-$count" VALUE="$q">\n};
        $count++;
    }
    print("</table>\n");
    print qq{<INPUT TYPE=HIDDEN NAME="numqueries" VALUE="$count">\n};
    if (!$count) {
        print qq{
If you go create remembered queries in the <A HREF="query.cgi">query page</A>,
you can then come to this page and choose <br>to have some of them appear in the 
footer of each FeatureKong page.
        };
    }
    print("<hr>");
    print("<br><input type=submit name=\"Footer\" value=submit>\n");
    print qq{</FORM>\n};
}
              
    
sub SaveFooter {
    my %old;
    SendSQL("SELECT name, linkinfooter FROM namedqueries " .
            "WHERE userid = $userid");
    while (MoreSQLData()) {
        my ($name, $linkinfooter) = (FetchSQLData());
        $old{$name} = $linkinfooter;
    }
    
    for (my $c=0 ; $c<$::FORM{'numqueries'} ; $c++) {
        my $name = $::FORM{"name-$c"};
        if (exists $old{$name}) {
            my $new = $::FORM{"query-$c"};
            if ($new ne $old{$name}) {
                SendSQL("UPDATE namedqueries SET linkinfooter = $new " .
                        "WHERE userid = $userid " .
                        "AND name = " . SqlQuote($name));
            }
        } else {
            Error("Hmm, the $name query seems to have gone away.");
        }
    }
    SendSQL("UPDATE profiles SET mybugslink = '" . $::FORM{'mybugslink'} .
            "' WHERE userid = $userid");
    print("<h2>Footer preferences updated!</h2>\n");
}
    


sub ShowPermissions {
    print("<TABLE WIDTH=\"100%\">\n");
    print("<tr><th bgcolor=dddddd><b><center><b>Permissions</b></center></b></th></tr>\n");
    print("</TABLE>\n");
    print("<hr>\n");
    print "You have the following permission bits set on your account:\n";
    print "<P><UL>\n";
    my $found = 0;
    SendSQL("SELECT description FROM groups " .
            "WHERE bit & $::usergroupset != 0 " .
            "ORDER BY bit");
    while (MoreSQLData()) {
        my ($description) = (FetchSQLData());
        print "<LI>$description\n";
        $found = 1;
    }
    if ($found == 0) {
        print "<LI>(No extra permission bits have been set).\n";
    }
    print "</UL>\n";
    SendSQL("SELECT blessgroupset FROM profiles WHERE userid = $userid");
    my $blessgroupset = FetchOneColumn();
    if ($blessgroupset) {
        print "And you can turn on or off the following bits for\n";
        print qq{<A HREF="editusers.cgi">other users</A>:\n};
        print "<P><UL>\n";
        SendSQL("SELECT description FROM groups " .
                "WHERE bit & $blessgroupset != 0 " .
                "ORDER BY bit");
        while (MoreSQLData()) {
            my ($description) = (FetchSQLData());
            print "<LI>$description\n";
        }
        print "</UL>\n";
    }
}
        



######################################################################
################# Live code (not sub defs) starts here ###############


confirm_login();

print "Content-type: text/html\n\n";

GetVersionTable();

PutHeader("User Preferences", "User Preferences", "Cusomize your account.");

#foreach my $k (sort(keys(%::FORM))) {
#    print "<pre>" . value_quote($k) . ": " . value_quote($::FORM{$k}) . "\n</pre>";
#}

$userid = DBNameToIdAndCheck($::COOKIE{'FeatureKong_login'});

#print("<h1>\$::COOKIE{'FeatureKong_login'} $::COOKIE{'FeatureKong_login'}</h1>\n");
#print("<h1>\$userid $userid</h1>\n");

if($::FORM{Account}) {
   SaveAccount();
};
if($::FORM{Email}) {
   SaveEmailOptions();
};
if($::FORM{Footer}) {
   SaveFooter();
};

print("<table cellpadding=\"4\" bgcolor=\"#9999aa\"><tr><td>\n");
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
ShowAccount();
print("</td></tr></table>\n\n");
print("</td></tr></table>\n\n");
print("<br>\n");
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
ShowEmailOptions();
print("</td></tr></table>\n\n");
print("</td></tr></table>\n\n");
print("<br>\n");
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
ShowFooter();
print("</td></tr></table>\n\n");
print("</td></tr></table>\n\n");
print("<br>\n");
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
print qq{<TABLE BGCOLOR="#ffffff" CELLSPACING="0" CELLPADDING="3" BORDER=0><tr><td>};
ShowPermissions();
print("</td></tr></table>\n\n");
print("</td></tr></table>\n\n");
print("<br>\n");
print("</td></tr></table>\n\n");
print qq{</FORM>\n};

print "<P>";
PutFooter();
