/* Copyright (c) Rick Dean 1997 */
/* <mishawaka@fdd.com> "Rick Dean" */

#include <assert.h>
#include <windows.h>
#include "debug.h"
#include "registry.h"

static HWND hDebugWnd;
#define MISH_SET_EDIT_TEXT         (WM_USER + 30)
static char const debugClassNameStr[] = "mishDebug";

/* Msg displays a message box containing the given formatted string. */
void __cdecl Printf(LPSTR formatStr, ... )
{
    static char outputStr[8*1024] = "";
    static int outputStrLength;
    char *newlineCharPtr;

    if(formatStr == NULL) {   // if command is to clear window
        outputStr[0] = '\0';
        outputStrLength = 0;
    } else { 
        wvsprintf(outputStr+outputStrLength,formatStr,(char *)(&formatStr+1));
        outputStrLength += strlen(outputStr+outputStrLength);
    };
    if(hDebugWnd)
        SendMessage(hDebugWnd,MISH_SET_EDIT_TEXT,0,(LPARAM)outputStr);  
    assert(outputStrLength < sizeof(outputStr));
    if(sizeof(outputStr)-outputStrLength < 1024) {  // if too much text
        newlineCharPtr = strchr(outputStr+256,'/n');
        if(newlineCharPtr == NULL) {  
            outputStr[0] = '\0';  
            outputStrLength = 0;
        } else {
            memmove(outputStr,newlineCharPtr+1,outputStrLength+1-(newlineCharPtr-outputStr+1));
            outputStrLength -= (newlineCharPtr-outputStr+1);
        };
    }
}

static void DoDebugSize(HWND hEditWnd,HWND hScrollBarWnd,LPARAM lParam)
{
    int width,height;

    width = LOWORD(lParam);
    height = HIWORD(lParam);
    MoveWindow(hEditWnd,0,0,width,height,TRUE);
    MoveWindow(hScrollBarWnd,width-16,1,16,height-1,TRUE);
}

int IsDebugShowing(void)
{
    return (int)hDebugWnd;
}

static void CreateDebugWindow()
{
	hDebugWnd = CreateWindow(debugClassNameStr,"Mishawaka Debug",WS_OVERLAPPEDWINDOW|WS_VISIBLE,0,0,
        700,GetSystemMetrics(SM_CYSCREEN),NULL,NULL,0,NULL);
    Printf("");  // fill the EDIT window with text
};

//  the return value is 1 if now visible, 0 otherwise
void ToggleDebugShow(void)
{
    if(hDebugWnd == NULL) { //If debug window not existing
        CreateDebugWindow();
        SetOurRegistryInt("debugWindowShowing",1);
    } else {
        DestroyWindow(hDebugWnd);
        hDebugWnd = NULL;
        SetOurRegistryInt("debugWindowShowing",0);
    }
}

LRESULT CALLBACK DebugWindowProcedure(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HWND hScrollBarWnd,hDebugEditWnd;
    extern HWND hMainWnd;
    
    switch (message) { 
        case WM_SIZE: 
            if(lParam)  // if not being minimized
                DoDebugSize(hDebugEditWnd,hScrollBarWnd,lParam);
            break;
        case MISH_SET_EDIT_TEXT:
            SendMessage(hDebugEditWnd,WM_SETTEXT,0,lParam); 
            SendMessage(hDebugEditWnd,WM_VSCROLL,(WPARAM)( 0x7fff0000|SB_THUMBPOSITION),(LPARAM)hScrollBarWnd);
            UpdateWindow(hDebugEditWnd);
            break;
        case WM_COMMAND:
            PostMessage(hMainWnd,message,wParam,lParam);
            break;
        case WM_KEYDOWN:
            switch(wParam) {
            case VK_PRIOR:
                SendMessage(hDebugEditWnd,WM_VSCROLL,(WPARAM)SB_PAGEUP,(LPARAM)hScrollBarWnd);
                break;
            case VK_NEXT:
                SendMessage(hDebugEditWnd,WM_VSCROLL,(WPARAM)SB_PAGEDOWN,(LPARAM)hScrollBarWnd);
                break;
            case VK_UP:
                SendMessage(hDebugEditWnd,WM_VSCROLL,(WPARAM)SB_LINEUP,(LPARAM)hScrollBarWnd);
                break;
            case VK_DOWN:
                SendMessage(hDebugEditWnd,WM_VSCROLL,(WPARAM)SB_LINEDOWN,(LPARAM)hScrollBarWnd);
                break;
            default:
                break;
            };
            break;
        case WM_CREATE:
            hDebugEditWnd = CreateWindow("EDIT",NULL,WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOVSCROLL|ES_MULTILINE|ES_LEFT|ES_WANTRETURN|WS_TABSTOP|WS_CLIPCHILDREN,
               0,0,700,600,hWnd,NULL,0, NULL);
            hScrollBarWnd = CreateWindow("SCROLLBAR",NULL,WS_CHILD|WS_VISIBLE|SBS_RIGHTALIGN|SBS_VERT,
               0,0,16,100,hDebugEditWnd,NULL,0, NULL);
			break;
        case WM_DESTROY:
            hDebugWnd = NULL;
            break;
		default:
			return DefWindowProc(hWnd,message,wParam,lParam);
	}
	return 0;
}

void InitDebugWindow(void)
{   
	WNDCLASS  wc;
    int showDebug = 0;

	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = (WNDPROC)DebugWindowProcedure;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = 0;
	wc.hIcon         = NULL;
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;  
	wc.lpszClassName = debugClassNameStr;
    if(!RegisterClass(&wc)) 
        return;
    GetOurRegistryInt("debugWindowShowing",&showDebug);
    if(showDebug)
        CreateDebugWindow();
}
