
/* Copyright (c) Rick Dean 1997 */
/* <mishawaka@fdd.com> "Rick Dean" */

#include <assert.h>
#include <winsock2.h>
#include <stdio.h>

#include "mishawaka.h"
#include "inbound.h"
#include "status.h"
#include "dns.h"
#include "debug.h"

//  We need dns.c because Windows networking does not do
//  MX (mail exchnager) lookups, only A (address)
//  lookups.  Furthermore Windows hides the
//  IP address of the DNS name server.  Fuck!

// This file only supports UDP (not TCP).  
// It is now only a client, not a server.
// It does not use the DNS function of Win95/NT.

// This aggressive program spams all of the DNS servers at
// once.  This is not nice, especially for a batch job like a
// daemon delivering mail.  I need to fix it.

// You should be familiar with RFC883 and RFC973 before looking at this file.
// I made no attempt at documenting DNS syntax, and assumed this knowledge.
// see http://www.cis.ohio-state.edu/hypertext/information/rfc.html

#define MAX_NUM_OF_NAMESERVERS (10)
int nameserverAddressArr[MAX_NUM_OF_NAMESERVERS]; // a zero value mean empty
#define MAX_DNS_MESSAGE_LENGTH (1500)
#define MAX_NUM_OF_ATTEMPTS (5) 

typedef unsigned char uchar;

// returns 0 on error
// This function will ignore spaces in the middle of the address (not in the middle of a nuber though)
// This function will ignore characters after the last number, so that the addresss does not have to be a token.
// This function will ignore a leading '['
static int IPstringToAddress(char *ipStringPtr)
{
    int a,b,c,d;

    if(*ipStringPtr == '[' || *ipStringPtr == ' ')
        ipStringPtr++;
    if(sscanf(ipStringPtr,"%d.%d.%d.%d",&a,&b,&c,&d) != 4)
        return 0;
    return (a<<24) + (b<<16) + (c<<8) + d;
}

static int ManualDNSInit(void)
{
    extern char *manualDNSServerPtr;
    char *cursorPtr;
    int currentNameserver;

    cursorPtr=manualDNSServerPtr;
    for(currentNameserver=0;currentNameserver < MAX_NUM_OF_NAMESERVERS;currentNameserver++) {
        nameserverAddressArr[currentNameserver] = IPstringToAddress(cursorPtr);
        cursorPtr = strchr(cursorPtr,' ');
        if(cursorPtr == NULL)
            break;
        while(*cursorPtr == ' ' || *cursorPtr == ',' || *cursorPtr == ']' || *cursorPtr == '[')
            cursorPtr++;
        if(*cursorPtr == '\0')
            break;
    };
    return 0;
}

static void PrintHostEnt(struct hostent *hostEntPtr)
{
    char **charHdl;

    Printf(" h_name=<<%s>>\r\n",hostEntPtr->h_name);
    for(charHdl = hostEntPtr->h_aliases;*charHdl;charHdl++)
        Printf(" h_aliases=<<%s>>\r\n",*charHdl);
//     for(charHdl = hostEntPtr->h_aliases;*charHdl;charHdl++)
//        Printf(" h_aliases=<<%s>>\r\n",*charHdl);
}

static int ReverseDNSMethodInit(void)
{
    char myHostnameArr[256];
    struct hostent *hostEntPtr;

    gethostname(myHostnameArr,sizeof(myHostnameArr));
    Printf("myHostnameArr <<%s>>\r\n",myHostnameArr);
    hostEntPtr = gethostbyname(myHostnameArr);
    if(hostEntPtr == NULL) {
        Printf("null myHostEntPtr\r\n");
        return 1;
    };
    Printf("myHostEnt\r\n");
    PrintHostEnt(hostEntPtr);
    hostEntPtr = gethostbyname("A.ROOT-SERVERS.NET");
    if(hostEntPtr == NULL) {
        Printf("null rootHostEntPtr\r\n");
        return 1;
    };
    Printf("rootHostEnt\r\n");
    PrintHostEnt(hostEntPtr);
    return 0;
}

static void ClearNameservers(void)
{
    int currentNameserver;

    for(currentNameserver=0;currentNameserver < MAX_NUM_OF_NAMESERVERS;currentNameserver++) 
        nameserverAddressArr[currentNameserver] = 0;
}

// returns 0 if initialized OK
// returns 1 if uninitialized
int InitDNS(void)
{
    extern int dnsAquizition,autoMyHostname;
   // extern char *myHostnamePtr;
    int returnStatus;

    SetStatusText("Initializing DNS");  // status.h
    Printf("Initializing DNS\r\n");  // debug.h
    ClearNameservers();
    switch(dnsAquizition) {
    case IDC_MANUAL_DNS:
        returnStatus = ManualDNSInit(); // return "initilization successful"
        break;
    case IDC_REVERSE_DNS:
    default:  // actually an internal error. but someone could fuck with the registry
        returnStatus = ReverseDNSMethodInit();
        break;
    case IDC_FISH_REGISTRY:
        assert(0);
    case IDC_PROBE_SUBNET:
        assert(0);
    };
    SetStatusText("");  // status.h
    return returnStatus;
}

// returns 0 if initialized OK
// returns 1 if uninitialized
static int CheckInitDNS(void)
{
    if(nameserverAddressArr[0] != 0)
        return 0;  // return "already initialized"
    return InitDNS();
}

// (bubble) sort them so that lowest number priority is first
// We don't care about randomizing the order.  That is the job of the DNS server.
// I don't care enough about duplicates to eliminate them.
static void PrioritizeMailExchangers(MailExchanger mailExchangerArr[MAX_NUM_OF_MAIL_EXCHANGERS])
{
    int destMailExchangerIndex,sourceMailExchangerIndex,numMailExchangers;
    int doneFlag,mailExchangerIndex;
    MailExchanger tempMailExchanger;

    // find first non empty
    destMailExchangerIndex = 0;
    for(sourceMailExchangerIndex=0;sourceMailExchangerIndex < MAX_NUM_OF_MAIL_EXCHANGERS;sourceMailExchangerIndex++) 
        if(mailExchangerArr[sourceMailExchangerIndex].ipAddress == 0) 
            break;
    // move up the rest
    destMailExchangerIndex=sourceMailExchangerIndex; 
    for(sourceMailExchangerIndex++;sourceMailExchangerIndex < MAX_NUM_OF_MAIL_EXCHANGERS;sourceMailExchangerIndex++) 
        if(mailExchangerArr[sourceMailExchangerIndex].ipAddress != 0) {
           mailExchangerArr[destMailExchangerIndex++] = mailExchangerArr[sourceMailExchangerIndex];
           mailExchangerArr[sourceMailExchangerIndex].ipAddress = 0;
        };           
    numMailExchangers = destMailExchangerIndex;
    // bubble sort
    for(doneFlag=0;!doneFlag;) { // for each search pass
        doneFlag=1;
        for(mailExchangerIndex=0;mailExchangerIndex < numMailExchangers-1;mailExchangerIndex++) { 
            if(mailExchangerArr[mailExchangerIndex].priority > mailExchangerArr[mailExchangerIndex+1].priority){
                tempMailExchanger = mailExchangerArr[mailExchangerIndex];
                mailExchangerArr[mailExchangerIndex] = mailExchangerArr[mailExchangerIndex+1];
                mailExchangerArr[mailExchangerIndex+1] = tempMailExchanger;
                doneFlag = 0;
            };
        };
    }
}

// Returns 0 if no host name remains, non-zero othewise.
// This copies label from the dot notation to the compressed notation.
// The compressed form looks like a bunch of pascal strings. 
static char *ExtractLabel(char **remainingHostNameHdl,char **messageHdl)
{
    int zoneNameLength;
    char *nextPeriodPtr;

    nextPeriodPtr = strchr(*remainingHostNameHdl,'.');
    if(nextPeriodPtr == NULL) // if last zone name (no more periods)
        zoneNameLength = strlen(*remainingHostNameHdl);
    else
        zoneNameLength = nextPeriodPtr - *remainingHostNameHdl;
    (*messageHdl)[0] = zoneNameLength;
    memcpy(*messageHdl + 1,*remainingHostNameHdl,zoneNameLength);
    *messageHdl += zoneNameLength+1;
    *remainingHostNameHdl += zoneNameLength+1;
    return nextPeriodPtr;
}

// The host name should have only letters, dashes, and periods.  No carrage return.
static void RequestDNS(SOCKET sock,char *hostNameStr,int nameserver,int queryType)
{
    char messageStr[MAX_DNS_MESSAGE_LENGTH];
    char *remainingHostNamePtr; // points to first unused byte. (first byte of next zone name)
    char *messageCursorPtr;  // points to first empty byte
    SOCKADDR_IN sockaddr_in;

    if(strlen(hostNameStr) > sizeof(messageStr)+16)
        return;  // domain name too long
    messageStr[0] = 0;  // more significant byte of ID
    messageStr[1] = 1;  // less significant byte of ID
    messageStr[2] = 1;  // bit field (queryOrResponse=query,opcode=standardQuery,authoritativeAnswer=no,truncated=no,recurse=on)
    messageStr[3] = 0;  // bit field (recursionAvailable=no,responseCode=noErrorCondition)
    messageStr[4] = 0;  // more significant byte of QDCOUNT (question count)
    messageStr[5] = 1;  // less significant byte of QDCOUNT (question count)
    messageStr[6] = messageStr[7] = 0;  // ANCOUNT (answer count)
    messageStr[8] = messageStr[9] = 0;  // NSCOUNT (name service authority count)
    messageStr[10] = messageStr[11] = 0;  // ARCOUNT (resource record count)
    remainingHostNamePtr = hostNameStr;
    messageCursorPtr = messageStr + 12;
    while(ExtractLabel(&remainingHostNamePtr,&messageCursorPtr))
        ;
    *messageCursorPtr++ = 0;  // zero length string to mark end of QNAME
    *messageCursorPtr++ = queryType >> 8;  // more significant byte of QTYPE
    *messageCursorPtr++ = queryType;   // less significant byte of QTYPE 1=A 12=PTR 15=MX
    *messageCursorPtr++ = 0;  // more significant byte of QCLASS
    *messageCursorPtr++ = 1;  // less significant byte of QCLASS=IN (ARPA Internet)
    sockaddr_in.sin_family = AF_INET;
    sockaddr_in.sin_port = htons(53);  // "domain" port
    sockaddr_in.sin_addr.S_un.S_addr = htonl(nameserver);
    sendto(sock,messageStr,messageCursorPtr - messageStr,0,(SOCKADDR*)&sockaddr_in,sizeof(sockaddr_in));
}

// queryType 1=A 15=MX
static void SpamRequestDNS(SOCKET sock,char *hostNameStr,int queryType)
{
    int nameServerIndex;

    for(nameServerIndex = 0;nameServerIndex < MAX_NUM_OF_NAMESERVERS;nameServerIndex++) // for every nameserver
        if(nameserverAddressArr[nameServerIndex] != 0)  // if this server is defined
            RequestDNS(sock,hostNameStr,nameserverAddressArr[nameServerIndex],queryType);
}

static SOCKET OpenDatagramSocket(void)
{
    SOCKADDR_IN sockaddr_in;
    SOCKET sock;
    
    sock = socket(AF_INET,SOCK_DGRAM,0);
    if(sock == INVALID_SOCKET)
        Printf("socket() failed in dns.c");
    sockaddr_in.sin_family = AF_INET;  /* address family internet */
    sockaddr_in.sin_addr.s_addr = INADDR_ANY;  /* accept connection from anyone */
    sockaddr_in.sin_port = 0; //listen on random port
    if(bind(sock,(struct sockaddr FAR *) &sockaddr_in,sizeof(sockaddr_in)) == SOCKET_ERROR)
        Printf("bind() failed in dns.c");
    return sock;
}

static uchar *ExpandCompressedName(uchar *dnsMessagePtr,uchar *dnsMessageCursorPtr,uchar *outOfBoundsMessagePtr,
                           char *expandedNamePtr,char *outOfBoundsNamePtr)
{
    uchar *returnValuePtr = NULL;

    *(outOfBoundsNamePtr-1) = '0';
    if(dnsMessageCursorPtr >= outOfBoundsMessagePtr)
        return outOfBoundsMessagePtr;
    while(*dnsMessageCursorPtr!=0) { // for every label
        if(*dnsMessageCursorPtr >= 0xc0) { // if length indicates compressed notation
            if(returnValuePtr == NULL)
               returnValuePtr = dnsMessageCursorPtr+2;
            dnsMessageCursorPtr = dnsMessagePtr + (0x3f & *dnsMessageCursorPtr)*256 + *(dnsMessageCursorPtr+1);  
            if(dnsMessageCursorPtr >= outOfBoundsMessagePtr)
                return outOfBoundsMessagePtr;
           continue;  // to the start of "for every label"
        } else if((*dnsMessageCursorPtr & 0xc0))  // if illegal length
            return outOfBoundsMessagePtr;
        if(dnsMessageCursorPtr+*dnsMessageCursorPtr+2 > outOfBoundsMessagePtr ||
           expandedNamePtr+*dnsMessageCursorPtr >= outOfBoundsNamePtr)  // save space for period/null
            return outOfBoundsMessagePtr;
        memcpy(expandedNamePtr,dnsMessageCursorPtr+1,*dnsMessageCursorPtr);
        expandedNamePtr += *dnsMessageCursorPtr;
        *expandedNamePtr++ = '.';
        dnsMessageCursorPtr += 1+*dnsMessageCursorPtr;  // +1 for the initial size
    };
    expandedNamePtr--;
    *expandedNamePtr = '\0';
    if(returnValuePtr)
        return returnValuePtr;
    return dnsMessageCursorPtr+1;
}

// the return value is the type or -2 for error
static int ParseResourceRecord(uchar *dnsMessagePtr,uchar **dnsMessageCursorHdl,uchar *outOfBoundsMessagePtr,
                               char *namePtr,char *outOfBoundsNamePtr,int *ipAddressPtr,int *priorityPtr) 
{  
    uchar *dnsMessageCursorPtr;
    int type,rdLength;

    dnsMessageCursorPtr = 10 + ExpandCompressedName(dnsMessagePtr,*dnsMessageCursorHdl,
                      outOfBoundsMessagePtr,namePtr,outOfBoundsNamePtr);      
    if(dnsMessageCursorPtr >= outOfBoundsMessagePtr)
        return -2;
    type = dnsMessageCursorPtr[-10]*256 + dnsMessageCursorPtr[-9];  // 1=A 6=SOA 15=MX 
    rdLength = dnsMessageCursorPtr[-2]*256 + dnsMessageCursorPtr[-1];
    if(dnsMessageCursorPtr + rdLength > outOfBoundsMessagePtr)
        return -2;
    switch(type) { 
    case 1: // type=A  
        if(priorityPtr)
            *priorityPtr = 0; 
        if(ipAddressPtr)
            *ipAddressPtr = dnsMessageCursorPtr[0]*0x1000000 + dnsMessageCursorPtr[1]*0x10000 + 
                            dnsMessageCursorPtr[2]*0x100     + dnsMessageCursorPtr[3];
        //Printf("A %d.%d.%d.%d\r\n",dnsMessageCursorPtr[0],dnsMessageCursorPtr[1],dnsMessageCursorPtr[2],dnsMessageCursorPtr[3]);
        break;
    case 15: // type=MX
        if(priorityPtr)
            *priorityPtr = dnsMessageCursorPtr[0]*256 + dnsMessageCursorPtr[1];
        ExpandCompressedName(dnsMessagePtr,dnsMessageCursorPtr+2,outOfBoundsMessagePtr,
            namePtr,outOfBoundsNamePtr);
        //Printf("MX %s\r\n",namePtr);
        break;
    case 12: // type=PTR
    case 2: // type=NS
    case 6: // type=SOA
        ExpandCompressedName(dnsMessagePtr,dnsMessageCursorPtr,outOfBoundsMessagePtr,
            namePtr,outOfBoundsNamePtr);
        //Printf("SOA,NS, or PTR %s\r\n",namePtr);
        break;
    default: 
        break;
    };
    *dnsMessageCursorHdl = rdLength + dnsMessageCursorPtr;
    return type;
}

// returns -2 on error in message 
//         address (in network order)
//         0 no address
static int ExtractAddress(uchar *dnsMessagePtr,int messageLength)
{
    int questionCount,answerCount;
    uchar *outOfMessageBoundsPtr,*dnsMessageCursorPtr;
    char nameArr[MAX_DOT_ADDR_LENGTH];  // junk buffer 
    int recordsToGo,type,ipAddress;

    outOfMessageBoundsPtr = dnsMessagePtr+messageLength;
    if(messageLength < 12)//if not long enough for header
        return -2;  // return "error in message" 
    if((dnsMessagePtr[3]&0x0f) == 3)//RCODE=NXDOMAIN
        return 0;  // return "no address"
    if((dnsMessagePtr[3]&0x0f)) 
        return -2;
    questionCount = dnsMessagePtr[4]<<8 | dnsMessagePtr[5];  
    answerCount = dnsMessagePtr[6]<<8 | dnsMessagePtr[7];
    if(answerCount == 0)  
        return 0;
    dnsMessageCursorPtr = dnsMessagePtr + 12;
    for(recordsToGo=questionCount;recordsToGo;recordsToGo--) { // for every question
        dnsMessageCursorPtr = 4 + ExpandCompressedName(dnsMessagePtr,dnsMessageCursorPtr,
                              outOfMessageBoundsPtr,nameArr,nameArr+sizeof(nameArr));
        if(dnsMessageCursorPtr > outOfMessageBoundsPtr)
            return -2;
    };
    // if they return more than one answer then it is their responsibility to randomize the order
    recordsToGo = answerCount;
    do { 
        recordsToGo--;
        type = ParseResourceRecord(dnsMessagePtr,&dnsMessageCursorPtr,outOfMessageBoundsPtr,
            nameArr,nameArr+sizeof(nameArr),&ipAddress,NULL); 
    } while (type != 1 && recordsToGo > 0);
    if(type != 1)   // if NOT type=A 
        return -2;                           
    return ipAddress;
}

// returns -2 on error in message 
//         # of answers
static int ExtractNames(uchar *dnsMessagePtr,int messageLength,char *namesArr,int maxNamesLength)
{
    int questionCount,answerCount;
    uchar *outOfMessageBoundsPtr,*dnsMessageCursorPtr;
    char *currentNamePtr; 
    int recordsToGo,type,ipAddress;

    outOfMessageBoundsPtr = dnsMessagePtr+messageLength;
    if(messageLength < 12)//if not long enough for header
        return -2;  // return "error in message" 
    if((dnsMessagePtr[3]&0x0f) == 3)//RCODE=NXDOMAIN
        return 0;  // return "no address"
    if((dnsMessagePtr[3]&0x0f)) 
        return -2;
    questionCount = dnsMessagePtr[4]<<8 | dnsMessagePtr[5];  
    answerCount = dnsMessagePtr[6]<<8 | dnsMessagePtr[7];
    if(answerCount == 0)  
        return 0;
    dnsMessageCursorPtr = dnsMessagePtr + 12;
    for(recordsToGo=questionCount;recordsToGo;recordsToGo--) { // for every question
        dnsMessageCursorPtr = 4 + ExpandCompressedName(dnsMessagePtr,dnsMessageCursorPtr,
                              outOfMessageBoundsPtr,namesArr,namesArr+maxNamesLength);
        if(dnsMessageCursorPtr > outOfMessageBoundsPtr)
            return -2;
    };
    currentNamePtr = namesArr;
    for(recordsToGo = answerCount;recordsToGo;recordsToGo--) { 
        type = ParseResourceRecord(dnsMessagePtr,&dnsMessageCursorPtr,outOfMessageBoundsPtr,
            currentNamePtr,namesArr+maxNamesLength-1,&ipAddress,NULL); 
        if(type == 12) 
            currentNamePtr += strlen(currentNamePtr)+1;
    };
    *currentNamePtr = '\0';
    return answerCount;
}

// find a list of names separated by a charater null, terminated by a zero length name
// The return value is the number of names found.
int GetHostByAddr(int address,char *namesArr,int maxNameLength)
{
    char lookupNameArr[100];
    SOCKET sock;
    extern struct timeval timeoutUntilDNSResend;  // max wait time for DNS servers in seconds
    extern int numDNSRetries;
    struct fd_set myFD_set;
    int dnsRetries,dnsBytesReturned,addressResponse;
    uchar dnsMessageArr[MAX_DNS_MESSAGE_LENGTH];

    if((address&0xff000000) == 0x7f000000) {
        memcpy(namesArr,"localhost\0",10);
        return 1;
    }
    if(CheckInitDNS())
        return 1;
    sprintf(lookupNameArr,"%d.%d.%d.%d.in-addr.arpa",address&0xff,(address>>8)&0xff,(address>>16)&0xff,(address>>24)&0xff);
    namesArr[0] = namesArr[1] = '\0';
    sock = OpenDatagramSocket();  // new socket so we don't get MX answers by accident
    for(dnsRetries=1;;dnsRetries++) { // for each broadcast try
        SpamRequestDNS(sock,lookupNameArr,12); // queryType=PTR ("domain name pointer")
        FD_ZERO(&myFD_set);
        FD_SET(sock,&myFD_set);
        while(select(0,&myFD_set,NULL,NULL,&timeoutUntilDNSResend) != 0) {  // for all responses while no timeout
            dnsBytesReturned=recv(sock,dnsMessageArr,sizeof(dnsMessageArr),0);  // get response
            addressResponse = ExtractNames(dnsMessageArr,dnsBytesReturned,namesArr,maxNameLength);
            if(addressResponse != -2) { // if message was error-free
                closesocket(sock);
                return addressResponse;  // return address (success)
            }  // else must have been a syntax or server-internal error
            FD_ZERO(&myFD_set);
            FD_SET(sock,&myFD_set);
        }; 
        if(dnsRetries >= numDNSRetries) { /* if still no error-free responses */
            closesocket(sock);
            return -1;  /* return "DNS unavailable" */    
        };
    };
}

// returns address (in network order) if success or 
//          0                         if no address or 
//          -1                        if DNS unavailable 
int GetHostByName(char *nameStr)
{
    SOCKET sock;
    extern struct timeval timeoutUntilDNSResend;  // max wait time for DNS servers in seconds
    extern int numDNSRetries;
    struct fd_set myFD_set;
    int dnsRetries,dnsBytesReturned,addressResponse;
    uchar dnsMessageArr[MAX_DNS_MESSAGE_LENGTH];

    assert(nameStr[0] != '\0');
    if(CheckInitDNS())
        return 1;
    Printf("Getting IP address for <%s>\r\n",nameStr);
    sock = OpenDatagramSocket();  // new socket so we don't get MX answers by accident
    for(dnsRetries=1;;dnsRetries++) { // for each broadcast try
        SpamRequestDNS(sock,nameStr,1); // queryType=A (host address)
        FD_ZERO(&myFD_set);
        FD_SET(sock,&myFD_set);
        while(select(0,&myFD_set,NULL,NULL,&timeoutUntilDNSResend) != 0) {  // for all responses while no timeout
            dnsBytesReturned=recv(sock,dnsMessageArr,sizeof(dnsMessageArr),0);  // get response
            addressResponse = ExtractAddress(dnsMessageArr,dnsBytesReturned);
            if(addressResponse != -2) { // if message was error-free
                closesocket(sock);
                return addressResponse;  // return address (success)
            }  // else must have been a syntax or server-internal error
            FD_ZERO(&myFD_set);
            FD_SET(sock,&myFD_set);
        }; 
        if(dnsRetries >= numDNSRetries) { /* if still no error-free responses */
           closesocket(sock);
           return -1;  /* return "DNS unavailable" */    
        };
    };
}

// returns numerOfAnswers or -1 on non-existent domain or -2 on error.
static int ExtractMailExchangers(uchar *dnsMessagePtr,int messageLength,
                                 MailExchanger mailExchangerArr[MAX_NUM_OF_MAIL_EXCHANGERS])
{
    int questionCount,answerCount,nsCount,arCount,numAnswersToKeep,numAnswersToTrash;
    uchar *outOfMessageBoundsPtr,*dnsMessageCursorPtr;
    char answerNamesArr[MAX_DOT_ADDR_LENGTH*MAX_NUM_OF_MAIL_EXCHANGERS];
    char nameArr[MAX_DOT_ADDR_LENGTH];  // junk buffer 
    int recordsToGo,type,exchangerIndex,ipAddress;

    outOfMessageBoundsPtr = dnsMessagePtr+messageLength;
    if(messageLength < 12)//if not long enough for header
        return -2;  // return "error in message" 
    if((dnsMessagePtr[3]&0x0f) == 3)//RCODE=NXDOMAIN
        return -1;  // return "non-existent domain"
    if((dnsMessagePtr[3]&0x0f)) 
        return -2;
    questionCount = dnsMessagePtr[4]<<8 | dnsMessagePtr[5];  
    answerCount = dnsMessagePtr[6]<<8 | dnsMessagePtr[7];
    if(answerCount == 0)  
        return 0;
    nsCount = dnsMessagePtr[8]<<8 | dnsMessagePtr[9];  // authoritative nameservice records
    arCount = dnsMessagePtr[10]<<8 | dnsMessagePtr[11];  // additional records
    dnsMessageCursorPtr = dnsMessagePtr + 12;
    for(recordsToGo=questionCount;recordsToGo;recordsToGo--) { // for every question
        dnsMessageCursorPtr = 4 + ExpandCompressedName(dnsMessagePtr,dnsMessageCursorPtr,
                              outOfMessageBoundsPtr,nameArr,nameArr+sizeof(nameArr));
        if(dnsMessageCursorPtr > outOfMessageBoundsPtr)
            return -2;
    };
    if(answerCount > MAX_NUM_OF_MAIL_EXCHANGERS) {
        numAnswersToKeep = MAX_NUM_OF_MAIL_EXCHANGERS;
        numAnswersToTrash = answerCount - numAnswersToKeep;
    } else {
        numAnswersToKeep = answerCount;
        numAnswersToTrash = 0;
    };
    Printf("keeping %d MX addresses of %d\r\n",numAnswersToKeep,answerCount);
    for(recordsToGo=numAnswersToKeep;recordsToGo;recordsToGo--) { // for every answer to keep
        type = ParseResourceRecord(dnsMessagePtr,&dnsMessageCursorPtr,outOfMessageBoundsPtr,
                answerNamesArr+MAX_DOT_ADDR_LENGTH*(recordsToGo-1),answerNamesArr+MAX_DOT_ADDR_LENGTH*recordsToGo,
                &mailExchangerArr[recordsToGo-1].ipAddress,&mailExchangerArr[recordsToGo-1].priority); 
        if(type == -2) 
            return -2;                           
    };
    for(recordsToGo=numAnswersToTrash;recordsToGo;recordsToGo--) { // for every answer to trash
        type = ParseResourceRecord(dnsMessagePtr,&dnsMessageCursorPtr,outOfMessageBoundsPtr,
                nameArr,nameArr+sizeof(nameArr),NULL,NULL); 
        if(type == -2) 
            return -2;                           
    };
    for(recordsToGo=nsCount;recordsToGo;recordsToGo--) { // for every nameserver authority
        type = ParseResourceRecord(dnsMessagePtr,&dnsMessageCursorPtr,outOfMessageBoundsPtr,
                nameArr,nameArr+sizeof(nameArr),NULL,NULL); 
        if(type == -2) 
            return -2;   
        if(nameArr[0] == '\0' && type == 6)
            return -1;  // return "non-existent domain"
    };
    for(recordsToGo=arCount;recordsToGo;recordsToGo--) { // for every additional record (look for addresses of MX answers)
        type = ParseResourceRecord(dnsMessagePtr,&dnsMessageCursorPtr,outOfMessageBoundsPtr,
                nameArr,nameArr+sizeof(nameArr),&ipAddress,NULL);
        if(type == -2) 
            return -2;  
        if(type == 1) //if type=A
            for(exchangerIndex = 0;exchangerIndex < numAnswersToKeep;exchangerIndex++) { // for every MX answer
               if(0 == strcmp(nameArr,answerNamesArr+MAX_DOT_ADDR_LENGTH*(exchangerIndex))) {
                   mailExchangerArr[exchangerIndex].ipAddress = ipAddress;
                   break; // stop searching for mail exchanger name matches
               };
            };
    };
    // done with message, now make sure all MX host have IP addresses...
    for(exchangerIndex = 0;exchangerIndex < numAnswersToKeep;exchangerIndex++)// for every MX answer
        if(mailExchangerArr[exchangerIndex].ipAddress == 0) {  // if IP address not known
            mailExchangerArr[exchangerIndex].ipAddress = GetHostByName(answerNamesArr+MAX_DOT_ADDR_LENGTH*(exchangerIndex));
            if(mailExchangerArr[exchangerIndex].ipAddress == -1)  // in DNS not available
                mailExchangerArr[exchangerIndex].ipAddress = 0;  // this could be better.
        };
    return numAnswersToKeep;
}

// The goal of this function is to get IP address(es) where the letter can be sent to.
// We assume that all nameservers will respond the same way. (ignoring errored responses)
//   The return value is 1 if DNS unavailable.
//   The return value is 2 if invalid domain.
//   The return value is 3 if invalid host.
//   Otherwise           0 if OK
//
// We first search for MX records. possible outcomes:
//    no error-free DNS responses                     return 1 (DNS unavailable)
//    dns response is bad address (root authority)    return 2 (invalid domain)
//    dns response is MX record(s) > 0                use them return 0
//    dns response is no MX records                   use own name for second stage return 0
int GetMXforName(char *hostNameStr,MailExchanger mailExchangerArr[MAX_NUM_OF_MAIL_EXCHANGERS])
{
    SOCKET sock;
    extern struct timeval timeoutUntilDNSResend;  // max wait time for DNS servers in seconds
    extern int numDNSRetries;
    struct fd_set myFD_set;
    int dnsRetries,dnsBytesReturned,mxResponses;
    uchar dnsMessageArr[MAX_DNS_MESSAGE_LENGTH];

    assert(hostNameStr != NULL);
    if(CheckInitDNS())
        return 1;
    SetStatusText("Getting MX address for %s",hostNameStr);
    for(mxResponses=0;mxResponses < MAX_NUM_OF_MAIL_EXCHANGERS;mxResponses++) 
        mailExchangerArr[mxResponses].ipAddress = 0;  // set to "not defined"
    if((mailExchangerArr[0].ipAddress = IPstringToAddress(hostNameStr)) != 0)  // if numerical notation
        return 0;
    sock = OpenDatagramSocket();
    // try for QUERYTYPE = MX
    for(dnsRetries=1,mxResponses=-3;;dnsRetries++) {  // for each broadcast try
        SpamRequestDNS(sock,hostNameStr,15); // queryType=MX (mail exchanger)
        FD_ZERO(&myFD_set);
        FD_SET(sock,&myFD_set);
        while(select(0,&myFD_set,NULL,NULL,&timeoutUntilDNSResend) != 0) {  // for all responses while no timeout
            dnsBytesReturned=recv(sock,dnsMessageArr,sizeof(dnsMessageArr),0);  // get response
            mxResponses = ExtractMailExchangers(dnsMessageArr,dnsBytesReturned,mailExchangerArr);
            if(mxResponses > 0) { // if MX record count is >0
                closesocket(sock);
                PrioritizeMailExchangers(mailExchangerArr);
                return 0;  // return "success"
            } else if(mxResponses == 0) { // if MX record count is 0
                break; // break for QUERYTYPE=A  // "break 2;" sure would be nice
            } else if(mxResponses == -1) {// if invalid domain
                closesocket(sock);
                Printf("invalid domain\r\n");
                return 2;  // invalid domain
            };   // else must have been a syntax or server-internal error
            FD_ZERO(&myFD_set);
            FD_SET(sock,&myFD_set);
        }; 
        if(mxResponses == 0)
            break;
        if(dnsRetries >= numDNSRetries) {  /* if still no error-free responses */
            closesocket(sock);
            Printf("DNS unavailable\r\n");
            return 1;  /* return "DNS unavailable" */    
        };
    };
    closesocket(sock);
    // try for QUERYTYPE=A
    mailExchangerArr[0].priority = 0;
    mailExchangerArr[0].ipAddress = GetHostByName(hostNameStr);
    if(mailExchangerArr[0].ipAddress == -1) {
        Printf("DNS unavailable\r\n");
        return 1;  // return "DNS not available"
    };
    if(mailExchangerArr[0].ipAddress == 0)
        return 3;  // return "invalid host"
    SetStatusText("");
    return 0; // return "success"
}


