
/* Copyright (c) Rick Dean 1997 */
/* <mishawaka@fdd.com> "Rick Dean" */

#include <assert.h>
#include <winsock2.h>
#include <setjmp.h>
#include <stdio.h>
#include <windows.h>

#include "mishawaka.h"
#include "inbound.h"
#include "status.h"
#include "schedule.h"
#include "debug.h"
#include "dns.h"
#include "match.h"

static HANDLE numActiveInboundMutexHdl;  // owner of this mutex can read/write to numActiveInbound
int volatile numActiveInbound = 0;  // has mutex because multiple threads write to it

void InitInbound(HWND hWnd)
{
   SOCKADDR_IN sockaddr_in;
   SOCKET sock;

   sock = socket(AF_INET,SOCK_STREAM, 0);
   if(sock == INVALID_SOCKET) {
        Msg("socket() failed");
        exit(1);
   };
   sockaddr_in.sin_family = AF_INET;
   sockaddr_in.sin_addr.s_addr = INADDR_ANY;// we restrict connections after we answer so it is runtime changable
   sockaddr_in.sin_port = htons(25);   /* listen on port 25 */ 
   if(bind(sock,(SOCKADDR *) &sockaddr_in,sizeof(sockaddr_in)) == SOCKET_ERROR) {
       Msg("bind(sock) failed.\n(%d)", WSAGetLastError());
       closesocket( sock );
       exit(1);
   };
   if(listen(sock,1 /* max pending requests */ ) == SOCKET_ERROR) {
       Msg("listen(sock) failed (%d)", WSAGetLastError());
       exit(1);
   };
   /* Send window a user defined event, MISH_ACCEPT, when something is trying to connect.  */
   if(WSAAsyncSelect(sock,hWnd,MISH_INBOUND_MAIL_ACCEPT,FD_ACCEPT) == SOCKET_ERROR) {
       Msg("Error on WSAAsyncSelect() (%d)",WSAGetLastError());
       closesocket( sock );
       exit(1);
   };
   numActiveInboundMutexHdl = CreateMutex(NULL,FALSE,"nummActiveInbound");
}

static int IsOkayToConnectSMTP(int sourceAddress,char *sourceHostnameArr) 
{
    extern char *hostsToConnectSMTPPtr;

    return IsHostInList(sourceAddress,sourceHostnameArr,hostsToConnectSMTPPtr);
}

static int IsForwardAnythingHost(int sourceAddress,char *sourceHostnamePtr)
{
    extern char *forwardAnythingHostListPtr;

    return IsHostInList(sourceAddress,sourceHostnamePtr,forwardAnythingHostListPtr);
}

// charsOfProgress is the state variable which this routine needs between buffers
static int IsEndOfMessage(int charsInNextBuffer,char *nextBufferPtr,int *charsOfProgressPtr)
{
    static char endingSequenceArr[] = "\r\n.\r\n";
    int index;

    assert(*charsOfProgressPtr >= 0 && *charsOfProgressPtr < sizeof(endingSequenceArr)-1);
    for(index=0;index < charsInNextBuffer;index++) {
        if(nextBufferPtr[index] == endingSequenceArr[*charsOfProgressPtr]) {
            if(*charsOfProgressPtr == 4)  // -1 for the null 
                return 1;
            (*charsOfProgressPtr)++;
        } else if(nextBufferPtr[index] == endingSequenceArr[0])
            *charsOfProgressPtr = 1;
        else
            *charsOfProgressPtr = 0;
    };
    return 0;
}

static int IsCommandSame(char *receivedLineStr,char *commandPatternStr)
{
   while(*receivedLineStr == ' ')  // for each white space to skip
       receivedLineStr++;
   for(;*commandPatternStr != '\0';commandPatternStr++,receivedLineStr++) // for each letter of command
       if(tolower(*receivedLineStr) != *commandPatternStr)
           return 0;
   return 1;
}

// returns non-zero on error
static int CopyEAddress(char *destPtr,char *sourcePtr,int maxDestSize)
{
    char *startPtr,*endPtr;

    startPtr = strchr(sourcePtr,'<');
    endPtr = strchr(sourcePtr,'>');
    if(startPtr == NULL || endPtr == NULL)
        return 1;
    if(endPtr-startPtr+2 > maxDestSize)
        return 2;
    memcpy(destPtr,startPtr,endPtr-startPtr+1);
    destPtr[endPtr-startPtr+1] = '\0';
    return 0;
}

static void PostReceivedEvent(char *filenameStr)
{
    char *filenamePtr;
    extern HWND hMainWnd;

    filenamePtr = GlobalAlloc(GMEM_FIXED,strlen(filenameStr)+1);  
    if(filenamePtr == NULL)  // if out of memory
        return;
    strcpy(filenamePtr,filenameStr);
    PostMessage(hMainWnd,MISH_MAIL_RECEIVED,(WPARAM)filenamePtr,0);
}

int SprintfDateTime(char *dateTimeStr)
{
    char dateArr[20],timeArr[20];
    TIME_ZONE_INFORMATION timeZoneInfo;

    GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,NULL,"ddd',' d MMM yyyy",dateArr,sizeof(dateArr));
    GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,NULL,"HH':'mm':'ss ",timeArr,sizeof(timeArr));
    GetTimeZoneInformation(&timeZoneInfo);
    sprintf(dateTimeStr,"%s %s %c%04d",dateArr,timeArr,timeZoneInfo.Bias<0?'+':'-',(timeZoneInfo.Bias/60*100)+(timeZoneInfo.Bias%60));
    assert(strlen(dateArr) < sizeof(dateArr));
    assert(strlen(timeArr) < sizeof(timeArr));
    return strlen(dateTimeStr);
}

static void CloseAndDelete(HANDLE *fileHdl,char *filenameStr) 
{
    if(*fileHdl == NULL || *fileHdl == INVALID_HANDLE_VALUE)
        return;
    CloseHandle(*fileHdl);
    DeleteFile(filenameStr);
    *fileHdl = NULL;
}

static void SendHelp(SOCKET sock,jmp_buf resetJmpBuf)
{
    if(send(sock,"214 possible commands: DATA HELO HELP MAIL NOOP QUIT RCPT RSET\r\n",64,0) == SOCKET_ERROR)
        longjmp(resetJmpBuf,2);
}

static void SendError(SOCKET sock,jmp_buf resetJmpBuf)
{
    if(send(sock,"500 error\r\n",11,0) == SOCKET_ERROR)
        longjmp(resetJmpBuf,2);
}

static void SendOK(SOCKET sock,jmp_buf resetJmpBuf)
{
    if(send(sock,"250 OK\r\n",8,0) == SOCKET_ERROR)
        longjmp(resetJmpBuf,2);
}

static void SendDiskFull(SOCKET sock,jmp_buf resetJmpBuf)
{
    send(sock,"421 disk full, closing connection\r\n",55,0);
    longjmp(resetJmpBuf,2);
}

static void SendBadAddress(SOCKET sock)
{
    send(sock,"500 bad address, use <>\r\n",25,0);
}

static HANDLE OpenNew822File(SOCKET sock,Envelope *envelopePtr,jmp_buf resetJmpBuf)
{
    int filenameRetriesToGo;
    HANDLE eight22FileHdl;

    for(filenameRetriesToGo = 10;;filenameRetriesToGo--) {  // find a unique filename
        sprintf(envelopePtr->eight22FilenameArr,"mish_%x.822",GetTickCount()*0x12f3253*(int)envelopePtr);//GetTickCount() for random number
        eight22FileHdl = CreateFile(envelopePtr->eight22FilenameArr,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_NEW,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
        if(eight22FileHdl != INVALID_HANDLE_VALUE)
            break;
        if(filenameRetriesToGo == 0) {
            Printf("could not open new 822 file for inbound mail\r\n");
            SendDiskFull(sock,resetJmpBuf);  // return 2
        }
    };
    return eight22FileHdl;
}

static HANDLE OpenNewEVLFile(SOCKET sock,Envelope *envelopePtr,char *envelopeFilenameStr,jmp_buf resetJmpBuf)
{ 
    HANDLE envelopeFileHdl;

    strcpy(envelopeFilenameStr,envelopePtr->eight22FilenameArr);  
    strcpy(strchr(envelopeFilenameStr,'.')+1,"evl");  // change suffix
    envelopeFileHdl = CreateFile(envelopeFilenameStr,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_NEW,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
    if(envelopeFileHdl == INVALID_HANDLE_VALUE) {
        Printf("could not open new evl file for inbound mail (%s)\r\n",envelopeFilenameStr);
        SendDiskFull(sock,resetJmpBuf);  // return 2
    };
    return envelopeFileHdl;
}

static void WriteReceivedLine(HANDLE eight22FileHdl,int sourceAddress,Envelope *envelopePtr)
{
    char tempLineArr[1024];
    extern char *myHostnamePtr;
    int lineLength,numBytesWritten;
    
    lineLength = sprintf(tempLineArr,"Received: from [%d.%d.%d.%d] by %s\r\n",
        (sourceAddress>>24)&0xff,(sourceAddress >> 16)&0xff,(sourceAddress >> 8)&0xff,sourceAddress&0xff,myHostnamePtr);
    assert(strlen(tempLineArr) < sizeof(tempLineArr));
    WriteFile(eight22FileHdl,tempLineArr,lineLength,&numBytesWritten,NULL);
    lineLength = sprintf(tempLineArr,"\tvia Mishawaka ("VERSION_STRING" build "__DATE__") with SMTP id %s;\r\n\t",
        envelopePtr->eight22FilenameArr);
    lineLength += SprintfDateTime(tempLineArr+lineLength);
    lstrcat(tempLineArr+lineLength,"\r\n");
    assert(strlen(tempLineArr) < sizeof(tempLineArr));
    WriteFile(eight22FileHdl,tempLineArr,lineLength+2,&numBytesWritten,NULL);
}

static int ReadArrayFromSocket(SOCKET sock,jmp_buf resetJmpBuf,char *bufferArr,int bufferLength)
{
    struct fd_set myFD_set;
    extern struct timeval networkTimeout;
    int selectResponse;
    int numBytesRead;

    FD_ZERO(&myFD_set);
    FD_SET(sock,&myFD_set); // list our socket as the one to check
    selectResponse = select(sock,&myFD_set,NULL,NULL,&networkTimeout);
    if(selectResponse == 0) { // if sending timeout occurrs
        send(sock,"520 timeout. closing channel\r\n",30,0);
        longjmp(resetJmpBuf,2); // close socket
    };
    if(selectResponse == SOCKET_ERROR)  // if network problem
        longjmp(resetJmpBuf,2); // close socket
    numBytesRead = recv(sock,bufferArr,bufferLength,0);
    //Printf("asked %d got %d\r\n",bufferLength,numBytesRead);
    if(numBytesRead == 0 || numBytesRead == SOCKET_ERROR)    
        longjmp(resetJmpBuf,2); // close socket
    return numBytesRead;
}

//  This also writes the ending <CRLF>.<CRLF>
static void ReadDataIntoFile(SOCKET sock,jmp_buf resetJmpBuf,HANDLE fileHdl)
{
    int numBytesRead,numBytesWritten;
    char bufferArr[2048];
    int endOfMessageCounter = 0;

    for(;;) {  
        numBytesRead = ReadArrayFromSocket(sock,resetJmpBuf,bufferArr,sizeof(bufferArr));
        WriteFile(fileHdl,bufferArr,numBytesRead,&numBytesWritten,NULL);
        if(numBytesWritten != numBytesRead) {
            Printf("disk full\r\n");
            SendDiskFull(sock,resetJmpBuf); // return 2
        };
        if(IsEndOfMessage(numBytesRead,bufferArr,&endOfMessageCounter)) { // if end of letter found
            Printf("end of message\r\n");
            return;           
        };
    };
}

static int GetLineAndCheckReset(SOCKET sock,jmp_buf resetJmpBuf,char receivedLineArr[MAX_RECEIVED_LINE_LENGTH+1]) 
{
    int numBytesRead,additionalBytesRead;

    for(;;) {  // for all worthless responses
        for(numBytesRead=0;;) {  // for all partial line reads
            additionalBytesRead = ReadArrayFromSocket(sock,resetJmpBuf,receivedLineArr+numBytesRead,MAX_RECEIVED_LINE_LENGTH-numBytesRead);
            numBytesRead += additionalBytesRead;
            receivedLineArr[numBytesRead] = '\0';  // terminate string
            if(numBytesRead == MAX_RECEIVED_LINE_LENGTH || strchr(receivedLineArr,'\n') != NULL)
                break;
        };
        Printf("received: %s",receivedLineArr);
        if(IsCommandSame(receivedLineArr,"helo") || IsCommandSame(receivedLineArr,"noop")) 
            SendOK(sock,resetJmpBuf);
        else if(IsCommandSame(receivedLineArr,"help"))
            SendHelp(sock,resetJmpBuf);
        else if(*receivedLineArr == '\r' || *receivedLineArr == '\n')
            SendOK(sock,resetJmpBuf);
        else
            break;
    };
    if(IsCommandSame(receivedLineArr,"mail from:") || IsCommandSame(receivedLineArr,"rset"))
        longjmp(resetJmpBuf,3);   // close files, start new letter
    if(IsCommandSame(receivedLineArr,"quit")) {
        send(sock,"221 thanks, closing channel\r\n",29,0);
        longjmp(resetJmpBuf,2);  // close socket
    };
    return numBytesRead;
};

static void ReceiveSMTP(SOCKET sock,int sourceAddress,char *sourceNamePtr)
{
    HANDLE envelopeFileHdl=NULL,eight22FileHdl=NULL;
    int isSocketError,numBytesWritten,numRecipients;
    char receivedLineArr[MAX_RECEIVED_LINE_LENGTH+1];
    char envelopeFilenameStr[MAX_822FILENAME_LENGTH];
    jmp_buf resetJmpBuf;
    extern struct timeval networkTimeout;
    extern char *myHostnamePtr;
    Envelope envelope;
    extern char *eAddressesToAcceptFromAnyonePtr;

    send(sock,"220 ",4,0);
    send(sock,myHostnamePtr,strlen(myHostnamePtr),0);
    send(sock," Mishawaka Simple Mail Transfer Service Ready\r\n",47,0);
    envelope.magicNumber = ENVELOPE_MAGIC_NUMBER;
    receivedLineArr[0] = '\0';
    isSocketError = setjmp(resetJmpBuf);   // 2=socket_error 3=smtp_reset_or_mail
    CloseAndDelete(&eight22FileHdl,envelope.eight22FilenameArr);
    CloseAndDelete(&envelopeFileHdl,envelopeFilenameStr);
    if(isSocketError == 2)  // if connection closed
        return;
    if(!IsCommandSame(receivedLineArr,"mail")) {
        if(IsCommandSame(receivedLineArr,"rset"))
            SendOK(sock,resetJmpBuf);
        else if(receivedLineArr[0] != '\0')//if not first time or blank line
            SendError(sock,resetJmpBuf);
        GetLineAndCheckReset(sock,resetJmpBuf,receivedLineArr);// don't rely on the return value, because it may not return
        longjmp(resetJmpBuf,3);
    };

    if(CopyEAddress(envelope.fromAddressArr,receivedLineArr+10,sizeof(envelope.toAddressArr))) {
        SendBadAddress(sock);
        GetLineAndCheckReset(sock,resetJmpBuf,receivedLineArr);
        longjmp(resetJmpBuf,3);
    }
    // should refuse mail based on From: address here!!!
    eight22FileHdl  = OpenNew822File(sock,&envelope,resetJmpBuf);
    envelopeFileHdl = OpenNewEVLFile(sock,&envelope,envelopeFilenameStr,resetJmpBuf);
    SendOK(sock,resetJmpBuf);
    WriteReceivedLine(eight22FileHdl,sourceAddress,&envelope);
    // get "rcpt to:" lines 
    for(numRecipients = 0;;) {  // for every rcpt line
        GetLineAndCheckReset(sock,resetJmpBuf,receivedLineArr);
        if(IsCommandSame(receivedLineArr,"rcpt to:")) {
            if(CopyEAddress(envelope.toAddressArr,receivedLineArr+8,sizeof(envelope.fromAddressArr))) {
                SendBadAddress(sock);
                continue;
            };
            if(!IsMatchList(eAddressesToAcceptFromAnyonePtr,envelope.toAddressArr) && 
                !IsForwardAnythingHost(sourceAddress,sourceNamePtr)) {
                send(sock,"501 forwarding denied\r\n",33,0);
                continue;
            };
            WriteFile(envelopeFileHdl,&envelope,sizeof(Envelope),&numBytesWritten,NULL);
            if(numBytesWritten != sizeof(envelope))
                SendDiskFull(sock,resetJmpBuf);  // return 2
            SendOK(sock,resetJmpBuf);
            numRecipients++;
        } else if(IsCommandSame(receivedLineArr,"data") && numRecipients > 0)
            break;
        else
            SendError(sock,resetJmpBuf);
    };
    send(sock,"354 Start mail input; end with <CRLF>.<CRLF>\r\n",46,0);
    ReadDataIntoFile(sock,resetJmpBuf,eight22FileHdl);
    SendOK(sock,resetJmpBuf);
    FlushFileBuffers(eight22FileHdl);
    CloseHandle(eight22FileHdl);
    FlushFileBuffers(envelopeFileHdl);
    CloseHandle(envelopeFileHdl);
    eight22FileHdl = envelopeFileHdl = NULL;
    PostReceivedEvent(envelopeFilenameStr);
    GetLineAndCheckReset(sock,resetJmpBuf,receivedLineArr);
    longjmp(resetJmpBuf,3);
}

static int IsHostFromList(int address,char *addressListPtr)
{
    if(addressListPtr == NULL)
        return 0;
    return 0;
}

/* here we decide if it is someone we want to listen to. */
static WINAPI InboundThreadMain(SOCKET sock)
{
    SOCKADDR_IN sockaddr_in; 
    int sockaddr_inLength;     
    extern int acceptConnectionsFromOthers;
    extern int maxActiveInbound;
    int sourceAddress;
    char sourceHostnameArr[256];

    sockaddr_inLength = sizeof(sockaddr_in);
    sock = accept(sock,(SOCKADDR *) &sockaddr_in,&sockaddr_inLength); // creates new socket
    if(sock == INVALID_SOCKET) {
        Printf("##accept() failed for inbound (%d)",WSAGetLastError());
        return 0;
    };
    WaitForSingleObject(numActiveInboundMutexHdl,INFINITE);
    if(numActiveInbound >= maxActiveInbound) {
        ReleaseMutex(numActiveInboundMutexHdl);
        Printf("rejected SMTP connection because max concurrent reaced\r\n");
        send(sock,"421 too many connections\r\n",26,0);
        closesocket(sock);
        return 0;
    }; 
    numActiveInbound++;
    ReleaseMutex(numActiveInboundMutexHdl);
    sourceAddress = ntohl(sockaddr_in.sin_addr.s_addr);
    GetHostByAddr(sourceAddress,sourceHostnameArr,sizeof(sourceHostnameArr));      
    if(IsOkayToConnectSMTP(sourceAddress,sourceHostnameArr)) {
        ReceiveSMTP(sock,sourceAddress,sourceHostnameArr);
    } else {      
        Printf("rejected SMTP connection from 0x%x (%s)\r\n",sockaddr_in.sin_addr.s_addr,sourceHostnameArr);
        send(sock,"421 connection from your address refused\r\n",42,0);
    };
    closesocket(sock);
    WaitForSingleObject(numActiveInboundMutexHdl,INFINITE);
    numActiveInbound--;
    ReleaseMutex(numActiveInboundMutexHdl);
    return 0;
}

/*   Accept an incoming connection.    */
void DoInboundMailAccept(HWND hWnd,SOCKET sock,LPARAM lParam)
{
    int threadID;

    Printf("accepting inbound SMTP connection\r\n");
    if(HIWORD(lParam) == 0)  // if accept didn't have an error
        if(CreateThread(NULL,0,(void*)&InboundThreadMain,(void*)sock,0,&threadID) == NULL) {
            closesocket(sock);
            Printf("##CreateThread() failed for inbound\r\n");
        };
}



