

IDD_ALIAS DIALOG DISCARDABLE  0, 0, 233, 169
STYLE DS_MODALFRAME | WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU
CAPTION "E-mail aliases"
FONT 10, "MS Sans Serif"
BEGIN
    PUSHBUTTON      "OK >>",IDC_OK_NEXT,169,150,57,12
    PUSHBUTTON      "<< OK",IDC_OK_PREV,4,150,57,12
    PUSHBUTTON      "OK",IDOK,73,150,33,12
    PUSHBUTTON      "Cancel",IDCANCEL,118,150,39,12
    EDITTEXT         IDC_ALIAS_LIST,4,6,222,137,ES_AUTOHSCROLL | ES_MULTILINE | 
                     ES_AUTOVSCROLL | ES_WANTRETURN
END


static BOOL CALLBACK AliasDialogProc(HWND hWndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
    int command;
    
    switch (uMsg) {
    case WM_INITDIALOG:
        SetDlgItemText(hWndDlg,IDC_ALIAS_LIST,aliasList);
        return 1; // return "did not set focus"
    case WM_COMMAND:
        command = LOWORD(wParam);
        if(command == IDC_OK_NEXT)
            PostMessage(GetWindow(hWndDlg,GW_OWNER),WM_COMMAND,IDM_TIMEOUT,0);
        if(command == IDC_OK_PREV)
            PostMessage(GetWindow(hWndDlg,GW_OWNER),WM_COMMAND,IDM_ROUTE,0);
        if(command == IDOK || command == IDC_OK_NEXT || command == IDC_OK_PREV) {
            UpdatePreferenceString(hWndDlg,IDC_ALIAS_LIST,&aliasList);
            SetOurRegistryStr("aliasList",aliasList);
            EndDialog(hWndDlg,0);
            return TRUE;
        } else if(command == IDCANCEL) {
            EndDialog(hWndDlg,0);
            return TRUE; 
        };
    }
    return FALSE;  // return "message not handled"
} 


static void MailAgain()
{
#ifdef ASDFASDF
    extern char *aliasList;
    char *aliasCursorPtr,*foundCharPtr;
    int numPatternChars;   // will include :
    int numRuleChars;      // will include \n but not :

    assert(strlen(aliasList) <= routeListCharsProcessed);
    for(aliasCursorPtr=aliasList+routeListCharsProcessed;*aliasCursorPtr;) {  // for every alias rule remaining
        foundCharPtr = strchr(aliasCursorPtr,'\n');
        if(foundCharPtr == NULL)
            numRuleChars = strlen(aliasCursorPtr);
        else
            numRuleChars = foundCharPtr - aliasCursorPtr;
        foundCharPtr = strchr(aliasCursorPtr,':');
        if(foundCharPtr == NULL)
            numPatternChars = numRuleChars;  
        else
            numPatternChars = foundCharPtr - aliasCursorPtr;
        if(numRuleChars <= numPatternChars) // if no : in rule
            if(numRuleChars != numPatternChars) {  // if not last rule
                aliasCursorPtr += numRuleChars;
                continue;
            } else 
                break;
        aliasCursorPtr[numPatternChars-1] = '\0'; // temporarily truncate string
        if(IsMatchList(aliasCursorPtr,envelopePtr->toAddressArr)) {
            Envelope *additionalEnvelopePtr;

            *additionalEnvelopePtr = *envelopePtr;
            RouteEnvelope(queueFileHdl,additionalEnvelopePtr,routeListCharsProcessed)

        };
        aliasCursorPtr[numPatternChars-1] = ':';  // restore end of pattern marker
        break;
    };
#endif
}


int IsEAddressMatchList(char *patternListPtr,char *angleBracketedEAddressArr) 
{
    char eAddressArr[MAX_E_ADDRESS_LENGTH],*lastCharPtr;

    strcpy(eAddressArr,angleBracketedEAddressArr+1);  // skip the open angle bracket (<)
    lastCharPtr = eAddressArr+strlen(eAddressArr)-1;
    *lastCharPtr = '\0'; // delete the close angle bracket (>)
    return IsMatchList(patternListPtr,eAddressArr);
}
 


    for(availableSocketTriesLeft = 10;;availableSocketTriesLeft--) {
        sockaddr_in.sin_port = 0; //htons((short)((GetTickCount()*0x12434345 & 0x7fff) + 0x2000));// listen on random port
        if(bind(sock,(struct sockaddr FAR *) &sockaddr_in,sizeof(sockaddr_in)) != SOCKET_ERROR) 
            break;
        if(availableSocketTriesLeft == 0) {            
            Msg("bind(sock) failed for DNS after 10 tries.\n(%d)", WSAGetLastError());
            closesocket(sock);
            exit(1);
        };
    };    


#ifdef CONNECTION_WIZZARD
CONNECTION DIALOG DISCARDABLE  0, 0, 233, 167
STYLE DS_MODALFRAME | WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU
CAPTION "Connection"
FONT 10, "MS Sans Serif"
BEGIN
    PUSHBUTTON      "OK >>",IDC_OK_NEXT,171,148,57,12
    LTEXT           "These questions will help you configure the other windows.",
                    IDC_STATIC,7,5,219,10
    GROUPBOX        "How do you attached to the network?",IDC_STATIC,7,17,
                    219,25
    CONTROL         "Network Card (full time)",IDM_NETWORK_CARD,"Button",
                    BS_AUTORADIOBUTTON,14,29,83,8
    CONTROL         "Modem (part time)",IDM_DIALUP,"Button",
                    BS_AUTORADIOBUTTON,122,29,89,8
    GROUPBOX        "Is there a firewall between you and the Internet?",
                    IDC_STATIC,7,47,219,25
    CONTROL         "No firewall",IDM_NO_FIREWALL,"Button",
                    BS_AUTORADIOBUTTON,14,57,54,8
    CONTROL         "Yes, firewall or private network",IDM_YES_FIREWALL,
                    "Button",BS_AUTORADIOBUTTON,71,57,98,8
    GROUPBOX        "If Dial-Up, where do you connect?",IDC_STATIC,7,77,219,
                    25
    CONTROL         "One ISP in one metropolitan area",IDM_ONE_ISP,"Button",
                    BS_AUTORADIOBUTTON,14,88,118,8
    CONTROL         "I'm mobile",IDM_MR_MOBILE,"Button",BS_AUTORADIOBUTTON,
                    140,87,61,8
    GROUPBOX        "Does your IP address change?",IDC_STATIC,7,107,219,25
    CONTROL         "No, static address",IDM_STATIC_IP,"Button",
                    BS_AUTORADIOBUTTON,10,118,67,8
    CONTROL         "Yes, dynamic address (DHCP and most PPP)",
                    IDM_DYNAMIC_IP,"Button",BS_AUTORADIOBUTTON,80,118,144,8
    PUSHBUTTON      "<< OK",IDC_OK_PREV,6,148,57,12
    PUSHBUTTON      "OK",IDOK,75,148,33,12
    PUSHBUTTON      "Cancel",IDCANCEL,120,148,39,12
END
#endif 

#ifdef CONNECTION_WIZZARD
static BOOL CALLBACK ConnectionDialogProc(HWND hWndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)	
{
    int command;
    
    switch (uMsg) {
    case WM_INITDIALOG:
        return 1; // return "did not set focus"
    case WM_COMMAND:
        command = LOWORD(wParam);
        if(command == IDC_OK_NEXT)
            PostMessage(GetWindow(hWndDlg,GW_OWNER),WM_COMMAND,IDM_DNS,0);
        if(command == IDC_OK_PREV)
            PostMessage(GetWindow(hWndDlg,GW_OWNER),WM_COMMAND,IDM_STARTUP,0);
        if(command == IDOK || command == IDC_OK_NEXT || 
            command == IDC_OK_PREV || command == IDCANCEL) {
            EndDialog(hWndDlg,0);
            return TRUE; 
        };
    }
    return FALSE;  // return "message not handled"
}
#endif

//static int IPAddress(int a,int b,int c,int d)
//{
//    return htonl(d<<24 | c<<16 | b<<8 | a);
//}
//
//static void FindNameservers(void)
//{
 //  nameserverAddressArr[0] = IPAddress(182,1,83,66);   // tahiti.ccrl.mot.com?
 //   nameserverAddressArr[1] = IPAddress(182,1,2,10);
   // nameserverAddressArr[0] = IPAddress(198,49,174,58);  // ns1.wwa.com
    //nameserverAddressArr[2] = IPAddress(192,94,207,66);  // icm1.icp.net
   // nameserverAddressArr[3] = IPAddress(129,105,5,104);  // ns2.eecs.nwu.edu
//    nameserverAddressArr[1] = IPAddress(127,0,0,1);  // localhost
//    nameserverAddressArr[5] = IPAddress(206,141,251,2);  // ns1.ameritech.net
//    nameserverAddressArr[6] = IPAddress(206,141,192,243);  // mailhost.chicago.il.ameritech.net
//}


//    struct hostent *hostentPtr;
//    char shortHostnameArr[50];
//char *myCharPtr;
//int *myIntPtr;

    if(0 && autoMyHostname) {
        if(gethostname(shortHostnameArr,sizeof(shortHostnameArr))) {
            Printf("gethostname() failed\r\n");
            return 1;  // return DNS initialization failure
        };
        hostentPtr = gethostbyname(shortHostnameArr);
        if(hostentPtr == NULL) {
            Printf("gethostbyname() failed\r\n");
            return 1;  // return DNS initialization failure
        };
Printf("hostentPtr->h_name %s\r\n",hostentPtr->h_name);
for(myCharPtr = *hostentPtr->h_aliases;*myCharPtr != '\0';myCharPtr++)
    Printf("hostentPtr->h_alias %s\r\n",myCharPtr);
for(myIntPtr = (int*)*hostentPtr->h_addr_list;*myIntPtr != 0;myIntPtr++)
    Printf("hostentPtr->h_addr_list %d\r\n",*myIntPtr); 

Printf("----------- again\r\n");
        hostentPtr = gethostbyaddr(hostentPtr->h_addr,4,AF_INET);    
        if(hostentPtr == NULL) {
            Printf("gethostbyname() 2 failed\r\n");
            return 1;  // return DNS initialization failure
        }; 
Printf("hostentPtr->h_name %s\r\n",hostentPtr->h_name);
for(myCharPtr = *hostentPtr->h_aliases;*myCharPtr != '\0';myCharPtr++)
    Printf("hostentPtr->h_alias %s\r\n",myCharPtr);
for(myIntPtr = (int*)*hostentPtr->h_addr_list;*myIntPtr != 0;myIntPtr++)
    Printf("hostentPtr->h_addr_list %d\r\n",*myIntPtr);


        strncpy(myHostnameArr,hostentPtr->h_name,sizeof(myHostnameArr)-1);
        myHostnameArr[sizeof(myHostnameArr)-1] = '\0';
    };




static void WindowRectToClient(HWND hWndParent,RECT *rectPtr)
{
    ScreenToClient(hWndParent,(POINT*)&rectPtr->left);
    ScreenToClient(hWndParent,(POINT*)&rectPtr->right);
}

static void PrintRect(RECT *rectPtr)
{
    Printf(" Rect %d %d %d %d\r\n",rectPtr->left,rectPtr->top,rectPtr->right,rectPtr->bottom);
}

// This will resize the prop sheet.  There has to be a better way to do this.
static int CALLBACK OptionsWindowProc(HWND hWndDlg,UINT uMsg,LPARAM lParam)
{
    HWND hWndChild;
    RECT windowRect,childRect;
    int enlargedWidth,enlargedHeight,moveX,moveY;

return 0;
    enlargedWidth = 370;
    enlargedHeight = 200;
    switch(uMsg) {
    case PSCB_INITIALIZED:
        GetWindowRect(hWndDlg,&windowRect);
PrintRect(&windowRect); 
ShowWindow(hWndDlg,SW_SHOW);
        MoveWindow(hWndDlg,0,0,enlargedWidth,enlargedHeight,TRUE);
//WindowRectToClient(hWndDlg,&childRect);
GetWindowRect(hWndDlg,&windowRect);
PrintRect(&windowRect);
        moveX = enlargedWidth-(windowRect.right-windowRect.left);
        moveY = enlargedHeight-(windowRect.bottom-windowRect.top);
Printf("moveX=%d moveY=%d\r\n",moveX,moveY);
//moveX = 40;
//moveY = 40;
        for(hWndChild=GetWindow(hWndDlg,GW_CHILD);hWndChild;hWndChild=GetWindow(hWndChild,GW_HWNDNEXT)){
            GetWindowRect(hWndChild,&childRect);
            WindowRectToClient(hWndDlg,&childRect);
Printf("child");
PrintRect(&childRect);
            if(windowRect.top > 50)
                MoveWindow(hWndChild,windowRect.left+moveX,windowRect.top+moveY,windowRect.right-windowRect.left,
                             windowRect.bottom-windowRect.top,TRUE);
       //     else
       //         MoveWindow(hWndChild,windowRect.left,windowRect.top,windowRect.right-windowRect.left,
       //                      windowRect.bottom-windowRect.top,TRUE);
            GetWindowRect(hWndChild,&windowRect);
            Printf("         %d %d %d %d\r\n",windowRect.left,windowRect.top,windowRect.right,windowRect.bottom);
        };
    };
    return 0;
}


static char *tabNameStrArr[] = { "About","Start","Connection","DNS","Directory",
                                 "Allow","Filter","Rate","Timeout"};
static DLGPROC tabProcArr[] = { NULL,NULL,NULL,DNSPageProc,NULL,
                                NULL,NULL,NULL,TimeoutPageProc };
void DoOptionsWindow(HWND hWndOwner,int startPage)
{ 
    PROPSHEETPAGE psp[sizeof(tabNameStrArr)/sizeof(*tabNameStrArr)]; 
    PROPSHEETHEADER psh;
    int tabIndex;

    for(tabIndex=0;tabIndex < sizeof(tabNameStrArr)/sizeof(*tabNameStrArr);tabIndex++) {
        psp[tabIndex].dwSize = sizeof(PROPSHEETPAGE);
        psp[tabIndex].dwFlags = PSP_USETITLE;
        psp[tabIndex].hInstance = 0;
        psp[tabIndex].pszTemplate = tabNameStrArr[tabIndex];
        psp[tabIndex].pszIcon = NULL;
        psp[tabIndex].pfnDlgProc = tabProcArr[tabIndex];
        psp[tabIndex].pszTitle = tabNameStrArr[tabIndex];
        psp[tabIndex].lParam = 0;
    };
    psh.dwSize = sizeof(PROPSHEETHEADER);
    psh.dwFlags = PSH_PROPSHEETPAGE | PSH_USECALLBACK;
    psh.hwndParent = hWndOwner;
    psh.hInstance = 0;
    psh.pszIcon = NULL;
    psh.pszCaption = (LPSTR) "Mishawaka Options";
    psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
    psh.nStartPage = startPage;
    psh.ppsp = (LPCPROPSHEETPAGE) &psp;
    psh.pfnCallback = OptionsWindowProc;
    PropertySheet(&psh);  // display dialog box
}

void DoDialogTab(int tabIndex,int code)
{
    RECT tabClientRect;

    if(code == TCN_SELCHANGING) {  // deactivate old sheet
        DestroyWindow(hDialogWnd);
        hDialogWnd = NULL;
    } else if(code == TCN_SELCHANGE) {  // activate new page
        hDialogWnd = CreateDialog(hInst,tabNameStrArr[tabIndex],hTabWnd,(DLGPROC)DialogWindowProcedure);       
        code = MISHAWAKA_CHANGE_SIZE;
    };
    if(code == MISHAWAKA_CHANGE_SIZE && hDialogWnd) {
        GetClientRect(hTabWnd,&tabClientRect);   
        SendMessage(hTabWnd,TCM_ADJUSTRECT,FALSE,(LPARAM)&tabClientRect);  // get the client area of the tab window
        MoveWindow(hDialogWnd,tabClientRect.left,tabClientRect.top,tabClientRect.right-tabClientRect.left,tabClientRect.bottom-tabClientRect.top,TRUE);
    };
}


// returns 0 on error
// This function will ignore spaces in the middle of the address (not in the middle of a nuber though)
// This function will ignore characters after the last number, so that the addresss does not have to be a token.
// This function will ignore a leading '['
static int IPstringToAddress(char *ipStringPtr)
{
    int a,b,c,d;

    if(*ipStringPtr == '[' || *ipStringPtr == ' ')
        ipStringPtr++;
    ifsscanf(ipStringPtr,"%d.%d.%d.%d",&a,&b,&c,&d) != 4)
        return 0;
    return (a<<24) + (b<<16) + (c<<8) + d;
}



#ifdef ASDFASDF
void CreateTabs(HWND hWnd)
{
    int tabIndex;
    TC_ITEM tc_item;

    hTabWnd = CreateWindow(WC_TABCONTROL,NULL,TCS_SINGLELINE|WS_VISIBLE|WS_CHILD|WS_TABSTOP,0,0,100,100,hWnd,NULL,0,NULL);
    tc_item.mask = TCIF_TEXT;  // |TCIF_IMAGE|TCIF_PARAM;
    for(tabIndex=0;tabIndex < sizeof(tabNameStrArr)/sizeof(*tabNameStrArr);tabIndex++) {
        tc_item.pszText = tabNameStrArr[tabIndex];
        tc_item.cchTextMax = strlen(tc_item.pszText);
        SendMessage(hTabWnd,TCM_INSERTITEM,tabIndex,(LPARAM)&tc_item);
    }
    SendMessage(hTabWnd,TCM_SETCURSEL,10,0);
    DoTabChange(TCN_SELCHANGE);
}
#endif


#ifdef ASDFAS
static WINAPI InboundThreadMain(void *sock)
{
    char fromStr[MAX_E_ADDRESS_LENGTH];
    char recipientStr[MAX_E_ADDRESS_LENGTH];
    char domainNameStr[MAX_E_ADDRESS_LENGTH];
    int returnStatus;

    returnStatus = ReceiveSMTP(sock,"incomming.mail",fromStr,recipientStr);
    Printf("ReceiveSMTP()=%d\r\n",returnStatus);
    returnStatus = ExtractDomainName(recipientStr,domainNameStr);
    DeleteTrailingCRLF(recipientStr);
    DeleteTrailingCRLF(fromStr);
    Printf("SendSMTP(\"incomming.mail\",%s,%s,%s);\r\n",recipientStr,domainNameStr,fromStr);
    Printf("SendSMTP() = %d\r\n",SendSMTP("incomming.mail",recipientStr,domainNameStr,fromStr));
    Printf("error=%s\r\n",GetLastOutboundErrorStr());

    return 0;
};
#endif
#ifdef ASDFASDF
static HANDLE OpenQueueFileDeleteOthers()
{
    HANDLE queueFileHdl;
    static char queue1FilenameStr[] = "queue1.evl";
    static char queue2FilenameStr[] = "queue2.evl";
    static char queue3FilenameStr[] = "queue3.evl";

    queueFileHdl = CreateFile(queue1FilenameStr,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_RANDOM_ACCESS,NULL);
    if(queueFileHdl != INVALID_HANDLE_VALUE) {
        DeleteFile(queue2FilenameStr);
        DeleteFile(queue3FilenameStr);
        return queueFileHdl;
    };
    queueFileHdl = CreateFile("queue1.evl",GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_RANDOM_ACCESS,NULL);
    if(queueFileHdl != INVALID_HANDLE_VALUE) {
        if(CopyFile(queue2FilenameStr,queue1FilenameStr,TRUE) == FALSE)) {
            Msg("Could not copy %s to %s",queue2FilenameStr,queue1FilenameStr);
            exit(1);
        };
        DeleteFile(queue2FilenameStr);
        DeleteFile(queue3FilenameStr);
        return queueFileHdl;
    };
    queueFileHdl = CreateFile("queue1.evl",GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_RANDOM_ACCESS,NULL);
    if(queueFileHdl != INVALID_HANDLE_VALUE) {
        if(CopyFile(queue3FilenameStr,queue1FilenameStr,TRUE) == FALSE)) {
            Msg("Could not copy %s to %s",queue3FilenameStr,queue1FilenameStr);
            exit(1);
        };
        DeleteFile(queue2FilenameStr);
        DeleteFile(queue3FilenameStr);
        return queueFileHdl;
    };
    Printf("Could not find existing queue file\r\n");
    queueFileHdl = CreateFile("queue1.evl",GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_NEW,FILE_FLAG_RANDOM_ACCESS,NULL);
    if(queueFileHdl != INVALID_HANDLE_VALUE) {
        Msg("Could not open existing queue1.evl file.\n");
        exit(1);
    };
    return queueFileHdl;
}
#endif


static void WriteConstantLengthLine(HANDLE fileHdl,char *bufferPtr,int bufferLength)
{
    int numBytesWritten,bytesToGo;
    char spacesStr[] = "          \r\n";  // ten spaces and a CRLF

    WriteFile(fileHdl,bufferPtr,bufferLength,&numBytesWritten,NULL);
    bytesToGo = MAX_RECEIVED_LINE_LENGTH - numBytesWritten;
    for(;bytesToGo > 12;bytesToGo -= numBytesWritten) 
        WriteFile(fileHdl,spacesStr,10,&numBytesWritten,NULL);
    WriteFile(fileHdl,12-bytesToGo+spacesStr,bytesToGo,&numBytesWritten,NULL);
}


static void DeleteTrailingSpaceCRLF(char *theStr)
{
    char *thePtr;
    
    thePtr = strchr(theStr,' ');  // most likely to shorten most first
    if(thePtr != NULL)
        *thePtr = '\0';
    thePtr = strchr(theStr,'\r');
    if(thePtr != NULL)
        *thePtr = '\0';
    thePtr = strchr(theStr,'\n');
    if(thePtr != NULL)
        *thePtr = '\0';
}

