/* Copyright (c) Rick Dean 1997 */
/* <mishawaka@fdd.com> "Rick Dean" */

#include <assert.h>
#include <windows.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <ctype.h>

#include "match.h"
#include "dns.h"
#include "schedule.h"

static int IsWhiteSpaceChar(char theChar)
{
    return theChar == ' ' || theChar == '\r' || theChar == '\n' || theChar == '\t';
}

static int IsEndingTokenChar(char theChar)
{
    return IsWhiteSpaceChar(theChar) || theChar == '\0';
}

int IsMatch(char *patternPtr,char *targetPtr)
{
    for(;;patternPtr++,targetPtr++) {
        if(IsEndingTokenChar(*patternPtr))
            if(IsEndingTokenChar(*targetPtr))
                return 1;
            else 
                return 0;
        if(IsEndingTokenChar(*targetPtr))
            return 0;
        if(tolower(*patternPtr) == tolower(*targetPtr) || *patternPtr == '?')
            continue;
        if(*patternPtr == '*') {
             while(*patternPtr == '*')
                 patternPtr++;
             for(;;targetPtr++) {
                 if(IsMatch(patternPtr,targetPtr))
                     return 1;
                 if(IsEndingTokenChar(*targetPtr))
                     return 0;
             };        
        };
        return 0;
    };
}

int IsMatchList(char *patternListPtr,char *targetPtr)
{
    for(;;) { 
        while(IsWhiteSpaceChar(*patternListPtr))  /* skip white space in pattern string */
            patternListPtr++;
        if(*patternListPtr == '\0')   /* if we reached end of pattern list string */
            return 0;
        if(IsMatch(patternListPtr,targetPtr)) /* if successful match */
            return 1;
        while(!IsEndingTokenChar(*patternListPtr))  /* skip the non-matching pattern */
            patternListPtr++;
    };
}

// we have already verified that the begins with "rcpt to:"
int IsHostInList(int address,char *hostnameArr,char *patternArr) 
{
    char ipAddressStr[50];
    
    wsprintf(ipAddressStr,"[%d.%d.%d.%d]",(address>>24)&0xff,(address >> 16)&0xff,(address >> 8)&0xff,address&0xff);
    return (*hostnameArr != '\0' && IsMatchList(patternArr,hostnameArr)) ||
#ifdef PHOBIC_SMTP_ACCEPT
        (sourceAddress == GetHostByName(ipAddressStr) && IsMatchList(patternArr,ipAddressStr));
#else 
        IsMatchList(patternArr,ipAddressStr);
#endif
}




