
/* Copyright (c) Rick Dean 1997 */
/* <mishawaka@fdd.com> "Rick Dean" */

#include <assert.h>
#include <winsock2.h>
#include <setjmp.h>
//#include <stdio.h>
#include <windows.h>

#include "mishawaka.h"
#include "inbound.h"
#include "status.h"
#include "schedule.h"
#include "debug.h"
#include "match.h"
#include "dns.h"
#include "outbound.h"

static HANDLE numActivePOP3MutexHdl;  // owner of this mutex can read/write to numActiveInbound
int volatile numActivePOP3 = 0;  // has mutex because multiple threads write to it

typedef struct messageStruct {
    int queueFileOffset;
    int isDeleted;
    unsigned sizeOf822File;
} Message;

void InitPOP3(HWND hWnd)
{
   SOCKADDR_IN sockaddr_in;
   SOCKET sock;

   sock = socket(AF_INET,SOCK_STREAM, 0);
   if(sock == INVALID_SOCKET) {
        Msg("socket() failed");
        exit(1);
   };
   sockaddr_in.sin_family = AF_INET;
   sockaddr_in.sin_addr.s_addr = INADDR_ANY;// we restrict connections after we answer so it is runtime changable
   sockaddr_in.sin_port = htons(110);   /* listen on port 110 */ 
   if(bind(sock,(SOCKADDR *) &sockaddr_in,sizeof(sockaddr_in)) == SOCKET_ERROR) {
       Msg("bind(sock) failed.\n(%d)", WSAGetLastError());
       closesocket( sock );
       exit(1);
   };
   if(listen(sock,1 /* max pending requests */ ) == SOCKET_ERROR) {
       Msg("listen(sock) failed (%d)", WSAGetLastError());
       exit(1);
   };
   /* Send window a user defined event, MISH_ACCEPT, when something is trying to connect.  */
   if(WSAAsyncSelect(sock,hWnd,MISH_INBOUND_POP3_ACCEPT,FD_ACCEPT) == SOCKET_ERROR) {
       Msg("Error on WSAAsyncSelect() (%d)",WSAGetLastError());
       closesocket( sock );
       exit(1);
   };
   numActivePOP3MutexHdl = CreateMutex(NULL,FALSE,"nummActivePOP3");
}

static HANDLE OpenQueueFileReadOnly(void)
{
    HANDLE queueFileHdl;

    queueFileHdl = CreateFile("mishawaka queue.evl",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_ALWAYS,FILE_FLAG_RANDOM_ACCESS,NULL);
    if(queueFileHdl == INVALID_HANDLE_VALUE) 
        Msg("Could not open queue file read only.\n");
    return queueFileHdl;
}

static void UpdatePOP3(HANDLE queueFileHdl,Message *messagePtr,int numMaildropMessages,char *addressListPtr)
{
    extern HWND hMainWnd;
    int messageIndex,numBytesRead;
    Envelope envelope;

    for(messageIndex=1;messageIndex <= numMaildropMessages;messageIndex++) {
        if(!messagePtr[messageIndex-1].isDeleted)
            continue;
        SetFilePointer(queueFileHdl,messagePtr[messageIndex-1].queueFileOffset,NULL,FILE_BEGIN);
        ReadFile(queueFileHdl,&envelope,sizeof(Envelope),&numBytesRead,NULL);
        if(envelope.sizeOf822File != messagePtr[messageIndex-1].sizeOf822File || !IsMatchList(addressListPtr,envelope.toAddressArr))
            continue;
        envelope.status = SUCCESS_FILE_SENT;
        SendMessage(hMainWnd,MISH_MAIL_STATUS,(WPARAM)&envelope,0);//wait until message processed
    };
}

static void SendEmptyLetter(SOCKET sock,jmp_buf resetJmpBuf)
{
    if(send(sock,"\r\n.\r\n",6,0) == SOCKET_ERROR)
        longjmp(resetJmpBuf,2);
}

static void SendError(SOCKET sock,jmp_buf resetJmpBuf)
{
Printf("sending error\r\n");
    if(send(sock,"-ERR\r\n",6,0) == SOCKET_ERROR)
        longjmp(resetJmpBuf,2);
}

static void SendOK(SOCKET sock,jmp_buf resetJmpBuf)
{
    if(send(sock,"+OK\r\n",5,0) == SOCKET_ERROR)
        longjmp(resetJmpBuf,2);
}

//  "New" because this routine dynamically allocates a string
//  This routine first checks the POP3 alias list, otherwise it creates one.
static char *NewEAddressListForUser(char *usernamePtr,jmp_buf endJmpBuf)
{
    char *addressListPtr;

    addressListPtr = (char*) GlobalAlloc(GMEM_FIXED,strlen(usernamePtr)+5);
    if(addressListPtr == NULL)
        longjmp(endJmpBuf,1);
    wsprintf(addressListPtr,"<%s@*>",usernamePtr);
    return addressListPtr;
}

static void DoLIST(SOCKET sock,char *commandPtr,Message *messagePtr,
   int numMaildropMessages,HANDLE queueFileHdl,char *addressListPtr,jmp_buf endJmpBuf)
{
    int messageIndex;
    
    messageIndex = atoi(commandPtr+5);
    if(messageIndex == 0) {
        SendOK(sock,endJmpBuf);
        for(messageIndex = 1;messageIndex <= numMaildropMessages;messageIndex++)
            if(!messagePtr[messageIndex-1].isDeleted)
                SocketPrintf(sock,endJmpBuf,"%d %d\r\n",messageIndex,messagePtr[messageIndex-1].sizeOf822File);
        SocketPrintf(sock,endJmpBuf,".\r\n");
    } else if(messageIndex < 1 || messageIndex > numMaildropMessages || messagePtr[messageIndex-1].isDeleted) {
        SendError(sock,endJmpBuf);
    } else 
        SocketPrintf(sock,endJmpBuf,"+OK %d %d\r\n",messageIndex,messagePtr[messageIndex-1].sizeOf822File);
}

static void DoRETR(SOCKET sock,char *commandPtr,Message *messagePtr,
   int numMaildropMessages,HANDLE queueFileHdl,char *addressListPtr,jmp_buf endJmpBuf)
{
    int messageIndex,numBytesRead;
    Envelope envelope;
    
    messageIndex = atoi(commandPtr+5);
    if(messageIndex < 1 || messageIndex > numMaildropMessages || messagePtr[messageIndex-1].isDeleted) {
        SendError(sock,endJmpBuf);
        return;
    } 
    SetFilePointer(queueFileHdl,messagePtr[messageIndex-1].queueFileOffset,NULL,FILE_BEGIN);
    ReadFile(queueFileHdl,&envelope,sizeof(Envelope),&numBytesRead,NULL);
    if(!IsMatchList(addressListPtr,envelope.toAddressArr) || envelope.status != KEEPER ||
        messagePtr[messageIndex-1].sizeOf822File != envelope.sizeOf822File) {
        SendEmptyLetter(sock,endJmpBuf);
        return;
    };
    SendOK(sock,endJmpBuf);
    if(WriteToSocketFromFile(sock,endJmpBuf,envelope.eight22FilenameArr))//if file not openable
        SendEmptyLetter(sock,endJmpBuf);
}

static void DoUIDL(SOCKET sock,char *commandPtr,Message *messagePtr,
   int numMaildropMessages,HANDLE queueFileHdl,char *addressListPtr,jmp_buf endJmpBuf)
{
    int messageIndex,numBytesRead;
    Envelope envelope;
    
    messageIndex = atoi(commandPtr+5);
    if(messageIndex == 0) {
        SendOK(sock,endJmpBuf);
        for(messageIndex = 1;messageIndex <= numMaildropMessages;messageIndex++)
            if(!messagePtr[messageIndex-1].isDeleted) {
                SetFilePointer(queueFileHdl,messagePtr[messageIndex-1].queueFileOffset,NULL,FILE_BEGIN);
                ReadFile(queueFileHdl,&envelope,sizeof(Envelope),&numBytesRead,NULL);
                SocketPrintf(sock,endJmpBuf,"%d %s\r\n",messageIndex,envelope.eight22FilenameArr);
            };
        SocketPrintf(sock,endJmpBuf,".\r\n");
    } else if(messageIndex < 1 || messageIndex > numMaildropMessages || messagePtr[messageIndex-1].isDeleted) {
        SendError(sock,endJmpBuf);
    } else {
        SetFilePointer(queueFileHdl,messagePtr[messageIndex-1].queueFileOffset,NULL,FILE_BEGIN);
        ReadFile(queueFileHdl,&envelope,sizeof(Envelope),&numBytesRead,NULL);
        SocketPrintf(sock,endJmpBuf,"+OK %d %s\r\n",messageIndex,envelope.eight22FilenameArr);
    };
}

static void TransactionPOP3Command(SOCKET sock,char *commandPtr,Message *messagePtr,
   int numMaildropMessages,HANDLE queueFileHdl,char *addressListPtr,jmp_buf endJmpBuf)
{
    int messageIndex,numMaildropBytes;

    if(_strnicmp(commandPtr,"stat",4) == 0) {
        numMaildropBytes = 0;
        for(messageIndex = 1;messageIndex <= numMaildropMessages;messageIndex++)
            numMaildropBytes += messagePtr[messageIndex-1].sizeOf822File;
        SocketPrintf(sock,endJmpBuf,"+OK %d %d\r\n",numMaildropMessages,numMaildropBytes);
        return;
    } else if(_strnicmp(commandPtr,"list",4) == 0) {
        DoLIST(sock,commandPtr,messagePtr,numMaildropMessages,queueFileHdl,addressListPtr,endJmpBuf);
        return;
    } else if(_strnicmp(commandPtr,"retr",4) == 0) {
        DoRETR(sock,commandPtr,messagePtr,numMaildropMessages,queueFileHdl,addressListPtr,endJmpBuf);
        return;
    } else if(_strnicmp(commandPtr,"uidl",4) == 0) {
        DoUIDL(sock,commandPtr,messagePtr,numMaildropMessages,queueFileHdl,addressListPtr,endJmpBuf);
        return;
    } else if(_strnicmp(commandPtr,"dele",4) == 0) {
        messageIndex = atoi(commandPtr+5);
        if(messageIndex < 1 || messageIndex > numMaildropMessages || messagePtr[messageIndex-1].isDeleted) {
            SendError(sock,endJmpBuf);
            return;
        } 
        messagePtr[messageIndex-1].isDeleted = 1;
        SendOK(sock,endJmpBuf);
        return;
    } else if(_strnicmp(commandPtr,"noop",4) == 0) {
        SendOK(sock,endJmpBuf);
        return;
    } else if(_strnicmp(commandPtr,"rset",4) == 0) {
        for(messageIndex=0;messageIndex < numMaildropMessages;messageIndex++)
            messagePtr[messageIndex].isDeleted = 0;
        return;
    };
    SendError(sock,endJmpBuf);            
}

//  "New" because it allocates memory dynamically for the pointer it returns.
static Message *NewCalculateMaildrop(char *usernamePtr,HANDLE queueFileHdl,int *numMaildropMessagesPtr,char *addressListPtr,jmp_buf endJmpBuf)
{
    Envelope envelope;
    int numBytesRead, numMessagesFoundAgain;
    Message *messagePtr,*messageCursorPtr;
    
    // count the number of messages in the maildrop
    SetFilePointer(queueFileHdl,0,NULL,FILE_BEGIN);
    *numMaildropMessagesPtr = 0;
    for(;;) {  // for every envelope in the queue file
        ReadFile(queueFileHdl,&envelope,sizeof(Envelope),&numBytesRead,NULL);
        if(numBytesRead == 0)  // if end of file
            break;
        if(envelope.status != KEEPER) 
            continue;
        if(IsMatchList(addressListPtr,envelope.toAddressArr)) 
            (*numMaildropMessagesPtr)++;
    };
    // allocate memory for all the Message structs
    messagePtr = (Message *) GlobalAlloc(GMEM_FIXED,sizeof(Message)**numMaildropMessagesPtr);
    if(messagePtr == NULL)
        longjmp(endJmpBuf,1);
    // fill in the message array withe file indexes (being careful in case the number of matches changed).
    SetFilePointer(queueFileHdl,0,NULL,FILE_BEGIN);
    messageCursorPtr = messagePtr;
    for(numMessagesFoundAgain=0;numMessagesFoundAgain < *numMaildropMessagesPtr;) {  // for every envelope in the queue file
        ReadFile(queueFileHdl,&envelope,sizeof(Envelope),&numBytesRead,NULL);
        if(numBytesRead == 0)  // if end of file
            break;
        if(envelope.status != KEEPER) 
            continue;
        if(IsMatchList(addressListPtr,envelope.toAddressArr)) {
            numMessagesFoundAgain++;
            messageCursorPtr->queueFileOffset = envelope.queueFileOffset;
            messageCursorPtr->isDeleted = 0;
            messageCursorPtr->sizeOf822File = envelope.sizeOf822File;
            messageCursorPtr++;
        };
    };
    *numMaildropMessagesPtr = numMessagesFoundAgain;
    return messagePtr;
}

//  Process POP3 "transaction" state.   
static void TransactionPOP3(SOCKET sock,char *usernamePtr)
{
    HANDLE queueFileHdl;
    char *addressListPtr=NULL,receivedLineArr[1024];
    int numMaildropMessages;
    Message *messagePtr=NULL;
    jmp_buf endJmpBuf;

    queueFileHdl = OpenQueueFileReadOnly();
    if(queueFileHdl == NULL)
        return;
    if(setjmp(endJmpBuf) == 0) {  // if not returning because of a longjmp() because of an error
        addressListPtr = NewEAddressListForUser(usernamePtr,endJmpBuf);
        messagePtr = NewCalculateMaildrop(usernamePtr,queueFileHdl,&numMaildropMessages,addressListPtr,endJmpBuf);
        while(ReceiveExpected(sock,"quit",receivedLineArr,sizeof(receivedLineArr),endJmpBuf)) 
            TransactionPOP3Command(sock,receivedLineArr,messagePtr,numMaildropMessages,queueFileHdl,addressListPtr,endJmpBuf);
        UpdatePOP3(queueFileHdl,messagePtr,numMaildropMessages,addressListPtr);
    };
    SafeGlobalFree(messagePtr);  // status.c
    SafeGlobalFree(addressListPtr); // status.c
    CloseHandle(queueFileHdl);
}

static void AuthorizationPOP3(SOCKET sock,int sourceAddress,char *sourceNamePtr)
{
    char receivedLineArr[1024],*foundCharPtr,usernameArr[32],*domainArgToUsePtr;
    int returnStatus;
    jmp_buf abortJmpBuf;
    extern char *masterPOP3passwordPtr,*pop3DomainNamePtr;
    HANDLE userTokenHdl = NULL;
    
    returnStatus = setjmp(abortJmpBuf);
    if(returnStatus != 0)
        return;
    send(sock,"+OK Mishawaka POP3 ready\r\n",26,0);
    while(ReceiveExpected(sock,"user",receivedLineArr,sizeof(receivedLineArr),abortJmpBuf))
        SendError(sock,abortJmpBuf);
    SendOK(sock,abortJmpBuf);
    strncpy(usernameArr,strtok(receivedLineArr+5,"\r\n"),sizeof(usernameArr)-1);
    usernameArr[sizeof(usernameArr)-1] = '\0';
    while(ReceiveExpected(sock,"pass",receivedLineArr,sizeof(receivedLineArr),abortJmpBuf))
        SendError(sock,abortJmpBuf);
    foundCharPtr = strchr(receivedLineArr,'\r');
    if(foundCharPtr)
        *foundCharPtr = '\0';
    domainArgToUsePtr = strcmp(pop3DomainNamePtr,"") ? pop3DomainNamePtr : NULL;
    if(masterPOP3passwordPtr[0] != '\0' && strcmp(receivedLineArr+5,masterPOP3passwordPtr) != 0 &&
        LogonUser(usernameArr,domainArgToUsePtr,receivedLineArr+5,LOGON32_LOGON_BATCH,LOGON32_PROVIDER_DEFAULT,&userTokenHdl) != TRUE) {
        SendError(sock,abortJmpBuf);
        return;
    };
    if(userTokenHdl != NULL)
        CloseHandle(userTokenHdl);
    SendOK(sock,abortJmpBuf);
    TransactionPOP3(sock,usernameArr);
}

static int IsOkayToConnectPOP3(int sourceAddress,char *sourceHostnameArr) 
{
    extern char *hostsToConnectPOP3Ptr;

    return IsHostInList(sourceAddress,sourceHostnameArr,hostsToConnectPOP3Ptr);
}

/* here we decide if it is someone we want to listen to. */
static WINAPI POP3ThreadMain(SOCKET sock)
{
    SOCKADDR_IN sockaddr_in; 
    int sockaddr_inLength;     
    extern int maxActivePOP3;
    int sourceAddress;
    char sourceHostnameArr[256];

    sockaddr_inLength = sizeof(sockaddr_in);
    sock = accept(sock,(SOCKADDR *) &sockaddr_in,&sockaddr_inLength); // creates new socket
    if(sock == INVALID_SOCKET) {
        Printf("##accept() failed for POP3 (%d)",WSAGetLastError());
        return 0;
    };
    WaitForSingleObject(numActivePOP3MutexHdl,INFINITE);
    if(numActivePOP3 >= maxActivePOP3) {
        ReleaseMutex(numActivePOP3MutexHdl);
        Printf("rejected POP3 because max reached\r\n");
        send(sock,"-ERR too many connections\r\n",27,0);
        closesocket(sock);
        return 0;
    }; 
    numActivePOP3++;
    ReleaseMutex(numActivePOP3MutexHdl);
    sourceAddress = ntohl(sockaddr_in.sin_addr.s_addr);
    GetHostByAddr(sourceAddress,sourceHostnameArr,sizeof(sourceHostnameArr));      
    if(IsOkayToConnectPOP3(sourceAddress,sourceHostnameArr)) {
        AuthorizationPOP3(sock,sourceAddress,sourceHostnameArr);
        Printf("closing POP3 connection\r\n");
    } else {
        Printf("rejected POP3 connection from 0x%x (%s)\r\n",sourceAddress,sourceHostnameArr);
        send(sock,"-ERR your address refused\r\n",27,0);
    };
    closesocket(sock);
    WaitForSingleObject(numActivePOP3MutexHdl,INFINITE);
    numActivePOP3--;
    ReleaseMutex(numActivePOP3MutexHdl);
    return 0;
}

/*   Accept an incoming connection.    */
void DoInboundPOP3Accept(HWND hWnd,SOCKET sock,LPARAM lParam)
{
   int threadID;

   Printf("accepting POP3 connection\r\n");
   if(HIWORD(lParam) == 0)  // if accept didn't have an error
       if(CreateThread(NULL,0,(void*)&POP3ThreadMain,(void*)sock,0,&threadID) == NULL) {
           closesocket(sock);
           Printf("##CreateThread() failed for POP3\r\n");
       };
}


