
#ifndef SCHEDULE_H_
#define SCHEDULE_H_


#define MAX_E_ADDRESS_LENGTH (96)
#define MAX_822FILENAME_LENGTH (20)
#define ENVELOPE_MAGIC_NUMBER (0x6873694d)  // 'Mish'
#define TIMER_INDEX_FOR_SCHEDULE (1)

typedef enum statusEnum {
    EMPTY   = 0x59544d45,  // 'EMTY'
    WAITING = 0x54494157,  // 'WAIT'
    SENDING = 0x444e4553,  // 'SEND'
    KEEPER  = 0x5045454b,  // 'KEEP'
    ERRORED = 0x20525245   // 'ERR '
} Status;

typedef struct EnvelopeStruct {
    int magicNumber;  //  Just to check we are looking at what we think we are.
    Status status;
    int queueFileOffset;
    int minuteOfReceipt;
    int minuteOfLastDeliveryAttempt;
    unsigned sizeOf822File;
    char fromAddressArr[MAX_E_ADDRESS_LENGTH];
    char toAddressArr[MAX_E_ADDRESS_LENGTH];
    char eight22FilenameArr[MAX_822FILENAME_LENGTH];
    HANDLE smtpErrorPtr;  // dynamically allocated (only valid when status == SMTP_ERROR)
} Envelope;

//  This file is NOT re-entrant.  There is one thread for
//  the interface, and that is the only one which calls schedule.c
void SafeGlobalFree(void *voidPtr);
void ResetListView(HWND hWndList);
int IsAnyMail(Status status);
int DoScheduleTimer(void);
void DoCommandOnEnvleope(char *filenameArr,int queueFileOffset,int command);
void DoMailStatus(HWND hWnd,Envelope *envelopePtr);
void DoRouteInboundMail(HWND hWnd,char *filenamePtr);
void InitSchedule(HWND hWnd);
void QuitSchedule(HWND hWnd);

#endif SCHEDULE_H_
