
/* Copyright (c) Rick Dean 1997 */
/* <dean@ccrl.mot.com> "Rick Dean" */

#include <windows.h>
#include <commctrl.h>
#include <assert.h>

#include "status.h"
#include "mishawaka.h"

static HWND hWndStatus;
int statusHeight;

void __cdecl SetStatusText(char *statusFormatStr, ...)
{
    char outputStr[1024];

    wvsprintf(outputStr, statusFormatStr, (char *)(&statusFormatStr+1));
    lstrcat(outputStr, "\r\n");
    SendMessage(hWndStatus, SB_SETTEXT, 0, (LPARAM) outputStr);
    assert(strlen(outputStr) < sizeof(outputStr));
}

// Call this after the parent window resizes so the status window stays along the bottom.
void MoveStatusWindow(HWND hWnd)
{
    RECT clientRect;

    if(statusHeight == 0)
        return;
    GetClientRect(hWnd,&clientRect);
    MoveWindow(hWndStatus,0,clientRect.bottom-statusHeight,clientRect.right,statusHeight,1);
}

void InitStatusWindow(HWND hWnd)
{
    RECT rect;

    hWndStatus = CreateStatusWindow(WS_CHILD|WS_BORDER,"",hWnd,IDW_STATUS); 
    ShowWindow(hWndStatus,SW_SHOWNORMAL);
    GetWindowRect(hWndStatus,&rect);
    statusHeight = rect.bottom - rect.top;
    SetStatusText("initializing");
}
