/* Copyright (c) Rick Dean 1997 */
/* <mishawaka@fdd.com> Rick Dean */

#include <assert.h>
#include <windows.h>
#include "mishawaka.h"
#include "status.h"
#include "timer.h"

int startTime;
int bytesToSend;
int localQueueSize;
char zRecipientStr[80];

void SendingStarted(HANDLE fileHdl,char *recipientStr)
{   
    bytesToSend = GetFileSize(fileHdl,NULL);
    startTime = GetTickCount();
    localQueueSize = 1000;  // probably low
    strcpy(zRecipientStr,recipientStr);
}

// If the sending has lasted less than a second, we assume the bytes
// are just going into the local queue, and we forever subtract that from
// the progress.
void SendingProgress(int totalBytesSent)
{
    int elapsedTimeInMillisec,averageBytesPerSecond,minutesRemaining;
    extern HWND hMainWnd;

    elapsedTimeInMillisec = GetTickCount() - startTime;
    if(elapsedTimeInMillisec < 1000)   // less than 1 second
        localQueueSize = totalBytesSent;
    totalBytesSent -= localQueueSize;
    if(elapsedTimeInMillisec < 5000) { // less than 5 seconds   
        SetStatusText("sent %s %d bytes of %d",zRecipientStr,totalBytesSent,bytesToSend);
        return;
    };
    if(elapsedTimeInMillisec == 0)
        averageBytesPerSecond = 100000;
    else
        averageBytesPerSecond = totalBytesSent*1000/elapsedTimeInMillisec;
    if(averageBytesPerSecond == 0)
        minutesRemaining = 0x7fffffff;
    else
        minutesRemaining = ((bytesToSend-totalBytesSent)/averageBytesPerSecond+30)/60; // +30 to round to nearest
    SetStatusText("sent %s %d bytes of %d (%d bytes/sec) %d minutes remaining",
        zRecipientStr,totalBytesSent,bytesToSend,averageBytesPerSecond,minutesRemaining);
}

