
# Copyright (c) 2003 Frederick Dean

use strict;

package about;

my $about_window;

sub delete_event { $about_window->destroy(); }
sub ok_clicked { delete_event(); }

my %keystroke = ( "\n" => \&ok_clicked, " " => \&ok_clicked );

sub do_key_press_event 
{ 
   my($widget,$event) = @_;
   return undef unless defined $$event{'string'};  # ignore events without key code (e.g. Alt key)
   &{$keystroke{$$event{'string'}}} if defined $keystroke{$$event{'string'}};  # call %keystroke function if defined
   #print map { "   $_ -> " . $$event{$_} ."\n"} keys %$event;
   return undef;
}

sub my_button 
{
   my($name,$func) = @_;
   my $button = Gtk::Button->new($name); # child, yes expand, yes fill, 4 padding
   $button->child->parse_uline($name); # turn underscore to 
   $button->signal_connect('clicked', $func); 
   die if defined $keystroke{lc($1)};  # check for duplicate shortcut
   $keystroke{lc($1)} = $func if $name =~ /_(.)/;  # get keyboard shortcut
   return $button;
}

sub ok_box
{
   my($title,$width,$height,$widget) = @_;
   $about_window = new Gtk::Window( 'dialog' );
   $about_window->title($title);
   $about_window->set_policy(0,0,0);  # no allow_shrink, no allow_grow, no auto_shrink
   $about_window->set_default_size($width,$height);
   $about_window->signal_connect('delete_event', \&delete_event ) or die; # quit on main window close
   $about_window->signal_connect('key_press_event', \&do_key_press_event ) or die; 
   $about_window->border_width(4);
   $about_window->set_modal(1);  # i.e. exclusive user interaction
   $about_window->set_transient_for($::main_window); 
   # vertical box
   my $vbox = new Gtk::VBox( 0, 0 ); # non-homogenous, zero padding
   $about_window->add($vbox);  
   # Main widget
   $vbox->pack_start($widget,0,0,4); # child, no expand, no fill, 4 padding
   # horizontal box for history and bid-buttons
   my $hbox1= new Gtk::HBox( 0, 0 ); # non-homogenous, zero padding
   $vbox->pack_start($hbox1,0,0,4); # child, no expand, no fill, 4 padding
   # okay button
   $hbox1->pack_start(my_button('_OK',\&ok_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # show me the money!
   Gtk->main_iteration while ( Gtk->events_pending );
   $about_window->show_all();
}

sub open_window
{
   my $label1= Gtk::Label->new("OpenBridge\nby Fred Dean <software\@fdd.com>\n".
                               "http://fdd.com/software/openbridge/\n".
                               "Copyright (c) Frederick Dean 2003\nLicensed under the GPL\n" .
                               "Written in Perl using the Gtk+ 1.2 library.\n\n".
                               "Cards (c) 1998 Ryu Changwoo <cwryu\@eve.kaist.ac.kr>");
   ok_box('About OpenBridge',500,400,$label1);
}

1;  # return value
